---
title: Lists and tables
description: 'Organize information with styled lists and responsive tables for clear, consistent readability.'
framework: nuxt
---

## Lists

Markdown supports unordered, ordered, and nested lists for various content needs.

### Unordered lists

Use unordered lists for items without a specific sequence. Start each item with a `-` symbol.

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0 [&>div]:*:w-full"}

- I'm a list item.
- I'm another list item.
- I'm the last list item.

#code

```mdc
- I'm a list item.
- I'm another list item.
- I'm the last list item.
```

::

::component-theme{slug="ul" prose label="Theme"}
---
extra:
  - li
---
::

::

### Ordered lists

Use ordered lists when item order matters, like steps in a process. Start each item with a number.

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0 [&>div]:*:w-full"}

1. I'm a list item.
2. I'm another list item.
3. I'm the last list item.

#code

```mdc
1. I'm a list item.
2. I'm another list item.
3. I'm the last list item.
```

::

::component-theme{slug="ol" prose label="Theme"}
---
extra:
  - li
---
::

::

### Nested lists

Create hierarchical lists with sub-items for complex structures. Indent sub-items by four spaces for nesting.

::code-preview{class="[&>div]:*:my-0 [&>div]:*:w-full"}

- I'm a list item.
  - I'm a nested list item.
  - I'm another nested list item.
- I'm another list item.
  - Another nested item
    - Deep nested item
    - Another deep nested item
  - Back to second level

#code

```mdc
- I'm a list item.
  - I'm a nested list item.
  - I'm another nested list item.
- I'm another list item.
  - Another nested item
    - Deep nested item
    - Another deep nested item
  - Back to second level
```

::

### Mixed lists

You can combine ordered and unordered lists for complex hierarchies.

::code-preview{class="[&>div]:*:my-0 [&>div]:*:w-full"}

1. First major step
   - Sub-requirement A
   - Sub-requirement B
2. Second major step
   - Another sub-item
   - Final sub-item
3. Final step

#code

```mdc
1. First major step
   - Sub-requirement A
   - Sub-requirement B
2. Second major step
   - Another sub-item
   - Final sub-item
3. Final step
```

::

## Tables

Present structured data in rows and columns clearly. Tables are ideal for comparing data or listing properties.

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0 [&>div]:*:w-full"}

| Prop    | Default   | Type                     |
|---------|-----------|--------------------------|
| `name`  |           | `string`{lang="ts-type"} |
| `size`  | `md`      | `string`{lang="ts-type"} |
| `color` | `neutral` | `string`{lang="ts-type"} |

#code

```mdc
| Prop    | Default   | Type                     |
|---------|-----------|--------------------------|
| `name`  |           | `string`{lang="ts-type"} |
| `size`  | `md`      | `string`{lang="ts-type"} |
| `color` | `neutral` | `string`{lang="ts-type"} |
```

::

::component-theme{slug="table" prose label="Theme"}
---
extra:
  - thead
  - tbody
  - tr
  - th
  - td
---
::

::
