---
title: Images and embeds
description: 'Responsive images, videos, and rich media embeds to enhance and illustrate your documentation.'
framework: nuxt
---

## Images

Responsive images with automatic optimization and interactive zoom functionality.

::tabs{class="gap-0"}

:::code-preview{label="Preview" class="[&>div>p]:my-0"}
![Image](/assets/templates/nuxt/dashboard-dark.png)

#code

```mdc
![Image](/assets/templates/nuxt/dashboard-dark.png)
```

:::

:component-props{slug="img" prose label="Props"}

:component-theme{slug="img" prose label="Theme"}

::

::note
If [`@nuxt/image`](https://image.nuxt.com/get-started/installation) is installed, the `<NuxtImg>` component will be used instead of the native `img` tag for enhanced performance and optimization.
::

### Zoom

By default, images support interactive zoom: clicking an image opens it in a modal overlay with smooth transitions, allowing users to examine details more closely.

To prevent zoom on a specific image, add the `:zoom="false"` attribute.

::code-preview{class="[&>div>p]:my-0"}
![Image without zoom](/assets/templates/nuxt/dashboard-dark.png){:zoom="false"}

#code

```mdc
![Image without zoom](/assets/templates/nuxt/dashboard-dark.png){:zoom="false"}
```

::

### Size

Images automatically adapt to their container while maintaining aspect ratio. You can control sizing through markdown or HTML attributes when needed.

::code-preview
![Small Image](/assets/templates/nuxt/dashboard-dark.png){width="300"}

#code

```mdc
![Small Image](/assets/templates/nuxt/dashboard-dark.png){width="300"}
```

::

## Iframes

Easily embed interactive content like CodeSandbox, Figma, or YouTube.

### YouTube

::code-preview

<iframe src="https://www.youtube-nocookie.com/embed/_eQxomah-nA?si=pDSzchUBDKb2NQu7" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen style="aspect-ratio: 16/9; width: 100%;"></iframe>

#code

```html
<iframe src="https://www.youtube-nocookie.com/embed/_eQxomah-nA?si=pDSzchUBDKb2NQu7" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen style="aspect-ratio: 16/9; width: 100%;"></iframe>
```

::

### CodeSandbox

::code-preview
<iframe src="https://codesandbox.io/p/devbox/nuxt-ui-xgrzw5" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen style="aspect-ratio: 16/9; width: 100%;"></iframe>

#code

```html
<iframe src="https://codesandbox.io/p/devbox/nuxt-ui-xgrzw5" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen style="aspect-ratio: 16/9; width: 100%;"></iframe>
```

::

### Figma

::code-preview

<iframe style="border: 1px solid rgba(0, 0, 0, 0.1); width: 100%; height: 450px;" src="https://embed.figma.com/file/1544369209862884086/hf_embed?community_viewer=true&embed_host=fastma&fuid=960610330589944894&kind=file&page-selector=0&viewer=1" allowfullscreen></iframe>

#code

```html
<iframe style="border: 1px solid rgba(0, 0, 0, 0.1); width: 100%; height: 450px;" src="https://embed.figma.com/file/1544369209862884086/hf_embed?community_viewer=true&embed_host=fastma&fuid=960610330589944894&kind=file&page-selector=0&viewer=1" allowfullscreen></iframe>
```

::
