---
title: Code
description: 'Display inline code and syntax-highlighted code blocks with copy-to-clipboard support.'
framework: nuxt
---

## Code blocks

Code blocks are rendered by the `ProsePre` component of `@nuxtjs/mdc` and [code highlighting](https://content.nuxt.com/docs/files/markdown#code-highlighting) is done underneath by [Shiki](https://github.com/shikijs/shiki).

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0 [&>div]:*:w-full"}

```ts
export default defineNuxtConfig({
  modules: ['@nuxt/ui']
})
```

#code

````mdc
```ts
export default defineNuxtConfig({
  modules: ['@nuxt/ui']
})
```
````

::

:component-props{slug="pre" prose label="Props"}

::component-theme{slug="pre" prose label="Theme"}
---
extra:
  - codeIcon
---
::

::

### Language

Syntax highlighting is available for dozens of programming languages.

::code-preview{class="[&>div]:*:my-0 [&>div]:*:w-full"}

```vue
<script setup lang="ts">
const message = ref('Hello World!')

function updateMessage() {
  message.value = 'Button clicked!'
}
</script>

<template>
  <div>
    <h1>{{ message }}</h1>
    <UButton @click="updateMessage">
      Click me
    </UButton>
  </div>
</template>
```

#code

````html
```vue
<script setup lang="ts">
const message = ref('Hello World!')

function updateMessage() {
  message.value = 'Button clicked!'
}
</script>

<template>
  <div>
    <h1>{{ message }}</h1>
    <UButton @click="updateMessage">
      Click me
    </UButton>
  </div>
</template>
```
````

::

::tip
By default for syntax highlighting, `material-theme-lighter` and `material-theme-palenight` VSCode themes are used for light & dark mode respectively. You can change this in your `nuxt.config.ts` through the [`content.build.markdown.highlight`](https://content.nuxt.com/docs/getting-started/configuration#highlight) key.
::

### Filename

Code blocks support filename display with automatic icon detection.

::code-preview{class="[&>div]:*:my-0 [&>div]:*:w-full"}

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  modules: ['@nuxt/ui']
})
```

#code

````mdc
```ts [nuxt.config.ts]
export default defineNuxtConfig({
  modules: ['@nuxt/ui']
})
```
````

::

::tip
The filename icon is rendered by the `ProseCodeIcon` component and contains a set of predefined icons which you can customize in your `app.config.ts`:

```ts [app.config.ts]
export default defineAppConfig({
  ui: {
    prose: {
      codeIcon: {
        terminal: 'i-ph-terminal-window-duotone',
        config: 'i-lucide-settings',
        package: 'i-lucide-package'
      }
    }
  }
})
```
::

### Copy button

Every code-block has a built-in copy button that will copy the code to your clipboard.

::tip
You can change the icon in your `app.config.ts` through the `ui.icons.copy` and `ui.icons.copyCheck` keys:

```ts [app.config.ts]
export default defineAppConfig({
  ui: {
    icons: {
      copy: 'i-lucide-copy',
      copyCheck: 'i-lucide-copy-check'
    }
  }
})
```

::

### Line highlighting

Highlight specific lines to draw attention to important parts.

::code-preview{class="[&>div]:*:my-0 [&>div]:*:w-full"}

```ts [nuxt.config.ts] {2}
export default defineNuxtConfig({
  modules: ['@nuxt/ui'], // This line is highlighted
  css: ['~/assets/css/main.css']
})
```

#code

````mdc
```ts [nuxt.config.ts] {2}
export default defineNuxtConfig({
  modules: ['@nuxt/ui'], // This line is highlighted
  css: ['~/assets/css/main.css']
})
```
````

::

### Code diff

Use the `diff` language to show changes between code versions.

::code-preview{class="[&>div]:*:my-0 [&>div]:*:w-full"}

```diff [nuxt.config.ts]
export default defineNuxtConfig({
  modules: [
-   '@nuxt/ui-pro'
+   '@nuxt/ui'
  ]
})
```

#code

````md
```diff [nuxt.config.ts]
export default defineNuxtConfig({
  modules: [
-   '@nuxt/ui-pro'
+   '@nuxt/ui'
  ]
})
```
````

::

## Inline code

Inline code snippets are rendered by the `ProseCode` component of `@nuxtjs/mdc`.

::tabs{class="gap-0"}

:::code-preview{label="Preview" class="[&>div]:*:my-0"}
`inline code`

#code

```mdc
`inline code`
```

:::

:component-props{slug="code" prose label="Props"}

:component-theme{slug="code" prose label="Theme"}

::

### Color

Use the `color` prop to change the color of the inline code. Defaults to `neutral`.

::code-preview{class="[&>div]:*:my-0"}
`inline code`{color="error"}

#code

```mdc
`inline code`{color="error"}
```

::

### Lang

Use the `lang` prop to specify the language of the inline code.

::code-preview{label="Preview" class="[&>div]:*:my-0"}
`nuxt.config.ts`{lang="ts-type"}

#code

```mdc
`nuxt.config.ts`{lang="ts-type"}
```

::
