# .NET Core OS Platforms

You can install .NET Core on the following platforms, some of which are [supported by Microsoft](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md) and others by the community. This document provides links to the best download pages or instructions to install the latest version of .NET Core on a given operating system.

## Official Builds

* [Windows](https://github.com/dotnet/core/blob/master/release-notes/download-archives/2.0.3.md)
* [Linux](https://github.com/dotnet/core/blob/master/release-notes/download-archives/2.0.3.md)
* [macOS](https://github.com/dotnet/core/blob/master/release-notes/download-archives/2.0.3.md)

## Supported Operating System Versions

* [.NET Core 2.0 supported OS versions](https://github.com/dotnet/core/blob/master/release-notes/2.0/2.0-supported-os.md)
* [.NET Core 1.x supported OS versions](https://github.com/dotnet/core/blob/master/release-notes/1.0/1.0-supported-os.md)

## Official Docker Repos

* [.NET Core](https://hub.docker.com/r/microsoft/dotnet/)
* [.NET Core "Nightly"](https://hub.docker.com/r/microsoft/dotnet-nightly/)
* [ASP.NET Core](https://hub.docker.com/r/microsoft/aspnetcore/)
* [ASP.NET Core Builder](https://hub.docker.com/r/microsoft/aspnetcore-builder/)

Note: Debian and Nanoserver images are supported.

## Nightly Builds (Unsupported)

* [Preview Releases](https://github.com/dotnet/core/blob/master/daily-builds.md)
* [Servicing Releases](https://github.com/dotnet/core/blob/master/daily-builds-servicing.md)

## Unofficial Instructions 

* [Alpine](https://github.com/dotnet/announcements/issues/49)
* [ARM32 / Raspberry Pi](https://github.com/dotnet/core/blob/master/samples/RaspberryPiInstructions.md)
* [RHEL 6](https://github.com/dotnet/core/blob/master/Documentation/build-and-install-rhel6-prerequisites.md)
* [Yocto](https://github.com/dotnet/core/blob/master/samples/YoctoInstructions.md)

## Build from Source

* [Source-Build](https://github.com/dotnet/source-build)
