# .NET Core 2.1 Preview 2 Known Issues

This document lists known issues for *.NET Core 2.1 Preview 2* which may be encountered during usage.

## SDK

[sdk/issues/2128](https://github.com/dotnet/sdk/issues/2128)

There is a regression in DotNetCliToolReference support which results in the SDK failing to launch with the following error:

> Unable to generate deps.json, it may have been already generated. You can specify the "-d" option before the tool name for diagnostic output (for example, "dotnet -d ": /usr/local/share/dotnet/sdk/2.1.300-preview2-008530/Sdks/Microsoft.NET.Sdk/targets/GenerateDeps/GenerateDeps.proj

There error does not point to the actual issue which is:

> error MSB4018: System.UnauthorizedAccessException: Access to the path '/usr/local/share/dotnet/sdk/2.1.300-preview2-008530/Sdks/Microsoft.NET.Sdk/targets/GenerateDeps/obj/Debug/netcoreapp2.1/GenerateDeps.assets.cache' is denied.

**Workaround** - Give write permissions to the /usr/share/dotnet/sdk/version

## Installing on Linux using the installers installs the latest available dotnet-host package

There is an issue with dotnet-host 2.1.0-preview2-26406-04-1 which introduces a dependency incompatibility. [core-setup/issues/2128](https://github.com/dotnet/core-setup/issues/4007). This is only a problem when installing a previous version of .NET Core on a clean machine. For example, if you installed dotnet-runtime-2.0.6, the Preview 2 host will be installed but not the rest of Preview 2.

We have temporarily removed the Preview 2 installers from the Linux package feeds until this is fully resolved.

**Workaround** - If you have gotten into this state, downgrade the dotnet-host pacakge to an older version.

```bash
sudo apt install dotnet-host=2.0.6-1
```