# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public static class MemoryMarshal {
+        public static ReadOnlySpan<byte> AsBytes<T>(ReadOnlySpan<T> span) where T : struct;
+        public static Span<byte> AsBytes<T>(Span<T> span) where T : struct;
-        public static Memory<T> AsMemory<T>(ReadOnlyMemory<T> readOnlyMemory);
+        public static Memory<T> AsMemory<T>(ReadOnlyMemory<T> memory);
+        public static ReadOnlySpan<TTo> Cast<TFrom, TTo>(ReadOnlySpan<TFrom> span) where TFrom : struct where TTo : struct;
+        public static Span<TTo> Cast<TFrom, TTo>(Span<TFrom> span) where TFrom : struct where TTo : struct;
+        public static ReadOnlySpan<T> CreateReadOnlySpan<T>(ref T reference, int length);
+        public static Span<T> CreateSpan<T>(ref T reference, int length);
+        public static T Read<T>(ReadOnlySpan<byte> source) where T : struct;
+        public static IEnumerable<T> ToEnumerable<T>(ReadOnlyMemory<T> memory);
-        public static bool TryGetArray<T>(ReadOnlyMemory<T> readOnlyMemory, out ArraySegment<T> arraySegment);
+        public static bool TryGetArray<T>(ReadOnlyMemory<T> memory, out ArraySegment<T> segment);
+        public static bool TryGetMemoryManager<T, TManager>(ReadOnlyMemory<T> memory, out TManager manager) where TManager : MemoryManager<T>;
+        public static bool TryGetMemoryManager<T, TManager>(ReadOnlyMemory<T> memory, out TManager manager, out int start, out int length) where TManager : MemoryManager<T>;
+        public static bool TryGetString(ReadOnlyMemory<char> memory, out string text, out int start, out int length);
+        public static bool TryRead<T>(ReadOnlySpan<byte> source, out T value) where T : struct;
+        public static bool TryWrite<T>(Span<byte> destination, ref T value) where T : struct;
+        public static void Write<T>(Span<byte> destination, ref T value) where T : struct;
     }
+    public static class SequenceMarshal {
+        public static bool TryGetArray<T>(ReadOnlySequence<T> sequence, out ArraySegment<T> segment);
+        public static bool TryGetMemoryManager<T>(ReadOnlySequence<T> sequence, out MemoryManager<T> manager, out int start, out int length);
+        public static bool TryGetReadOnlyMemory<T>(ReadOnlySequence<T> sequence, out ReadOnlyMemory<T> memory);
+        public static bool TryGetReadOnlySequenceSegment<T>(ReadOnlySequence<T> sequence, out ReadOnlySequenceSegment<T> startSegment, out int startIndex, out ReadOnlySequenceSegment<T> endSegment, out int endIndex);
+    }
 }
```

