# .NET Core 2.1-Preview2

.NET Core 2.1-Preview2 comprises:

* .NET Core Runtime 2.1.0-preview2-26406-04
* .NET Core SDK 2.1.300-preview2-008530

|         | SDK Installer                                         | SDK Binaries                                                         | Runtime Installer                                                  | Runtime Binaries                                                   |
| ------- | :---------------------------------------------------: | :-------------------------------------------------------------------:| :----------------------------------------------------------------: | :----------------------------------------------------------------: |
| Windows | [32-bit](https://download.microsoft.com/download/3/7/C/37C0D2E3-2056-4F9A-A67C-14DEFBD70F06/dotnet-sdk-2.1.300-preview2-008530-win-x86.exe) / [64-bit](https://download.microsoft.com/download/3/7/C/37C0D2E3-2056-4F9A-A67C-14DEFBD70F06/dotnet-sdk-2.1.300-preview2-008530-win-x64.exe)  | [32-bit](https://download.microsoft.com/download/3/7/C/37C0D2E3-2056-4F9A-A67C-14DEFBD70F06/dotnet-sdk-2.1.300-preview2-008530-win-x86.zip) / [64-bit](https://download.microsoft.com/download/3/7/C/37C0D2E3-2056-4F9A-A67C-14DEFBD70F06/dotnet-sdk-2.1.300-preview2-008530-win-x64.zip) | [32-bit](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/dotnet-runtime-2.1.0-preview2-26406-04-win-x86.exe) / [64-bit](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/dotnet-runtime-2.1.0-preview2-26406-04-win-x64.exe) | [32-bit](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/dotnet-runtime-2.1.0-preview2-26406-04-win-x86.zip) / [64-bit](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/dotnet-runtime-2.1.0-preview2-26406-04-win-x64.zip) |
| macOS   | [64-bit](https://download.microsoft.com/download/3/7/C/37C0D2E3-2056-4F9A-A67C-14DEFBD70F06/dotnet-sdk-2.1.300-preview2-008530-osx-x64.pkg)  | [64-bit](https://download.microsoft.com/download/3/7/C/37C0D2E3-2056-4F9A-A67C-14DEFBD70F06/dotnet-sdk-2.1.300-preview2-008530-osx-x64.tar.gz)| [64-bit](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/dotnet-runtime-2.1.0-preview2-26406-04-osx-x64.pkg)      | [64-bit](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/dotnet-runtime-2.1.0-preview2-26406-04-osx-x64.tar.gz)   |
| Linux * | See installations steps below                         | [64-bit](https://download.microsoft.com/download/3/7/C/37C0D2E3-2056-4F9A-A67C-14DEFBD70F06/dotnet-sdk-2.1.300-preview2-008530-linux-x64.tar.gz)     | -                                                                  | [64-bit](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/dotnet-runtime-2.1.0-preview2-26406-04-linux-x64.tar.gz) |

**Checksum** files to verify downloads are available as follows:
* [Checksums_Runtime](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.0-preview2-26406-04-runtime-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.300-preview2-008530-sdk-sha.txt)

**Debug Symbols**
* [Shared Framework](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/coreclr-2.1-preview2-symbols.zip)
* [Runtime](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/corefx-2.1-preview2-symbols.zip)
* [Setup](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/core-setup-2.1-preview2-symbols.zip)

## Docker

Images for .NET Core 2.1.0-preview2-26406-04 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).
## Installing .NET Core on Linux

### Uninstall any Preview versions

If you have previous .NET Core Previews or daily builds installed, these to be removed before attempting to install .NET Core 2.1. This can be done by running a command such as the following.

### Linux installer issue

There's an issue with the Linux installers where a clean system installing a stable release of .NET Core will also install the Preview version of the .NET Host (`dotnet-host` package) resulting in a broken state. Until we work out how best to resolve this issue, Preview installers will not be published to the Linux package manager feeds. Please use the binary archive (tar.gz) install instructions below.

## Installation from a binary archive

Installing from the packages detailed above is recommended and you can also install from binary archive. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet` and a symbolic link created for `dotnet`.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1.0-preview2-26406-04` using your package manager.

## Server Hosting

If you are looking to host stand-alone apps on Servers, the following installers can be used on Windows and Linx systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:
[dotnet-hosting-2.1.0-preview2-final-win.exe](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/dotnet-hosting-2.1.0-preview2-final-win.exe)
This will install the ASP.NET Core Module for IIS

### ASP.NET Core Runtime

The ASP.NET Core Runtime is installed by the .NET Core SDK and the Windows Server Hosting installer. If you need to install the ASP.NET Runtime separately, the following can be used.

* [aspnetcore-runtime-2.1.0-preview2-final-win-x64.exe](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/aspnetcore-runtime-2.1.0-preview2-final-win-x64.exe)
* [aspnetcore-runtime-2.1.0-preview2-final-win-x86.exe](https://download.microsoft.com/download/9/0/F/90F8F18D-CD21-4A79-ACDC-AF4CB95F490C/aspnetcore-runtime-2.1.0-preview2-final-win-x86.exe)

On Linux systems install `aspnetcore-runtime-2.1.0-preview2-26406-04` using your package manager. This will install both the ASP.NET Core and .NET Core runtime components.
