// Copyright 2016 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Flags: --harmony-regexp-property

function t(re, s) { assertTrue(re.test(s)); }
function f(re, s) { assertFalse(re.test(s)); }

t(/\p{Script_Extensions=Bopo}+/u, "\u300A");
t(/\p{Script_Extensions=Hang}+/u, "\u300A");
t(/\p{Script_Extensions=Hani}+/u, "\u300A");
t(/\p{Script_Extensions=Hira}+/u, "\u300A");
t(/\p{Script_Extensions=Kana}+/u, "\u300A");
t(/\p{Script_Extensions=Yiii}+/u, "\u300A");

t(/\p{scx=Bopomofo}+/u, "\u3003");
t(/\p{scx=Hangul}+/u, "\u3003");
t(/\p{scx=Han}+/u, "\u3003");
t(/\p{scx=Hiragana}+/u, "\u3003");
t(/\p{scx=Katakana}+/u, "\u3003");
f(/\p{scx=Yi}+/u, "\u3003");

t(/\p{Script_Extensions=Cypriot}+/u, "\u{10107}");
f(/\p{Script=Cypriot}+/u, "\u{10107}");
f(/\p{scx=Cprt}+/u, "\u3003");

/* Auto-generated from unicode data file using following script
let data = read("ScriptExtensions.txt");
let map = new Map();
for (let line of data.split("\n")) {
  let match = /^(\p{Hex}{4,6})(..(\p{Hex}{4,6}))?\s+; ([\w\s]+) #/u.exec(line);
  if (!match) continue;
  let [,start,,end,scripts] = match;
  if (!end) end = start;
  start = parseInt(start, 16);
  end = parseInt(end, 16);
  for (let script of scripts.split(" ")) {
    let codepoints = map.get(script) || new Set();
    for (let c = start; c <= end; c++) codepoints.add(c);
    map.set(script, codepoints);
  }
}

for (let s of map.keys()){
  let codepoints = map.get(s);
  print(`// Script_Extension=${s}`);
  for (let c of codepoints.values()) {
    print(`t(/\\p{scx=${s}}/u, "\\u{${c.toString(16)}}");`);
    print(`f(/\\P{scx=${s}}/u, "\\u{${c.toString(16)}}");`);
  }
  for (let i = 0; i < 5;) {
    let c = (Math.random() * 0x110000) | 0;
    if (codepoints.has(c)) continue;
    print(`f(/(?=\\P{sc=${s}})\\p{scx=${s}}/u, "\\u{${c.toString(16)}}");`);
    i++;
  }
}
*/

// Unicode version 9.0.0
// Script_Extension=Deva
t(/\p{scx=Deva}/u, "\u{1cd1}");
f(/\P{scx=Deva}/u, "\u{1cd1}");
t(/\p{scx=Deva}/u, "\u{1cd4}");
f(/\P{scx=Deva}/u, "\u{1cd4}");
t(/\p{scx=Deva}/u, "\u{1cd5}");
f(/\P{scx=Deva}/u, "\u{1cd5}");
t(/\p{scx=Deva}/u, "\u{1cd6}");
f(/\P{scx=Deva}/u, "\u{1cd6}");
t(/\p{scx=Deva}/u, "\u{1cd8}");
f(/\P{scx=Deva}/u, "\u{1cd8}");
t(/\p{scx=Deva}/u, "\u{1cdb}");
f(/\P{scx=Deva}/u, "\u{1cdb}");
t(/\p{scx=Deva}/u, "\u{1cde}");
f(/\P{scx=Deva}/u, "\u{1cde}");
t(/\p{scx=Deva}/u, "\u{1cdf}");
f(/\P{scx=Deva}/u, "\u{1cdf}");
t(/\p{scx=Deva}/u, "\u{1ce1}");
f(/\P{scx=Deva}/u, "\u{1ce1}");
t(/\p{scx=Deva}/u, "\u{1ce2}");
f(/\P{scx=Deva}/u, "\u{1ce2}");
t(/\p{scx=Deva}/u, "\u{1ce3}");
f(/\P{scx=Deva}/u, "\u{1ce3}");
t(/\p{scx=Deva}/u, "\u{1ce4}");
f(/\P{scx=Deva}/u, "\u{1ce4}");
t(/\p{scx=Deva}/u, "\u{1ce5}");
f(/\P{scx=Deva}/u, "\u{1ce5}");
t(/\p{scx=Deva}/u, "\u{1ce6}");
f(/\P{scx=Deva}/u, "\u{1ce6}");
t(/\p{scx=Deva}/u, "\u{1ce7}");
f(/\P{scx=Deva}/u, "\u{1ce7}");
t(/\p{scx=Deva}/u, "\u{1ce8}");
f(/\P{scx=Deva}/u, "\u{1ce8}");
t(/\p{scx=Deva}/u, "\u{1ce9}");
f(/\P{scx=Deva}/u, "\u{1ce9}");
t(/\p{scx=Deva}/u, "\u{1cea}");
f(/\P{scx=Deva}/u, "\u{1cea}");
t(/\p{scx=Deva}/u, "\u{1ceb}");
f(/\P{scx=Deva}/u, "\u{1ceb}");
t(/\p{scx=Deva}/u, "\u{1cec}");
f(/\P{scx=Deva}/u, "\u{1cec}");
t(/\p{scx=Deva}/u, "\u{1ced}");
f(/\P{scx=Deva}/u, "\u{1ced}");
t(/\p{scx=Deva}/u, "\u{1cee}");
f(/\P{scx=Deva}/u, "\u{1cee}");
t(/\p{scx=Deva}/u, "\u{1cef}");
f(/\P{scx=Deva}/u, "\u{1cef}");
t(/\p{scx=Deva}/u, "\u{1cf0}");
f(/\P{scx=Deva}/u, "\u{1cf0}");
t(/\p{scx=Deva}/u, "\u{1cf1}");
f(/\P{scx=Deva}/u, "\u{1cf1}");
t(/\p{scx=Deva}/u, "\u{1cf6}");
f(/\P{scx=Deva}/u, "\u{1cf6}");
t(/\p{scx=Deva}/u, "\u{a8f1}");
f(/\P{scx=Deva}/u, "\u{a8f1}");
t(/\p{scx=Deva}/u, "\u{1cd0}");
f(/\P{scx=Deva}/u, "\u{1cd0}");
t(/\p{scx=Deva}/u, "\u{1cd2}");
f(/\P{scx=Deva}/u, "\u{1cd2}");
t(/\p{scx=Deva}/u, "\u{1cd3}");
f(/\P{scx=Deva}/u, "\u{1cd3}");
t(/\p{scx=Deva}/u, "\u{1cf2}");
f(/\P{scx=Deva}/u, "\u{1cf2}");
t(/\p{scx=Deva}/u, "\u{1cf3}");
f(/\P{scx=Deva}/u, "\u{1cf3}");
t(/\p{scx=Deva}/u, "\u{1cf4}");
f(/\P{scx=Deva}/u, "\u{1cf4}");
t(/\p{scx=Deva}/u, "\u{1cf8}");
f(/\P{scx=Deva}/u, "\u{1cf8}");
t(/\p{scx=Deva}/u, "\u{1cf9}");
f(/\P{scx=Deva}/u, "\u{1cf9}");
t(/\p{scx=Deva}/u, "\u{1cf5}");
f(/\P{scx=Deva}/u, "\u{1cf5}");
t(/\p{scx=Deva}/u, "\u{1cd7}");
f(/\P{scx=Deva}/u, "\u{1cd7}");
t(/\p{scx=Deva}/u, "\u{1cd9}");
f(/\P{scx=Deva}/u, "\u{1cd9}");
t(/\p{scx=Deva}/u, "\u{1cdc}");
f(/\P{scx=Deva}/u, "\u{1cdc}");
t(/\p{scx=Deva}/u, "\u{1cdd}");
f(/\P{scx=Deva}/u, "\u{1cdd}");
t(/\p{scx=Deva}/u, "\u{1ce0}");
f(/\P{scx=Deva}/u, "\u{1ce0}");
t(/\p{scx=Deva}/u, "\u{a8f3}");
f(/\P{scx=Deva}/u, "\u{a8f3}");
t(/\p{scx=Deva}/u, "\u{20f0}");
f(/\P{scx=Deva}/u, "\u{20f0}");
t(/\p{scx=Deva}/u, "\u{966}");
f(/\P{scx=Deva}/u, "\u{966}");
t(/\p{scx=Deva}/u, "\u{967}");
f(/\P{scx=Deva}/u, "\u{967}");
t(/\p{scx=Deva}/u, "\u{968}");
f(/\P{scx=Deva}/u, "\u{968}");
t(/\p{scx=Deva}/u, "\u{969}");
f(/\P{scx=Deva}/u, "\u{969}");
t(/\p{scx=Deva}/u, "\u{96a}");
f(/\P{scx=Deva}/u, "\u{96a}");
t(/\p{scx=Deva}/u, "\u{96b}");
f(/\P{scx=Deva}/u, "\u{96b}");
t(/\p{scx=Deva}/u, "\u{96c}");
f(/\P{scx=Deva}/u, "\u{96c}");
t(/\p{scx=Deva}/u, "\u{96d}");
f(/\P{scx=Deva}/u, "\u{96d}");
t(/\p{scx=Deva}/u, "\u{96e}");
f(/\P{scx=Deva}/u, "\u{96e}");
t(/\p{scx=Deva}/u, "\u{96f}");
f(/\P{scx=Deva}/u, "\u{96f}");
t(/\p{scx=Deva}/u, "\u{1cda}");
f(/\P{scx=Deva}/u, "\u{1cda}");
t(/\p{scx=Deva}/u, "\u{a836}");
f(/\P{scx=Deva}/u, "\u{a836}");
t(/\p{scx=Deva}/u, "\u{a837}");
f(/\P{scx=Deva}/u, "\u{a837}");
t(/\p{scx=Deva}/u, "\u{a838}");
f(/\P{scx=Deva}/u, "\u{a838}");
t(/\p{scx=Deva}/u, "\u{a839}");
f(/\P{scx=Deva}/u, "\u{a839}");
t(/\p{scx=Deva}/u, "\u{a830}");
f(/\P{scx=Deva}/u, "\u{a830}");
t(/\p{scx=Deva}/u, "\u{a831}");
f(/\P{scx=Deva}/u, "\u{a831}");
t(/\p{scx=Deva}/u, "\u{a832}");
f(/\P{scx=Deva}/u, "\u{a832}");
t(/\p{scx=Deva}/u, "\u{a833}");
f(/\P{scx=Deva}/u, "\u{a833}");
t(/\p{scx=Deva}/u, "\u{a834}");
f(/\P{scx=Deva}/u, "\u{a834}");
t(/\p{scx=Deva}/u, "\u{a835}");
f(/\P{scx=Deva}/u, "\u{a835}");
t(/\p{scx=Deva}/u, "\u{952}");
f(/\P{scx=Deva}/u, "\u{952}");
t(/\p{scx=Deva}/u, "\u{951}");
f(/\P{scx=Deva}/u, "\u{951}");
t(/\p{scx=Deva}/u, "\u{964}");
f(/\P{scx=Deva}/u, "\u{964}");
t(/\p{scx=Deva}/u, "\u{965}");
f(/\P{scx=Deva}/u, "\u{965}");
f(/(?=\P{sc=Deva})\p{scx=Deva}/u, "\u{ce0}");
f(/(?=\P{sc=Deva})\p{scx=Deva}/u, "\u{98eb0}");
f(/(?=\P{sc=Deva})\p{scx=Deva}/u, "\u{1b381}");
f(/(?=\P{sc=Deva})\p{scx=Deva}/u, "\u{558ed}");
f(/(?=\P{sc=Deva})\p{scx=Deva}/u, "\u{36998}");
// Script_Extension=Dupl
t(/\p{scx=Dupl}/u, "\u{1bca0}");
f(/\P{scx=Dupl}/u, "\u{1bca0}");
t(/\p{scx=Dupl}/u, "\u{1bca1}");
f(/\P{scx=Dupl}/u, "\u{1bca1}");
t(/\p{scx=Dupl}/u, "\u{1bca2}");
f(/\P{scx=Dupl}/u, "\u{1bca2}");
t(/\p{scx=Dupl}/u, "\u{1bca3}");
f(/\P{scx=Dupl}/u, "\u{1bca3}");
f(/(?=\P{sc=Dupl})\p{scx=Dupl}/u, "\u{42ba7}");
f(/(?=\P{sc=Dupl})\p{scx=Dupl}/u, "\u{fa669}");
f(/(?=\P{sc=Dupl})\p{scx=Dupl}/u, "\u{8a725}");
f(/(?=\P{sc=Dupl})\p{scx=Dupl}/u, "\u{4d069}");
f(/(?=\P{sc=Dupl})\p{scx=Dupl}/u, "\u{b3c09}");
// Script_Extension=Grek
t(/\p{scx=Grek}/u, "\u{342}");
f(/\P{scx=Grek}/u, "\u{342}");
t(/\p{scx=Grek}/u, "\u{345}");
f(/\P{scx=Grek}/u, "\u{345}");
t(/\p{scx=Grek}/u, "\u{1dc0}");
f(/\P{scx=Grek}/u, "\u{1dc0}");
t(/\p{scx=Grek}/u, "\u{1dc1}");
f(/\P{scx=Grek}/u, "\u{1dc1}");
f(/(?=\P{sc=Grek})\p{scx=Grek}/u, "\u{dd38b}");
f(/(?=\P{sc=Grek})\p{scx=Grek}/u, "\u{121bd}");
f(/(?=\P{sc=Grek})\p{scx=Grek}/u, "\u{f8499}");
f(/(?=\P{sc=Grek})\p{scx=Grek}/u, "\u{29b57}");
f(/(?=\P{sc=Grek})\p{scx=Grek}/u, "\u{6e536}");
// Script_Extension=Hani
t(/\p{scx=Hani}/u, "\u{3006}");
f(/\P{scx=Hani}/u, "\u{3006}");
t(/\p{scx=Hani}/u, "\u{303e}");
f(/\P{scx=Hani}/u, "\u{303e}");
t(/\p{scx=Hani}/u, "\u{303f}");
f(/\P{scx=Hani}/u, "\u{303f}");
t(/\p{scx=Hani}/u, "\u{3190}");
f(/\P{scx=Hani}/u, "\u{3190}");
t(/\p{scx=Hani}/u, "\u{3191}");
f(/\P{scx=Hani}/u, "\u{3191}");
t(/\p{scx=Hani}/u, "\u{3192}");
f(/\P{scx=Hani}/u, "\u{3192}");
t(/\p{scx=Hani}/u, "\u{3193}");
f(/\P{scx=Hani}/u, "\u{3193}");
t(/\p{scx=Hani}/u, "\u{3194}");
f(/\P{scx=Hani}/u, "\u{3194}");
t(/\p{scx=Hani}/u, "\u{3195}");
f(/\P{scx=Hani}/u, "\u{3195}");
t(/\p{scx=Hani}/u, "\u{3196}");
f(/\P{scx=Hani}/u, "\u{3196}");
t(/\p{scx=Hani}/u, "\u{3197}");
f(/\P{scx=Hani}/u, "\u{3197}");
t(/\p{scx=Hani}/u, "\u{3198}");
f(/\P{scx=Hani}/u, "\u{3198}");
t(/\p{scx=Hani}/u, "\u{3199}");
f(/\P{scx=Hani}/u, "\u{3199}");
t(/\p{scx=Hani}/u, "\u{319a}");
f(/\P{scx=Hani}/u, "\u{319a}");
t(/\p{scx=Hani}/u, "\u{319b}");
f(/\P{scx=Hani}/u, "\u{319b}");
t(/\p{scx=Hani}/u, "\u{319c}");
f(/\P{scx=Hani}/u, "\u{319c}");
t(/\p{scx=Hani}/u, "\u{319d}");
f(/\P{scx=Hani}/u, "\u{319d}");
t(/\p{scx=Hani}/u, "\u{319e}");
f(/\P{scx=Hani}/u, "\u{319e}");
t(/\p{scx=Hani}/u, "\u{319f}");
f(/\P{scx=Hani}/u, "\u{319f}");
t(/\p{scx=Hani}/u, "\u{31c0}");
f(/\P{scx=Hani}/u, "\u{31c0}");
t(/\p{scx=Hani}/u, "\u{31c1}");
f(/\P{scx=Hani}/u, "\u{31c1}");
t(/\p{scx=Hani}/u, "\u{31c2}");
f(/\P{scx=Hani}/u, "\u{31c2}");
t(/\p{scx=Hani}/u, "\u{31c3}");
f(/\P{scx=Hani}/u, "\u{31c3}");
t(/\p{scx=Hani}/u, "\u{31c4}");
f(/\P{scx=Hani}/u, "\u{31c4}");
t(/\p{scx=Hani}/u, "\u{31c5}");
f(/\P{scx=Hani}/u, "\u{31c5}");
t(/\p{scx=Hani}/u, "\u{31c6}");
f(/\P{scx=Hani}/u, "\u{31c6}");
t(/\p{scx=Hani}/u, "\u{31c7}");
f(/\P{scx=Hani}/u, "\u{31c7}");
t(/\p{scx=Hani}/u, "\u{31c8}");
f(/\P{scx=Hani}/u, "\u{31c8}");
t(/\p{scx=Hani}/u, "\u{31c9}");
f(/\P{scx=Hani}/u, "\u{31c9}");
t(/\p{scx=Hani}/u, "\u{31ca}");
f(/\P{scx=Hani}/u, "\u{31ca}");
t(/\p{scx=Hani}/u, "\u{31cb}");
f(/\P{scx=Hani}/u, "\u{31cb}");
t(/\p{scx=Hani}/u, "\u{31cc}");
f(/\P{scx=Hani}/u, "\u{31cc}");
t(/\p{scx=Hani}/u, "\u{31cd}");
f(/\P{scx=Hani}/u, "\u{31cd}");
t(/\p{scx=Hani}/u, "\u{31ce}");
f(/\P{scx=Hani}/u, "\u{31ce}");
t(/\p{scx=Hani}/u, "\u{31cf}");
f(/\P{scx=Hani}/u, "\u{31cf}");
t(/\p{scx=Hani}/u, "\u{31d0}");
f(/\P{scx=Hani}/u, "\u{31d0}");
t(/\p{scx=Hani}/u, "\u{31d1}");
f(/\P{scx=Hani}/u, "\u{31d1}");
t(/\p{scx=Hani}/u, "\u{31d2}");
f(/\P{scx=Hani}/u, "\u{31d2}");
t(/\p{scx=Hani}/u, "\u{31d3}");
f(/\P{scx=Hani}/u, "\u{31d3}");
t(/\p{scx=Hani}/u, "\u{31d4}");
f(/\P{scx=Hani}/u, "\u{31d4}");
t(/\p{scx=Hani}/u, "\u{31d5}");
f(/\P{scx=Hani}/u, "\u{31d5}");
t(/\p{scx=Hani}/u, "\u{31d6}");
f(/\P{scx=Hani}/u, "\u{31d6}");
t(/\p{scx=Hani}/u, "\u{31d7}");
f(/\P{scx=Hani}/u, "\u{31d7}");
t(/\p{scx=Hani}/u, "\u{31d8}");
f(/\P{scx=Hani}/u, "\u{31d8}");
t(/\p{scx=Hani}/u, "\u{31d9}");
f(/\P{scx=Hani}/u, "\u{31d9}");
t(/\p{scx=Hani}/u, "\u{31da}");
f(/\P{scx=Hani}/u, "\u{31da}");
t(/\p{scx=Hani}/u, "\u{31db}");
f(/\P{scx=Hani}/u, "\u{31db}");
t(/\p{scx=Hani}/u, "\u{31dc}");
f(/\P{scx=Hani}/u, "\u{31dc}");
t(/\p{scx=Hani}/u, "\u{31dd}");
f(/\P{scx=Hani}/u, "\u{31dd}");
t(/\p{scx=Hani}/u, "\u{31de}");
f(/\P{scx=Hani}/u, "\u{31de}");
t(/\p{scx=Hani}/u, "\u{31df}");
f(/\P{scx=Hani}/u, "\u{31df}");
t(/\p{scx=Hani}/u, "\u{31e0}");
f(/\P{scx=Hani}/u, "\u{31e0}");
t(/\p{scx=Hani}/u, "\u{31e1}");
f(/\P{scx=Hani}/u, "\u{31e1}");
t(/\p{scx=Hani}/u, "\u{31e2}");
f(/\P{scx=Hani}/u, "\u{31e2}");
t(/\p{scx=Hani}/u, "\u{31e3}");
f(/\P{scx=Hani}/u, "\u{31e3}");
t(/\p{scx=Hani}/u, "\u{3220}");
f(/\P{scx=Hani}/u, "\u{3220}");
t(/\p{scx=Hani}/u, "\u{3221}");
f(/\P{scx=Hani}/u, "\u{3221}");
t(/\p{scx=Hani}/u, "\u{3222}");
f(/\P{scx=Hani}/u, "\u{3222}");
t(/\p{scx=Hani}/u, "\u{3223}");
f(/\P{scx=Hani}/u, "\u{3223}");
t(/\p{scx=Hani}/u, "\u{3224}");
f(/\P{scx=Hani}/u, "\u{3224}");
t(/\p{scx=Hani}/u, "\u{3225}");
f(/\P{scx=Hani}/u, "\u{3225}");
t(/\p{scx=Hani}/u, "\u{3226}");
f(/\P{scx=Hani}/u, "\u{3226}");
t(/\p{scx=Hani}/u, "\u{3227}");
f(/\P{scx=Hani}/u, "\u{3227}");
t(/\p{scx=Hani}/u, "\u{3228}");
f(/\P{scx=Hani}/u, "\u{3228}");
t(/\p{scx=Hani}/u, "\u{3229}");
f(/\P{scx=Hani}/u, "\u{3229}");
t(/\p{scx=Hani}/u, "\u{322a}");
f(/\P{scx=Hani}/u, "\u{322a}");
t(/\p{scx=Hani}/u, "\u{322b}");
f(/\P{scx=Hani}/u, "\u{322b}");
t(/\p{scx=Hani}/u, "\u{322c}");
f(/\P{scx=Hani}/u, "\u{322c}");
t(/\p{scx=Hani}/u, "\u{322d}");
f(/\P{scx=Hani}/u, "\u{322d}");
t(/\p{scx=Hani}/u, "\u{322e}");
f(/\P{scx=Hani}/u, "\u{322e}");
t(/\p{scx=Hani}/u, "\u{322f}");
f(/\P{scx=Hani}/u, "\u{322f}");
t(/\p{scx=Hani}/u, "\u{3230}");
f(/\P{scx=Hani}/u, "\u{3230}");
t(/\p{scx=Hani}/u, "\u{3231}");
f(/\P{scx=Hani}/u, "\u{3231}");
t(/\p{scx=Hani}/u, "\u{3232}");
f(/\P{scx=Hani}/u, "\u{3232}");
t(/\p{scx=Hani}/u, "\u{3233}");
f(/\P{scx=Hani}/u, "\u{3233}");
t(/\p{scx=Hani}/u, "\u{3234}");
f(/\P{scx=Hani}/u, "\u{3234}");
t(/\p{scx=Hani}/u, "\u{3235}");
f(/\P{scx=Hani}/u, "\u{3235}");
t(/\p{scx=Hani}/u, "\u{3236}");
f(/\P{scx=Hani}/u, "\u{3236}");
t(/\p{scx=Hani}/u, "\u{3237}");
f(/\P{scx=Hani}/u, "\u{3237}");
t(/\p{scx=Hani}/u, "\u{3238}");
f(/\P{scx=Hani}/u, "\u{3238}");
t(/\p{scx=Hani}/u, "\u{3239}");
f(/\P{scx=Hani}/u, "\u{3239}");
t(/\p{scx=Hani}/u, "\u{323a}");
f(/\P{scx=Hani}/u, "\u{323a}");
t(/\p{scx=Hani}/u, "\u{323b}");
f(/\P{scx=Hani}/u, "\u{323b}");
t(/\p{scx=Hani}/u, "\u{323c}");
f(/\P{scx=Hani}/u, "\u{323c}");
t(/\p{scx=Hani}/u, "\u{323d}");
f(/\P{scx=Hani}/u, "\u{323d}");
t(/\p{scx=Hani}/u, "\u{323e}");
f(/\P{scx=Hani}/u, "\u{323e}");
t(/\p{scx=Hani}/u, "\u{323f}");
f(/\P{scx=Hani}/u, "\u{323f}");
t(/\p{scx=Hani}/u, "\u{3240}");
f(/\P{scx=Hani}/u, "\u{3240}");
t(/\p{scx=Hani}/u, "\u{3241}");
f(/\P{scx=Hani}/u, "\u{3241}");
t(/\p{scx=Hani}/u, "\u{3242}");
f(/\P{scx=Hani}/u, "\u{3242}");
t(/\p{scx=Hani}/u, "\u{3243}");
f(/\P{scx=Hani}/u, "\u{3243}");
t(/\p{scx=Hani}/u, "\u{3244}");
f(/\P{scx=Hani}/u, "\u{3244}");
t(/\p{scx=Hani}/u, "\u{3245}");
f(/\P{scx=Hani}/u, "\u{3245}");
t(/\p{scx=Hani}/u, "\u{3246}");
f(/\P{scx=Hani}/u, "\u{3246}");
t(/\p{scx=Hani}/u, "\u{3247}");
f(/\P{scx=Hani}/u, "\u{3247}");
t(/\p{scx=Hani}/u, "\u{3280}");
f(/\P{scx=Hani}/u, "\u{3280}");
t(/\p{scx=Hani}/u, "\u{3281}");
f(/\P{scx=Hani}/u, "\u{3281}");
t(/\p{scx=Hani}/u, "\u{3282}");
f(/\P{scx=Hani}/u, "\u{3282}");
t(/\p{scx=Hani}/u, "\u{3283}");
f(/\P{scx=Hani}/u, "\u{3283}");
t(/\p{scx=Hani}/u, "\u{3284}");
f(/\P{scx=Hani}/u, "\u{3284}");
t(/\p{scx=Hani}/u, "\u{3285}");
f(/\P{scx=Hani}/u, "\u{3285}");
t(/\p{scx=Hani}/u, "\u{3286}");
f(/\P{scx=Hani}/u, "\u{3286}");
t(/\p{scx=Hani}/u, "\u{3287}");
f(/\P{scx=Hani}/u, "\u{3287}");
t(/\p{scx=Hani}/u, "\u{3288}");
f(/\P{scx=Hani}/u, "\u{3288}");
t(/\p{scx=Hani}/u, "\u{3289}");
f(/\P{scx=Hani}/u, "\u{3289}");
t(/\p{scx=Hani}/u, "\u{328a}");
f(/\P{scx=Hani}/u, "\u{328a}");
t(/\p{scx=Hani}/u, "\u{328b}");
f(/\P{scx=Hani}/u, "\u{328b}");
t(/\p{scx=Hani}/u, "\u{328c}");
f(/\P{scx=Hani}/u, "\u{328c}");
t(/\p{scx=Hani}/u, "\u{328d}");
f(/\P{scx=Hani}/u, "\u{328d}");
t(/\p{scx=Hani}/u, "\u{328e}");
f(/\P{scx=Hani}/u, "\u{328e}");
t(/\p{scx=Hani}/u, "\u{328f}");
f(/\P{scx=Hani}/u, "\u{328f}");
t(/\p{scx=Hani}/u, "\u{3290}");
f(/\P{scx=Hani}/u, "\u{3290}");
t(/\p{scx=Hani}/u, "\u{3291}");
f(/\P{scx=Hani}/u, "\u{3291}");
t(/\p{scx=Hani}/u, "\u{3292}");
f(/\P{scx=Hani}/u, "\u{3292}");
t(/\p{scx=Hani}/u, "\u{3293}");
f(/\P{scx=Hani}/u, "\u{3293}");
t(/\p{scx=Hani}/u, "\u{3294}");
f(/\P{scx=Hani}/u, "\u{3294}");
t(/\p{scx=Hani}/u, "\u{3295}");
f(/\P{scx=Hani}/u, "\u{3295}");
t(/\p{scx=Hani}/u, "\u{3296}");
f(/\P{scx=Hani}/u, "\u{3296}");
t(/\p{scx=Hani}/u, "\u{3297}");
f(/\P{scx=Hani}/u, "\u{3297}");
t(/\p{scx=Hani}/u, "\u{3298}");
f(/\P{scx=Hani}/u, "\u{3298}");
t(/\p{scx=Hani}/u, "\u{3299}");
f(/\P{scx=Hani}/u, "\u{3299}");
t(/\p{scx=Hani}/u, "\u{329a}");
f(/\P{scx=Hani}/u, "\u{329a}");
t(/\p{scx=Hani}/u, "\u{329b}");
f(/\P{scx=Hani}/u, "\u{329b}");
t(/\p{scx=Hani}/u, "\u{329c}");
f(/\P{scx=Hani}/u, "\u{329c}");
t(/\p{scx=Hani}/u, "\u{329d}");
f(/\P{scx=Hani}/u, "\u{329d}");
t(/\p{scx=Hani}/u, "\u{329e}");
f(/\P{scx=Hani}/u, "\u{329e}");
t(/\p{scx=Hani}/u, "\u{329f}");
f(/\P{scx=Hani}/u, "\u{329f}");
t(/\p{scx=Hani}/u, "\u{32a0}");
f(/\P{scx=Hani}/u, "\u{32a0}");
t(/\p{scx=Hani}/u, "\u{32a1}");
f(/\P{scx=Hani}/u, "\u{32a1}");
t(/\p{scx=Hani}/u, "\u{32a2}");
f(/\P{scx=Hani}/u, "\u{32a2}");
t(/\p{scx=Hani}/u, "\u{32a3}");
f(/\P{scx=Hani}/u, "\u{32a3}");
t(/\p{scx=Hani}/u, "\u{32a4}");
f(/\P{scx=Hani}/u, "\u{32a4}");
t(/\p{scx=Hani}/u, "\u{32a5}");
f(/\P{scx=Hani}/u, "\u{32a5}");
t(/\p{scx=Hani}/u, "\u{32a6}");
f(/\P{scx=Hani}/u, "\u{32a6}");
t(/\p{scx=Hani}/u, "\u{32a7}");
f(/\P{scx=Hani}/u, "\u{32a7}");
t(/\p{scx=Hani}/u, "\u{32a8}");
f(/\P{scx=Hani}/u, "\u{32a8}");
t(/\p{scx=Hani}/u, "\u{32a9}");
f(/\P{scx=Hani}/u, "\u{32a9}");
t(/\p{scx=Hani}/u, "\u{32aa}");
f(/\P{scx=Hani}/u, "\u{32aa}");
t(/\p{scx=Hani}/u, "\u{32ab}");
f(/\P{scx=Hani}/u, "\u{32ab}");
t(/\p{scx=Hani}/u, "\u{32ac}");
f(/\P{scx=Hani}/u, "\u{32ac}");
t(/\p{scx=Hani}/u, "\u{32ad}");
f(/\P{scx=Hani}/u, "\u{32ad}");
t(/\p{scx=Hani}/u, "\u{32ae}");
f(/\P{scx=Hani}/u, "\u{32ae}");
t(/\p{scx=Hani}/u, "\u{32af}");
f(/\P{scx=Hani}/u, "\u{32af}");
t(/\p{scx=Hani}/u, "\u{32b0}");
f(/\P{scx=Hani}/u, "\u{32b0}");
t(/\p{scx=Hani}/u, "\u{32c0}");
f(/\P{scx=Hani}/u, "\u{32c0}");
t(/\p{scx=Hani}/u, "\u{32c1}");
f(/\P{scx=Hani}/u, "\u{32c1}");
t(/\p{scx=Hani}/u, "\u{32c2}");
f(/\P{scx=Hani}/u, "\u{32c2}");
t(/\p{scx=Hani}/u, "\u{32c3}");
f(/\P{scx=Hani}/u, "\u{32c3}");
t(/\p{scx=Hani}/u, "\u{32c4}");
f(/\P{scx=Hani}/u, "\u{32c4}");
t(/\p{scx=Hani}/u, "\u{32c5}");
f(/\P{scx=Hani}/u, "\u{32c5}");
t(/\p{scx=Hani}/u, "\u{32c6}");
f(/\P{scx=Hani}/u, "\u{32c6}");
t(/\p{scx=Hani}/u, "\u{32c7}");
f(/\P{scx=Hani}/u, "\u{32c7}");
t(/\p{scx=Hani}/u, "\u{32c8}");
f(/\P{scx=Hani}/u, "\u{32c8}");
t(/\p{scx=Hani}/u, "\u{32c9}");
f(/\P{scx=Hani}/u, "\u{32c9}");
t(/\p{scx=Hani}/u, "\u{32ca}");
f(/\P{scx=Hani}/u, "\u{32ca}");
t(/\p{scx=Hani}/u, "\u{32cb}");
f(/\P{scx=Hani}/u, "\u{32cb}");
t(/\p{scx=Hani}/u, "\u{3358}");
f(/\P{scx=Hani}/u, "\u{3358}");
t(/\p{scx=Hani}/u, "\u{3359}");
f(/\P{scx=Hani}/u, "\u{3359}");
t(/\p{scx=Hani}/u, "\u{335a}");
f(/\P{scx=Hani}/u, "\u{335a}");
t(/\p{scx=Hani}/u, "\u{335b}");
f(/\P{scx=Hani}/u, "\u{335b}");
t(/\p{scx=Hani}/u, "\u{335c}");
f(/\P{scx=Hani}/u, "\u{335c}");
t(/\p{scx=Hani}/u, "\u{335d}");
f(/\P{scx=Hani}/u, "\u{335d}");
t(/\p{scx=Hani}/u, "\u{335e}");
f(/\P{scx=Hani}/u, "\u{335e}");
t(/\p{scx=Hani}/u, "\u{335f}");
f(/\P{scx=Hani}/u, "\u{335f}");
t(/\p{scx=Hani}/u, "\u{3360}");
f(/\P{scx=Hani}/u, "\u{3360}");
t(/\p{scx=Hani}/u, "\u{3361}");
f(/\P{scx=Hani}/u, "\u{3361}");
t(/\p{scx=Hani}/u, "\u{3362}");
f(/\P{scx=Hani}/u, "\u{3362}");
t(/\p{scx=Hani}/u, "\u{3363}");
f(/\P{scx=Hani}/u, "\u{3363}");
t(/\p{scx=Hani}/u, "\u{3364}");
f(/\P{scx=Hani}/u, "\u{3364}");
t(/\p{scx=Hani}/u, "\u{3365}");
f(/\P{scx=Hani}/u, "\u{3365}");
t(/\p{scx=Hani}/u, "\u{3366}");
f(/\P{scx=Hani}/u, "\u{3366}");
t(/\p{scx=Hani}/u, "\u{3367}");
f(/\P{scx=Hani}/u, "\u{3367}");
t(/\p{scx=Hani}/u, "\u{3368}");
f(/\P{scx=Hani}/u, "\u{3368}");
t(/\p{scx=Hani}/u, "\u{3369}");
f(/\P{scx=Hani}/u, "\u{3369}");
t(/\p{scx=Hani}/u, "\u{336a}");
f(/\P{scx=Hani}/u, "\u{336a}");
t(/\p{scx=Hani}/u, "\u{336b}");
f(/\P{scx=Hani}/u, "\u{336b}");
t(/\p{scx=Hani}/u, "\u{336c}");
f(/\P{scx=Hani}/u, "\u{336c}");
t(/\p{scx=Hani}/u, "\u{336d}");
f(/\P{scx=Hani}/u, "\u{336d}");
t(/\p{scx=Hani}/u, "\u{336e}");
f(/\P{scx=Hani}/u, "\u{336e}");
t(/\p{scx=Hani}/u, "\u{336f}");
f(/\P{scx=Hani}/u, "\u{336f}");
t(/\p{scx=Hani}/u, "\u{3370}");
f(/\P{scx=Hani}/u, "\u{3370}");
t(/\p{scx=Hani}/u, "\u{337b}");
f(/\P{scx=Hani}/u, "\u{337b}");
t(/\p{scx=Hani}/u, "\u{337c}");
f(/\P{scx=Hani}/u, "\u{337c}");
t(/\p{scx=Hani}/u, "\u{337d}");
f(/\P{scx=Hani}/u, "\u{337d}");
t(/\p{scx=Hani}/u, "\u{337e}");
f(/\P{scx=Hani}/u, "\u{337e}");
t(/\p{scx=Hani}/u, "\u{337f}");
f(/\P{scx=Hani}/u, "\u{337f}");
t(/\p{scx=Hani}/u, "\u{33e0}");
f(/\P{scx=Hani}/u, "\u{33e0}");
t(/\p{scx=Hani}/u, "\u{33e1}");
f(/\P{scx=Hani}/u, "\u{33e1}");
t(/\p{scx=Hani}/u, "\u{33e2}");
f(/\P{scx=Hani}/u, "\u{33e2}");
t(/\p{scx=Hani}/u, "\u{33e3}");
f(/\P{scx=Hani}/u, "\u{33e3}");
t(/\p{scx=Hani}/u, "\u{33e4}");
f(/\P{scx=Hani}/u, "\u{33e4}");
t(/\p{scx=Hani}/u, "\u{33e5}");
f(/\P{scx=Hani}/u, "\u{33e5}");
t(/\p{scx=Hani}/u, "\u{33e6}");
f(/\P{scx=Hani}/u, "\u{33e6}");
t(/\p{scx=Hani}/u, "\u{33e7}");
f(/\P{scx=Hani}/u, "\u{33e7}");
t(/\p{scx=Hani}/u, "\u{33e8}");
f(/\P{scx=Hani}/u, "\u{33e8}");
t(/\p{scx=Hani}/u, "\u{33e9}");
f(/\P{scx=Hani}/u, "\u{33e9}");
t(/\p{scx=Hani}/u, "\u{33ea}");
f(/\P{scx=Hani}/u, "\u{33ea}");
t(/\p{scx=Hani}/u, "\u{33eb}");
f(/\P{scx=Hani}/u, "\u{33eb}");
t(/\p{scx=Hani}/u, "\u{33ec}");
f(/\P{scx=Hani}/u, "\u{33ec}");
t(/\p{scx=Hani}/u, "\u{33ed}");
f(/\P{scx=Hani}/u, "\u{33ed}");
t(/\p{scx=Hani}/u, "\u{33ee}");
f(/\P{scx=Hani}/u, "\u{33ee}");
t(/\p{scx=Hani}/u, "\u{33ef}");
f(/\P{scx=Hani}/u, "\u{33ef}");
t(/\p{scx=Hani}/u, "\u{33f0}");
f(/\P{scx=Hani}/u, "\u{33f0}");
t(/\p{scx=Hani}/u, "\u{33f1}");
f(/\P{scx=Hani}/u, "\u{33f1}");
t(/\p{scx=Hani}/u, "\u{33f2}");
f(/\P{scx=Hani}/u, "\u{33f2}");
t(/\p{scx=Hani}/u, "\u{33f3}");
f(/\P{scx=Hani}/u, "\u{33f3}");
t(/\p{scx=Hani}/u, "\u{33f4}");
f(/\P{scx=Hani}/u, "\u{33f4}");
t(/\p{scx=Hani}/u, "\u{33f5}");
f(/\P{scx=Hani}/u, "\u{33f5}");
t(/\p{scx=Hani}/u, "\u{33f6}");
f(/\P{scx=Hani}/u, "\u{33f6}");
t(/\p{scx=Hani}/u, "\u{33f7}");
f(/\P{scx=Hani}/u, "\u{33f7}");
t(/\p{scx=Hani}/u, "\u{33f8}");
f(/\P{scx=Hani}/u, "\u{33f8}");
t(/\p{scx=Hani}/u, "\u{33f9}");
f(/\P{scx=Hani}/u, "\u{33f9}");
t(/\p{scx=Hani}/u, "\u{33fa}");
f(/\P{scx=Hani}/u, "\u{33fa}");
t(/\p{scx=Hani}/u, "\u{33fb}");
f(/\P{scx=Hani}/u, "\u{33fb}");
t(/\p{scx=Hani}/u, "\u{33fc}");
f(/\P{scx=Hani}/u, "\u{33fc}");
t(/\p{scx=Hani}/u, "\u{33fd}");
f(/\P{scx=Hani}/u, "\u{33fd}");
t(/\p{scx=Hani}/u, "\u{33fe}");
f(/\P{scx=Hani}/u, "\u{33fe}");
t(/\p{scx=Hani}/u, "\u{1d360}");
f(/\P{scx=Hani}/u, "\u{1d360}");
t(/\p{scx=Hani}/u, "\u{1d361}");
f(/\P{scx=Hani}/u, "\u{1d361}");
t(/\p{scx=Hani}/u, "\u{1d362}");
f(/\P{scx=Hani}/u, "\u{1d362}");
t(/\p{scx=Hani}/u, "\u{1d363}");
f(/\P{scx=Hani}/u, "\u{1d363}");
t(/\p{scx=Hani}/u, "\u{1d364}");
f(/\P{scx=Hani}/u, "\u{1d364}");
t(/\p{scx=Hani}/u, "\u{1d365}");
f(/\P{scx=Hani}/u, "\u{1d365}");
t(/\p{scx=Hani}/u, "\u{1d366}");
f(/\P{scx=Hani}/u, "\u{1d366}");
t(/\p{scx=Hani}/u, "\u{1d367}");
f(/\P{scx=Hani}/u, "\u{1d367}");
t(/\p{scx=Hani}/u, "\u{1d368}");
f(/\P{scx=Hani}/u, "\u{1d368}");
t(/\p{scx=Hani}/u, "\u{1d369}");
f(/\P{scx=Hani}/u, "\u{1d369}");
t(/\p{scx=Hani}/u, "\u{1d36a}");
f(/\P{scx=Hani}/u, "\u{1d36a}");
t(/\p{scx=Hani}/u, "\u{1d36b}");
f(/\P{scx=Hani}/u, "\u{1d36b}");
t(/\p{scx=Hani}/u, "\u{1d36c}");
f(/\P{scx=Hani}/u, "\u{1d36c}");
t(/\p{scx=Hani}/u, "\u{1d36d}");
f(/\P{scx=Hani}/u, "\u{1d36d}");
t(/\p{scx=Hani}/u, "\u{1d36e}");
f(/\P{scx=Hani}/u, "\u{1d36e}");
t(/\p{scx=Hani}/u, "\u{1d36f}");
f(/\P{scx=Hani}/u, "\u{1d36f}");
t(/\p{scx=Hani}/u, "\u{1d370}");
f(/\P{scx=Hani}/u, "\u{1d370}");
t(/\p{scx=Hani}/u, "\u{1d371}");
f(/\P{scx=Hani}/u, "\u{1d371}");
t(/\p{scx=Hani}/u, "\u{1f250}");
f(/\P{scx=Hani}/u, "\u{1f250}");
t(/\p{scx=Hani}/u, "\u{1f251}");
f(/\P{scx=Hani}/u, "\u{1f251}");
t(/\p{scx=Hani}/u, "\u{302a}");
f(/\P{scx=Hani}/u, "\u{302a}");
t(/\p{scx=Hani}/u, "\u{302b}");
f(/\P{scx=Hani}/u, "\u{302b}");
t(/\p{scx=Hani}/u, "\u{302c}");
f(/\P{scx=Hani}/u, "\u{302c}");
t(/\p{scx=Hani}/u, "\u{302d}");
f(/\P{scx=Hani}/u, "\u{302d}");
t(/\p{scx=Hani}/u, "\u{303c}");
f(/\P{scx=Hani}/u, "\u{303c}");
t(/\p{scx=Hani}/u, "\u{303d}");
f(/\P{scx=Hani}/u, "\u{303d}");
t(/\p{scx=Hani}/u, "\u{3003}");
f(/\P{scx=Hani}/u, "\u{3003}");
t(/\p{scx=Hani}/u, "\u{3013}");
f(/\P{scx=Hani}/u, "\u{3013}");
t(/\p{scx=Hani}/u, "\u{301c}");
f(/\P{scx=Hani}/u, "\u{301c}");
t(/\p{scx=Hani}/u, "\u{301d}");
f(/\P{scx=Hani}/u, "\u{301d}");
t(/\p{scx=Hani}/u, "\u{301e}");
f(/\P{scx=Hani}/u, "\u{301e}");
t(/\p{scx=Hani}/u, "\u{301f}");
f(/\P{scx=Hani}/u, "\u{301f}");
t(/\p{scx=Hani}/u, "\u{3030}");
f(/\P{scx=Hani}/u, "\u{3030}");
t(/\p{scx=Hani}/u, "\u{3037}");
f(/\P{scx=Hani}/u, "\u{3037}");
t(/\p{scx=Hani}/u, "\u{fe45}");
f(/\P{scx=Hani}/u, "\u{fe45}");
t(/\p{scx=Hani}/u, "\u{fe46}");
f(/\P{scx=Hani}/u, "\u{fe46}");
t(/\p{scx=Hani}/u, "\u{3001}");
f(/\P{scx=Hani}/u, "\u{3001}");
t(/\p{scx=Hani}/u, "\u{3002}");
f(/\P{scx=Hani}/u, "\u{3002}");
t(/\p{scx=Hani}/u, "\u{3008}");
f(/\P{scx=Hani}/u, "\u{3008}");
t(/\p{scx=Hani}/u, "\u{3009}");
f(/\P{scx=Hani}/u, "\u{3009}");
t(/\p{scx=Hani}/u, "\u{300a}");
f(/\P{scx=Hani}/u, "\u{300a}");
t(/\p{scx=Hani}/u, "\u{300b}");
f(/\P{scx=Hani}/u, "\u{300b}");
t(/\p{scx=Hani}/u, "\u{300c}");
f(/\P{scx=Hani}/u, "\u{300c}");
t(/\p{scx=Hani}/u, "\u{300d}");
f(/\P{scx=Hani}/u, "\u{300d}");
t(/\p{scx=Hani}/u, "\u{300e}");
f(/\P{scx=Hani}/u, "\u{300e}");
t(/\p{scx=Hani}/u, "\u{300f}");
f(/\P{scx=Hani}/u, "\u{300f}");
t(/\p{scx=Hani}/u, "\u{3010}");
f(/\P{scx=Hani}/u, "\u{3010}");
t(/\p{scx=Hani}/u, "\u{3011}");
f(/\P{scx=Hani}/u, "\u{3011}");
t(/\p{scx=Hani}/u, "\u{3014}");
f(/\P{scx=Hani}/u, "\u{3014}");
t(/\p{scx=Hani}/u, "\u{3015}");
f(/\P{scx=Hani}/u, "\u{3015}");
t(/\p{scx=Hani}/u, "\u{3016}");
f(/\P{scx=Hani}/u, "\u{3016}");
t(/\p{scx=Hani}/u, "\u{3017}");
f(/\P{scx=Hani}/u, "\u{3017}");
t(/\p{scx=Hani}/u, "\u{3018}");
f(/\P{scx=Hani}/u, "\u{3018}");
t(/\p{scx=Hani}/u, "\u{3019}");
f(/\P{scx=Hani}/u, "\u{3019}");
t(/\p{scx=Hani}/u, "\u{301a}");
f(/\P{scx=Hani}/u, "\u{301a}");
t(/\p{scx=Hani}/u, "\u{301b}");
f(/\P{scx=Hani}/u, "\u{301b}");
t(/\p{scx=Hani}/u, "\u{30fb}");
f(/\P{scx=Hani}/u, "\u{30fb}");
t(/\p{scx=Hani}/u, "\u{ff61}");
f(/\P{scx=Hani}/u, "\u{ff61}");
t(/\p{scx=Hani}/u, "\u{ff62}");
f(/\P{scx=Hani}/u, "\u{ff62}");
t(/\p{scx=Hani}/u, "\u{ff63}");
f(/\P{scx=Hani}/u, "\u{ff63}");
t(/\p{scx=Hani}/u, "\u{ff64}");
f(/\P{scx=Hani}/u, "\u{ff64}");
t(/\p{scx=Hani}/u, "\u{ff65}");
f(/\P{scx=Hani}/u, "\u{ff65}");
f(/(?=\P{sc=Hani})\p{scx=Hani}/u, "\u{a7c}");
f(/(?=\P{sc=Hani})\p{scx=Hani}/u, "\u{9c8f4}");
f(/(?=\P{sc=Hani})\p{scx=Hani}/u, "\u{54f00}");
f(/(?=\P{sc=Hani})\p{scx=Hani}/u, "\u{6c549}");
f(/(?=\P{sc=Hani})\p{scx=Hani}/u, "\u{c5c5}");
// Script_Extension=Latn
t(/\p{scx=Latn}/u, "\u{363}");
f(/\P{scx=Latn}/u, "\u{363}");
t(/\p{scx=Latn}/u, "\u{364}");
f(/\P{scx=Latn}/u, "\u{364}");
t(/\p{scx=Latn}/u, "\u{365}");
f(/\P{scx=Latn}/u, "\u{365}");
t(/\p{scx=Latn}/u, "\u{366}");
f(/\P{scx=Latn}/u, "\u{366}");
t(/\p{scx=Latn}/u, "\u{367}");
f(/\P{scx=Latn}/u, "\u{367}");
t(/\p{scx=Latn}/u, "\u{368}");
f(/\P{scx=Latn}/u, "\u{368}");
t(/\p{scx=Latn}/u, "\u{369}");
f(/\P{scx=Latn}/u, "\u{369}");
t(/\p{scx=Latn}/u, "\u{36a}");
f(/\P{scx=Latn}/u, "\u{36a}");
t(/\p{scx=Latn}/u, "\u{36b}");
f(/\P{scx=Latn}/u, "\u{36b}");
t(/\p{scx=Latn}/u, "\u{36c}");
f(/\P{scx=Latn}/u, "\u{36c}");
t(/\p{scx=Latn}/u, "\u{36d}");
f(/\P{scx=Latn}/u, "\u{36d}");
t(/\p{scx=Latn}/u, "\u{36e}");
f(/\P{scx=Latn}/u, "\u{36e}");
t(/\p{scx=Latn}/u, "\u{36f}");
f(/\P{scx=Latn}/u, "\u{36f}");
t(/\p{scx=Latn}/u, "\u{485}");
f(/\P{scx=Latn}/u, "\u{485}");
t(/\p{scx=Latn}/u, "\u{486}");
f(/\P{scx=Latn}/u, "\u{486}");
t(/\p{scx=Latn}/u, "\u{10fb}");
f(/\P{scx=Latn}/u, "\u{10fb}");
t(/\p{scx=Latn}/u, "\u{20f0}");
f(/\P{scx=Latn}/u, "\u{20f0}");
t(/\p{scx=Latn}/u, "\u{a92e}");
f(/\P{scx=Latn}/u, "\u{a92e}");
t(/\p{scx=Latn}/u, "\u{952}");
f(/\P{scx=Latn}/u, "\u{952}");
t(/\p{scx=Latn}/u, "\u{951}");
f(/\P{scx=Latn}/u, "\u{951}");
f(/(?=\P{sc=Latn})\p{scx=Latn}/u, "\u{fcf93}");
f(/(?=\P{sc=Latn})\p{scx=Latn}/u, "\u{f40d2}");
f(/(?=\P{sc=Latn})\p{scx=Latn}/u, "\u{7f2e4}");
f(/(?=\P{sc=Latn})\p{scx=Latn}/u, "\u{5ccdd}");
f(/(?=\P{sc=Latn})\p{scx=Latn}/u, "\u{1010dd}");
// Script_Extension=Arab
t(/\p{scx=Arab}/u, "\u{102e0}");
f(/\P{scx=Arab}/u, "\u{102e0}");
t(/\p{scx=Arab}/u, "\u{102e1}");
f(/\P{scx=Arab}/u, "\u{102e1}");
t(/\p{scx=Arab}/u, "\u{102e2}");
f(/\P{scx=Arab}/u, "\u{102e2}");
t(/\p{scx=Arab}/u, "\u{102e3}");
f(/\P{scx=Arab}/u, "\u{102e3}");
t(/\p{scx=Arab}/u, "\u{102e4}");
f(/\P{scx=Arab}/u, "\u{102e4}");
t(/\p{scx=Arab}/u, "\u{102e5}");
f(/\P{scx=Arab}/u, "\u{102e5}");
t(/\p{scx=Arab}/u, "\u{102e6}");
f(/\P{scx=Arab}/u, "\u{102e6}");
t(/\p{scx=Arab}/u, "\u{102e7}");
f(/\P{scx=Arab}/u, "\u{102e7}");
t(/\p{scx=Arab}/u, "\u{102e8}");
f(/\P{scx=Arab}/u, "\u{102e8}");
t(/\p{scx=Arab}/u, "\u{102e9}");
f(/\P{scx=Arab}/u, "\u{102e9}");
t(/\p{scx=Arab}/u, "\u{102ea}");
f(/\P{scx=Arab}/u, "\u{102ea}");
t(/\p{scx=Arab}/u, "\u{102eb}");
f(/\P{scx=Arab}/u, "\u{102eb}");
t(/\p{scx=Arab}/u, "\u{102ec}");
f(/\P{scx=Arab}/u, "\u{102ec}");
t(/\p{scx=Arab}/u, "\u{102ed}");
f(/\P{scx=Arab}/u, "\u{102ed}");
t(/\p{scx=Arab}/u, "\u{102ee}");
f(/\P{scx=Arab}/u, "\u{102ee}");
t(/\p{scx=Arab}/u, "\u{102ef}");
f(/\P{scx=Arab}/u, "\u{102ef}");
t(/\p{scx=Arab}/u, "\u{102f0}");
f(/\P{scx=Arab}/u, "\u{102f0}");
t(/\p{scx=Arab}/u, "\u{102f1}");
f(/\P{scx=Arab}/u, "\u{102f1}");
t(/\p{scx=Arab}/u, "\u{102f2}");
f(/\P{scx=Arab}/u, "\u{102f2}");
t(/\p{scx=Arab}/u, "\u{102f3}");
f(/\P{scx=Arab}/u, "\u{102f3}");
t(/\p{scx=Arab}/u, "\u{102f4}");
f(/\P{scx=Arab}/u, "\u{102f4}");
t(/\p{scx=Arab}/u, "\u{102f5}");
f(/\P{scx=Arab}/u, "\u{102f5}");
t(/\p{scx=Arab}/u, "\u{102f6}");
f(/\P{scx=Arab}/u, "\u{102f6}");
t(/\p{scx=Arab}/u, "\u{102f7}");
f(/\P{scx=Arab}/u, "\u{102f7}");
t(/\p{scx=Arab}/u, "\u{102f8}");
f(/\P{scx=Arab}/u, "\u{102f8}");
t(/\p{scx=Arab}/u, "\u{102f9}");
f(/\P{scx=Arab}/u, "\u{102f9}");
t(/\p{scx=Arab}/u, "\u{102fa}");
f(/\P{scx=Arab}/u, "\u{102fa}");
t(/\p{scx=Arab}/u, "\u{102fb}");
f(/\P{scx=Arab}/u, "\u{102fb}");
t(/\p{scx=Arab}/u, "\u{64b}");
f(/\P{scx=Arab}/u, "\u{64b}");
t(/\p{scx=Arab}/u, "\u{64c}");
f(/\P{scx=Arab}/u, "\u{64c}");
t(/\p{scx=Arab}/u, "\u{64d}");
f(/\P{scx=Arab}/u, "\u{64d}");
t(/\p{scx=Arab}/u, "\u{64e}");
f(/\P{scx=Arab}/u, "\u{64e}");
t(/\p{scx=Arab}/u, "\u{64f}");
f(/\P{scx=Arab}/u, "\u{64f}");
t(/\p{scx=Arab}/u, "\u{650}");
f(/\P{scx=Arab}/u, "\u{650}");
t(/\p{scx=Arab}/u, "\u{651}");
f(/\P{scx=Arab}/u, "\u{651}");
t(/\p{scx=Arab}/u, "\u{652}");
f(/\P{scx=Arab}/u, "\u{652}");
t(/\p{scx=Arab}/u, "\u{653}");
f(/\P{scx=Arab}/u, "\u{653}");
t(/\p{scx=Arab}/u, "\u{654}");
f(/\P{scx=Arab}/u, "\u{654}");
t(/\p{scx=Arab}/u, "\u{655}");
f(/\P{scx=Arab}/u, "\u{655}");
t(/\p{scx=Arab}/u, "\u{670}");
f(/\P{scx=Arab}/u, "\u{670}");
t(/\p{scx=Arab}/u, "\u{660}");
f(/\P{scx=Arab}/u, "\u{660}");
t(/\p{scx=Arab}/u, "\u{661}");
f(/\P{scx=Arab}/u, "\u{661}");
t(/\p{scx=Arab}/u, "\u{662}");
f(/\P{scx=Arab}/u, "\u{662}");
t(/\p{scx=Arab}/u, "\u{663}");
f(/\P{scx=Arab}/u, "\u{663}");
t(/\p{scx=Arab}/u, "\u{664}");
f(/\P{scx=Arab}/u, "\u{664}");
t(/\p{scx=Arab}/u, "\u{665}");
f(/\P{scx=Arab}/u, "\u{665}");
t(/\p{scx=Arab}/u, "\u{666}");
f(/\P{scx=Arab}/u, "\u{666}");
t(/\p{scx=Arab}/u, "\u{667}");
f(/\P{scx=Arab}/u, "\u{667}");
t(/\p{scx=Arab}/u, "\u{668}");
f(/\P{scx=Arab}/u, "\u{668}");
t(/\p{scx=Arab}/u, "\u{669}");
f(/\P{scx=Arab}/u, "\u{669}");
t(/\p{scx=Arab}/u, "\u{fdf2}");
f(/\P{scx=Arab}/u, "\u{fdf2}");
t(/\p{scx=Arab}/u, "\u{fdfd}");
f(/\P{scx=Arab}/u, "\u{fdfd}");
t(/\p{scx=Arab}/u, "\u{60c}");
f(/\P{scx=Arab}/u, "\u{60c}");
t(/\p{scx=Arab}/u, "\u{61b}");
f(/\P{scx=Arab}/u, "\u{61b}");
t(/\p{scx=Arab}/u, "\u{61f}");
f(/\P{scx=Arab}/u, "\u{61f}");
t(/\p{scx=Arab}/u, "\u{640}");
f(/\P{scx=Arab}/u, "\u{640}");
f(/(?=\P{sc=Arab})\p{scx=Arab}/u, "\u{8901f}");
f(/(?=\P{sc=Arab})\p{scx=Arab}/u, "\u{91256}");
f(/(?=\P{sc=Arab})\p{scx=Arab}/u, "\u{71d97}");
f(/(?=\P{sc=Arab})\p{scx=Arab}/u, "\u{3c94d}");
f(/(?=\P{sc=Arab})\p{scx=Arab}/u, "\u{f9299}");
// Script_Extension=Copt
t(/\p{scx=Copt}/u, "\u{102e0}");
f(/\P{scx=Copt}/u, "\u{102e0}");
t(/\p{scx=Copt}/u, "\u{102e1}");
f(/\P{scx=Copt}/u, "\u{102e1}");
t(/\p{scx=Copt}/u, "\u{102e2}");
f(/\P{scx=Copt}/u, "\u{102e2}");
t(/\p{scx=Copt}/u, "\u{102e3}");
f(/\P{scx=Copt}/u, "\u{102e3}");
t(/\p{scx=Copt}/u, "\u{102e4}");
f(/\P{scx=Copt}/u, "\u{102e4}");
t(/\p{scx=Copt}/u, "\u{102e5}");
f(/\P{scx=Copt}/u, "\u{102e5}");
t(/\p{scx=Copt}/u, "\u{102e6}");
f(/\P{scx=Copt}/u, "\u{102e6}");
t(/\p{scx=Copt}/u, "\u{102e7}");
f(/\P{scx=Copt}/u, "\u{102e7}");
t(/\p{scx=Copt}/u, "\u{102e8}");
f(/\P{scx=Copt}/u, "\u{102e8}");
t(/\p{scx=Copt}/u, "\u{102e9}");
f(/\P{scx=Copt}/u, "\u{102e9}");
t(/\p{scx=Copt}/u, "\u{102ea}");
f(/\P{scx=Copt}/u, "\u{102ea}");
t(/\p{scx=Copt}/u, "\u{102eb}");
f(/\P{scx=Copt}/u, "\u{102eb}");
t(/\p{scx=Copt}/u, "\u{102ec}");
f(/\P{scx=Copt}/u, "\u{102ec}");
t(/\p{scx=Copt}/u, "\u{102ed}");
f(/\P{scx=Copt}/u, "\u{102ed}");
t(/\p{scx=Copt}/u, "\u{102ee}");
f(/\P{scx=Copt}/u, "\u{102ee}");
t(/\p{scx=Copt}/u, "\u{102ef}");
f(/\P{scx=Copt}/u, "\u{102ef}");
t(/\p{scx=Copt}/u, "\u{102f0}");
f(/\P{scx=Copt}/u, "\u{102f0}");
t(/\p{scx=Copt}/u, "\u{102f1}");
f(/\P{scx=Copt}/u, "\u{102f1}");
t(/\p{scx=Copt}/u, "\u{102f2}");
f(/\P{scx=Copt}/u, "\u{102f2}");
t(/\p{scx=Copt}/u, "\u{102f3}");
f(/\P{scx=Copt}/u, "\u{102f3}");
t(/\p{scx=Copt}/u, "\u{102f4}");
f(/\P{scx=Copt}/u, "\u{102f4}");
t(/\p{scx=Copt}/u, "\u{102f5}");
f(/\P{scx=Copt}/u, "\u{102f5}");
t(/\p{scx=Copt}/u, "\u{102f6}");
f(/\P{scx=Copt}/u, "\u{102f6}");
t(/\p{scx=Copt}/u, "\u{102f7}");
f(/\P{scx=Copt}/u, "\u{102f7}");
t(/\p{scx=Copt}/u, "\u{102f8}");
f(/\P{scx=Copt}/u, "\u{102f8}");
t(/\p{scx=Copt}/u, "\u{102f9}");
f(/\P{scx=Copt}/u, "\u{102f9}");
t(/\p{scx=Copt}/u, "\u{102fa}");
f(/\P{scx=Copt}/u, "\u{102fa}");
t(/\p{scx=Copt}/u, "\u{102fb}");
f(/\P{scx=Copt}/u, "\u{102fb}");
f(/(?=\P{sc=Copt})\p{scx=Copt}/u, "\u{b543e}");
f(/(?=\P{sc=Copt})\p{scx=Copt}/u, "\u{10ce3f}");
f(/(?=\P{sc=Copt})\p{scx=Copt}/u, "\u{ea3a9}");
f(/(?=\P{sc=Copt})\p{scx=Copt}/u, "\u{83f15}");
f(/(?=\P{sc=Copt})\p{scx=Copt}/u, "\u{8b9a5}");
// Script_Extension=Syrc
t(/\p{scx=Syrc}/u, "\u{64b}");
f(/\P{scx=Syrc}/u, "\u{64b}");
t(/\p{scx=Syrc}/u, "\u{64c}");
f(/\P{scx=Syrc}/u, "\u{64c}");
t(/\p{scx=Syrc}/u, "\u{64d}");
f(/\P{scx=Syrc}/u, "\u{64d}");
t(/\p{scx=Syrc}/u, "\u{64e}");
f(/\P{scx=Syrc}/u, "\u{64e}");
t(/\p{scx=Syrc}/u, "\u{64f}");
f(/\P{scx=Syrc}/u, "\u{64f}");
t(/\p{scx=Syrc}/u, "\u{650}");
f(/\P{scx=Syrc}/u, "\u{650}");
t(/\p{scx=Syrc}/u, "\u{651}");
f(/\P{scx=Syrc}/u, "\u{651}");
t(/\p{scx=Syrc}/u, "\u{652}");
f(/\P{scx=Syrc}/u, "\u{652}");
t(/\p{scx=Syrc}/u, "\u{653}");
f(/\P{scx=Syrc}/u, "\u{653}");
t(/\p{scx=Syrc}/u, "\u{654}");
f(/\P{scx=Syrc}/u, "\u{654}");
t(/\p{scx=Syrc}/u, "\u{655}");
f(/\P{scx=Syrc}/u, "\u{655}");
t(/\p{scx=Syrc}/u, "\u{670}");
f(/\P{scx=Syrc}/u, "\u{670}");
t(/\p{scx=Syrc}/u, "\u{60c}");
f(/\P{scx=Syrc}/u, "\u{60c}");
t(/\p{scx=Syrc}/u, "\u{61b}");
f(/\P{scx=Syrc}/u, "\u{61b}");
t(/\p{scx=Syrc}/u, "\u{61f}");
f(/\P{scx=Syrc}/u, "\u{61f}");
t(/\p{scx=Syrc}/u, "\u{640}");
f(/\P{scx=Syrc}/u, "\u{640}");
f(/(?=\P{sc=Syrc})\p{scx=Syrc}/u, "\u{dab32}");
f(/(?=\P{sc=Syrc})\p{scx=Syrc}/u, "\u{6b768}");
f(/(?=\P{sc=Syrc})\p{scx=Syrc}/u, "\u{877e7}");
f(/(?=\P{sc=Syrc})\p{scx=Syrc}/u, "\u{66f8b}");
f(/(?=\P{sc=Syrc})\p{scx=Syrc}/u, "\u{12a45}");
// Script_Extension=Thaa
t(/\p{scx=Thaa}/u, "\u{660}");
f(/\P{scx=Thaa}/u, "\u{660}");
t(/\p{scx=Thaa}/u, "\u{661}");
f(/\P{scx=Thaa}/u, "\u{661}");
t(/\p{scx=Thaa}/u, "\u{662}");
f(/\P{scx=Thaa}/u, "\u{662}");
t(/\p{scx=Thaa}/u, "\u{663}");
f(/\P{scx=Thaa}/u, "\u{663}");
t(/\p{scx=Thaa}/u, "\u{664}");
f(/\P{scx=Thaa}/u, "\u{664}");
t(/\p{scx=Thaa}/u, "\u{665}");
f(/\P{scx=Thaa}/u, "\u{665}");
t(/\p{scx=Thaa}/u, "\u{666}");
f(/\P{scx=Thaa}/u, "\u{666}");
t(/\p{scx=Thaa}/u, "\u{667}");
f(/\P{scx=Thaa}/u, "\u{667}");
t(/\p{scx=Thaa}/u, "\u{668}");
f(/\P{scx=Thaa}/u, "\u{668}");
t(/\p{scx=Thaa}/u, "\u{669}");
f(/\P{scx=Thaa}/u, "\u{669}");
t(/\p{scx=Thaa}/u, "\u{fdf2}");
f(/\P{scx=Thaa}/u, "\u{fdf2}");
t(/\p{scx=Thaa}/u, "\u{fdfd}");
f(/\P{scx=Thaa}/u, "\u{fdfd}");
t(/\p{scx=Thaa}/u, "\u{60c}");
f(/\P{scx=Thaa}/u, "\u{60c}");
t(/\p{scx=Thaa}/u, "\u{61b}");
f(/\P{scx=Thaa}/u, "\u{61b}");
t(/\p{scx=Thaa}/u, "\u{61f}");
f(/\P{scx=Thaa}/u, "\u{61f}");
f(/(?=\P{sc=Thaa})\p{scx=Thaa}/u, "\u{bf3cb}");
f(/(?=\P{sc=Thaa})\p{scx=Thaa}/u, "\u{33196}");
f(/(?=\P{sc=Thaa})\p{scx=Thaa}/u, "\u{5bc9e}");
f(/(?=\P{sc=Thaa})\p{scx=Thaa}/u, "\u{b350c}");
f(/(?=\P{sc=Thaa})\p{scx=Thaa}/u, "\u{1a475}");
// Script_Extension=Armn
t(/\p{scx=Armn}/u, "\u{589}");
f(/\P{scx=Armn}/u, "\u{589}");
f(/(?=\P{sc=Armn})\p{scx=Armn}/u, "\u{a4bc3}");
f(/(?=\P{sc=Armn})\p{scx=Armn}/u, "\u{7e5df}");
f(/(?=\P{sc=Armn})\p{scx=Armn}/u, "\u{619d5}");
f(/(?=\P{sc=Armn})\p{scx=Armn}/u, "\u{6299c}");
f(/(?=\P{sc=Armn})\p{scx=Armn}/u, "\u{ecd52}");
// Script_Extension=Geor
t(/\p{scx=Geor}/u, "\u{589}");
f(/\P{scx=Geor}/u, "\u{589}");
t(/\p{scx=Geor}/u, "\u{10fb}");
f(/\P{scx=Geor}/u, "\u{10fb}");
f(/(?=\P{sc=Geor})\p{scx=Geor}/u, "\u{1b0d2}");
f(/(?=\P{sc=Geor})\p{scx=Geor}/u, "\u{9e197}");
f(/(?=\P{sc=Geor})\p{scx=Geor}/u, "\u{413c6}");
f(/(?=\P{sc=Geor})\p{scx=Geor}/u, "\u{25864}");
f(/(?=\P{sc=Geor})\p{scx=Geor}/u, "\u{3cec4}");
// Script_Extension=Beng
t(/\p{scx=Beng}/u, "\u{a8f1}");
f(/\P{scx=Beng}/u, "\u{a8f1}");
t(/\p{scx=Beng}/u, "\u{9e6}");
f(/\P{scx=Beng}/u, "\u{9e6}");
t(/\p{scx=Beng}/u, "\u{9e7}");
f(/\P{scx=Beng}/u, "\u{9e7}");
t(/\p{scx=Beng}/u, "\u{9e8}");
f(/\P{scx=Beng}/u, "\u{9e8}");
t(/\p{scx=Beng}/u, "\u{9e9}");
f(/\P{scx=Beng}/u, "\u{9e9}");
t(/\p{scx=Beng}/u, "\u{9ea}");
f(/\P{scx=Beng}/u, "\u{9ea}");
t(/\p{scx=Beng}/u, "\u{9eb}");
f(/\P{scx=Beng}/u, "\u{9eb}");
t(/\p{scx=Beng}/u, "\u{9ec}");
f(/\P{scx=Beng}/u, "\u{9ec}");
t(/\p{scx=Beng}/u, "\u{9ed}");
f(/\P{scx=Beng}/u, "\u{9ed}");
t(/\p{scx=Beng}/u, "\u{9ee}");
f(/\P{scx=Beng}/u, "\u{9ee}");
t(/\p{scx=Beng}/u, "\u{9ef}");
f(/\P{scx=Beng}/u, "\u{9ef}");
t(/\p{scx=Beng}/u, "\u{952}");
f(/\P{scx=Beng}/u, "\u{952}");
t(/\p{scx=Beng}/u, "\u{951}");
f(/\P{scx=Beng}/u, "\u{951}");
t(/\p{scx=Beng}/u, "\u{964}");
f(/\P{scx=Beng}/u, "\u{964}");
t(/\p{scx=Beng}/u, "\u{965}");
f(/\P{scx=Beng}/u, "\u{965}");
f(/(?=\P{sc=Beng})\p{scx=Beng}/u, "\u{10b8e0}");
f(/(?=\P{sc=Beng})\p{scx=Beng}/u, "\u{a1a3d}");
f(/(?=\P{sc=Beng})\p{scx=Beng}/u, "\u{63024}");
f(/(?=\P{sc=Beng})\p{scx=Beng}/u, "\u{e1e3a}");
f(/(?=\P{sc=Beng})\p{scx=Beng}/u, "\u{732a7}");
// Script_Extension=Bopo
t(/\p{scx=Bopo}/u, "\u{302a}");
f(/\P{scx=Bopo}/u, "\u{302a}");
t(/\p{scx=Bopo}/u, "\u{302b}");
f(/\P{scx=Bopo}/u, "\u{302b}");
t(/\p{scx=Bopo}/u, "\u{302c}");
f(/\P{scx=Bopo}/u, "\u{302c}");
t(/\p{scx=Bopo}/u, "\u{302d}");
f(/\P{scx=Bopo}/u, "\u{302d}");
t(/\p{scx=Bopo}/u, "\u{3003}");
f(/\P{scx=Bopo}/u, "\u{3003}");
t(/\p{scx=Bopo}/u, "\u{3013}");
f(/\P{scx=Bopo}/u, "\u{3013}");
t(/\p{scx=Bopo}/u, "\u{301c}");
f(/\P{scx=Bopo}/u, "\u{301c}");
t(/\p{scx=Bopo}/u, "\u{301d}");
f(/\P{scx=Bopo}/u, "\u{301d}");
t(/\p{scx=Bopo}/u, "\u{301e}");
f(/\P{scx=Bopo}/u, "\u{301e}");
t(/\p{scx=Bopo}/u, "\u{301f}");
f(/\P{scx=Bopo}/u, "\u{301f}");
t(/\p{scx=Bopo}/u, "\u{3030}");
f(/\P{scx=Bopo}/u, "\u{3030}");
t(/\p{scx=Bopo}/u, "\u{3037}");
f(/\P{scx=Bopo}/u, "\u{3037}");
t(/\p{scx=Bopo}/u, "\u{fe45}");
f(/\P{scx=Bopo}/u, "\u{fe45}");
t(/\p{scx=Bopo}/u, "\u{fe46}");
f(/\P{scx=Bopo}/u, "\u{fe46}");
t(/\p{scx=Bopo}/u, "\u{3001}");
f(/\P{scx=Bopo}/u, "\u{3001}");
t(/\p{scx=Bopo}/u, "\u{3002}");
f(/\P{scx=Bopo}/u, "\u{3002}");
t(/\p{scx=Bopo}/u, "\u{3008}");
f(/\P{scx=Bopo}/u, "\u{3008}");
t(/\p{scx=Bopo}/u, "\u{3009}");
f(/\P{scx=Bopo}/u, "\u{3009}");
t(/\p{scx=Bopo}/u, "\u{300a}");
f(/\P{scx=Bopo}/u, "\u{300a}");
t(/\p{scx=Bopo}/u, "\u{300b}");
f(/\P{scx=Bopo}/u, "\u{300b}");
t(/\p{scx=Bopo}/u, "\u{300c}");
f(/\P{scx=Bopo}/u, "\u{300c}");
t(/\p{scx=Bopo}/u, "\u{300d}");
f(/\P{scx=Bopo}/u, "\u{300d}");
t(/\p{scx=Bopo}/u, "\u{300e}");
f(/\P{scx=Bopo}/u, "\u{300e}");
t(/\p{scx=Bopo}/u, "\u{300f}");
f(/\P{scx=Bopo}/u, "\u{300f}");
t(/\p{scx=Bopo}/u, "\u{3010}");
f(/\P{scx=Bopo}/u, "\u{3010}");
t(/\p{scx=Bopo}/u, "\u{3011}");
f(/\P{scx=Bopo}/u, "\u{3011}");
t(/\p{scx=Bopo}/u, "\u{3014}");
f(/\P{scx=Bopo}/u, "\u{3014}");
t(/\p{scx=Bopo}/u, "\u{3015}");
f(/\P{scx=Bopo}/u, "\u{3015}");
t(/\p{scx=Bopo}/u, "\u{3016}");
f(/\P{scx=Bopo}/u, "\u{3016}");
t(/\p{scx=Bopo}/u, "\u{3017}");
f(/\P{scx=Bopo}/u, "\u{3017}");
t(/\p{scx=Bopo}/u, "\u{3018}");
f(/\P{scx=Bopo}/u, "\u{3018}");
t(/\p{scx=Bopo}/u, "\u{3019}");
f(/\P{scx=Bopo}/u, "\u{3019}");
t(/\p{scx=Bopo}/u, "\u{301a}");
f(/\P{scx=Bopo}/u, "\u{301a}");
t(/\p{scx=Bopo}/u, "\u{301b}");
f(/\P{scx=Bopo}/u, "\u{301b}");
t(/\p{scx=Bopo}/u, "\u{30fb}");
f(/\P{scx=Bopo}/u, "\u{30fb}");
t(/\p{scx=Bopo}/u, "\u{ff61}");
f(/\P{scx=Bopo}/u, "\u{ff61}");
t(/\p{scx=Bopo}/u, "\u{ff62}");
f(/\P{scx=Bopo}/u, "\u{ff62}");
t(/\p{scx=Bopo}/u, "\u{ff63}");
f(/\P{scx=Bopo}/u, "\u{ff63}");
t(/\p{scx=Bopo}/u, "\u{ff64}");
f(/\P{scx=Bopo}/u, "\u{ff64}");
t(/\p{scx=Bopo}/u, "\u{ff65}");
f(/\P{scx=Bopo}/u, "\u{ff65}");
f(/(?=\P{sc=Bopo})\p{scx=Bopo}/u, "\u{d9494}");
f(/(?=\P{sc=Bopo})\p{scx=Bopo}/u, "\u{c8328}");
f(/(?=\P{sc=Bopo})\p{scx=Bopo}/u, "\u{fbf6e}");
f(/(?=\P{sc=Bopo})\p{scx=Bopo}/u, "\u{1b8cc}");
f(/(?=\P{sc=Bopo})\p{scx=Bopo}/u, "\u{10477}");
// Script_Extension=Bugi
t(/\p{scx=Bugi}/u, "\u{a9cf}");
f(/\P{scx=Bugi}/u, "\u{a9cf}");
f(/(?=\P{sc=Bugi})\p{scx=Bugi}/u, "\u{ec046}");
f(/(?=\P{sc=Bugi})\p{scx=Bugi}/u, "\u{a8402}");
f(/(?=\P{sc=Bugi})\p{scx=Bugi}/u, "\u{85530}");
f(/(?=\P{sc=Bugi})\p{scx=Bugi}/u, "\u{86942}");
f(/(?=\P{sc=Bugi})\p{scx=Bugi}/u, "\u{c6ded}");
// Script_Extension=Java
t(/\p{scx=Java}/u, "\u{a9cf}");
f(/\P{scx=Java}/u, "\u{a9cf}");
f(/(?=\P{sc=Java})\p{scx=Java}/u, "\u{d4343}");
f(/(?=\P{sc=Java})\p{scx=Java}/u, "\u{6d000}");
f(/(?=\P{sc=Java})\p{scx=Java}/u, "\u{c72a4}");
f(/(?=\P{sc=Java})\p{scx=Java}/u, "\u{9ad6f}");
f(/(?=\P{sc=Java})\p{scx=Java}/u, "\u{fb350}");
// Script_Extension=Cprt
t(/\p{scx=Cprt}/u, "\u{10100}");
f(/\P{scx=Cprt}/u, "\u{10100}");
t(/\p{scx=Cprt}/u, "\u{10101}");
f(/\P{scx=Cprt}/u, "\u{10101}");
t(/\p{scx=Cprt}/u, "\u{10102}");
f(/\P{scx=Cprt}/u, "\u{10102}");
t(/\p{scx=Cprt}/u, "\u{10137}");
f(/\P{scx=Cprt}/u, "\u{10137}");
t(/\p{scx=Cprt}/u, "\u{10138}");
f(/\P{scx=Cprt}/u, "\u{10138}");
t(/\p{scx=Cprt}/u, "\u{10139}");
f(/\P{scx=Cprt}/u, "\u{10139}");
t(/\p{scx=Cprt}/u, "\u{1013a}");
f(/\P{scx=Cprt}/u, "\u{1013a}");
t(/\p{scx=Cprt}/u, "\u{1013b}");
f(/\P{scx=Cprt}/u, "\u{1013b}");
t(/\p{scx=Cprt}/u, "\u{1013c}");
f(/\P{scx=Cprt}/u, "\u{1013c}");
t(/\p{scx=Cprt}/u, "\u{1013d}");
f(/\P{scx=Cprt}/u, "\u{1013d}");
t(/\p{scx=Cprt}/u, "\u{1013e}");
f(/\P{scx=Cprt}/u, "\u{1013e}");
t(/\p{scx=Cprt}/u, "\u{1013f}");
f(/\P{scx=Cprt}/u, "\u{1013f}");
t(/\p{scx=Cprt}/u, "\u{10107}");
f(/\P{scx=Cprt}/u, "\u{10107}");
t(/\p{scx=Cprt}/u, "\u{10108}");
f(/\P{scx=Cprt}/u, "\u{10108}");
t(/\p{scx=Cprt}/u, "\u{10109}");
f(/\P{scx=Cprt}/u, "\u{10109}");
t(/\p{scx=Cprt}/u, "\u{1010a}");
f(/\P{scx=Cprt}/u, "\u{1010a}");
t(/\p{scx=Cprt}/u, "\u{1010b}");
f(/\P{scx=Cprt}/u, "\u{1010b}");
t(/\p{scx=Cprt}/u, "\u{1010c}");
f(/\P{scx=Cprt}/u, "\u{1010c}");
t(/\p{scx=Cprt}/u, "\u{1010d}");
f(/\P{scx=Cprt}/u, "\u{1010d}");
t(/\p{scx=Cprt}/u, "\u{1010e}");
f(/\P{scx=Cprt}/u, "\u{1010e}");
t(/\p{scx=Cprt}/u, "\u{1010f}");
f(/\P{scx=Cprt}/u, "\u{1010f}");
t(/\p{scx=Cprt}/u, "\u{10110}");
f(/\P{scx=Cprt}/u, "\u{10110}");
t(/\p{scx=Cprt}/u, "\u{10111}");
f(/\P{scx=Cprt}/u, "\u{10111}");
t(/\p{scx=Cprt}/u, "\u{10112}");
f(/\P{scx=Cprt}/u, "\u{10112}");
t(/\p{scx=Cprt}/u, "\u{10113}");
f(/\P{scx=Cprt}/u, "\u{10113}");
t(/\p{scx=Cprt}/u, "\u{10114}");
f(/\P{scx=Cprt}/u, "\u{10114}");
t(/\p{scx=Cprt}/u, "\u{10115}");
f(/\P{scx=Cprt}/u, "\u{10115}");
t(/\p{scx=Cprt}/u, "\u{10116}");
f(/\P{scx=Cprt}/u, "\u{10116}");
t(/\p{scx=Cprt}/u, "\u{10117}");
f(/\P{scx=Cprt}/u, "\u{10117}");
t(/\p{scx=Cprt}/u, "\u{10118}");
f(/\P{scx=Cprt}/u, "\u{10118}");
t(/\p{scx=Cprt}/u, "\u{10119}");
f(/\P{scx=Cprt}/u, "\u{10119}");
t(/\p{scx=Cprt}/u, "\u{1011a}");
f(/\P{scx=Cprt}/u, "\u{1011a}");
t(/\p{scx=Cprt}/u, "\u{1011b}");
f(/\P{scx=Cprt}/u, "\u{1011b}");
t(/\p{scx=Cprt}/u, "\u{1011c}");
f(/\P{scx=Cprt}/u, "\u{1011c}");
t(/\p{scx=Cprt}/u, "\u{1011d}");
f(/\P{scx=Cprt}/u, "\u{1011d}");
t(/\p{scx=Cprt}/u, "\u{1011e}");
f(/\P{scx=Cprt}/u, "\u{1011e}");
t(/\p{scx=Cprt}/u, "\u{1011f}");
f(/\P{scx=Cprt}/u, "\u{1011f}");
t(/\p{scx=Cprt}/u, "\u{10120}");
f(/\P{scx=Cprt}/u, "\u{10120}");
t(/\p{scx=Cprt}/u, "\u{10121}");
f(/\P{scx=Cprt}/u, "\u{10121}");
t(/\p{scx=Cprt}/u, "\u{10122}");
f(/\P{scx=Cprt}/u, "\u{10122}");
t(/\p{scx=Cprt}/u, "\u{10123}");
f(/\P{scx=Cprt}/u, "\u{10123}");
t(/\p{scx=Cprt}/u, "\u{10124}");
f(/\P{scx=Cprt}/u, "\u{10124}");
t(/\p{scx=Cprt}/u, "\u{10125}");
f(/\P{scx=Cprt}/u, "\u{10125}");
t(/\p{scx=Cprt}/u, "\u{10126}");
f(/\P{scx=Cprt}/u, "\u{10126}");
t(/\p{scx=Cprt}/u, "\u{10127}");
f(/\P{scx=Cprt}/u, "\u{10127}");
t(/\p{scx=Cprt}/u, "\u{10128}");
f(/\P{scx=Cprt}/u, "\u{10128}");
t(/\p{scx=Cprt}/u, "\u{10129}");
f(/\P{scx=Cprt}/u, "\u{10129}");
t(/\p{scx=Cprt}/u, "\u{1012a}");
f(/\P{scx=Cprt}/u, "\u{1012a}");
t(/\p{scx=Cprt}/u, "\u{1012b}");
f(/\P{scx=Cprt}/u, "\u{1012b}");
t(/\p{scx=Cprt}/u, "\u{1012c}");
f(/\P{scx=Cprt}/u, "\u{1012c}");
t(/\p{scx=Cprt}/u, "\u{1012d}");
f(/\P{scx=Cprt}/u, "\u{1012d}");
t(/\p{scx=Cprt}/u, "\u{1012e}");
f(/\P{scx=Cprt}/u, "\u{1012e}");
t(/\p{scx=Cprt}/u, "\u{1012f}");
f(/\P{scx=Cprt}/u, "\u{1012f}");
t(/\p{scx=Cprt}/u, "\u{10130}");
f(/\P{scx=Cprt}/u, "\u{10130}");
t(/\p{scx=Cprt}/u, "\u{10131}");
f(/\P{scx=Cprt}/u, "\u{10131}");
t(/\p{scx=Cprt}/u, "\u{10132}");
f(/\P{scx=Cprt}/u, "\u{10132}");
t(/\p{scx=Cprt}/u, "\u{10133}");
f(/\P{scx=Cprt}/u, "\u{10133}");
f(/(?=\P{sc=Cprt})\p{scx=Cprt}/u, "\u{27a83}");
f(/(?=\P{sc=Cprt})\p{scx=Cprt}/u, "\u{172f5}");
f(/(?=\P{sc=Cprt})\p{scx=Cprt}/u, "\u{6ef51}");
f(/(?=\P{sc=Cprt})\p{scx=Cprt}/u, "\u{7837}");
f(/(?=\P{sc=Cprt})\p{scx=Cprt}/u, "\u{c5ce1}");
// Script_Extension=Linb
t(/\p{scx=Linb}/u, "\u{10100}");
f(/\P{scx=Linb}/u, "\u{10100}");
t(/\p{scx=Linb}/u, "\u{10101}");
f(/\P{scx=Linb}/u, "\u{10101}");
t(/\p{scx=Linb}/u, "\u{10102}");
f(/\P{scx=Linb}/u, "\u{10102}");
t(/\p{scx=Linb}/u, "\u{10137}");
f(/\P{scx=Linb}/u, "\u{10137}");
t(/\p{scx=Linb}/u, "\u{10138}");
f(/\P{scx=Linb}/u, "\u{10138}");
t(/\p{scx=Linb}/u, "\u{10139}");
f(/\P{scx=Linb}/u, "\u{10139}");
t(/\p{scx=Linb}/u, "\u{1013a}");
f(/\P{scx=Linb}/u, "\u{1013a}");
t(/\p{scx=Linb}/u, "\u{1013b}");
f(/\P{scx=Linb}/u, "\u{1013b}");
t(/\p{scx=Linb}/u, "\u{1013c}");
f(/\P{scx=Linb}/u, "\u{1013c}");
t(/\p{scx=Linb}/u, "\u{1013d}");
f(/\P{scx=Linb}/u, "\u{1013d}");
t(/\p{scx=Linb}/u, "\u{1013e}");
f(/\P{scx=Linb}/u, "\u{1013e}");
t(/\p{scx=Linb}/u, "\u{1013f}");
f(/\P{scx=Linb}/u, "\u{1013f}");
t(/\p{scx=Linb}/u, "\u{10107}");
f(/\P{scx=Linb}/u, "\u{10107}");
t(/\p{scx=Linb}/u, "\u{10108}");
f(/\P{scx=Linb}/u, "\u{10108}");
t(/\p{scx=Linb}/u, "\u{10109}");
f(/\P{scx=Linb}/u, "\u{10109}");
t(/\p{scx=Linb}/u, "\u{1010a}");
f(/\P{scx=Linb}/u, "\u{1010a}");
t(/\p{scx=Linb}/u, "\u{1010b}");
f(/\P{scx=Linb}/u, "\u{1010b}");
t(/\p{scx=Linb}/u, "\u{1010c}");
f(/\P{scx=Linb}/u, "\u{1010c}");
t(/\p{scx=Linb}/u, "\u{1010d}");
f(/\P{scx=Linb}/u, "\u{1010d}");
t(/\p{scx=Linb}/u, "\u{1010e}");
f(/\P{scx=Linb}/u, "\u{1010e}");
t(/\p{scx=Linb}/u, "\u{1010f}");
f(/\P{scx=Linb}/u, "\u{1010f}");
t(/\p{scx=Linb}/u, "\u{10110}");
f(/\P{scx=Linb}/u, "\u{10110}");
t(/\p{scx=Linb}/u, "\u{10111}");
f(/\P{scx=Linb}/u, "\u{10111}");
t(/\p{scx=Linb}/u, "\u{10112}");
f(/\P{scx=Linb}/u, "\u{10112}");
t(/\p{scx=Linb}/u, "\u{10113}");
f(/\P{scx=Linb}/u, "\u{10113}");
t(/\p{scx=Linb}/u, "\u{10114}");
f(/\P{scx=Linb}/u, "\u{10114}");
t(/\p{scx=Linb}/u, "\u{10115}");
f(/\P{scx=Linb}/u, "\u{10115}");
t(/\p{scx=Linb}/u, "\u{10116}");
f(/\P{scx=Linb}/u, "\u{10116}");
t(/\p{scx=Linb}/u, "\u{10117}");
f(/\P{scx=Linb}/u, "\u{10117}");
t(/\p{scx=Linb}/u, "\u{10118}");
f(/\P{scx=Linb}/u, "\u{10118}");
t(/\p{scx=Linb}/u, "\u{10119}");
f(/\P{scx=Linb}/u, "\u{10119}");
t(/\p{scx=Linb}/u, "\u{1011a}");
f(/\P{scx=Linb}/u, "\u{1011a}");
t(/\p{scx=Linb}/u, "\u{1011b}");
f(/\P{scx=Linb}/u, "\u{1011b}");
t(/\p{scx=Linb}/u, "\u{1011c}");
f(/\P{scx=Linb}/u, "\u{1011c}");
t(/\p{scx=Linb}/u, "\u{1011d}");
f(/\P{scx=Linb}/u, "\u{1011d}");
t(/\p{scx=Linb}/u, "\u{1011e}");
f(/\P{scx=Linb}/u, "\u{1011e}");
t(/\p{scx=Linb}/u, "\u{1011f}");
f(/\P{scx=Linb}/u, "\u{1011f}");
t(/\p{scx=Linb}/u, "\u{10120}");
f(/\P{scx=Linb}/u, "\u{10120}");
t(/\p{scx=Linb}/u, "\u{10121}");
f(/\P{scx=Linb}/u, "\u{10121}");
t(/\p{scx=Linb}/u, "\u{10122}");
f(/\P{scx=Linb}/u, "\u{10122}");
t(/\p{scx=Linb}/u, "\u{10123}");
f(/\P{scx=Linb}/u, "\u{10123}");
t(/\p{scx=Linb}/u, "\u{10124}");
f(/\P{scx=Linb}/u, "\u{10124}");
t(/\p{scx=Linb}/u, "\u{10125}");
f(/\P{scx=Linb}/u, "\u{10125}");
t(/\p{scx=Linb}/u, "\u{10126}");
f(/\P{scx=Linb}/u, "\u{10126}");
t(/\p{scx=Linb}/u, "\u{10127}");
f(/\P{scx=Linb}/u, "\u{10127}");
t(/\p{scx=Linb}/u, "\u{10128}");
f(/\P{scx=Linb}/u, "\u{10128}");
t(/\p{scx=Linb}/u, "\u{10129}");
f(/\P{scx=Linb}/u, "\u{10129}");
t(/\p{scx=Linb}/u, "\u{1012a}");
f(/\P{scx=Linb}/u, "\u{1012a}");
t(/\p{scx=Linb}/u, "\u{1012b}");
f(/\P{scx=Linb}/u, "\u{1012b}");
t(/\p{scx=Linb}/u, "\u{1012c}");
f(/\P{scx=Linb}/u, "\u{1012c}");
t(/\p{scx=Linb}/u, "\u{1012d}");
f(/\P{scx=Linb}/u, "\u{1012d}");
t(/\p{scx=Linb}/u, "\u{1012e}");
f(/\P{scx=Linb}/u, "\u{1012e}");
t(/\p{scx=Linb}/u, "\u{1012f}");
f(/\P{scx=Linb}/u, "\u{1012f}");
t(/\p{scx=Linb}/u, "\u{10130}");
f(/\P{scx=Linb}/u, "\u{10130}");
t(/\p{scx=Linb}/u, "\u{10131}");
f(/\P{scx=Linb}/u, "\u{10131}");
t(/\p{scx=Linb}/u, "\u{10132}");
f(/\P{scx=Linb}/u, "\u{10132}");
t(/\p{scx=Linb}/u, "\u{10133}");
f(/\P{scx=Linb}/u, "\u{10133}");
f(/(?=\P{sc=Linb})\p{scx=Linb}/u, "\u{42fd8}");
f(/(?=\P{sc=Linb})\p{scx=Linb}/u, "\u{5847b}");
f(/(?=\P{sc=Linb})\p{scx=Linb}/u, "\u{71859}");
f(/(?=\P{sc=Linb})\p{scx=Linb}/u, "\u{6b485}");
f(/(?=\P{sc=Linb})\p{scx=Linb}/u, "\u{ba1f}");
// Script_Extension=Cyrl
t(/\p{scx=Cyrl}/u, "\u{484}");
f(/\P{scx=Cyrl}/u, "\u{484}");
t(/\p{scx=Cyrl}/u, "\u{487}");
f(/\P{scx=Cyrl}/u, "\u{487}");
t(/\p{scx=Cyrl}/u, "\u{2e43}");
f(/\P{scx=Cyrl}/u, "\u{2e43}");
t(/\p{scx=Cyrl}/u, "\u{a66f}");
f(/\P{scx=Cyrl}/u, "\u{a66f}");
t(/\p{scx=Cyrl}/u, "\u{485}");
f(/\P{scx=Cyrl}/u, "\u{485}");
t(/\p{scx=Cyrl}/u, "\u{486}");
f(/\P{scx=Cyrl}/u, "\u{486}");
t(/\p{scx=Cyrl}/u, "\u{483}");
f(/\P{scx=Cyrl}/u, "\u{483}");
f(/(?=\P{sc=Cyrl})\p{scx=Cyrl}/u, "\u{a7c62}");
f(/(?=\P{sc=Cyrl})\p{scx=Cyrl}/u, "\u{d4e8}");
f(/(?=\P{sc=Cyrl})\p{scx=Cyrl}/u, "\u{95699}");
f(/(?=\P{sc=Cyrl})\p{scx=Cyrl}/u, "\u{2175f}");
f(/(?=\P{sc=Cyrl})\p{scx=Cyrl}/u, "\u{10000c}");
// Script_Extension=Glag
t(/\p{scx=Glag}/u, "\u{484}");
f(/\P{scx=Glag}/u, "\u{484}");
t(/\p{scx=Glag}/u, "\u{487}");
f(/\P{scx=Glag}/u, "\u{487}");
t(/\p{scx=Glag}/u, "\u{2e43}");
f(/\P{scx=Glag}/u, "\u{2e43}");
t(/\p{scx=Glag}/u, "\u{a66f}");
f(/\P{scx=Glag}/u, "\u{a66f}");
f(/(?=\P{sc=Glag})\p{scx=Glag}/u, "\u{bcabd}");
f(/(?=\P{sc=Glag})\p{scx=Glag}/u, "\u{d05c1}");
f(/(?=\P{sc=Glag})\p{scx=Glag}/u, "\u{b9e24}");
f(/(?=\P{sc=Glag})\p{scx=Glag}/u, "\u{22e2e}");
f(/(?=\P{sc=Glag})\p{scx=Glag}/u, "\u{d3d37}");
// Script_Extension=Perm
t(/\p{scx=Perm}/u, "\u{483}");
f(/\P{scx=Perm}/u, "\u{483}");
f(/(?=\P{sc=Perm})\p{scx=Perm}/u, "\u{10d33d}");
f(/(?=\P{sc=Perm})\p{scx=Perm}/u, "\u{4c279}");
f(/(?=\P{sc=Perm})\p{scx=Perm}/u, "\u{73666}");
f(/(?=\P{sc=Perm})\p{scx=Perm}/u, "\u{2e79d}");
f(/(?=\P{sc=Perm})\p{scx=Perm}/u, "\u{680f8}");
// Script_Extension=Gran
t(/\p{scx=Gran}/u, "\u{1cd0}");
f(/\P{scx=Gran}/u, "\u{1cd0}");
t(/\p{scx=Gran}/u, "\u{1cd2}");
f(/\P{scx=Gran}/u, "\u{1cd2}");
t(/\p{scx=Gran}/u, "\u{1cd3}");
f(/\P{scx=Gran}/u, "\u{1cd3}");
t(/\p{scx=Gran}/u, "\u{1cf2}");
f(/\P{scx=Gran}/u, "\u{1cf2}");
t(/\p{scx=Gran}/u, "\u{1cf3}");
f(/\P{scx=Gran}/u, "\u{1cf3}");
t(/\p{scx=Gran}/u, "\u{1cf4}");
f(/\P{scx=Gran}/u, "\u{1cf4}");
t(/\p{scx=Gran}/u, "\u{1cf8}");
f(/\P{scx=Gran}/u, "\u{1cf8}");
t(/\p{scx=Gran}/u, "\u{1cf9}");
f(/\P{scx=Gran}/u, "\u{1cf9}");
t(/\p{scx=Gran}/u, "\u{baa}");
f(/\P{scx=Gran}/u, "\u{baa}");
t(/\p{scx=Gran}/u, "\u{bb5}");
f(/\P{scx=Gran}/u, "\u{bb5}");
t(/\p{scx=Gran}/u, "\u{be6}");
f(/\P{scx=Gran}/u, "\u{be6}");
t(/\p{scx=Gran}/u, "\u{be7}");
f(/\P{scx=Gran}/u, "\u{be7}");
t(/\p{scx=Gran}/u, "\u{be8}");
f(/\P{scx=Gran}/u, "\u{be8}");
t(/\p{scx=Gran}/u, "\u{be9}");
f(/\P{scx=Gran}/u, "\u{be9}");
t(/\p{scx=Gran}/u, "\u{bea}");
f(/\P{scx=Gran}/u, "\u{bea}");
t(/\p{scx=Gran}/u, "\u{beb}");
f(/\P{scx=Gran}/u, "\u{beb}");
t(/\p{scx=Gran}/u, "\u{bec}");
f(/\P{scx=Gran}/u, "\u{bec}");
t(/\p{scx=Gran}/u, "\u{bed}");
f(/\P{scx=Gran}/u, "\u{bed}");
t(/\p{scx=Gran}/u, "\u{bee}");
f(/\P{scx=Gran}/u, "\u{bee}");
t(/\p{scx=Gran}/u, "\u{bef}");
f(/\P{scx=Gran}/u, "\u{bef}");
t(/\p{scx=Gran}/u, "\u{bf0}");
f(/\P{scx=Gran}/u, "\u{bf0}");
t(/\p{scx=Gran}/u, "\u{bf1}");
f(/\P{scx=Gran}/u, "\u{bf1}");
t(/\p{scx=Gran}/u, "\u{bf2}");
f(/\P{scx=Gran}/u, "\u{bf2}");
t(/\p{scx=Gran}/u, "\u{11303}");
f(/\P{scx=Gran}/u, "\u{11303}");
t(/\p{scx=Gran}/u, "\u{1133c}");
f(/\P{scx=Gran}/u, "\u{1133c}");
t(/\p{scx=Gran}/u, "\u{20f0}");
f(/\P{scx=Gran}/u, "\u{20f0}");
t(/\p{scx=Gran}/u, "\u{952}");
f(/\P{scx=Gran}/u, "\u{952}");
t(/\p{scx=Gran}/u, "\u{951}");
f(/\P{scx=Gran}/u, "\u{951}");
t(/\p{scx=Gran}/u, "\u{964}");
f(/\P{scx=Gran}/u, "\u{964}");
t(/\p{scx=Gran}/u, "\u{965}");
f(/\P{scx=Gran}/u, "\u{965}");
f(/(?=\P{sc=Gran})\p{scx=Gran}/u, "\u{bb28a}");
f(/(?=\P{sc=Gran})\p{scx=Gran}/u, "\u{ede3d}");
f(/(?=\P{sc=Gran})\p{scx=Gran}/u, "\u{5a3a1}");
f(/(?=\P{sc=Gran})\p{scx=Gran}/u, "\u{a9d70}");
f(/(?=\P{sc=Gran})\p{scx=Gran}/u, "\u{d1d5e}");
// Script_Extension=Knda
t(/\p{scx=Knda}/u, "\u{1cf5}");
f(/\P{scx=Knda}/u, "\u{1cf5}");
t(/\p{scx=Knda}/u, "\u{1cda}");
f(/\P{scx=Knda}/u, "\u{1cda}");
t(/\p{scx=Knda}/u, "\u{a830}");
f(/\P{scx=Knda}/u, "\u{a830}");
t(/\p{scx=Knda}/u, "\u{a831}");
f(/\P{scx=Knda}/u, "\u{a831}");
t(/\p{scx=Knda}/u, "\u{a832}");
f(/\P{scx=Knda}/u, "\u{a832}");
t(/\p{scx=Knda}/u, "\u{a833}");
f(/\P{scx=Knda}/u, "\u{a833}");
t(/\p{scx=Knda}/u, "\u{a834}");
f(/\P{scx=Knda}/u, "\u{a834}");
t(/\p{scx=Knda}/u, "\u{a835}");
f(/\P{scx=Knda}/u, "\u{a835}");
t(/\p{scx=Knda}/u, "\u{952}");
f(/\P{scx=Knda}/u, "\u{952}");
t(/\p{scx=Knda}/u, "\u{951}");
f(/\P{scx=Knda}/u, "\u{951}");
t(/\p{scx=Knda}/u, "\u{964}");
f(/\P{scx=Knda}/u, "\u{964}");
t(/\p{scx=Knda}/u, "\u{965}");
f(/\P{scx=Knda}/u, "\u{965}");
f(/(?=\P{sc=Knda})\p{scx=Knda}/u, "\u{1571e}");
f(/(?=\P{sc=Knda})\p{scx=Knda}/u, "\u{8e880}");
f(/(?=\P{sc=Knda})\p{scx=Knda}/u, "\u{5995d}");
f(/(?=\P{sc=Knda})\p{scx=Knda}/u, "\u{8516e}");
f(/(?=\P{sc=Knda})\p{scx=Knda}/u, "\u{108a91}");
// Script_Extension=Shrd
t(/\p{scx=Shrd}/u, "\u{1cd7}");
f(/\P{scx=Shrd}/u, "\u{1cd7}");
t(/\p{scx=Shrd}/u, "\u{1cd9}");
f(/\P{scx=Shrd}/u, "\u{1cd9}");
t(/\p{scx=Shrd}/u, "\u{1cdc}");
f(/\P{scx=Shrd}/u, "\u{1cdc}");
t(/\p{scx=Shrd}/u, "\u{1cdd}");
f(/\P{scx=Shrd}/u, "\u{1cdd}");
t(/\p{scx=Shrd}/u, "\u{1ce0}");
f(/\P{scx=Shrd}/u, "\u{1ce0}");
t(/\p{scx=Shrd}/u, "\u{951}");
f(/\P{scx=Shrd}/u, "\u{951}");
f(/(?=\P{sc=Shrd})\p{scx=Shrd}/u, "\u{5c32b}");
f(/(?=\P{sc=Shrd})\p{scx=Shrd}/u, "\u{10fe3a}");
f(/(?=\P{sc=Shrd})\p{scx=Shrd}/u, "\u{4e2d9}");
f(/(?=\P{sc=Shrd})\p{scx=Shrd}/u, "\u{ea40}");
f(/(?=\P{sc=Shrd})\p{scx=Shrd}/u, "\u{cc847}");
// Script_Extension=Taml
t(/\p{scx=Taml}/u, "\u{a8f3}");
f(/\P{scx=Taml}/u, "\u{a8f3}");
t(/\p{scx=Taml}/u, "\u{baa}");
f(/\P{scx=Taml}/u, "\u{baa}");
t(/\p{scx=Taml}/u, "\u{bb5}");
f(/\P{scx=Taml}/u, "\u{bb5}");
t(/\p{scx=Taml}/u, "\u{be6}");
f(/\P{scx=Taml}/u, "\u{be6}");
t(/\p{scx=Taml}/u, "\u{be7}");
f(/\P{scx=Taml}/u, "\u{be7}");
t(/\p{scx=Taml}/u, "\u{be8}");
f(/\P{scx=Taml}/u, "\u{be8}");
t(/\p{scx=Taml}/u, "\u{be9}");
f(/\P{scx=Taml}/u, "\u{be9}");
t(/\p{scx=Taml}/u, "\u{bea}");
f(/\P{scx=Taml}/u, "\u{bea}");
t(/\p{scx=Taml}/u, "\u{beb}");
f(/\P{scx=Taml}/u, "\u{beb}");
t(/\p{scx=Taml}/u, "\u{bec}");
f(/\P{scx=Taml}/u, "\u{bec}");
t(/\p{scx=Taml}/u, "\u{bed}");
f(/\P{scx=Taml}/u, "\u{bed}");
t(/\p{scx=Taml}/u, "\u{bee}");
f(/\P{scx=Taml}/u, "\u{bee}");
t(/\p{scx=Taml}/u, "\u{bef}");
f(/\P{scx=Taml}/u, "\u{bef}");
t(/\p{scx=Taml}/u, "\u{bf0}");
f(/\P{scx=Taml}/u, "\u{bf0}");
t(/\p{scx=Taml}/u, "\u{bf1}");
f(/\P{scx=Taml}/u, "\u{bf1}");
t(/\p{scx=Taml}/u, "\u{bf2}");
f(/\P{scx=Taml}/u, "\u{bf2}");
t(/\p{scx=Taml}/u, "\u{11303}");
f(/\P{scx=Taml}/u, "\u{11303}");
t(/\p{scx=Taml}/u, "\u{1133c}");
f(/\P{scx=Taml}/u, "\u{1133c}");
t(/\p{scx=Taml}/u, "\u{1cda}");
f(/\P{scx=Taml}/u, "\u{1cda}");
t(/\p{scx=Taml}/u, "\u{952}");
f(/\P{scx=Taml}/u, "\u{952}");
t(/\p{scx=Taml}/u, "\u{951}");
f(/\P{scx=Taml}/u, "\u{951}");
t(/\p{scx=Taml}/u, "\u{964}");
f(/\P{scx=Taml}/u, "\u{964}");
t(/\p{scx=Taml}/u, "\u{965}");
f(/\P{scx=Taml}/u, "\u{965}");
f(/(?=\P{sc=Taml})\p{scx=Taml}/u, "\u{cd2c8}");
f(/(?=\P{sc=Taml})\p{scx=Taml}/u, "\u{3b11}");
f(/(?=\P{sc=Taml})\p{scx=Taml}/u, "\u{4c056}");
f(/(?=\P{sc=Taml})\p{scx=Taml}/u, "\u{f32f7}");
f(/(?=\P{sc=Taml})\p{scx=Taml}/u, "\u{b753f}");
// Script_Extension=Gujr
t(/\p{scx=Gujr}/u, "\u{ae6}");
f(/\P{scx=Gujr}/u, "\u{ae6}");
t(/\p{scx=Gujr}/u, "\u{ae7}");
f(/\P{scx=Gujr}/u, "\u{ae7}");
t(/\p{scx=Gujr}/u, "\u{ae8}");
f(/\P{scx=Gujr}/u, "\u{ae8}");
t(/\p{scx=Gujr}/u, "\u{ae9}");
f(/\P{scx=Gujr}/u, "\u{ae9}");
t(/\p{scx=Gujr}/u, "\u{aea}");
f(/\P{scx=Gujr}/u, "\u{aea}");
t(/\p{scx=Gujr}/u, "\u{aeb}");
f(/\P{scx=Gujr}/u, "\u{aeb}");
t(/\p{scx=Gujr}/u, "\u{aec}");
f(/\P{scx=Gujr}/u, "\u{aec}");
t(/\p{scx=Gujr}/u, "\u{aed}");
f(/\P{scx=Gujr}/u, "\u{aed}");
t(/\p{scx=Gujr}/u, "\u{aee}");
f(/\P{scx=Gujr}/u, "\u{aee}");
t(/\p{scx=Gujr}/u, "\u{aef}");
f(/\P{scx=Gujr}/u, "\u{aef}");
t(/\p{scx=Gujr}/u, "\u{a836}");
f(/\P{scx=Gujr}/u, "\u{a836}");
t(/\p{scx=Gujr}/u, "\u{a837}");
f(/\P{scx=Gujr}/u, "\u{a837}");
t(/\p{scx=Gujr}/u, "\u{a838}");
f(/\P{scx=Gujr}/u, "\u{a838}");
t(/\p{scx=Gujr}/u, "\u{a839}");
f(/\P{scx=Gujr}/u, "\u{a839}");
t(/\p{scx=Gujr}/u, "\u{a830}");
f(/\P{scx=Gujr}/u, "\u{a830}");
t(/\p{scx=Gujr}/u, "\u{a831}");
f(/\P{scx=Gujr}/u, "\u{a831}");
t(/\p{scx=Gujr}/u, "\u{a832}");
f(/\P{scx=Gujr}/u, "\u{a832}");
t(/\p{scx=Gujr}/u, "\u{a833}");
f(/\P{scx=Gujr}/u, "\u{a833}");
t(/\p{scx=Gujr}/u, "\u{a834}");
f(/\P{scx=Gujr}/u, "\u{a834}");
t(/\p{scx=Gujr}/u, "\u{a835}");
f(/\P{scx=Gujr}/u, "\u{a835}");
t(/\p{scx=Gujr}/u, "\u{952}");
f(/\P{scx=Gujr}/u, "\u{952}");
t(/\p{scx=Gujr}/u, "\u{951}");
f(/\P{scx=Gujr}/u, "\u{951}");
t(/\p{scx=Gujr}/u, "\u{964}");
f(/\P{scx=Gujr}/u, "\u{964}");
t(/\p{scx=Gujr}/u, "\u{965}");
f(/\P{scx=Gujr}/u, "\u{965}");
f(/(?=\P{sc=Gujr})\p{scx=Gujr}/u, "\u{6e146}");
f(/(?=\P{sc=Gujr})\p{scx=Gujr}/u, "\u{6c1e2}");
f(/(?=\P{sc=Gujr})\p{scx=Gujr}/u, "\u{122b2}");
f(/(?=\P{sc=Gujr})\p{scx=Gujr}/u, "\u{1084c8}");
f(/(?=\P{sc=Gujr})\p{scx=Gujr}/u, "\u{e13be}");
// Script_Extension=Khoj
t(/\p{scx=Khoj}/u, "\u{ae6}");
f(/\P{scx=Khoj}/u, "\u{ae6}");
t(/\p{scx=Khoj}/u, "\u{ae7}");
f(/\P{scx=Khoj}/u, "\u{ae7}");
t(/\p{scx=Khoj}/u, "\u{ae8}");
f(/\P{scx=Khoj}/u, "\u{ae8}");
t(/\p{scx=Khoj}/u, "\u{ae9}");
f(/\P{scx=Khoj}/u, "\u{ae9}");
t(/\p{scx=Khoj}/u, "\u{aea}");
f(/\P{scx=Khoj}/u, "\u{aea}");
t(/\p{scx=Khoj}/u, "\u{aeb}");
f(/\P{scx=Khoj}/u, "\u{aeb}");
t(/\p{scx=Khoj}/u, "\u{aec}");
f(/\P{scx=Khoj}/u, "\u{aec}");
t(/\p{scx=Khoj}/u, "\u{aed}");
f(/\P{scx=Khoj}/u, "\u{aed}");
t(/\p{scx=Khoj}/u, "\u{aee}");
f(/\P{scx=Khoj}/u, "\u{aee}");
t(/\p{scx=Khoj}/u, "\u{aef}");
f(/\P{scx=Khoj}/u, "\u{aef}");
f(/(?=\P{sc=Khoj})\p{scx=Khoj}/u, "\u{54d2e}");
f(/(?=\P{sc=Khoj})\p{scx=Khoj}/u, "\u{7f810}");
f(/(?=\P{sc=Khoj})\p{scx=Khoj}/u, "\u{1b6a5}");
f(/(?=\P{sc=Khoj})\p{scx=Khoj}/u, "\u{25b08}");
f(/(?=\P{sc=Khoj})\p{scx=Khoj}/u, "\u{3f5a4}");
// Script_Extension=Guru
t(/\p{scx=Guru}/u, "\u{a66}");
f(/\P{scx=Guru}/u, "\u{a66}");
t(/\p{scx=Guru}/u, "\u{a67}");
f(/\P{scx=Guru}/u, "\u{a67}");
t(/\p{scx=Guru}/u, "\u{a68}");
f(/\P{scx=Guru}/u, "\u{a68}");
t(/\p{scx=Guru}/u, "\u{a69}");
f(/\P{scx=Guru}/u, "\u{a69}");
t(/\p{scx=Guru}/u, "\u{a6a}");
f(/\P{scx=Guru}/u, "\u{a6a}");
t(/\p{scx=Guru}/u, "\u{a6b}");
f(/\P{scx=Guru}/u, "\u{a6b}");
t(/\p{scx=Guru}/u, "\u{a6c}");
f(/\P{scx=Guru}/u, "\u{a6c}");
t(/\p{scx=Guru}/u, "\u{a6d}");
f(/\P{scx=Guru}/u, "\u{a6d}");
t(/\p{scx=Guru}/u, "\u{a6e}");
f(/\P{scx=Guru}/u, "\u{a6e}");
t(/\p{scx=Guru}/u, "\u{a6f}");
f(/\P{scx=Guru}/u, "\u{a6f}");
t(/\p{scx=Guru}/u, "\u{a836}");
f(/\P{scx=Guru}/u, "\u{a836}");
t(/\p{scx=Guru}/u, "\u{a837}");
f(/\P{scx=Guru}/u, "\u{a837}");
t(/\p{scx=Guru}/u, "\u{a838}");
f(/\P{scx=Guru}/u, "\u{a838}");
t(/\p{scx=Guru}/u, "\u{a839}");
f(/\P{scx=Guru}/u, "\u{a839}");
t(/\p{scx=Guru}/u, "\u{a830}");
f(/\P{scx=Guru}/u, "\u{a830}");
t(/\p{scx=Guru}/u, "\u{a831}");
f(/\P{scx=Guru}/u, "\u{a831}");
t(/\p{scx=Guru}/u, "\u{a832}");
f(/\P{scx=Guru}/u, "\u{a832}");
t(/\p{scx=Guru}/u, "\u{a833}");
f(/\P{scx=Guru}/u, "\u{a833}");
t(/\p{scx=Guru}/u, "\u{a834}");
f(/\P{scx=Guru}/u, "\u{a834}");
t(/\p{scx=Guru}/u, "\u{a835}");
f(/\P{scx=Guru}/u, "\u{a835}");
t(/\p{scx=Guru}/u, "\u{952}");
f(/\P{scx=Guru}/u, "\u{952}");
t(/\p{scx=Guru}/u, "\u{951}");
f(/\P{scx=Guru}/u, "\u{951}");
t(/\p{scx=Guru}/u, "\u{964}");
f(/\P{scx=Guru}/u, "\u{964}");
t(/\p{scx=Guru}/u, "\u{965}");
f(/\P{scx=Guru}/u, "\u{965}");
f(/(?=\P{sc=Guru})\p{scx=Guru}/u, "\u{c01ee}");
f(/(?=\P{sc=Guru})\p{scx=Guru}/u, "\u{8b95a}");
f(/(?=\P{sc=Guru})\p{scx=Guru}/u, "\u{bf5a}");
f(/(?=\P{sc=Guru})\p{scx=Guru}/u, "\u{171c5}");
f(/(?=\P{sc=Guru})\p{scx=Guru}/u, "\u{89de9}");
// Script_Extension=Mult
t(/\p{scx=Mult}/u, "\u{a66}");
f(/\P{scx=Mult}/u, "\u{a66}");
t(/\p{scx=Mult}/u, "\u{a67}");
f(/\P{scx=Mult}/u, "\u{a67}");
t(/\p{scx=Mult}/u, "\u{a68}");
f(/\P{scx=Mult}/u, "\u{a68}");
t(/\p{scx=Mult}/u, "\u{a69}");
f(/\P{scx=Mult}/u, "\u{a69}");
t(/\p{scx=Mult}/u, "\u{a6a}");
f(/\P{scx=Mult}/u, "\u{a6a}");
t(/\p{scx=Mult}/u, "\u{a6b}");
f(/\P{scx=Mult}/u, "\u{a6b}");
t(/\p{scx=Mult}/u, "\u{a6c}");
f(/\P{scx=Mult}/u, "\u{a6c}");
t(/\p{scx=Mult}/u, "\u{a6d}");
f(/\P{scx=Mult}/u, "\u{a6d}");
t(/\p{scx=Mult}/u, "\u{a6e}");
f(/\P{scx=Mult}/u, "\u{a6e}");
t(/\p{scx=Mult}/u, "\u{a6f}");
f(/\P{scx=Mult}/u, "\u{a6f}");
f(/(?=\P{sc=Mult})\p{scx=Mult}/u, "\u{cb98f}");
f(/(?=\P{sc=Mult})\p{scx=Mult}/u, "\u{d30de}");
f(/(?=\P{sc=Mult})\p{scx=Mult}/u, "\u{5d609}");
f(/(?=\P{sc=Mult})\p{scx=Mult}/u, "\u{935d8}");
f(/(?=\P{sc=Mult})\p{scx=Mult}/u, "\u{72f8e}");
// Script_Extension=Hira
t(/\p{scx=Hira}/u, "\u{3031}");
f(/\P{scx=Hira}/u, "\u{3031}");
t(/\p{scx=Hira}/u, "\u{3032}");
f(/\P{scx=Hira}/u, "\u{3032}");
t(/\p{scx=Hira}/u, "\u{3033}");
f(/\P{scx=Hira}/u, "\u{3033}");
t(/\p{scx=Hira}/u, "\u{3034}");
f(/\P{scx=Hira}/u, "\u{3034}");
t(/\p{scx=Hira}/u, "\u{3035}");
f(/\P{scx=Hira}/u, "\u{3035}");
t(/\p{scx=Hira}/u, "\u{3099}");
f(/\P{scx=Hira}/u, "\u{3099}");
t(/\p{scx=Hira}/u, "\u{309a}");
f(/\P{scx=Hira}/u, "\u{309a}");
t(/\p{scx=Hira}/u, "\u{309b}");
f(/\P{scx=Hira}/u, "\u{309b}");
t(/\p{scx=Hira}/u, "\u{309c}");
f(/\P{scx=Hira}/u, "\u{309c}");
t(/\p{scx=Hira}/u, "\u{30a0}");
f(/\P{scx=Hira}/u, "\u{30a0}");
t(/\p{scx=Hira}/u, "\u{30fc}");
f(/\P{scx=Hira}/u, "\u{30fc}");
t(/\p{scx=Hira}/u, "\u{ff70}");
f(/\P{scx=Hira}/u, "\u{ff70}");
t(/\p{scx=Hira}/u, "\u{ff9e}");
f(/\P{scx=Hira}/u, "\u{ff9e}");
t(/\p{scx=Hira}/u, "\u{ff9f}");
f(/\P{scx=Hira}/u, "\u{ff9f}");
t(/\p{scx=Hira}/u, "\u{303c}");
f(/\P{scx=Hira}/u, "\u{303c}");
t(/\p{scx=Hira}/u, "\u{303d}");
f(/\P{scx=Hira}/u, "\u{303d}");
t(/\p{scx=Hira}/u, "\u{3003}");
f(/\P{scx=Hira}/u, "\u{3003}");
t(/\p{scx=Hira}/u, "\u{3013}");
f(/\P{scx=Hira}/u, "\u{3013}");
t(/\p{scx=Hira}/u, "\u{301c}");
f(/\P{scx=Hira}/u, "\u{301c}");
t(/\p{scx=Hira}/u, "\u{301d}");
f(/\P{scx=Hira}/u, "\u{301d}");
t(/\p{scx=Hira}/u, "\u{301e}");
f(/\P{scx=Hira}/u, "\u{301e}");
t(/\p{scx=Hira}/u, "\u{301f}");
f(/\P{scx=Hira}/u, "\u{301f}");
t(/\p{scx=Hira}/u, "\u{3030}");
f(/\P{scx=Hira}/u, "\u{3030}");
t(/\p{scx=Hira}/u, "\u{3037}");
f(/\P{scx=Hira}/u, "\u{3037}");
t(/\p{scx=Hira}/u, "\u{fe45}");
f(/\P{scx=Hira}/u, "\u{fe45}");
t(/\p{scx=Hira}/u, "\u{fe46}");
f(/\P{scx=Hira}/u, "\u{fe46}");
t(/\p{scx=Hira}/u, "\u{3001}");
f(/\P{scx=Hira}/u, "\u{3001}");
t(/\p{scx=Hira}/u, "\u{3002}");
f(/\P{scx=Hira}/u, "\u{3002}");
t(/\p{scx=Hira}/u, "\u{3008}");
f(/\P{scx=Hira}/u, "\u{3008}");
t(/\p{scx=Hira}/u, "\u{3009}");
f(/\P{scx=Hira}/u, "\u{3009}");
t(/\p{scx=Hira}/u, "\u{300a}");
f(/\P{scx=Hira}/u, "\u{300a}");
t(/\p{scx=Hira}/u, "\u{300b}");
f(/\P{scx=Hira}/u, "\u{300b}");
t(/\p{scx=Hira}/u, "\u{300c}");
f(/\P{scx=Hira}/u, "\u{300c}");
t(/\p{scx=Hira}/u, "\u{300d}");
f(/\P{scx=Hira}/u, "\u{300d}");
t(/\p{scx=Hira}/u, "\u{300e}");
f(/\P{scx=Hira}/u, "\u{300e}");
t(/\p{scx=Hira}/u, "\u{300f}");
f(/\P{scx=Hira}/u, "\u{300f}");
t(/\p{scx=Hira}/u, "\u{3010}");
f(/\P{scx=Hira}/u, "\u{3010}");
t(/\p{scx=Hira}/u, "\u{3011}");
f(/\P{scx=Hira}/u, "\u{3011}");
t(/\p{scx=Hira}/u, "\u{3014}");
f(/\P{scx=Hira}/u, "\u{3014}");
t(/\p{scx=Hira}/u, "\u{3015}");
f(/\P{scx=Hira}/u, "\u{3015}");
t(/\p{scx=Hira}/u, "\u{3016}");
f(/\P{scx=Hira}/u, "\u{3016}");
t(/\p{scx=Hira}/u, "\u{3017}");
f(/\P{scx=Hira}/u, "\u{3017}");
t(/\p{scx=Hira}/u, "\u{3018}");
f(/\P{scx=Hira}/u, "\u{3018}");
t(/\p{scx=Hira}/u, "\u{3019}");
f(/\P{scx=Hira}/u, "\u{3019}");
t(/\p{scx=Hira}/u, "\u{301a}");
f(/\P{scx=Hira}/u, "\u{301a}");
t(/\p{scx=Hira}/u, "\u{301b}");
f(/\P{scx=Hira}/u, "\u{301b}");
t(/\p{scx=Hira}/u, "\u{30fb}");
f(/\P{scx=Hira}/u, "\u{30fb}");
t(/\p{scx=Hira}/u, "\u{ff61}");
f(/\P{scx=Hira}/u, "\u{ff61}");
t(/\p{scx=Hira}/u, "\u{ff62}");
f(/\P{scx=Hira}/u, "\u{ff62}");
t(/\p{scx=Hira}/u, "\u{ff63}");
f(/\P{scx=Hira}/u, "\u{ff63}");
t(/\p{scx=Hira}/u, "\u{ff64}");
f(/\P{scx=Hira}/u, "\u{ff64}");
t(/\p{scx=Hira}/u, "\u{ff65}");
f(/\P{scx=Hira}/u, "\u{ff65}");
f(/(?=\P{sc=Hira})\p{scx=Hira}/u, "\u{e76fe}");
f(/(?=\P{sc=Hira})\p{scx=Hira}/u, "\u{53a36}");
f(/(?=\P{sc=Hira})\p{scx=Hira}/u, "\u{acd83}");
f(/(?=\P{sc=Hira})\p{scx=Hira}/u, "\u{b4cab}");
f(/(?=\P{sc=Hira})\p{scx=Hira}/u, "\u{e9807}");
// Script_Extension=Kana
t(/\p{scx=Kana}/u, "\u{3031}");
f(/\P{scx=Kana}/u, "\u{3031}");
t(/\p{scx=Kana}/u, "\u{3032}");
f(/\P{scx=Kana}/u, "\u{3032}");
t(/\p{scx=Kana}/u, "\u{3033}");
f(/\P{scx=Kana}/u, "\u{3033}");
t(/\p{scx=Kana}/u, "\u{3034}");
f(/\P{scx=Kana}/u, "\u{3034}");
t(/\p{scx=Kana}/u, "\u{3035}");
f(/\P{scx=Kana}/u, "\u{3035}");
t(/\p{scx=Kana}/u, "\u{3099}");
f(/\P{scx=Kana}/u, "\u{3099}");
t(/\p{scx=Kana}/u, "\u{309a}");
f(/\P{scx=Kana}/u, "\u{309a}");
t(/\p{scx=Kana}/u, "\u{309b}");
f(/\P{scx=Kana}/u, "\u{309b}");
t(/\p{scx=Kana}/u, "\u{309c}");
f(/\P{scx=Kana}/u, "\u{309c}");
t(/\p{scx=Kana}/u, "\u{30a0}");
f(/\P{scx=Kana}/u, "\u{30a0}");
t(/\p{scx=Kana}/u, "\u{30fc}");
f(/\P{scx=Kana}/u, "\u{30fc}");
t(/\p{scx=Kana}/u, "\u{ff70}");
f(/\P{scx=Kana}/u, "\u{ff70}");
t(/\p{scx=Kana}/u, "\u{ff9e}");
f(/\P{scx=Kana}/u, "\u{ff9e}");
t(/\p{scx=Kana}/u, "\u{ff9f}");
f(/\P{scx=Kana}/u, "\u{ff9f}");
t(/\p{scx=Kana}/u, "\u{303c}");
f(/\P{scx=Kana}/u, "\u{303c}");
t(/\p{scx=Kana}/u, "\u{303d}");
f(/\P{scx=Kana}/u, "\u{303d}");
t(/\p{scx=Kana}/u, "\u{3003}");
f(/\P{scx=Kana}/u, "\u{3003}");
t(/\p{scx=Kana}/u, "\u{3013}");
f(/\P{scx=Kana}/u, "\u{3013}");
t(/\p{scx=Kana}/u, "\u{301c}");
f(/\P{scx=Kana}/u, "\u{301c}");
t(/\p{scx=Kana}/u, "\u{301d}");
f(/\P{scx=Kana}/u, "\u{301d}");
t(/\p{scx=Kana}/u, "\u{301e}");
f(/\P{scx=Kana}/u, "\u{301e}");
t(/\p{scx=Kana}/u, "\u{301f}");
f(/\P{scx=Kana}/u, "\u{301f}");
t(/\p{scx=Kana}/u, "\u{3030}");
f(/\P{scx=Kana}/u, "\u{3030}");
t(/\p{scx=Kana}/u, "\u{3037}");
f(/\P{scx=Kana}/u, "\u{3037}");
t(/\p{scx=Kana}/u, "\u{fe45}");
f(/\P{scx=Kana}/u, "\u{fe45}");
t(/\p{scx=Kana}/u, "\u{fe46}");
f(/\P{scx=Kana}/u, "\u{fe46}");
t(/\p{scx=Kana}/u, "\u{3001}");
f(/\P{scx=Kana}/u, "\u{3001}");
t(/\p{scx=Kana}/u, "\u{3002}");
f(/\P{scx=Kana}/u, "\u{3002}");
t(/\p{scx=Kana}/u, "\u{3008}");
f(/\P{scx=Kana}/u, "\u{3008}");
t(/\p{scx=Kana}/u, "\u{3009}");
f(/\P{scx=Kana}/u, "\u{3009}");
t(/\p{scx=Kana}/u, "\u{300a}");
f(/\P{scx=Kana}/u, "\u{300a}");
t(/\p{scx=Kana}/u, "\u{300b}");
f(/\P{scx=Kana}/u, "\u{300b}");
t(/\p{scx=Kana}/u, "\u{300c}");
f(/\P{scx=Kana}/u, "\u{300c}");
t(/\p{scx=Kana}/u, "\u{300d}");
f(/\P{scx=Kana}/u, "\u{300d}");
t(/\p{scx=Kana}/u, "\u{300e}");
f(/\P{scx=Kana}/u, "\u{300e}");
t(/\p{scx=Kana}/u, "\u{300f}");
f(/\P{scx=Kana}/u, "\u{300f}");
t(/\p{scx=Kana}/u, "\u{3010}");
f(/\P{scx=Kana}/u, "\u{3010}");
t(/\p{scx=Kana}/u, "\u{3011}");
f(/\P{scx=Kana}/u, "\u{3011}");
t(/\p{scx=Kana}/u, "\u{3014}");
f(/\P{scx=Kana}/u, "\u{3014}");
t(/\p{scx=Kana}/u, "\u{3015}");
f(/\P{scx=Kana}/u, "\u{3015}");
t(/\p{scx=Kana}/u, "\u{3016}");
f(/\P{scx=Kana}/u, "\u{3016}");
t(/\p{scx=Kana}/u, "\u{3017}");
f(/\P{scx=Kana}/u, "\u{3017}");
t(/\p{scx=Kana}/u, "\u{3018}");
f(/\P{scx=Kana}/u, "\u{3018}");
t(/\p{scx=Kana}/u, "\u{3019}");
f(/\P{scx=Kana}/u, "\u{3019}");
t(/\p{scx=Kana}/u, "\u{301a}");
f(/\P{scx=Kana}/u, "\u{301a}");
t(/\p{scx=Kana}/u, "\u{301b}");
f(/\P{scx=Kana}/u, "\u{301b}");
t(/\p{scx=Kana}/u, "\u{30fb}");
f(/\P{scx=Kana}/u, "\u{30fb}");
t(/\p{scx=Kana}/u, "\u{ff61}");
f(/\P{scx=Kana}/u, "\u{ff61}");
t(/\p{scx=Kana}/u, "\u{ff62}");
f(/\P{scx=Kana}/u, "\u{ff62}");
t(/\p{scx=Kana}/u, "\u{ff63}");
f(/\P{scx=Kana}/u, "\u{ff63}");
t(/\p{scx=Kana}/u, "\u{ff64}");
f(/\P{scx=Kana}/u, "\u{ff64}");
t(/\p{scx=Kana}/u, "\u{ff65}");
f(/\P{scx=Kana}/u, "\u{ff65}");
f(/(?=\P{sc=Kana})\p{scx=Kana}/u, "\u{62d2b}");
f(/(?=\P{sc=Kana})\p{scx=Kana}/u, "\u{7fb02}");
f(/(?=\P{sc=Kana})\p{scx=Kana}/u, "\u{272ad}");
f(/(?=\P{sc=Kana})\p{scx=Kana}/u, "\u{d8eae}");
f(/(?=\P{sc=Kana})\p{scx=Kana}/u, "\u{5ff06}");
// Script_Extension=Mong
t(/\p{scx=Mong}/u, "\u{1802}");
f(/\P{scx=Mong}/u, "\u{1802}");
t(/\p{scx=Mong}/u, "\u{1803}");
f(/\P{scx=Mong}/u, "\u{1803}");
t(/\p{scx=Mong}/u, "\u{1805}");
f(/\P{scx=Mong}/u, "\u{1805}");
f(/(?=\P{sc=Mong})\p{scx=Mong}/u, "\u{9b814}");
f(/(?=\P{sc=Mong})\p{scx=Mong}/u, "\u{2dce3}");
f(/(?=\P{sc=Mong})\p{scx=Mong}/u, "\u{2f969}");
f(/(?=\P{sc=Mong})\p{scx=Mong}/u, "\u{10f87c}");
f(/(?=\P{sc=Mong})\p{scx=Mong}/u, "\u{57d}");
// Script_Extension=Phag
t(/\p{scx=Phag}/u, "\u{1802}");
f(/\P{scx=Phag}/u, "\u{1802}");
t(/\p{scx=Phag}/u, "\u{1803}");
f(/\P{scx=Phag}/u, "\u{1803}");
t(/\p{scx=Phag}/u, "\u{1805}");
f(/\P{scx=Phag}/u, "\u{1805}");
f(/(?=\P{sc=Phag})\p{scx=Phag}/u, "\u{aa326}");
f(/(?=\P{sc=Phag})\p{scx=Phag}/u, "\u{ba8f3}");
f(/(?=\P{sc=Phag})\p{scx=Phag}/u, "\u{2cc5d}");
f(/(?=\P{sc=Phag})\p{scx=Phag}/u, "\u{f8f43}");
f(/(?=\P{sc=Phag})\p{scx=Phag}/u, "\u{effbb}");
// Script_Extension=Cakm
t(/\p{scx=Cakm}/u, "\u{9e6}");
f(/\P{scx=Cakm}/u, "\u{9e6}");
t(/\p{scx=Cakm}/u, "\u{9e7}");
f(/\P{scx=Cakm}/u, "\u{9e7}");
t(/\p{scx=Cakm}/u, "\u{9e8}");
f(/\P{scx=Cakm}/u, "\u{9e8}");
t(/\p{scx=Cakm}/u, "\u{9e9}");
f(/\P{scx=Cakm}/u, "\u{9e9}");
t(/\p{scx=Cakm}/u, "\u{9ea}");
f(/\P{scx=Cakm}/u, "\u{9ea}");
t(/\p{scx=Cakm}/u, "\u{9eb}");
f(/\P{scx=Cakm}/u, "\u{9eb}");
t(/\p{scx=Cakm}/u, "\u{9ec}");
f(/\P{scx=Cakm}/u, "\u{9ec}");
t(/\p{scx=Cakm}/u, "\u{9ed}");
f(/\P{scx=Cakm}/u, "\u{9ed}");
t(/\p{scx=Cakm}/u, "\u{9ee}");
f(/\P{scx=Cakm}/u, "\u{9ee}");
t(/\p{scx=Cakm}/u, "\u{9ef}");
f(/\P{scx=Cakm}/u, "\u{9ef}");
t(/\p{scx=Cakm}/u, "\u{1040}");
f(/\P{scx=Cakm}/u, "\u{1040}");
t(/\p{scx=Cakm}/u, "\u{1041}");
f(/\P{scx=Cakm}/u, "\u{1041}");
t(/\p{scx=Cakm}/u, "\u{1042}");
f(/\P{scx=Cakm}/u, "\u{1042}");
t(/\p{scx=Cakm}/u, "\u{1043}");
f(/\P{scx=Cakm}/u, "\u{1043}");
t(/\p{scx=Cakm}/u, "\u{1044}");
f(/\P{scx=Cakm}/u, "\u{1044}");
t(/\p{scx=Cakm}/u, "\u{1045}");
f(/\P{scx=Cakm}/u, "\u{1045}");
t(/\p{scx=Cakm}/u, "\u{1046}");
f(/\P{scx=Cakm}/u, "\u{1046}");
t(/\p{scx=Cakm}/u, "\u{1047}");
f(/\P{scx=Cakm}/u, "\u{1047}");
t(/\p{scx=Cakm}/u, "\u{1048}");
f(/\P{scx=Cakm}/u, "\u{1048}");
t(/\p{scx=Cakm}/u, "\u{1049}");
f(/\P{scx=Cakm}/u, "\u{1049}");
f(/(?=\P{sc=Cakm})\p{scx=Cakm}/u, "\u{f475a}");
f(/(?=\P{sc=Cakm})\p{scx=Cakm}/u, "\u{7c476}");
f(/(?=\P{sc=Cakm})\p{scx=Cakm}/u, "\u{10d135}");
f(/(?=\P{sc=Cakm})\p{scx=Cakm}/u, "\u{9365b}");
f(/(?=\P{sc=Cakm})\p{scx=Cakm}/u, "\u{363e5}");
// Script_Extension=Sylo
t(/\p{scx=Sylo}/u, "\u{9e6}");
f(/\P{scx=Sylo}/u, "\u{9e6}");
t(/\p{scx=Sylo}/u, "\u{9e7}");
f(/\P{scx=Sylo}/u, "\u{9e7}");
t(/\p{scx=Sylo}/u, "\u{9e8}");
f(/\P{scx=Sylo}/u, "\u{9e8}");
t(/\p{scx=Sylo}/u, "\u{9e9}");
f(/\P{scx=Sylo}/u, "\u{9e9}");
t(/\p{scx=Sylo}/u, "\u{9ea}");
f(/\P{scx=Sylo}/u, "\u{9ea}");
t(/\p{scx=Sylo}/u, "\u{9eb}");
f(/\P{scx=Sylo}/u, "\u{9eb}");
t(/\p{scx=Sylo}/u, "\u{9ec}");
f(/\P{scx=Sylo}/u, "\u{9ec}");
t(/\p{scx=Sylo}/u, "\u{9ed}");
f(/\P{scx=Sylo}/u, "\u{9ed}");
t(/\p{scx=Sylo}/u, "\u{9ee}");
f(/\P{scx=Sylo}/u, "\u{9ee}");
t(/\p{scx=Sylo}/u, "\u{9ef}");
f(/\P{scx=Sylo}/u, "\u{9ef}");
t(/\p{scx=Sylo}/u, "\u{964}");
f(/\P{scx=Sylo}/u, "\u{964}");
t(/\p{scx=Sylo}/u, "\u{965}");
f(/\P{scx=Sylo}/u, "\u{965}");
f(/(?=\P{sc=Sylo})\p{scx=Sylo}/u, "\u{b299f}");
f(/(?=\P{sc=Sylo})\p{scx=Sylo}/u, "\u{10375e}");
f(/(?=\P{sc=Sylo})\p{scx=Sylo}/u, "\u{ffbda}");
f(/(?=\P{sc=Sylo})\p{scx=Sylo}/u, "\u{19058}");
f(/(?=\P{sc=Sylo})\p{scx=Sylo}/u, "\u{461b8}");
// Script_Extension=Mymr
t(/\p{scx=Mymr}/u, "\u{1040}");
f(/\P{scx=Mymr}/u, "\u{1040}");
t(/\p{scx=Mymr}/u, "\u{1041}");
f(/\P{scx=Mymr}/u, "\u{1041}");
t(/\p{scx=Mymr}/u, "\u{1042}");
f(/\P{scx=Mymr}/u, "\u{1042}");
t(/\p{scx=Mymr}/u, "\u{1043}");
f(/\P{scx=Mymr}/u, "\u{1043}");
t(/\p{scx=Mymr}/u, "\u{1044}");
f(/\P{scx=Mymr}/u, "\u{1044}");
t(/\p{scx=Mymr}/u, "\u{1045}");
f(/\P{scx=Mymr}/u, "\u{1045}");
t(/\p{scx=Mymr}/u, "\u{1046}");
f(/\P{scx=Mymr}/u, "\u{1046}");
t(/\p{scx=Mymr}/u, "\u{1047}");
f(/\P{scx=Mymr}/u, "\u{1047}");
t(/\p{scx=Mymr}/u, "\u{1048}");
f(/\P{scx=Mymr}/u, "\u{1048}");
t(/\p{scx=Mymr}/u, "\u{1049}");
f(/\P{scx=Mymr}/u, "\u{1049}");
t(/\p{scx=Mymr}/u, "\u{a92e}");
f(/\P{scx=Mymr}/u, "\u{a92e}");
f(/(?=\P{sc=Mymr})\p{scx=Mymr}/u, "\u{103b42}");
f(/(?=\P{sc=Mymr})\p{scx=Mymr}/u, "\u{71346}");
f(/(?=\P{sc=Mymr})\p{scx=Mymr}/u, "\u{25259}");
f(/(?=\P{sc=Mymr})\p{scx=Mymr}/u, "\u{469c5}");
f(/(?=\P{sc=Mymr})\p{scx=Mymr}/u, "\u{faf0c}");
// Script_Extension=Tale
t(/\p{scx=Tale}/u, "\u{1040}");
f(/\P{scx=Tale}/u, "\u{1040}");
t(/\p{scx=Tale}/u, "\u{1041}");
f(/\P{scx=Tale}/u, "\u{1041}");
t(/\p{scx=Tale}/u, "\u{1042}");
f(/\P{scx=Tale}/u, "\u{1042}");
t(/\p{scx=Tale}/u, "\u{1043}");
f(/\P{scx=Tale}/u, "\u{1043}");
t(/\p{scx=Tale}/u, "\u{1044}");
f(/\P{scx=Tale}/u, "\u{1044}");
t(/\p{scx=Tale}/u, "\u{1045}");
f(/\P{scx=Tale}/u, "\u{1045}");
t(/\p{scx=Tale}/u, "\u{1046}");
f(/\P{scx=Tale}/u, "\u{1046}");
t(/\p{scx=Tale}/u, "\u{1047}");
f(/\P{scx=Tale}/u, "\u{1047}");
t(/\p{scx=Tale}/u, "\u{1048}");
f(/\P{scx=Tale}/u, "\u{1048}");
t(/\p{scx=Tale}/u, "\u{1049}");
f(/\P{scx=Tale}/u, "\u{1049}");
f(/(?=\P{sc=Tale})\p{scx=Tale}/u, "\u{1416e}");
f(/(?=\P{sc=Tale})\p{scx=Tale}/u, "\u{ccc0}");
f(/(?=\P{sc=Tale})\p{scx=Tale}/u, "\u{2a52f}");
f(/(?=\P{sc=Tale})\p{scx=Tale}/u, "\u{47a2b}");
f(/(?=\P{sc=Tale})\p{scx=Tale}/u, "\u{7752b}");
// Script_Extension=Lina
t(/\p{scx=Lina}/u, "\u{10107}");
f(/\P{scx=Lina}/u, "\u{10107}");
t(/\p{scx=Lina}/u, "\u{10108}");
f(/\P{scx=Lina}/u, "\u{10108}");
t(/\p{scx=Lina}/u, "\u{10109}");
f(/\P{scx=Lina}/u, "\u{10109}");
t(/\p{scx=Lina}/u, "\u{1010a}");
f(/\P{scx=Lina}/u, "\u{1010a}");
t(/\p{scx=Lina}/u, "\u{1010b}");
f(/\P{scx=Lina}/u, "\u{1010b}");
t(/\p{scx=Lina}/u, "\u{1010c}");
f(/\P{scx=Lina}/u, "\u{1010c}");
t(/\p{scx=Lina}/u, "\u{1010d}");
f(/\P{scx=Lina}/u, "\u{1010d}");
t(/\p{scx=Lina}/u, "\u{1010e}");
f(/\P{scx=Lina}/u, "\u{1010e}");
t(/\p{scx=Lina}/u, "\u{1010f}");
f(/\P{scx=Lina}/u, "\u{1010f}");
t(/\p{scx=Lina}/u, "\u{10110}");
f(/\P{scx=Lina}/u, "\u{10110}");
t(/\p{scx=Lina}/u, "\u{10111}");
f(/\P{scx=Lina}/u, "\u{10111}");
t(/\p{scx=Lina}/u, "\u{10112}");
f(/\P{scx=Lina}/u, "\u{10112}");
t(/\p{scx=Lina}/u, "\u{10113}");
f(/\P{scx=Lina}/u, "\u{10113}");
t(/\p{scx=Lina}/u, "\u{10114}");
f(/\P{scx=Lina}/u, "\u{10114}");
t(/\p{scx=Lina}/u, "\u{10115}");
f(/\P{scx=Lina}/u, "\u{10115}");
t(/\p{scx=Lina}/u, "\u{10116}");
f(/\P{scx=Lina}/u, "\u{10116}");
t(/\p{scx=Lina}/u, "\u{10117}");
f(/\P{scx=Lina}/u, "\u{10117}");
t(/\p{scx=Lina}/u, "\u{10118}");
f(/\P{scx=Lina}/u, "\u{10118}");
t(/\p{scx=Lina}/u, "\u{10119}");
f(/\P{scx=Lina}/u, "\u{10119}");
t(/\p{scx=Lina}/u, "\u{1011a}");
f(/\P{scx=Lina}/u, "\u{1011a}");
t(/\p{scx=Lina}/u, "\u{1011b}");
f(/\P{scx=Lina}/u, "\u{1011b}");
t(/\p{scx=Lina}/u, "\u{1011c}");
f(/\P{scx=Lina}/u, "\u{1011c}");
t(/\p{scx=Lina}/u, "\u{1011d}");
f(/\P{scx=Lina}/u, "\u{1011d}");
t(/\p{scx=Lina}/u, "\u{1011e}");
f(/\P{scx=Lina}/u, "\u{1011e}");
t(/\p{scx=Lina}/u, "\u{1011f}");
f(/\P{scx=Lina}/u, "\u{1011f}");
t(/\p{scx=Lina}/u, "\u{10120}");
f(/\P{scx=Lina}/u, "\u{10120}");
t(/\p{scx=Lina}/u, "\u{10121}");
f(/\P{scx=Lina}/u, "\u{10121}");
t(/\p{scx=Lina}/u, "\u{10122}");
f(/\P{scx=Lina}/u, "\u{10122}");
t(/\p{scx=Lina}/u, "\u{10123}");
f(/\P{scx=Lina}/u, "\u{10123}");
t(/\p{scx=Lina}/u, "\u{10124}");
f(/\P{scx=Lina}/u, "\u{10124}");
t(/\p{scx=Lina}/u, "\u{10125}");
f(/\P{scx=Lina}/u, "\u{10125}");
t(/\p{scx=Lina}/u, "\u{10126}");
f(/\P{scx=Lina}/u, "\u{10126}");
t(/\p{scx=Lina}/u, "\u{10127}");
f(/\P{scx=Lina}/u, "\u{10127}");
t(/\p{scx=Lina}/u, "\u{10128}");
f(/\P{scx=Lina}/u, "\u{10128}");
t(/\p{scx=Lina}/u, "\u{10129}");
f(/\P{scx=Lina}/u, "\u{10129}");
t(/\p{scx=Lina}/u, "\u{1012a}");
f(/\P{scx=Lina}/u, "\u{1012a}");
t(/\p{scx=Lina}/u, "\u{1012b}");
f(/\P{scx=Lina}/u, "\u{1012b}");
t(/\p{scx=Lina}/u, "\u{1012c}");
f(/\P{scx=Lina}/u, "\u{1012c}");
t(/\p{scx=Lina}/u, "\u{1012d}");
f(/\P{scx=Lina}/u, "\u{1012d}");
t(/\p{scx=Lina}/u, "\u{1012e}");
f(/\P{scx=Lina}/u, "\u{1012e}");
t(/\p{scx=Lina}/u, "\u{1012f}");
f(/\P{scx=Lina}/u, "\u{1012f}");
t(/\p{scx=Lina}/u, "\u{10130}");
f(/\P{scx=Lina}/u, "\u{10130}");
t(/\p{scx=Lina}/u, "\u{10131}");
f(/\P{scx=Lina}/u, "\u{10131}");
t(/\p{scx=Lina}/u, "\u{10132}");
f(/\P{scx=Lina}/u, "\u{10132}");
t(/\p{scx=Lina}/u, "\u{10133}");
f(/\P{scx=Lina}/u, "\u{10133}");
f(/(?=\P{sc=Lina})\p{scx=Lina}/u, "\u{901a6}");
f(/(?=\P{sc=Lina})\p{scx=Lina}/u, "\u{4be73}");
f(/(?=\P{sc=Lina})\p{scx=Lina}/u, "\u{c7b70}");
f(/(?=\P{sc=Lina})\p{scx=Lina}/u, "\u{97401}");
f(/(?=\P{sc=Lina})\p{scx=Lina}/u, "\u{48165}");
// Script_Extension=Kthi
t(/\p{scx=Kthi}/u, "\u{966}");
f(/\P{scx=Kthi}/u, "\u{966}");
t(/\p{scx=Kthi}/u, "\u{967}");
f(/\P{scx=Kthi}/u, "\u{967}");
t(/\p{scx=Kthi}/u, "\u{968}");
f(/\P{scx=Kthi}/u, "\u{968}");
t(/\p{scx=Kthi}/u, "\u{969}");
f(/\P{scx=Kthi}/u, "\u{969}");
t(/\p{scx=Kthi}/u, "\u{96a}");
f(/\P{scx=Kthi}/u, "\u{96a}");
t(/\p{scx=Kthi}/u, "\u{96b}");
f(/\P{scx=Kthi}/u, "\u{96b}");
t(/\p{scx=Kthi}/u, "\u{96c}");
f(/\P{scx=Kthi}/u, "\u{96c}");
t(/\p{scx=Kthi}/u, "\u{96d}");
f(/\P{scx=Kthi}/u, "\u{96d}");
t(/\p{scx=Kthi}/u, "\u{96e}");
f(/\P{scx=Kthi}/u, "\u{96e}");
t(/\p{scx=Kthi}/u, "\u{96f}");
f(/\P{scx=Kthi}/u, "\u{96f}");
t(/\p{scx=Kthi}/u, "\u{a836}");
f(/\P{scx=Kthi}/u, "\u{a836}");
t(/\p{scx=Kthi}/u, "\u{a837}");
f(/\P{scx=Kthi}/u, "\u{a837}");
t(/\p{scx=Kthi}/u, "\u{a838}");
f(/\P{scx=Kthi}/u, "\u{a838}");
t(/\p{scx=Kthi}/u, "\u{a839}");
f(/\P{scx=Kthi}/u, "\u{a839}");
t(/\p{scx=Kthi}/u, "\u{a830}");
f(/\P{scx=Kthi}/u, "\u{a830}");
t(/\p{scx=Kthi}/u, "\u{a831}");
f(/\P{scx=Kthi}/u, "\u{a831}");
t(/\p{scx=Kthi}/u, "\u{a832}");
f(/\P{scx=Kthi}/u, "\u{a832}");
t(/\p{scx=Kthi}/u, "\u{a833}");
f(/\P{scx=Kthi}/u, "\u{a833}");
t(/\p{scx=Kthi}/u, "\u{a834}");
f(/\P{scx=Kthi}/u, "\u{a834}");
t(/\p{scx=Kthi}/u, "\u{a835}");
f(/\P{scx=Kthi}/u, "\u{a835}");
f(/(?=\P{sc=Kthi})\p{scx=Kthi}/u, "\u{13d9b}");
f(/(?=\P{sc=Kthi})\p{scx=Kthi}/u, "\u{24ff4}");
f(/(?=\P{sc=Kthi})\p{scx=Kthi}/u, "\u{4c2c6}");
f(/(?=\P{sc=Kthi})\p{scx=Kthi}/u, "\u{dfa34}");
f(/(?=\P{sc=Kthi})\p{scx=Kthi}/u, "\u{cfd5e}");
// Script_Extension=Mahj
t(/\p{scx=Mahj}/u, "\u{966}");
f(/\P{scx=Mahj}/u, "\u{966}");
t(/\p{scx=Mahj}/u, "\u{967}");
f(/\P{scx=Mahj}/u, "\u{967}");
t(/\p{scx=Mahj}/u, "\u{968}");
f(/\P{scx=Mahj}/u, "\u{968}");
t(/\p{scx=Mahj}/u, "\u{969}");
f(/\P{scx=Mahj}/u, "\u{969}");
t(/\p{scx=Mahj}/u, "\u{96a}");
f(/\P{scx=Mahj}/u, "\u{96a}");
t(/\p{scx=Mahj}/u, "\u{96b}");
f(/\P{scx=Mahj}/u, "\u{96b}");
t(/\p{scx=Mahj}/u, "\u{96c}");
f(/\P{scx=Mahj}/u, "\u{96c}");
t(/\p{scx=Mahj}/u, "\u{96d}");
f(/\P{scx=Mahj}/u, "\u{96d}");
t(/\p{scx=Mahj}/u, "\u{96e}");
f(/\P{scx=Mahj}/u, "\u{96e}");
t(/\p{scx=Mahj}/u, "\u{96f}");
f(/\P{scx=Mahj}/u, "\u{96f}");
t(/\p{scx=Mahj}/u, "\u{a836}");
f(/\P{scx=Mahj}/u, "\u{a836}");
t(/\p{scx=Mahj}/u, "\u{a837}");
f(/\P{scx=Mahj}/u, "\u{a837}");
t(/\p{scx=Mahj}/u, "\u{a838}");
f(/\P{scx=Mahj}/u, "\u{a838}");
t(/\p{scx=Mahj}/u, "\u{a839}");
f(/\P{scx=Mahj}/u, "\u{a839}");
t(/\p{scx=Mahj}/u, "\u{a830}");
f(/\P{scx=Mahj}/u, "\u{a830}");
t(/\p{scx=Mahj}/u, "\u{a831}");
f(/\P{scx=Mahj}/u, "\u{a831}");
t(/\p{scx=Mahj}/u, "\u{a832}");
f(/\P{scx=Mahj}/u, "\u{a832}");
t(/\p{scx=Mahj}/u, "\u{a833}");
f(/\P{scx=Mahj}/u, "\u{a833}");
t(/\p{scx=Mahj}/u, "\u{a834}");
f(/\P{scx=Mahj}/u, "\u{a834}");
t(/\p{scx=Mahj}/u, "\u{a835}");
f(/\P{scx=Mahj}/u, "\u{a835}");
t(/\p{scx=Mahj}/u, "\u{964}");
f(/\P{scx=Mahj}/u, "\u{964}");
t(/\p{scx=Mahj}/u, "\u{965}");
f(/\P{scx=Mahj}/u, "\u{965}");
f(/(?=\P{sc=Mahj})\p{scx=Mahj}/u, "\u{101f2b}");
f(/(?=\P{sc=Mahj})\p{scx=Mahj}/u, "\u{15a19}");
f(/(?=\P{sc=Mahj})\p{scx=Mahj}/u, "\u{de10b}");
f(/(?=\P{sc=Mahj})\p{scx=Mahj}/u, "\u{240fd}");
f(/(?=\P{sc=Mahj})\p{scx=Mahj}/u, "\u{e5eef}");
// Script_Extension=Kali
t(/\p{scx=Kali}/u, "\u{a92e}");
f(/\P{scx=Kali}/u, "\u{a92e}");
f(/(?=\P{sc=Kali})\p{scx=Kali}/u, "\u{59dbb}");
f(/(?=\P{sc=Kali})\p{scx=Kali}/u, "\u{ac769}");
f(/(?=\P{sc=Kali})\p{scx=Kali}/u, "\u{9255e}");
f(/(?=\P{sc=Kali})\p{scx=Kali}/u, "\u{a0523}");
f(/(?=\P{sc=Kali})\p{scx=Kali}/u, "\u{cca65}");
// Script_Extension=Buhd
t(/\p{scx=Buhd}/u, "\u{1735}");
f(/\P{scx=Buhd}/u, "\u{1735}");
t(/\p{scx=Buhd}/u, "\u{1736}");
f(/\P{scx=Buhd}/u, "\u{1736}");
f(/(?=\P{sc=Buhd})\p{scx=Buhd}/u, "\u{102987}");
f(/(?=\P{sc=Buhd})\p{scx=Buhd}/u, "\u{92d8}");
f(/(?=\P{sc=Buhd})\p{scx=Buhd}/u, "\u{85acd}");
f(/(?=\P{sc=Buhd})\p{scx=Buhd}/u, "\u{91eee}");
f(/(?=\P{sc=Buhd})\p{scx=Buhd}/u, "\u{99bf7}");
// Script_Extension=Hano
t(/\p{scx=Hano}/u, "\u{1735}");
f(/\P{scx=Hano}/u, "\u{1735}");
t(/\p{scx=Hano}/u, "\u{1736}");
f(/\P{scx=Hano}/u, "\u{1736}");
f(/(?=\P{sc=Hano})\p{scx=Hano}/u, "\u{7b94b}");
f(/(?=\P{sc=Hano})\p{scx=Hano}/u, "\u{10a944}");
f(/(?=\P{sc=Hano})\p{scx=Hano}/u, "\u{2cec}");
f(/(?=\P{sc=Hano})\p{scx=Hano}/u, "\u{64635}");
f(/(?=\P{sc=Hano})\p{scx=Hano}/u, "\u{25bea}");
// Script_Extension=Tagb
t(/\p{scx=Tagb}/u, "\u{1735}");
f(/\P{scx=Tagb}/u, "\u{1735}");
t(/\p{scx=Tagb}/u, "\u{1736}");
f(/\P{scx=Tagb}/u, "\u{1736}");
f(/(?=\P{sc=Tagb})\p{scx=Tagb}/u, "\u{950fe}");
f(/(?=\P{sc=Tagb})\p{scx=Tagb}/u, "\u{e85b7}");
f(/(?=\P{sc=Tagb})\p{scx=Tagb}/u, "\u{aead9}");
f(/(?=\P{sc=Tagb})\p{scx=Tagb}/u, "\u{37473}");
f(/(?=\P{sc=Tagb})\p{scx=Tagb}/u, "\u{a421a}");
// Script_Extension=Tglg
t(/\p{scx=Tglg}/u, "\u{1735}");
f(/\P{scx=Tglg}/u, "\u{1735}");
t(/\p{scx=Tglg}/u, "\u{1736}");
f(/\P{scx=Tglg}/u, "\u{1736}");
f(/(?=\P{sc=Tglg})\p{scx=Tglg}/u, "\u{c560d}");
f(/(?=\P{sc=Tglg})\p{scx=Tglg}/u, "\u{23ff2}");
f(/(?=\P{sc=Tglg})\p{scx=Tglg}/u, "\u{b1557}");
f(/(?=\P{sc=Tglg})\p{scx=Tglg}/u, "\u{f0d06}");
f(/(?=\P{sc=Tglg})\p{scx=Tglg}/u, "\u{9982b}");
// Script_Extension=Hang
t(/\p{scx=Hang}/u, "\u{3003}");
f(/\P{scx=Hang}/u, "\u{3003}");
t(/\p{scx=Hang}/u, "\u{3013}");
f(/\P{scx=Hang}/u, "\u{3013}");
t(/\p{scx=Hang}/u, "\u{301c}");
f(/\P{scx=Hang}/u, "\u{301c}");
t(/\p{scx=Hang}/u, "\u{301d}");
f(/\P{scx=Hang}/u, "\u{301d}");
t(/\p{scx=Hang}/u, "\u{301e}");
f(/\P{scx=Hang}/u, "\u{301e}");
t(/\p{scx=Hang}/u, "\u{301f}");
f(/\P{scx=Hang}/u, "\u{301f}");
t(/\p{scx=Hang}/u, "\u{3030}");
f(/\P{scx=Hang}/u, "\u{3030}");
t(/\p{scx=Hang}/u, "\u{3037}");
f(/\P{scx=Hang}/u, "\u{3037}");
t(/\p{scx=Hang}/u, "\u{fe45}");
f(/\P{scx=Hang}/u, "\u{fe45}");
t(/\p{scx=Hang}/u, "\u{fe46}");
f(/\P{scx=Hang}/u, "\u{fe46}");
t(/\p{scx=Hang}/u, "\u{3001}");
f(/\P{scx=Hang}/u, "\u{3001}");
t(/\p{scx=Hang}/u, "\u{3002}");
f(/\P{scx=Hang}/u, "\u{3002}");
t(/\p{scx=Hang}/u, "\u{3008}");
f(/\P{scx=Hang}/u, "\u{3008}");
t(/\p{scx=Hang}/u, "\u{3009}");
f(/\P{scx=Hang}/u, "\u{3009}");
t(/\p{scx=Hang}/u, "\u{300a}");
f(/\P{scx=Hang}/u, "\u{300a}");
t(/\p{scx=Hang}/u, "\u{300b}");
f(/\P{scx=Hang}/u, "\u{300b}");
t(/\p{scx=Hang}/u, "\u{300c}");
f(/\P{scx=Hang}/u, "\u{300c}");
t(/\p{scx=Hang}/u, "\u{300d}");
f(/\P{scx=Hang}/u, "\u{300d}");
t(/\p{scx=Hang}/u, "\u{300e}");
f(/\P{scx=Hang}/u, "\u{300e}");
t(/\p{scx=Hang}/u, "\u{300f}");
f(/\P{scx=Hang}/u, "\u{300f}");
t(/\p{scx=Hang}/u, "\u{3010}");
f(/\P{scx=Hang}/u, "\u{3010}");
t(/\p{scx=Hang}/u, "\u{3011}");
f(/\P{scx=Hang}/u, "\u{3011}");
t(/\p{scx=Hang}/u, "\u{3014}");
f(/\P{scx=Hang}/u, "\u{3014}");
t(/\p{scx=Hang}/u, "\u{3015}");
f(/\P{scx=Hang}/u, "\u{3015}");
t(/\p{scx=Hang}/u, "\u{3016}");
f(/\P{scx=Hang}/u, "\u{3016}");
t(/\p{scx=Hang}/u, "\u{3017}");
f(/\P{scx=Hang}/u, "\u{3017}");
t(/\p{scx=Hang}/u, "\u{3018}");
f(/\P{scx=Hang}/u, "\u{3018}");
t(/\p{scx=Hang}/u, "\u{3019}");
f(/\P{scx=Hang}/u, "\u{3019}");
t(/\p{scx=Hang}/u, "\u{301a}");
f(/\P{scx=Hang}/u, "\u{301a}");
t(/\p{scx=Hang}/u, "\u{301b}");
f(/\P{scx=Hang}/u, "\u{301b}");
t(/\p{scx=Hang}/u, "\u{30fb}");
f(/\P{scx=Hang}/u, "\u{30fb}");
t(/\p{scx=Hang}/u, "\u{ff61}");
f(/\P{scx=Hang}/u, "\u{ff61}");
t(/\p{scx=Hang}/u, "\u{ff62}");
f(/\P{scx=Hang}/u, "\u{ff62}");
t(/\p{scx=Hang}/u, "\u{ff63}");
f(/\P{scx=Hang}/u, "\u{ff63}");
t(/\p{scx=Hang}/u, "\u{ff64}");
f(/\P{scx=Hang}/u, "\u{ff64}");
t(/\p{scx=Hang}/u, "\u{ff65}");
f(/\P{scx=Hang}/u, "\u{ff65}");
f(/(?=\P{sc=Hang})\p{scx=Hang}/u, "\u{97df3}");
f(/(?=\P{sc=Hang})\p{scx=Hang}/u, "\u{e74b9}");
f(/(?=\P{sc=Hang})\p{scx=Hang}/u, "\u{a68b2}");
f(/(?=\P{sc=Hang})\p{scx=Hang}/u, "\u{82b9f}");
f(/(?=\P{sc=Hang})\p{scx=Hang}/u, "\u{60ae0}");
// Script_Extension=Mlym
t(/\p{scx=Mlym}/u, "\u{1cda}");
f(/\P{scx=Mlym}/u, "\u{1cda}");
t(/\p{scx=Mlym}/u, "\u{952}");
f(/\P{scx=Mlym}/u, "\u{952}");
t(/\p{scx=Mlym}/u, "\u{951}");
f(/\P{scx=Mlym}/u, "\u{951}");
t(/\p{scx=Mlym}/u, "\u{964}");
f(/\P{scx=Mlym}/u, "\u{964}");
t(/\p{scx=Mlym}/u, "\u{965}");
f(/\P{scx=Mlym}/u, "\u{965}");
f(/(?=\P{sc=Mlym})\p{scx=Mlym}/u, "\u{8ac6a}");
f(/(?=\P{sc=Mlym})\p{scx=Mlym}/u, "\u{2b695}");
f(/(?=\P{sc=Mlym})\p{scx=Mlym}/u, "\u{56e47}");
f(/(?=\P{sc=Mlym})\p{scx=Mlym}/u, "\u{c86ba}");
f(/(?=\P{sc=Mlym})\p{scx=Mlym}/u, "\u{b74e9}");
// Script_Extension=Telu
t(/\p{scx=Telu}/u, "\u{1cda}");
f(/\P{scx=Telu}/u, "\u{1cda}");
t(/\p{scx=Telu}/u, "\u{952}");
f(/\P{scx=Telu}/u, "\u{952}");
t(/\p{scx=Telu}/u, "\u{951}");
f(/\P{scx=Telu}/u, "\u{951}");
t(/\p{scx=Telu}/u, "\u{964}");
f(/\P{scx=Telu}/u, "\u{964}");
t(/\p{scx=Telu}/u, "\u{965}");
f(/\P{scx=Telu}/u, "\u{965}");
f(/(?=\P{sc=Telu})\p{scx=Telu}/u, "\u{d8bfa}");
f(/(?=\P{sc=Telu})\p{scx=Telu}/u, "\u{d2cc3}");
f(/(?=\P{sc=Telu})\p{scx=Telu}/u, "\u{54006}");
f(/(?=\P{sc=Telu})\p{scx=Telu}/u, "\u{104bf0}");
f(/(?=\P{sc=Telu})\p{scx=Telu}/u, "\u{2a98d}");
// Script_Extension=Adlm
t(/\p{scx=Adlm}/u, "\u{640}");
f(/\P{scx=Adlm}/u, "\u{640}");
f(/(?=\P{sc=Adlm})\p{scx=Adlm}/u, "\u{17d17}");
f(/(?=\P{sc=Adlm})\p{scx=Adlm}/u, "\u{90cdc}");
f(/(?=\P{sc=Adlm})\p{scx=Adlm}/u, "\u{8a2ee}");
f(/(?=\P{sc=Adlm})\p{scx=Adlm}/u, "\u{b1106}");
f(/(?=\P{sc=Adlm})\p{scx=Adlm}/u, "\u{49e11}");
// Script_Extension=Mand
t(/\p{scx=Mand}/u, "\u{640}");
f(/\P{scx=Mand}/u, "\u{640}");
f(/(?=\P{sc=Mand})\p{scx=Mand}/u, "\u{103f01}");
f(/(?=\P{sc=Mand})\p{scx=Mand}/u, "\u{d921a}");
f(/(?=\P{sc=Mand})\p{scx=Mand}/u, "\u{dc97e}");
f(/(?=\P{sc=Mand})\p{scx=Mand}/u, "\u{f1404}");
f(/(?=\P{sc=Mand})\p{scx=Mand}/u, "\u{5f57c}");
// Script_Extension=Mani
t(/\p{scx=Mani}/u, "\u{640}");
f(/\P{scx=Mani}/u, "\u{640}");
f(/(?=\P{sc=Mani})\p{scx=Mani}/u, "\u{4785e}");
f(/(?=\P{sc=Mani})\p{scx=Mani}/u, "\u{8a387}");
f(/(?=\P{sc=Mani})\p{scx=Mani}/u, "\u{10553f}");
f(/(?=\P{sc=Mani})\p{scx=Mani}/u, "\u{46537}");
f(/(?=\P{sc=Mani})\p{scx=Mani}/u, "\u{301ef}");
// Script_Extension=Phlp
t(/\p{scx=Phlp}/u, "\u{640}");
f(/\P{scx=Phlp}/u, "\u{640}");
f(/(?=\P{sc=Phlp})\p{scx=Phlp}/u, "\u{b669d}");
f(/(?=\P{sc=Phlp})\p{scx=Phlp}/u, "\u{e819a}");
f(/(?=\P{sc=Phlp})\p{scx=Phlp}/u, "\u{5a57a}");
f(/(?=\P{sc=Phlp})\p{scx=Phlp}/u, "\u{d6899}");
f(/(?=\P{sc=Phlp})\p{scx=Phlp}/u, "\u{3215f}");
// Script_Extension=Yiii
t(/\p{scx=Yiii}/u, "\u{3001}");
f(/\P{scx=Yiii}/u, "\u{3001}");
t(/\p{scx=Yiii}/u, "\u{3002}");
f(/\P{scx=Yiii}/u, "\u{3002}");
t(/\p{scx=Yiii}/u, "\u{3008}");
f(/\P{scx=Yiii}/u, "\u{3008}");
t(/\p{scx=Yiii}/u, "\u{3009}");
f(/\P{scx=Yiii}/u, "\u{3009}");
t(/\p{scx=Yiii}/u, "\u{300a}");
f(/\P{scx=Yiii}/u, "\u{300a}");
t(/\p{scx=Yiii}/u, "\u{300b}");
f(/\P{scx=Yiii}/u, "\u{300b}");
t(/\p{scx=Yiii}/u, "\u{300c}");
f(/\P{scx=Yiii}/u, "\u{300c}");
t(/\p{scx=Yiii}/u, "\u{300d}");
f(/\P{scx=Yiii}/u, "\u{300d}");
t(/\p{scx=Yiii}/u, "\u{300e}");
f(/\P{scx=Yiii}/u, "\u{300e}");
t(/\p{scx=Yiii}/u, "\u{300f}");
f(/\P{scx=Yiii}/u, "\u{300f}");
t(/\p{scx=Yiii}/u, "\u{3010}");
f(/\P{scx=Yiii}/u, "\u{3010}");
t(/\p{scx=Yiii}/u, "\u{3011}");
f(/\P{scx=Yiii}/u, "\u{3011}");
t(/\p{scx=Yiii}/u, "\u{3014}");
f(/\P{scx=Yiii}/u, "\u{3014}");
t(/\p{scx=Yiii}/u, "\u{3015}");
f(/\P{scx=Yiii}/u, "\u{3015}");
t(/\p{scx=Yiii}/u, "\u{3016}");
f(/\P{scx=Yiii}/u, "\u{3016}");
t(/\p{scx=Yiii}/u, "\u{3017}");
f(/\P{scx=Yiii}/u, "\u{3017}");
t(/\p{scx=Yiii}/u, "\u{3018}");
f(/\P{scx=Yiii}/u, "\u{3018}");
t(/\p{scx=Yiii}/u, "\u{3019}");
f(/\P{scx=Yiii}/u, "\u{3019}");
t(/\p{scx=Yiii}/u, "\u{301a}");
f(/\P{scx=Yiii}/u, "\u{301a}");
t(/\p{scx=Yiii}/u, "\u{301b}");
f(/\P{scx=Yiii}/u, "\u{301b}");
t(/\p{scx=Yiii}/u, "\u{30fb}");
f(/\P{scx=Yiii}/u, "\u{30fb}");
t(/\p{scx=Yiii}/u, "\u{ff61}");
f(/\P{scx=Yiii}/u, "\u{ff61}");
t(/\p{scx=Yiii}/u, "\u{ff62}");
f(/\P{scx=Yiii}/u, "\u{ff62}");
t(/\p{scx=Yiii}/u, "\u{ff63}");
f(/\P{scx=Yiii}/u, "\u{ff63}");
t(/\p{scx=Yiii}/u, "\u{ff64}");
f(/\P{scx=Yiii}/u, "\u{ff64}");
t(/\p{scx=Yiii}/u, "\u{ff65}");
f(/\P{scx=Yiii}/u, "\u{ff65}");
f(/(?=\P{sc=Yiii})\p{scx=Yiii}/u, "\u{2f309}");
f(/(?=\P{sc=Yiii})\p{scx=Yiii}/u, "\u{b5b22}");
f(/(?=\P{sc=Yiii})\p{scx=Yiii}/u, "\u{d51ae}");
f(/(?=\P{sc=Yiii})\p{scx=Yiii}/u, "\u{77b48}");
f(/(?=\P{sc=Yiii})\p{scx=Yiii}/u, "\u{12f5}");
// Script_Extension=Modi
t(/\p{scx=Modi}/u, "\u{a836}");
f(/\P{scx=Modi}/u, "\u{a836}");
t(/\p{scx=Modi}/u, "\u{a837}");
f(/\P{scx=Modi}/u, "\u{a837}");
t(/\p{scx=Modi}/u, "\u{a838}");
f(/\P{scx=Modi}/u, "\u{a838}");
t(/\p{scx=Modi}/u, "\u{a839}");
f(/\P{scx=Modi}/u, "\u{a839}");
t(/\p{scx=Modi}/u, "\u{a830}");
f(/\P{scx=Modi}/u, "\u{a830}");
t(/\p{scx=Modi}/u, "\u{a831}");
f(/\P{scx=Modi}/u, "\u{a831}");
t(/\p{scx=Modi}/u, "\u{a832}");
f(/\P{scx=Modi}/u, "\u{a832}");
t(/\p{scx=Modi}/u, "\u{a833}");
f(/\P{scx=Modi}/u, "\u{a833}");
t(/\p{scx=Modi}/u, "\u{a834}");
f(/\P{scx=Modi}/u, "\u{a834}");
t(/\p{scx=Modi}/u, "\u{a835}");
f(/\P{scx=Modi}/u, "\u{a835}");
f(/(?=\P{sc=Modi})\p{scx=Modi}/u, "\u{e64ef}");
f(/(?=\P{sc=Modi})\p{scx=Modi}/u, "\u{ff1a8}");
f(/(?=\P{sc=Modi})\p{scx=Modi}/u, "\u{103374}");
f(/(?=\P{sc=Modi})\p{scx=Modi}/u, "\u{721f6}");
f(/(?=\P{sc=Modi})\p{scx=Modi}/u, "\u{65c4f}");
// Script_Extension=Sind
t(/\p{scx=Sind}/u, "\u{a836}");
f(/\P{scx=Sind}/u, "\u{a836}");
t(/\p{scx=Sind}/u, "\u{a837}");
f(/\P{scx=Sind}/u, "\u{a837}");
t(/\p{scx=Sind}/u, "\u{a838}");
f(/\P{scx=Sind}/u, "\u{a838}");
t(/\p{scx=Sind}/u, "\u{a839}");
f(/\P{scx=Sind}/u, "\u{a839}");
t(/\p{scx=Sind}/u, "\u{a830}");
f(/\P{scx=Sind}/u, "\u{a830}");
t(/\p{scx=Sind}/u, "\u{a831}");
f(/\P{scx=Sind}/u, "\u{a831}");
t(/\p{scx=Sind}/u, "\u{a832}");
f(/\P{scx=Sind}/u, "\u{a832}");
t(/\p{scx=Sind}/u, "\u{a833}");
f(/\P{scx=Sind}/u, "\u{a833}");
t(/\p{scx=Sind}/u, "\u{a834}");
f(/\P{scx=Sind}/u, "\u{a834}");
t(/\p{scx=Sind}/u, "\u{a835}");
f(/\P{scx=Sind}/u, "\u{a835}");
t(/\p{scx=Sind}/u, "\u{964}");
f(/\P{scx=Sind}/u, "\u{964}");
t(/\p{scx=Sind}/u, "\u{965}");
f(/\P{scx=Sind}/u, "\u{965}");
f(/(?=\P{sc=Sind})\p{scx=Sind}/u, "\u{63856}");
f(/(?=\P{sc=Sind})\p{scx=Sind}/u, "\u{10fce1}");
f(/(?=\P{sc=Sind})\p{scx=Sind}/u, "\u{e9acf}");
f(/(?=\P{sc=Sind})\p{scx=Sind}/u, "\u{3127f}");
f(/(?=\P{sc=Sind})\p{scx=Sind}/u, "\u{c7ceb}");
// Script_Extension=Takr
t(/\p{scx=Takr}/u, "\u{a836}");
f(/\P{scx=Takr}/u, "\u{a836}");
t(/\p{scx=Takr}/u, "\u{a837}");
f(/\P{scx=Takr}/u, "\u{a837}");
t(/\p{scx=Takr}/u, "\u{a838}");
f(/\P{scx=Takr}/u, "\u{a838}");
t(/\p{scx=Takr}/u, "\u{a839}");
f(/\P{scx=Takr}/u, "\u{a839}");
t(/\p{scx=Takr}/u, "\u{a830}");
f(/\P{scx=Takr}/u, "\u{a830}");
t(/\p{scx=Takr}/u, "\u{a831}");
f(/\P{scx=Takr}/u, "\u{a831}");
t(/\p{scx=Takr}/u, "\u{a832}");
f(/\P{scx=Takr}/u, "\u{a832}");
t(/\p{scx=Takr}/u, "\u{a833}");
f(/\P{scx=Takr}/u, "\u{a833}");
t(/\p{scx=Takr}/u, "\u{a834}");
f(/\P{scx=Takr}/u, "\u{a834}");
t(/\p{scx=Takr}/u, "\u{a835}");
f(/\P{scx=Takr}/u, "\u{a835}");
t(/\p{scx=Takr}/u, "\u{964}");
f(/\P{scx=Takr}/u, "\u{964}");
t(/\p{scx=Takr}/u, "\u{965}");
f(/\P{scx=Takr}/u, "\u{965}");
f(/(?=\P{sc=Takr})\p{scx=Takr}/u, "\u{ec200}");
f(/(?=\P{sc=Takr})\p{scx=Takr}/u, "\u{10602d}");
f(/(?=\P{sc=Takr})\p{scx=Takr}/u, "\u{6143c}");
f(/(?=\P{sc=Takr})\p{scx=Takr}/u, "\u{cc552}");
f(/(?=\P{sc=Takr})\p{scx=Takr}/u, "\u{d1b37}");
// Script_Extension=Tirh
t(/\p{scx=Tirh}/u, "\u{a836}");
f(/\P{scx=Tirh}/u, "\u{a836}");
t(/\p{scx=Tirh}/u, "\u{a837}");
f(/\P{scx=Tirh}/u, "\u{a837}");
t(/\p{scx=Tirh}/u, "\u{a838}");
f(/\P{scx=Tirh}/u, "\u{a838}");
t(/\p{scx=Tirh}/u, "\u{a839}");
f(/\P{scx=Tirh}/u, "\u{a839}");
t(/\p{scx=Tirh}/u, "\u{a830}");
f(/\P{scx=Tirh}/u, "\u{a830}");
t(/\p{scx=Tirh}/u, "\u{a831}");
f(/\P{scx=Tirh}/u, "\u{a831}");
t(/\p{scx=Tirh}/u, "\u{a832}");
f(/\P{scx=Tirh}/u, "\u{a832}");
t(/\p{scx=Tirh}/u, "\u{a833}");
f(/\P{scx=Tirh}/u, "\u{a833}");
t(/\p{scx=Tirh}/u, "\u{a834}");
f(/\P{scx=Tirh}/u, "\u{a834}");
t(/\p{scx=Tirh}/u, "\u{a835}");
f(/\P{scx=Tirh}/u, "\u{a835}");
t(/\p{scx=Tirh}/u, "\u{964}");
f(/\P{scx=Tirh}/u, "\u{964}");
t(/\p{scx=Tirh}/u, "\u{965}");
f(/\P{scx=Tirh}/u, "\u{965}");
f(/(?=\P{sc=Tirh})\p{scx=Tirh}/u, "\u{d8409}");
f(/(?=\P{sc=Tirh})\p{scx=Tirh}/u, "\u{4406c}");
f(/(?=\P{sc=Tirh})\p{scx=Tirh}/u, "\u{aef3d}");
f(/(?=\P{sc=Tirh})\p{scx=Tirh}/u, "\u{46186}");
f(/(?=\P{sc=Tirh})\p{scx=Tirh}/u, "\u{b1229}");
// Script_Extension=Orya
t(/\p{scx=Orya}/u, "\u{952}");
f(/\P{scx=Orya}/u, "\u{952}");
t(/\p{scx=Orya}/u, "\u{951}");
f(/\P{scx=Orya}/u, "\u{951}");
t(/\p{scx=Orya}/u, "\u{964}");
f(/\P{scx=Orya}/u, "\u{964}");
t(/\p{scx=Orya}/u, "\u{965}");
f(/\P{scx=Orya}/u, "\u{965}");
f(/(?=\P{sc=Orya})\p{scx=Orya}/u, "\u{38982}");
f(/(?=\P{sc=Orya})\p{scx=Orya}/u, "\u{a6422}");
f(/(?=\P{sc=Orya})\p{scx=Orya}/u, "\u{b40c4}");
f(/(?=\P{sc=Orya})\p{scx=Orya}/u, "\u{50b36}");
f(/(?=\P{sc=Orya})\p{scx=Orya}/u, "\u{8033b}");
// Script_Extension=Sinh
t(/\p{scx=Sinh}/u, "\u{964}");
f(/\P{scx=Sinh}/u, "\u{964}");
t(/\p{scx=Sinh}/u, "\u{965}");
f(/\P{scx=Sinh}/u, "\u{965}");
f(/(?=\P{sc=Sinh})\p{scx=Sinh}/u, "\u{10a8c2}");
f(/(?=\P{sc=Sinh})\p{scx=Sinh}/u, "\u{109c02}");
f(/(?=\P{sc=Sinh})\p{scx=Sinh}/u, "\u{eb3fd}");
f(/(?=\P{sc=Sinh})\p{scx=Sinh}/u, "\u{a884}");
f(/(?=\P{sc=Sinh})\p{scx=Sinh}/u, "\u{89f0f}");
// Script_Extension=Limb
t(/\p{scx=Limb}/u, "\u{965}");
f(/\P{scx=Limb}/u, "\u{965}");
f(/(?=\P{sc=Limb})\p{scx=Limb}/u, "\u{9c91e}");
f(/(?=\P{sc=Limb})\p{scx=Limb}/u, "\u{e0433}");
f(/(?=\P{sc=Limb})\p{scx=Limb}/u, "\u{10d7c7}");
f(/(?=\P{sc=Limb})\p{scx=Limb}/u, "\u{f3980}");
f(/(?=\P{sc=Limb})\p{scx=Limb}/u, "\u{d5094}");
