// +build ignore

package main

import (
	"bytes"
	"io/ioutil"
	"log"
	"os"

	. "github.com/dave/jennifer/jen"
)

func main() {
	f := NewFile("version")

	f.Comment("This file was generated by release_generate.go; DO NOT EDIT.")
	f.Line()

	f.Comment("Values of builtAt and gitCommit will be set by the linker.")
	f.Var().Id("builtAt").Op("=").Lit("")
	f.Var().Id("gitCommit").Op("=").Lit("")

	gitTag := os.Getenv("RELEASE_GIT_TAG")
	f.Var().Id("gitTag").Op("=").Lit(gitTag)

	buf := &bytes.Buffer{}
	if _, err := buf.WriteString("// +build release\n\n"); err != nil {
		log.Fatal(err.Error())
	}
	if err := f.Render(buf); err != nil {
		log.Fatal(err.Error())
	}
	if err := ioutil.WriteFile("release.go", buf.Bytes(), 0644); err != nil {
		log.Fatal(err.Error())
	}
}
