// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: types/abci.proto

package types

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/pokt-network/pocket-core/codec/types"
	types1 "github.com/tendermint/tendermint/abci/types"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// TxResponse defines a structure containing relevant tx data and metadata. The
// tags are stringified and the log is JSON decoded.
type TxResponse struct {
	// The block height
	Height int64 `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	// The transaction hash.
	TxHash string `protobuf:"bytes,2,opt,name=txhash,proto3" json:"txhash,omitempty"`
	// Namespace for the Code
	Codespace string `protobuf:"bytes,3,opt,name=codespace,proto3" json:"codespace,omitempty"`
	// Response code.
	Code uint32 `protobuf:"varint,4,opt,name=code,proto3" json:"code,omitempty"`
	// Result bytes, if any.
	Data string `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
	// The output of the application's logger (raw string). May be non-deterministic.
	RawLog string `protobuf:"bytes,6,opt,name=raw_log,json=rawLog,proto3" json:"raw_log,omitempty"`
	// The output of the application's logger (typed). May be non-deterministic.
	Logs ABCIMessageLogs `protobuf:"bytes,7,rep,name=logs,proto3,castrepeated=ABCIMessageLogs" json:"logs"`
	// Additional information. May be non-deterministic.
	Info string `protobuf:"bytes,8,opt,name=info,proto3" json:"info,omitempty"`
	// Amount of gas requested for transaction.
	GasWanted int64 `protobuf:"varint,9,opt,name=gas_wanted,json=gasWanted,proto3" json:"gas_wanted,omitempty"`
	// Amount of gas consumed by transaction.
	GasUsed int64 `protobuf:"varint,10,opt,name=gas_used,json=gasUsed,proto3" json:"gas_used,omitempty"`
	// The request transaction bytes.
	Tx *types.Any `protobuf:"bytes,11,opt,name=tx,proto3" json:"tx,omitempty"`
	// Time of the previous block. For heights > 1, it's the weighted median of the
	// timestamps of the valid votes in the block.LastCommit. For height == 1, it's genesis time.
	Timestamp string `protobuf:"bytes,12,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (m *TxResponse) Reset()      { *m = TxResponse{} }
func (*TxResponse) ProtoMessage() {}
func (*TxResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_92d21ac2472171c0, []int{0}
}
func (m *TxResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TxResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TxResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TxResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TxResponse.Merge(m, src)
}
func (m *TxResponse) XXX_Size() int {
	return m.Size()
}
func (m *TxResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TxResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TxResponse proto.InternalMessageInfo

// ABCIMessageLog defines a structure containing an indexed tx ABCI message log.
type ABCIMessageLog struct {
	MsgIndex uint32 `protobuf:"varint,1,opt,name=msg_index,json=msgIndex,proto3" json:"msg_index,omitempty"`
	Success  bool   `protobuf:"varint,2,opt,name=success,proto3" json:"success,omitempty"`
	Log      string `protobuf:"bytes,3,opt,name=log,proto3" json:"log,omitempty"`
	// Events contains a slice of Event objects that were emitted during some
	// execution.
	Events StringEvents `protobuf:"bytes,4,rep,name=events,proto3,castrepeated=StringEvents" json:"events"`
}

func (m *ABCIMessageLog) Reset()      { *m = ABCIMessageLog{} }
func (*ABCIMessageLog) ProtoMessage() {}
func (*ABCIMessageLog) Descriptor() ([]byte, []int) {
	return fileDescriptor_92d21ac2472171c0, []int{1}
}
func (m *ABCIMessageLog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ABCIMessageLog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ABCIMessageLog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ABCIMessageLog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ABCIMessageLog.Merge(m, src)
}
func (m *ABCIMessageLog) XXX_Size() int {
	return m.Size()
}
func (m *ABCIMessageLog) XXX_DiscardUnknown() {
	xxx_messageInfo_ABCIMessageLog.DiscardUnknown(m)
}

var xxx_messageInfo_ABCIMessageLog proto.InternalMessageInfo

func (m *ABCIMessageLog) GetMsgIndex() uint32 {
	if m != nil {
		return m.MsgIndex
	}
	return 0
}

func (m *ABCIMessageLog) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *ABCIMessageLog) GetLog() string {
	if m != nil {
		return m.Log
	}
	return ""
}

func (m *ABCIMessageLog) GetEvents() StringEvents {
	if m != nil {
		return m.Events
	}
	return nil
}

// StringEvent defines en Event object wrapper where all the attributes
// contain key/value pairs that are strings instead of raw bytes.
type StringEvent struct {
	Type       string      `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Attributes []Attribute `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes"`
}

func (m *StringEvent) Reset()      { *m = StringEvent{} }
func (*StringEvent) ProtoMessage() {}
func (*StringEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_92d21ac2472171c0, []int{2}
}
func (m *StringEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StringEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StringEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StringEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringEvent.Merge(m, src)
}
func (m *StringEvent) XXX_Size() int {
	return m.Size()
}
func (m *StringEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_StringEvent.DiscardUnknown(m)
}

var xxx_messageInfo_StringEvent proto.InternalMessageInfo

func (m *StringEvent) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *StringEvent) GetAttributes() []Attribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// Attribute defines an attribute wrapper where the key and value are
// strings instead of raw bytes.
type Attribute struct {
	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Attribute) Reset()      { *m = Attribute{} }
func (*Attribute) ProtoMessage() {}
func (*Attribute) Descriptor() ([]byte, []int) {
	return fileDescriptor_92d21ac2472171c0, []int{3}
}
func (m *Attribute) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Attribute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Attribute.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Attribute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Attribute.Merge(m, src)
}
func (m *Attribute) XXX_Size() int {
	return m.Size()
}
func (m *Attribute) XXX_DiscardUnknown() {
	xxx_messageInfo_Attribute.DiscardUnknown(m)
}

var xxx_messageInfo_Attribute proto.InternalMessageInfo

func (m *Attribute) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Attribute) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// GasInfo defines tx execution gas context.
type GasInfo struct {
	// GasWanted is the maximum units of work we allow this tx to perform.
	GasWanted uint64 `protobuf:"varint,1,opt,name=gas_wanted,json=gasWanted,proto3" json:"gas_wanted,omitempty" yaml:"gas_wanted"`
	// GasUsed is the amount of gas actually consumed.
	GasUsed uint64 `protobuf:"varint,2,opt,name=gas_used,json=gasUsed,proto3" json:"gas_used,omitempty" yaml:"gas_used"`
}

func (m *GasInfo) Reset()      { *m = GasInfo{} }
func (*GasInfo) ProtoMessage() {}
func (*GasInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_92d21ac2472171c0, []int{4}
}
func (m *GasInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GasInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GasInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GasInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GasInfo.Merge(m, src)
}
func (m *GasInfo) XXX_Size() int {
	return m.Size()
}
func (m *GasInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GasInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GasInfo proto.InternalMessageInfo

func (m *GasInfo) GetGasWanted() uint64 {
	if m != nil {
		return m.GasWanted
	}
	return 0
}

func (m *GasInfo) GetGasUsed() uint64 {
	if m != nil {
		return m.GasUsed
	}
	return 0
}

// Result is the union of ResponseFormat and ResponseCheckTx.
type Result struct {
	Code      CodeType      `protobuf:"varint,1,opt,name=code,proto3,casttype=CodeType" json:"code,omitempty"`
	Codespace CodespaceType `protobuf:"bytes,2,opt,name=codespace,proto3,casttype=CodespaceType" json:"codespace,omitempty"`
	// Data is any data returned from message or handler execution. It MUST be length
	// prefixed in order to separate data from multiple message executions.
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// Log contains the log information from message or handler execution.
	Log       string `protobuf:"bytes,4,opt,name=log,proto3" json:"log,omitempty"`
	GasWanted uint64 `protobuf:"varint,5,opt,name=gasWanted,proto3" json:"gasWanted,omitempty"`
	GasUsed   uint64 `protobuf:"varint,6,opt,name=gasUsed,proto3" json:"gasUsed,omitempty"`
	// Events contains a slice of Event objects that were emitted during message or
	// handler execution.
	Events Events `protobuf:"bytes,7,rep,name=events,proto3,castrepeated=Events" json:"events"`
}

func (m *Result) Reset()      { *m = Result{} }
func (*Result) ProtoMessage() {}
func (*Result) Descriptor() ([]byte, []int) {
	return fileDescriptor_92d21ac2472171c0, []int{5}
}
func (m *Result) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Result) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Result.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Result) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Result.Merge(m, src)
}
func (m *Result) XXX_Size() int {
	return m.Size()
}
func (m *Result) XXX_DiscardUnknown() {
	xxx_messageInfo_Result.DiscardUnknown(m)
}

var xxx_messageInfo_Result proto.InternalMessageInfo

// SimulationResponse defines the response generated when a transaction is
// successfully simulated.
type SimulationResponse struct {
	GasInfo `protobuf:"bytes,1,opt,name=gas_info,json=gasInfo,proto3,embedded=gas_info" json:"gas_info"`
	Result  *Result `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
}

func (m *SimulationResponse) Reset()      { *m = SimulationResponse{} }
func (*SimulationResponse) ProtoMessage() {}
func (*SimulationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_92d21ac2472171c0, []int{6}
}
func (m *SimulationResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SimulationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SimulationResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SimulationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimulationResponse.Merge(m, src)
}
func (m *SimulationResponse) XXX_Size() int {
	return m.Size()
}
func (m *SimulationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SimulationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SimulationResponse proto.InternalMessageInfo

func (m *SimulationResponse) GetResult() *Result {
	if m != nil {
		return m.Result
	}
	return nil
}

// MsgData defines the data returned in a Result object during message execution.
type MsgData struct {
	MsgType string `protobuf:"bytes,1,opt,name=msg_type,json=msgType,proto3" json:"msg_type,omitempty"`
	Data    []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *MsgData) Reset()      { *m = MsgData{} }
func (*MsgData) ProtoMessage() {}
func (*MsgData) Descriptor() ([]byte, []int) {
	return fileDescriptor_92d21ac2472171c0, []int{7}
}
func (m *MsgData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MsgData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MsgData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MsgData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MsgData.Merge(m, src)
}
func (m *MsgData) XXX_Size() int {
	return m.Size()
}
func (m *MsgData) XXX_DiscardUnknown() {
	xxx_messageInfo_MsgData.DiscardUnknown(m)
}

var xxx_messageInfo_MsgData proto.InternalMessageInfo

func (m *MsgData) GetMsgType() string {
	if m != nil {
		return m.MsgType
	}
	return ""
}

func (m *MsgData) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// TxMsgData defines a list of MsgData. A transaction will have a MsgData object for
// each message.
type TxMsgData struct {
	Data []*MsgData `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
}

func (m *TxMsgData) Reset()      { *m = TxMsgData{} }
func (*TxMsgData) ProtoMessage() {}
func (*TxMsgData) Descriptor() ([]byte, []int) {
	return fileDescriptor_92d21ac2472171c0, []int{8}
}
func (m *TxMsgData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TxMsgData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TxMsgData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TxMsgData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TxMsgData.Merge(m, src)
}
func (m *TxMsgData) XXX_Size() int {
	return m.Size()
}
func (m *TxMsgData) XXX_DiscardUnknown() {
	xxx_messageInfo_TxMsgData.DiscardUnknown(m)
}

var xxx_messageInfo_TxMsgData proto.InternalMessageInfo

func (m *TxMsgData) GetData() []*MsgData {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterType((*TxResponse)(nil), "types.TxResponse")
	proto.RegisterType((*ABCIMessageLog)(nil), "types.ABCIMessageLog")
	proto.RegisterType((*StringEvent)(nil), "types.StringEvent")
	proto.RegisterType((*Attribute)(nil), "types.Attribute")
	proto.RegisterType((*GasInfo)(nil), "types.GasInfo")
	proto.RegisterType((*Result)(nil), "types.Result")
	proto.RegisterType((*SimulationResponse)(nil), "types.SimulationResponse")
	proto.RegisterType((*MsgData)(nil), "types.MsgData")
	proto.RegisterType((*TxMsgData)(nil), "types.TxMsgData")
}

func init() { proto.RegisterFile("types/abci.proto", fileDescriptor_92d21ac2472171c0) }

var fileDescriptor_92d21ac2472171c0 = []byte{
	// 855 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x5c, 0x54, 0x41, 0x6f, 0x1b, 0x45,
	0x14, 0xf6, 0xda, 0x9b, 0xb5, 0xfd, 0x9c, 0xa4, 0xe9, 0x90, 0xd2, 0x4d, 0x09, 0xb6, 0x59, 0x81,
	0x64, 0x0e, 0x5d, 0x4b, 0x09, 0x70, 0xc8, 0x01, 0xd1, 0x4d, 0x51, 0x89, 0xd4, 0x5e, 0xb6, 0x41,
	0x48, 0x5c, 0xac, 0xb1, 0x3d, 0x1d, 0xaf, 0xe2, 0xdd, 0xb1, 0x76, 0x66, 0x13, 0xfb, 0x86, 0xc4,
	0x05, 0x6e, 0xfc, 0x04, 0xb8, 0xf2, 0x4b, 0x7a, 0xcc, 0xb1, 0x07, 0x64, 0x20, 0xf9, 0x07, 0x3d,
	0xe6, 0x84, 0xe6, 0xcd, 0xd8, 0xde, 0x70, 0x59, 0xbd, 0xf7, 0xbe, 0xf7, 0x76, 0xde, 0x7c, 0xdf,
	0x7b, 0x03, 0x7b, 0x6a, 0x31, 0x63, 0xb2, 0x4f, 0x87, 0xa3, 0x24, 0x9c, 0xe5, 0x42, 0x09, 0xb2,
	0x85, 0x91, 0x27, 0x9f, 0x28, 0x96, 0x8d, 0x59, 0x9e, 0x26, 0x99, 0x42, 0xb4, 0x6f, 0x12, 0xf1,
	0x6b, 0x32, 0x9f, 0xec, 0x73, 0xc1, 0x05, 0x9a, 0x7d, 0x6d, 0xd9, 0xe8, 0x01, 0x17, 0x82, 0x4f,
	0x59, 0x1f, 0xbd, 0x61, 0xf1, 0xa6, 0x4f, 0xb3, 0x85, 0x81, 0x82, 0x9f, 0x6b, 0x00, 0xe7, 0xf3,
	0x98, 0xc9, 0x99, 0xc8, 0x24, 0x23, 0x1f, 0x82, 0x37, 0x61, 0x09, 0x9f, 0x28, 0xdf, 0xe9, 0x3a,
	0xbd, 0x5a, 0x6c, 0x3d, 0x12, 0x80, 0xa7, 0xe6, 0x13, 0x2a, 0x27, 0x7e, 0xb5, 0xeb, 0xf4, 0x9a,
	0x11, 0xdc, 0x2c, 0x3b, 0xde, 0xf9, 0xfc, 0x3b, 0x2a, 0x27, 0xb1, 0x45, 0xc8, 0x21, 0x34, 0x47,
	0x62, 0xcc, 0xe4, 0x8c, 0x8e, 0x98, 0x5f, 0xd3, 0x69, 0xf1, 0x26, 0x40, 0x08, 0xb8, 0xda, 0xf1,
	0xdd, 0xae, 0xd3, 0xdb, 0x89, 0xd1, 0xd6, 0xb1, 0x31, 0x55, 0xd4, 0xdf, 0xc2, 0x64, 0xb4, 0xc9,
	0x63, 0xa8, 0xe7, 0xf4, 0x6a, 0x30, 0x15, 0xdc, 0xf7, 0x30, 0xec, 0xe5, 0xf4, 0xea, 0xa5, 0xe0,
	0x24, 0x02, 0x77, 0x2a, 0xb8, 0xf4, 0xeb, 0xdd, 0x5a, 0xaf, 0x75, 0xf4, 0x28, 0x34, 0xd7, 0x7e,
	0x16, 0x9d, 0x9e, 0xbd, 0x62, 0x52, 0x52, 0xce, 0x5e, 0x0a, 0x1e, 0x3d, 0x7e, 0xbb, 0xec, 0x54,
	0xfe, 0xfc, 0xbb, 0xf3, 0xe0, 0x7e, 0x5c, 0xc6, 0x58, 0xab, 0x0f, 0x4c, 0xb2, 0x37, 0xc2, 0x6f,
	0x98, 0x03, 0xb5, 0x4d, 0x3e, 0x06, 0xe0, 0x54, 0x0e, 0xae, 0x68, 0xa6, 0xd8, 0xd8, 0x6f, 0xe2,
	0xb5, 0x9b, 0x9c, 0xca, 0x1f, 0x30, 0x40, 0x0e, 0xa0, 0xa1, 0xe1, 0x42, 0xb2, 0xb1, 0x0f, 0x08,
	0xd6, 0x39, 0x95, 0xdf, 0x4b, 0x36, 0x26, 0x9f, 0x42, 0x55, 0xcd, 0xfd, 0x56, 0xd7, 0xe9, 0xb5,
	0x8e, 0xf6, 0x43, 0xc3, 0x71, 0xb8, 0xe2, 0x38, 0x7c, 0x96, 0x2d, 0xe2, 0xaa, 0x9a, 0x6b, 0x5a,
	0x54, 0x92, 0x32, 0xa9, 0x68, 0x3a, 0xf3, 0xb7, 0x0d, 0x2d, 0xeb, 0xc0, 0x89, 0xfb, 0xcb, 0xef,
	0x9d, 0x4a, 0xf0, 0x87, 0x03, 0xbb, 0xf7, 0x3b, 0x26, 0x1f, 0x41, 0x33, 0x95, 0x7c, 0x90, 0x64,
	0x63, 0x36, 0x47, 0x31, 0x76, 0xe2, 0x46, 0x2a, 0xf9, 0x99, 0xf6, 0x89, 0x0f, 0x75, 0x59, 0x8c,
	0x46, 0x4c, 0x4a, 0xd4, 0xa3, 0x11, 0xaf, 0x5c, 0xb2, 0x07, 0x35, 0x4d, 0x9d, 0xa1, 0x5f, 0x9b,
	0xe4, 0x1b, 0xf0, 0xd8, 0x25, 0xcb, 0x94, 0xf4, 0x5d, 0x64, 0x8e, 0x58, 0xe6, 0x5e, 0xab, 0x3c,
	0xc9, 0xf8, 0xb7, 0x1a, 0x8a, 0xf6, 0x2d, 0x6d, 0xdb, 0xa5, 0xa0, 0x8c, 0x6d, 0xdd, 0x89, 0xfb,
	0xd3, 0x5f, 0x5d, 0x27, 0x18, 0x40, 0xab, 0x84, 0x6a, 0x2a, 0xf5, 0x7f, 0xb0, 0xb5, 0x66, 0x8c,
	0x36, 0xf9, 0x0a, 0x80, 0x2a, 0x95, 0x27, 0xc3, 0x42, 0x31, 0xdd, 0x99, 0x3e, 0x6e, 0x6f, 0x25,
	0xd4, 0x0a, 0x88, 0x5c, 0x7d, 0x58, 0x5c, 0xca, 0xb4, 0x07, 0x1c, 0x43, 0x73, 0x9d, 0xa4, 0xef,
	0x71, 0xc1, 0x16, 0xf6, 0xef, 0xda, 0x24, 0xfb, 0xb0, 0x75, 0x49, 0xa7, 0x05, 0x33, 0x13, 0x18,
	0x1b, 0x27, 0x28, 0xa0, 0xfe, 0x82, 0xca, 0x33, 0x2d, 0xe4, 0x17, 0xf7, 0x84, 0xd4, 0x95, 0x6e,
	0xf4, 0xe8, 0xfd, 0xb2, 0xf3, 0x70, 0x41, 0xd3, 0xe9, 0x49, 0xb0, 0xc1, 0x82, 0xb2, 0xbe, 0x61,
	0x49, 0xdf, 0x2a, 0xd6, 0x7c, 0xf0, 0x7e, 0xd9, 0x79, 0xb0, 0xa9, 0xd1, 0x48, 0xb0, 0x16, 0xdd,
	0xf6, 0xfa, 0x6b, 0x15, 0xbc, 0x98, 0xc9, 0x62, 0xaa, 0x48, 0xd7, 0x0e, 0x36, 0x6a, 0x14, 0x6d,
	0xdf, 0x2d, 0x3b, 0x8d, 0x53, 0x31, 0x66, 0xe7, 0x8b, 0x19, 0xb3, 0x63, 0xde, 0x2f, 0x2f, 0x86,
	0xd9, 0x9f, 0x87, 0x77, 0xcb, 0xce, 0xce, 0xe9, 0x2a, 0x88, 0xb9, 0xf7, 0x77, 0x05, 0xf7, 0x42,
	0xab, 0xb8, 0x6d, 0xf7, 0xc2, 0x0a, 0xeb, 0x6e, 0x84, 0x3d, 0x84, 0xcd, 0x35, 0x70, 0x85, 0xdc,
	0xf2, 0xbd, 0x7c, 0x58, 0xb5, 0x8c, 0x7b, 0xe4, 0x6e, 0xc6, 0xf6, 0xf9, 0x7a, 0x20, 0xcc, 0x2a,
	0x1d, 0x86, 0x9b, 0x77, 0x25, 0xc4, 0x57, 0xc7, 0x28, 0x66, 0x46, 0x63, 0xd7, 0x8e, 0x86, 0xf7,
	0xbf, 0xa1, 0x68, 0xe8, 0xc1, 0x45, 0x2e, 0x2e, 0x81, 0xbc, 0x4e, 0xd2, 0x62, 0x4a, 0x55, 0x22,
	0xb2, 0xf5, 0x4b, 0x72, 0x6c, 0x78, 0xc5, 0x75, 0x73, 0x70, 0x45, 0x76, 0xed, 0x7f, 0xad, 0x5e,
	0x51, 0x43, 0xff, 0xf9, 0x7a, 0xd9, 0x71, 0xb0, 0x35, 0x94, 0xf0, 0x33, 0xf0, 0x72, 0x64, 0x15,
	0x69, 0x6a, 0x1d, 0xed, 0xd8, 0x12, 0x43, 0x75, 0x6c, 0x41, 0xab, 0xc1, 0xd7, 0x50, 0x7f, 0x25,
	0xf9, 0x73, 0x4d, 0xce, 0x01, 0xe8, 0xdd, 0x18, 0x94, 0x06, 0xb2, 0x9e, 0x4a, 0xae, 0x69, 0x5d,
	0x73, 0x59, 0xdd, 0x70, 0x69, 0xeb, 0xbf, 0x84, 0xe6, 0xf9, 0x7c, 0xf5, 0x87, 0xc0, 0xa6, 0x39,
	0x48, 0xc9, 0xaa, 0x55, 0x8b, 0x96, 0xcb, 0xa2, 0x17, 0xef, 0xfe, 0x6d, 0x57, 0xde, 0xde, 0xb4,
	0x9d, 0xeb, 0x9b, 0xb6, 0xf3, 0xcf, 0x4d, 0xdb, 0xf9, 0xed, 0xb6, 0x5d, 0xb9, 0xbe, 0x6d, 0x57,
	0xde, 0xdd, 0xb6, 0x2b, 0x3f, 0x7e, 0xce, 0x13, 0x35, 0x29, 0x86, 0xe1, 0x48, 0xa4, 0xfd, 0x99,
	0xb8, 0x50, 0x4f, 0x33, 0xa6, 0xae, 0x44, 0x7e, 0xd1, 0x9f, 0x89, 0xd1, 0x05, 0x53, 0x4f, 0x47,
	0x22, 0x67, 0xe6, 0xc5, 0x1e, 0x7a, 0xf8, 0x54, 0x1c, 0xff, 0x17, 0x00, 0x00, 0xff, 0xff, 0x1a,
	0x0a, 0x4d, 0x7f, 0xf0, 0x05, 0x00, 0x00,
}

func (m *TxResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TxResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Timestamp) > 0 {
		i -= len(m.Timestamp)
		copy(dAtA[i:], m.Timestamp)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Timestamp)))
		i--
		dAtA[i] = 0x62
	}
	if m.Tx != nil {
		{
			size, err := m.Tx.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAbci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.GasUsed != 0 {
		i = encodeVarintAbci(dAtA, i, uint64(m.GasUsed))
		i--
		dAtA[i] = 0x50
	}
	if m.GasWanted != 0 {
		i = encodeVarintAbci(dAtA, i, uint64(m.GasWanted))
		i--
		dAtA[i] = 0x48
	}
	if len(m.Info) > 0 {
		i -= len(m.Info)
		copy(dAtA[i:], m.Info)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Info)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.Logs) > 0 {
		for iNdEx := len(m.Logs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Logs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAbci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.RawLog) > 0 {
		i -= len(m.RawLog)
		copy(dAtA[i:], m.RawLog)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.RawLog)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Code != 0 {
		i = encodeVarintAbci(dAtA, i, uint64(m.Code))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Codespace) > 0 {
		i -= len(m.Codespace)
		copy(dAtA[i:], m.Codespace)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Codespace)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.TxHash) > 0 {
		i -= len(m.TxHash)
		copy(dAtA[i:], m.TxHash)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.TxHash)))
		i--
		dAtA[i] = 0x12
	}
	if m.Height != 0 {
		i = encodeVarintAbci(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ABCIMessageLog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ABCIMessageLog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ABCIMessageLog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Events) > 0 {
		for iNdEx := len(m.Events) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Events[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAbci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Log) > 0 {
		i -= len(m.Log)
		copy(dAtA[i:], m.Log)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Log)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Success {
		i--
		if m.Success {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.MsgIndex != 0 {
		i = encodeVarintAbci(dAtA, i, uint64(m.MsgIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *StringEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAbci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Attribute) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Attribute) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Attribute) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GasInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GasInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GasInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.GasUsed != 0 {
		i = encodeVarintAbci(dAtA, i, uint64(m.GasUsed))
		i--
		dAtA[i] = 0x10
	}
	if m.GasWanted != 0 {
		i = encodeVarintAbci(dAtA, i, uint64(m.GasWanted))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Result) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Result) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Result) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Events) > 0 {
		for iNdEx := len(m.Events) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Events[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAbci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.GasUsed != 0 {
		i = encodeVarintAbci(dAtA, i, uint64(m.GasUsed))
		i--
		dAtA[i] = 0x30
	}
	if m.GasWanted != 0 {
		i = encodeVarintAbci(dAtA, i, uint64(m.GasWanted))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Log) > 0 {
		i -= len(m.Log)
		copy(dAtA[i:], m.Log)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Log)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Codespace) > 0 {
		i -= len(m.Codespace)
		copy(dAtA[i:], m.Codespace)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Codespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.Code != 0 {
		i = encodeVarintAbci(dAtA, i, uint64(m.Code))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SimulationResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SimulationResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SimulationResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size, err := m.Result.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAbci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	{
		size, err := m.GasInfo.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintAbci(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *MsgData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MsgData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MsgData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.MsgType) > 0 {
		i -= len(m.MsgType)
		copy(dAtA[i:], m.MsgType)
		i = encodeVarintAbci(dAtA, i, uint64(len(m.MsgType)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TxMsgData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxMsgData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TxMsgData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		for iNdEx := len(m.Data) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Data[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAbci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintAbci(dAtA []byte, offset int, v uint64) int {
	offset -= sovAbci(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *TxResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovAbci(uint64(m.Height))
	}
	l = len(m.TxHash)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	l = len(m.Codespace)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	if m.Code != 0 {
		n += 1 + sovAbci(uint64(m.Code))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	l = len(m.RawLog)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	if len(m.Logs) > 0 {
		for _, e := range m.Logs {
			l = e.Size()
			n += 1 + l + sovAbci(uint64(l))
		}
	}
	l = len(m.Info)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	if m.GasWanted != 0 {
		n += 1 + sovAbci(uint64(m.GasWanted))
	}
	if m.GasUsed != 0 {
		n += 1 + sovAbci(uint64(m.GasUsed))
	}
	if m.Tx != nil {
		l = m.Tx.Size()
		n += 1 + l + sovAbci(uint64(l))
	}
	l = len(m.Timestamp)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	return n
}

func (m *ABCIMessageLog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MsgIndex != 0 {
		n += 1 + sovAbci(uint64(m.MsgIndex))
	}
	if m.Success {
		n += 2
	}
	l = len(m.Log)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovAbci(uint64(l))
		}
	}
	return n
}

func (m *StringEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovAbci(uint64(l))
		}
	}
	return n
}

func (m *Attribute) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	return n
}

func (m *GasInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.GasWanted != 0 {
		n += 1 + sovAbci(uint64(m.GasWanted))
	}
	if m.GasUsed != 0 {
		n += 1 + sovAbci(uint64(m.GasUsed))
	}
	return n
}

func (m *Result) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovAbci(uint64(m.Code))
	}
	l = len(m.Codespace)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	l = len(m.Log)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	if m.GasWanted != 0 {
		n += 1 + sovAbci(uint64(m.GasWanted))
	}
	if m.GasUsed != 0 {
		n += 1 + sovAbci(uint64(m.GasUsed))
	}
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovAbci(uint64(l))
		}
	}
	return n
}

func (m *SimulationResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.GasInfo.Size()
	n += 1 + l + sovAbci(uint64(l))
	if m.Result != nil {
		l = m.Result.Size()
		n += 1 + l + sovAbci(uint64(l))
	}
	return n
}

func (m *MsgData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MsgType)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovAbci(uint64(l))
	}
	return n
}

func (m *TxMsgData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Data) > 0 {
		for _, e := range m.Data {
			l = e.Size()
			n += 1 + l + sovAbci(uint64(l))
		}
	}
	return n
}

func sovAbci(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAbci(x uint64) (n int) {
	return sovAbci(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ABCIMessageLog) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForEvents := "[]StringEvent{"
	for _, f := range this.Events {
		repeatedStringForEvents += strings.Replace(strings.Replace(f.String(), "StringEvent", "StringEvent", 1), `&`, ``, 1) + ","
	}
	repeatedStringForEvents += "}"
	s := strings.Join([]string{`&ABCIMessageLog{`,
		`MsgIndex:` + fmt.Sprintf("%v", this.MsgIndex) + `,`,
		`Success:` + fmt.Sprintf("%v", this.Success) + `,`,
		`Log:` + fmt.Sprintf("%v", this.Log) + `,`,
		`Events:` + repeatedStringForEvents + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringEvent) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAttributes := "[]Attribute{"
	for _, f := range this.Attributes {
		repeatedStringForAttributes += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForAttributes += "}"
	s := strings.Join([]string{`&StringEvent{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Attributes:` + repeatedStringForAttributes + `,`,
		`}`,
	}, "")
	return s
}
func (this *GasInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GasInfo{`,
		`GasWanted:` + fmt.Sprintf("%v", this.GasWanted) + `,`,
		`GasUsed:` + fmt.Sprintf("%v", this.GasUsed) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Result) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForEvents := "[]Event{"
	for _, f := range this.Events {
		repeatedStringForEvents += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForEvents += "}"
	s := strings.Join([]string{`&Result{`,
		`Code:` + fmt.Sprintf("%v", this.Code) + `,`,
		`Codespace:` + fmt.Sprintf("%v", this.Codespace) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`Log:` + fmt.Sprintf("%v", this.Log) + `,`,
		`GasWanted:` + fmt.Sprintf("%v", this.GasWanted) + `,`,
		`GasUsed:` + fmt.Sprintf("%v", this.GasUsed) + `,`,
		`Events:` + repeatedStringForEvents + `,`,
		`}`,
	}, "")
	return s
}
func (this *SimulationResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SimulationResponse{`,
		`GasInfo:` + strings.Replace(strings.Replace(this.GasInfo.String(), "GasInfo", "GasInfo", 1), `&`, ``, 1) + `,`,
		`Result:` + strings.Replace(this.Result.String(), "Result", "Result", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MsgData) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MsgData{`,
		`MsgType:` + fmt.Sprintf("%v", this.MsgType) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TxMsgData) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForData := "[]*MsgData{"
	for _, f := range this.Data {
		repeatedStringForData += strings.Replace(f.String(), "MsgData", "MsgData", 1) + ","
	}
	repeatedStringForData += "}"
	s := strings.Join([]string{`&TxMsgData{`,
		`Data:` + repeatedStringForData + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringAbci(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *TxResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAbci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxHash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TxHash = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Codespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Codespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawLog", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawLog = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Logs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Logs = append(m.Logs, ABCIMessageLog{})
			if err := m.Logs[len(m.Logs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Info = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasWanted", wireType)
			}
			m.GasWanted = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GasWanted |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasUsed", wireType)
			}
			m.GasUsed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GasUsed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tx", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tx == nil {
				m.Tx = &types.Any{}
			}
			if err := m.Tx.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Timestamp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAbci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ABCIMessageLog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAbci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ABCIMessageLog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ABCIMessageLog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgIndex", wireType)
			}
			m.MsgIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MsgIndex |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Success", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Success = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Log", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Log = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, StringEvent{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAbci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAbci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, Attribute{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAbci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Attribute) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAbci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Attribute: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Attribute: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAbci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GasInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAbci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GasInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GasInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasWanted", wireType)
			}
			m.GasWanted = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GasWanted |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasUsed", wireType)
			}
			m.GasUsed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GasUsed |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAbci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Result) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAbci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Result: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Result: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= CodeType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Codespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Codespace = CodespaceType(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Log", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Log = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasWanted", wireType)
			}
			m.GasWanted = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GasWanted |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasUsed", wireType)
			}
			m.GasUsed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GasUsed |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, types1.Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAbci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SimulationResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAbci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SimulationResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SimulationResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.GasInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Result == nil {
				m.Result = &Result{}
			}
			if err := m.Result.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAbci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MsgData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAbci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MsgData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MsgData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MsgType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAbci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxMsgData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAbci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxMsgData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxMsgData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAbci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAbci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data, &MsgData{})
			if err := m.Data[len(m.Data)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAbci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAbci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAbci(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAbci
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAbci
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAbci
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupAbci
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthAbci
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthAbci        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAbci          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupAbci = fmt.Errorf("proto: unexpected end of group")
)
