# coding: utf-8
#
# Copyright 2014 The Oppia Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Provides a seam for transaction services."""

__author__ = 'Sean Lip'


from google.appengine.ext import ndb


def run_in_transaction(fn, *args, **kwargs):
    """Run a function in a transaction."""
    return ndb.transaction(
        lambda: fn(*args, **kwargs),
        xg=True,
        propagation=ndb.TransactionOptions.ALLOWED,
    )


# The NDB toplevel() function. For more details, see
#   https://developers.google.com/appengine/docs/python/ndb/async#intro
toplevel_wrapper = ndb.toplevel
