# coding: utf-8
#
# Copyright 2014 The Oppia Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, softwar
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Rules for CodeEvaluation objects."""

__author__ = 'Koji Ashida'

from extensions.rules import base


class OutputEquals(base.CodeEvaluationRule):
    description = (
        'has output equal to {{x|UnicodeString}} (collapsing spaces)')
    is_generic = False

    def _evaluate(self, subject):
        normalized_result = ' '.join(subject['output'].split())
        normalized_expected_output = ' '.join(self.x.split())
        return normalized_result == normalized_expected_output


class ResultsInError(base.CodeEvaluationRule):
    description = 'results in an error when run'
    is_generic = False

    def _evaluate(self, subject):
        error = subject['error'].strip()
        return bool(error)
