T-MATS
==========

Toolbox for the Modeling and Analysis of Thermodynamic Systems <br>
<meta name="keywords" content="T-MATS, TMATS, Control System, Numerical Methods, Newton-Raphson, Jacobian Calculation, Propulsion, Aircraft Engine, Jet, Turbofan, Turbojet, Compressor, Turbine, Nozzle, Inlet, open source, simulation, modeling, NASA, thermodynamics, turbomachinery, MATLAB, Simulink, jet, engine,  etc.">
<meta name="google-site-verification" content="nqMigEmX-6lqKvj4sewxDamtZEXHEvE1VfzjVRZoJ40" />
<b> <a href= "https://github.com/nasa/T-MATS/releases" >Click Here</a> for stable release download</b> <br>
For questions, comments, and general support see the <b> <a href= "https://groups.google.com/forum/#!forum/t-mats-user-group" >T-MATS user's forum</a></b>. <br>
Please take a moment and fill out our <b> <a href= "https://docs.google.com/forms/d/1cjcCyOKZpV49-gsdGGaKHUsZ2c2fKX5mwkKrntt60Eo/viewform?usp=send_form" >Survey</a></b>, user interest and feedback allows us to continue working on this package.<br><br>

<b>Introduction</b> <br>
The Toolbox for the Modeling and Analysis of Thermodynamic Systems (T-MATS) 
is a Simulink toolbox intended for use in the modeling and simulation of thermodynamic 
systems and their controls. T-MATS contains generic thermodynamic and controls 
components that may be combined with a variable input iterative solver and optimization 
algorithm to create complex systems to meet the needs of a developer. Development of this tool
was initiated on behalf of the NASA Aviation Safety Program's Vehicle Systems Safety Technologies
(VSST) project.
<br><br>
<b>Description</b> <br>
The T-MATS software provides a toolbox for the development of thermodynamic 
system models; it contains a simulation framework, multi-loop solver techniques, and modular 
thermodynamic simulation blocks. While much of the capability in T-MATS is in transient 
thermodynamic simulation, the developers' main interests are in aero-thermal applications; 
as such, one highlight of the T-MATS software package is the turbomachinery block set. This 
set of Simulink blocks gives a developer the tools required to create virtually any steady 
state or dynamic turbomachinery simulation, e.g., a gas turbine simulation. In systems where 
the control or other related systems are modeled in MATLAB/Simulink, the T-MATS developer has 
the ability to create the complete system in a single tool.
<br><br>
T-MATS is written in MATLAB/Simulink (The Mathworks, Inc.), is open source, 
and is intended for use by industry, government, and academia. All T-MATS equations 
were developed from public sources and all default maps and constants provided in the 
T-MATS software package are nonproprietary and available to the public. The software 
is released under the Apache V2.0 license agreement. 
<br><br>
<b>Getting Started</b> <br>
Stable releases of T-MATS are located under the <a href= "https://github.com/nasa/T-MATS/releases" >releases tab</a>. It is encouraged that a user
download the most up to date version using the appropriate software download button (green button). 
Installation instructions are detailed in the user's manual which is included within the package. 
<br><br>
T-MATS encourages open collaboration and if a user wishes to become a developer the software 
may be forked at any time via the main page link.
