function MWS = setup_Fan(MWS)
%		T-MATS -- setup_Fan.m
% *************************************************************************
% written by Jeffryes Chapman
% NASA Glenn Research Center, Cleveland, OH
% Dec 18th, 2012
%
% This function creates the properties of the Fan component for the JT9D.
% *************************************************************************
            
  
 MWS.FAN.NcVec = [ 0.500 0.600 0.700 0.800 0.850 0.900 0.950...
                   1.000 1.050 1.100 1.150];

 MWS.FAN.RlineVec = [   1.000   1.200    1.400    1.600    1.800...   
                        2.000   2.200    2.400    2.600    2.800...
                        3.000   3.200];


%========== Wc = f(NcMap, RlineMap) ==================
 MWS.FAN.WcArray = [ 1129.0825  1258.8474  1382.1909  1498.6384  1607.7749...
                     1709.2917  1802.8665  1888.3794  1965.6499  2034.6738...
                     2095.4690  2148.1226;
                     1396.9045  1546.6948  1685.6306  1813.0896  1928.5979...
                     2031.8818  2122.7800  2201.2161  2267.4148  2321.6023...
                     2364.1392  2395.5188;
                     1636.3572  1816.0977  1977.3179  2119.2051  2241.3333...
                     2343.6414  2426.3811  2490.0854  2535.5586  2563.8640...
                     2576.1626  2576.9243;
                     1884.0764  2099.0234  2284.7820  2440.4712  2565.9761...
                     2661.9326  2729.5161  2770.3828  2786.6572  2787.1653...
                     2787.1653  2787.1653;
                     2049.3005  2269.7354  2456.5759  2609.2085  2727.9202...
                     2813.8420  2868.7388  2894.8994  2898.0327  2898.0327...
                     2898.0327  2898.0327;
                     2288.3171  2492.5862  2662.3203  2797.5042  2898.9448...
                     2968.1807  3007.2944  3018.8535  3018.8535  3018.8535...
                     3018.8535  3018.8535;
                     2562.6401  2733.0469  2872.2166  2980.6609  3059.4998...
                     3110.3328  3135.1262  3138.4663  3138.4663  3138.4663...
                     3138.4663  3138.4663;
                     2769.6670  2909.9534  3022.0933  3106.9241  3165.6892...
                     3199.9995  3211.6814  3211.7039  3211.7039  3211.7039...
                     3211.7039  3211.7039;
                     2954.6721  3056.6882  3137.9358  3199.1514  3241.2805...
                     3265.4429  3272.8789  3272.8789  3272.8789  3272.8789...
                     3272.8789  3272.8789;
                     3130.1790  3195.2559  3246.9822  3285.8452  3312.4382...
                     3327.4097  3331.4949  3331.4949  3331.4949  3331.4949...
                     3331.4949  3331.4949;
                     3275.6797  3310.4507  3338.3101  3359.5127  3374.2856...
                     3382.9170  3385.6724  3385.6724  3385.6724  3385.6724...
                     3385.6724  3385.6724];
							  				      							       							      							       				   
%========== eff = f(NcMap, RlineMap) ==================
 MWS.FAN.EffArray = [0.7900  0.8409  0.8835  0.9160  0.9360  0.9401...
                     0.9257  0.8894  0.8233  0.7152  0.5453  0.2792
                     0.7728  0.8298  0.8776  0.9141  0.9368  0.9421... 
                     0.9271  0.8885  0.8179  0.7026  0.5223  0.2425
                     0.7237  0.7965  0.8579  0.9053  0.9352  0.9432... 
                     0.9256  0.8776  0.7882  0.6405  0.4067  0.0380
                     0.6854  0.7705  0.8423  0.8978  0.9331  0.9431... 
                     0.9239  0.8702  0.7703  0.6058  0.3474  0.0000
                     0.7003  0.7808  0.8483  0.9001  0.9327  0.9418... 
                     0.9243  0.8763  0.7882  0.6463  0.4299  0.1059
                     0.7556  0.8178  0.8692  0.9080  0.9318  0.9379... 
                     0.9248  0.8907  0.8305  0.7378  0.6034  0.4147
                     0.8143  0.8549  0.8878  0.9120  0.9262  0.9290... 
                     0.9201  0.8991  0.8639  0.8121  0.7405  0.6453
                     0.8431  0.8697  0.8909  0.9059  0.9142  0.9150... 
                     0.9081  0.8936  0.8704  0.8373  0.7928  0.7353
                     0.8613  0.8780  0.8909  0.8998  0.9042  0.9037... 
                     0.8984  0.8884  0.8731  0.8519  0.8243  0.7893
                     0.8696  0.8785  0.8851  0.8892  0.8908  0.8896... 
                     0.8856  0.8791  0.8697  0.8573  0.8416  0.8222
                     0.8644  0.8680  0.8704  0.8716  0.8714  0.8699... 
                     0.8670  0.8629  0.8575  0.8507  0.8424  0.8326];

%========== PR = f(NcMap, RlineMap) ==================
 MWS.FAN.PRArray = [ 1.1119  1.1119  1.1098  1.1058  1.0998  1.0919... 
                     1.0822  1.0711  1.0586  1.0446  1.0292  1.0125;
                     1.1622  1.1638  1.1621  1.1570  1.1487  1.1372... 
                     1.1228  1.1060  1.0869  1.0655  1.0420  1.0164;
                     1.2172  1.2249  1.2266  1.2221  1.2115  1.1950... 
                     1.1733  1.1471  1.1168  1.0825  1.0447  1.0035;
                     1.2858  1.3036  1.3114  1.3090  1.2965  1.2742... 
                     1.2433  1.2052  1.1606  1.1099  1.0537  1.0000;
                     1.3350  1.3543  1.3628  1.3603  1.3467  1.3224... 
                     1.2887  1.2474  1.1988  1.1438  1.0830  1.0174;
                     1.4075  1.4214  1.4258  1.4204  1.4055  1.3813... 
                     1.3489  1.3098  1.2643  1.2131  1.1567  1.0957;
                     1.4915  1.4971  1.4955  1.4869  1.4712  1.4487... 
                     1.4202  1.3867  1.3485  1.3058  1.2591  1.2086;
                     1.5579  1.5567  1.5503  1.5386  1.5218  1.5000... 
                     1.4738  1.4439  1.4106  1.3739  1.3341  1.2914;
                     1.6184  1.6123  1.6024  1.5888  1.5717  1.5510... 
                     1.5273  1.5010  1.4722  1.4410  1.4076  1.3720;
                     1.6748  1.6655  1.6538  1.6399  1.6238  1.6054... 
                     1.5852  1.5633  1.5399  1.5150  1.4886  1.4608;
                     1.7224  1.7122  1.7008  1.6882  1.6744  1.6595... 
                     1.6434  1.6266  1.6089  1.5904  1.5711  1.5510];

%------ scalar for corrected flow -------------
MWS.FAN.s_Wc = 0.521629;

%--------- scalar for pressure ratio ----------
MWS.FAN.s_PR = 1.4369; 

%--------- scalar for efficiency ----------  
MWS.FAN.s_eff = 0.967977;

%--------- scalar for corrected FAN speed ----------
% MWS.FAN.s_Nc = 0.0002535;
MWS.FAN.s_Nc = 3943.959;