/*       /NASA/GasTables/therm/pt2sc.c            		   
*														   
*  Computes entropy as function of pressure & temperature 
*       S = f(P,T,faratio)									   
*														   
*	    D K Frederick
*---------------------------------------------------------
*   Using option 2 of therm.f as basis for Matlab code	   
*---------------------------------------------------------
*/

#include <stdio.h>
#include <math.h>

double pt2sc(double P, double T, double fa)
{
	/*--------Define Arrays--------*/
	int ITAB[60] = {1,1,1,2,3,3,4,4,4,5,5,5,5,6,6,6,6,6,7,7,7,7,7,7,
		 8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,10,
		 11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11};
	int TTTAB[11] = {300,400,500,700,1000,1400,1900,2500,3100,3700,4500};
	double AHAIR[11] = {2.074402000000e3,2.767580000000e3,3.461230000000e3,
		 4.854285000000e3,6.981156000000e3,9.933801000000e3,
         1.382117000000e4,1.870811000000e4,2.375618000000e4,
         2.891518000000e4,3.591874000000e4};
	double BHAIR[11] = {6.930375143000e0,6.933262304370e0,6.941415639521e0,
         6.999806554132e0,7.201291270059e0,7.564016167549e0,
         7.965574033453e0,8.298411651745e0,8.515829359567e0,
         8.673620909986e0,8.825346607306e0};
	double CHAIR[11] = {1.327409630363e-5,1.559751739222e-5,6.593583412638e-5,
         2.260187389251e-4,4.455969808316e-4,4.612152628951e-4,
         3.419004689130e-4,2.128288949057e-4,1.495339514650e-4,
         1.134519659006e-4,7.620515574828e-5};
	double DHAIR[11] = {7.744736961966e-9,1.677943891139e-7,2.668048413312e-7,
         2.439758243406e-7,1.301523505289e-8,-7.954319598805e-8,
         -7.170643000405e-8,-3.51638574671e-8,-2.004554753575e-8,
         -1.551950423014e-8,2.007781800899e-22};
	double APAIR[11] = {4.229854000000e1,4.429218000000e1,4.584067000000e1,
         4.818303000000e1,5.070949000000e1,5.318950000000e1,
         5.556056000000e1,5.779398000000e1,5.960312000000e1,
         6.112402000000e1,6.283719000000e1};
	double BPAIR[11] = {2.305525000000e-2,1.732687898835e-2,1.390113404660e-2,
         9.984237743689e-3,7.194810211645e-3,5.398110354070e-3,
         4.191444392129e-3,3.318644249749e-3,2.746778608874e-3,
         2.344441314755e-3,1.960623219312e-3};
	double CPAIR[11] = {-3.628178988352e-5,-2.100192023298e-5,
         -1.325552918449e-5,-6.328952330080e-6,-2.969139443401e-6,
         -1.522610200538e-6,-8.907217233446e-7,-5.639451806208e-7,
         -3.891642208381e-7,-2.813979360273e-7,-1.983746832756e-7};
	double DPAIR[11] = {5.093289883514e-8,2.582130349498e-8,1.154429475734e-8,
         3.733125429643e-9,1.205441035719e-9,4.212589847953e-10,
         1.815425237354e-10,9.710053321261e-11,5.987015822823e-11,
         3.459302197988e-11,2.445751324881e-11};
	double AHSTOC[11] = {2.116286000000e3,2.831822000000e3,3.556413000000e3,
         5.033766000000e3,7.326000000000e3,1.054811000000e4,
         1.483580000000e4,2.028520000000e4,2.596610000000e4,
         3.180568000000e4,3.976139000000e4};
	double BHSTOC[11] = {7.113538900000e0,7.199470008152e0,7.292391067390e0,
         7.482468579354e0,7.811853002145e0,8.297006217518e0,
         8.832077018487e0,9.300821657633e0,9.616136350979e0,
         9.837032938452e0,1.003677698592e1};
	double CHSTOC[11] = {3.953219184767e-4,4.639891630481e-4,4.652214293286e-4,
         4.851661304903e-4,6.127819454796e-4,6.001010929530e-4,
         4.700405089856e-4,3.112005562576e-4,2.143239326515e-4,
         1.538370464703e-4,9.584301286375e-5};
	double DHSTOC[11] = {2.288908152379e-7,4.107554268465e-9,3.324116860284e-8,
         1.417953499881e-7,-1.056737710548e-8,-8.670705597826e-8,
         -8.824441818226e-8,-5.382034644785e-8,-3.360382565619e-8,
         -2.416418066940e-8,6.080973759837e-15};
	double APSTOC[11] = {4.208565000000e1,4.414325000000e1,4.576019000000e1,
         4.824312000000e1,5.096532000000e1,5.367114000000e1,
         5.628635000000e1,5.877705000000e1,6.081328000000e1,
         6.253552000000e1,6.448296000000e1};
	double BPSTOC[11] = {2.361110000000e-2,1.800764547338e-2,1.459451810646e-2,
         1.067795041447e-2,7.806395767972e-3,5.922535863503e-3,
         4.648916404273e-3,3.720736784998e-3,3.102786455737e-3,
         2.660467392055e-3,2.231936896092e-3};
	double CPSTOC[11] = {-3.50184547338e-5,-2.10160905323e-5,-1.31151831369e-5,
         -6.467655323031e-6,-3.104193498621e-6,-1.605456262554e-6,
         -9.417826559062e-7,-6.051833762187e-7,-4.247338392160e-7,
         -3.124646002534e-7,-2.231985197004e-7};
	double DPSTOC[11] = {4.667454733830e-8,2.633635798468e-8,1.107921302316e-8,
         3.737179804900e-9,1.248947696722e-9,4.424490710984e-10,
         1.869995998264e-10,1.002497427793e-10,6.237179942365e-11,
         3.719420023041e-11,2.698623281668e-11};

	double zmea, zmsp, tmlsr, zmwtr, tmls, temp, dl, phiea, phisp, phig, rcas, S;
	int Tindex, Tindex2, it;
	
	if (fa == 0){
		zmea = 4.7642;
		zmsp = 0;
		tmlsr = 0.2098988288;
		zmwtr = 0.0345194683;
	}
	else{
		zmea = 4.7642-fa*69.69056873;        /* eqn 35 */
		zmsp = fa*74.411931335;              /* eqn 38 */
		tmls = 4.7642+fa*4.721362582;        /* eqn 39 */
		zmwtr = tmls/(138.0148721*(1+fa));   /* eqn 42 */
		tmlsr = 1/tmls;
	}

	/*--- temperature index is integer part of temp/100 ----*/
	temp = 0.01 * (T - fmod(T,100));
	if (temp > 1)
		Tindex2 = temp;
	else
		Tindex2 = 1;
	if (Tindex2 < 60)
		Tindex = Tindex2;
	else
		Tindex = 60;
	
	it = ITAB[Tindex - 1] - 1;
	dl = T - TTTAB[it];
	phiea =((DPAIR[it]*dl + CPAIR[it])*dl + BPAIR[it])*dl + APAIR[it];

	if (fa > 0)
		phisp = ((DPSTOC[it]*dl + CPSTOC[it])*dl + BPSTOC[it])*dl + APSTOC[it];
	else
		phisp = 0;

	phig =(phisp*zmsp + phiea*zmea)*tmlsr;
	rcas = 1.98587*zmwtr;
	S = (phig*0.5035576347-23.0258509)*rcas - 0.1841304 - rcas * log(P/14.696);

	return S;
}