/* $Id$ */

/*
 *  Copyright (c) 2009 Axel Andersson
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#import "WCAdministration.h"

@interface WCEventsController : WCAdministrationController {
	IBOutlet NSPopUpButton				*_datePopUpButton;
	IBOutlet NSPopUpButton				*_nickPopUpButton;
	IBOutlet NSPopUpButton				*_loginPopUpButton;
	IBOutlet NSPopUpButton				*_ipPopUpButton;
	IBOutlet NSPopUpButton				*_typePopUpButton;
	IBOutlet NSSearchField				*_messageSearchField;
	
	IBOutlet WITableView				*_eventsTableView;
	IBOutlet NSTableColumn				*_timeTableColumn;
	IBOutlet NSTableColumn				*_nickTableColumn;
	IBOutlet NSTableColumn				*_loginTableColumn;
	IBOutlet NSTableColumn				*_ipTableColumn;
	IBOutlet NSTableColumn				*_imageTableColumn;
	IBOutlet NSTableColumn				*_messageTableColumn;
	
	IBOutlet NSWindow					*_clearEventsWindow;
	IBOutlet NSMatrix					*_clearMethodMatrix;
	IBOutlet NSDatePicker				*_startDatePicker;
	IBOutlet NSDatePicker				*_endDatePicker;
	
	NSMutableArray						*_allCurrentEvents;
	NSMutableArray						*_allArchivedEvents;
	NSMutableArray						*_listedEvents;
	NSMutableArray						*_receivedEvents;
	NSMutableArray						*_shownEvents;
	
	WIDateFormatter						*_dateFormatter;
	WISizeFormatter						*_sizeFormatter;
	
	NSMutableSet						*_allNicks;
	NSMutableSet						*_allLogins;
	NSMutableSet						*_allIPs;
	NSString							*_messageFilter;
	
	NSDate								*_firstDate;
	
	BOOL								_requested;
}

- (IBAction)date:(id)sender;
- (IBAction)nick:(id)sender;
- (IBAction)login:(id)sender;
- (IBAction)ip:(id)sender;
- (IBAction)type:(id)sender;
- (IBAction)message:(id)sender;

- (IBAction)clearEvents:(id)sender;
- (IBAction)okClear:(id)sender;
- (IBAction)cancelClear:(id)sender;

- (void)wiredEventGetFirstTimeReply:(WIP7Message *)message;
- (void)wiredEventGetEventsReply:(WIP7Message *)message;
- (void)wiredEventSubscribeReply:(WIP7Message *)message;

@end
