//
//  WIConfigManager.m
//  WiredFrameworks
//
//  Created by Rafaël Warnault on 23/06/13.
//  Copyright (c) 2013 Read-Write. All rights reserved.
//

#import "WIConfigManager.h"
#import "WIError.h"

@interface WIConfigManager(Private)

- (NSMutableDictionary *)_readConfig;
- (BOOL)_writeConfig:(NSDictionary *)config error:(WIError **)error;

@end


@implementation WIConfigManager(Private)

- (NSMutableDictionary *)_readConfig {
	NSMutableDictionary		*config;
	NSEnumerator			*enumerator;
	NSArray					*pair;
	NSString				*file, *line, *name, *value;
	
	config		= [NSMutableDictionary dictionary];
	file		= [NSString stringWithContentsOfFile:_configPath encoding:NSUTF8StringEncoding error:NULL];
	enumerator	= [[file componentsSeparatedByString:@"\n"] objectEnumerator];
	
	while((line = [enumerator nextObject])) {
		if([line hasPrefix:@"#"])
			continue;
		
		pair = [line componentsSeparatedByString:@"="];
		
		if([pair count] == 2) {
			name	= [[pair objectAtIndex:0] stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];;
			value	= [[pair objectAtIndex:1] stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];;
			
			if([config objectForKey:name])
				[[config objectForKey:name] addObject:value];
			else
				[config setObject:[NSMutableArray arrayWithObject:value] forKey:name];
		}
	}
	
	return config;
}



- (BOOL)_writeConfig:(NSDictionary *)config error:(WIError **)error {
	NSEnumerator		*enumerator, *valueEnumerator;
	NSMutableString		*string;
	NSString			*key, *value;
	
	string = [NSMutableString string];
    
	[string appendString: [NSSWF:@"# This file was generated by %@ at %@\n",
                          [[self bundle] objectForInfoDictionaryKey:@"CFBundleExecutable"],
                          [_dateFormatter stringFromDate:[NSDate date]]]];
	
	enumerator = [[[config allKeys] sortedArrayUsingSelector:@selector(compare:)] objectEnumerator];
	
	while((key = [enumerator nextObject])) {
		valueEnumerator = [[config objectForKey:key] objectEnumerator];
		
		while((value = [valueEnumerator nextObject]))
			[string appendFormat:@"%@ = %@\n", key, value];
	}
	
	return [[string dataUsingEncoding:NSUTF8StringEncoding] writeToFile:_configPath options:NSAtomicWrite error:(NSError **) &error];
}

@end



@implementation WIConfigManager

- (id)initWithConfigPath:(NSString *)configPath {
	self = [super init];
	
	_configPath = [configPath retain];
	
	_dateFormatter = [[WIDateFormatter alloc] init];
	[_dateFormatter setTimeStyle:NSDateFormatterShortStyle];
	[_dateFormatter setDateStyle:NSDateFormatterShortStyle];
    
	return self;
}



- (void)dealloc {
	[_configPath release];
	[_dateFormatter release];
	
	[super dealloc];
}



#pragma mark -

- (BOOL)setString:(NSString *)string forConfigWithName:(NSString *)name andWriteWithError:(WIError **)error {
	NSMutableDictionary		*config;
	
	config = [self _readConfig];
	
	[config setObject:[NSArray arrayWithObject:string] forKey:name];
	
	return [self _writeConfig:config error:error];
}



- (NSString *)stringForConfigWithName:(NSString *)name {
	NSDictionary		*config;
	
	config = [self _readConfig];
	
	if([[config objectForKey:name] count] == 0)
		return NULL;
	
	return [[config objectForKey:name] objectAtIndex:0];
}

@end
