/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.main;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.turbine.binder.Binder;
import com.google.turbine.deps.Dependencies;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.lower.Lower;
import com.google.turbine.options.TurbineOptions;
import com.google.turbine.options.TurbineOptionsParser;
import com.google.turbine.parse.Parser;
import com.google.turbine.proto.DepsProto;
import com.google.turbine.tree.Tree;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class Main {
    private static final int BUFFER_SIZE = 65536;
    private static final Function<String, Path> TO_PATH = new Function<String, Path>(){

        public Path apply(String input) {
            return Paths.get(input, new String[0]);
        }
    };

    public static void main(String[] args) throws IOException {
        Main.compile(args);
    }

    public static boolean compile(String[] args) throws IOException {
        TurbineOptions options = TurbineOptionsParser.parse(Arrays.asList(args));
        return Main.compile(options);
    }

    public static boolean compile(TurbineOptions options) throws IOException {
        if (!options.processors().isEmpty()) {
            return false;
        }
        ImmutableList<Tree.CompUnit> units = Main.parseAll(options);
        Collection<String> reducedClasspath = Dependencies.reduceClasspath(options.classPath(), options.directJarsToTargets(), options.depsArtifacts());
        Binder.BindingResult bound = Binder.bind(units, Iterables.transform(reducedClasspath, TO_PATH), Iterables.transform(options.bootClassPath(), TO_PATH));
        Lower.Lowered lowered = Lower.lowerAll(bound.units(), bound.classPathEnv());
        if (options.outputDeps().isPresent()) {
            DepsProto.Dependencies deps = Dependencies.collectDeps(options.targetLabel(), options.bootClassPath(), bound, lowered);
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(Paths.get((String)options.outputDeps().get(), new String[0]), new OpenOption[0]));){
                deps.writeTo(os);
            }
        }
        Main.writeOutput(Paths.get(options.outputFile(), new String[0]), lowered.bytes());
        return true;
    }

    private static ImmutableList<Tree.CompUnit> parseAll(TurbineOptions options) throws IOException {
        ImmutableList.Builder units = ImmutableList.builder();
        for (String source : options.sources()) {
            units.add((Object)Parser.parse(new SourceFile(source, new String(Files.readAllBytes(Paths.get(source, new String[0])), StandardCharsets.UTF_8))));
        }
        LinkedHashMap<String, SourceFile> sources = new LinkedHashMap<String, SourceFile>();
        for (String sourceJar : options.sourceJars()) {
            JarFile jf = new JarFile(sourceJar);
            Throwable throwable = null;
            try {
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements()) {
                    JarEntry je = entries.nextElement();
                    if (!je.getName().endsWith(".java")) continue;
                    String source = new String(ByteStreams.toByteArray((InputStream)jf.getInputStream(je)), StandardCharsets.UTF_8);
                    sources.put(je.getName(), new SourceFile(je.getName(), source));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jf == null) continue;
                if (throwable != null) {
                    try {
                        jf.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jf.close();
            }
        }
        for (SourceFile sourceFile : sources.values()) {
            units.add((Object)Parser.parse(sourceFile));
        }
        return units.build();
    }

    private static void writeOutput(Path path, Map<String, byte[]> lowered) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os, 65536);
             JarOutputStream jos = new JarOutputStream(bos);){
            for (Map.Entry<String, byte[]> entry : lowered.entrySet()) {
                JarEntry je = new JarEntry(entry.getKey() + ".class");
                je.setTime(0L);
                je.setMethod(0);
                byte[] bytes = entry.getValue();
                je.setSize(bytes.length);
                je.setCrc(Hashing.crc32().hashBytes(bytes).padToLong());
                jos.putNextEntry(je);
                jos.write(bytes);
            }
        }
    }
}

