//
// This source was autogenerated - do not modify it, changes may not be preserved
//
#if !TARGET_DOTNET
using System;
using System.Collections.Generic;
using System.Web;
using System.Web.Caching;

using NUnit.Framework;

namespace MonoTests.System.Web.Caching
{
	public partial class CacheItemPriorityQueueTest
	{
		[Test (Description="Generated from sequence file cache_pq_sequence_2010-01-29_10:24:08.seq")]
		public void Sequence_0000 ()
		{
			var list = new List <CacheItem> {
				new CacheItem {Key = "PartialCachingControl\nGUID: 0a543377-1bcc-4ec5-9096-616fa29ec3f5\n", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:38 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003610181191660, Disabled = false, Guid = new Guid ("b50f84e2-b96b-4183-ac6a-afeec88a258d")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:33 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003622131234770, Disabled = false, Guid = new Guid ("78f08aef-31b7-49e6-8ba9-2d7b09f5340e")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:33 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003622131252350, Disabled = false, Guid = new Guid ("ecd90b49-bb12-4524-818e-977356f8b9d2")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:41 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003610216655680, Disabled = false, Guid = new Guid ("38e7f821-d638-4f1d-89bd-41db556eb37a")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:41 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003610216655680, Disabled = false, Guid = new Guid ("6e723bac-5e11-4cb3-933f-39923948371c")}, 
				new CacheItem {Key = "PartialCachingControl\nGUID: 0a543377-1bcc-4ec5-9096-616fa29ec3f5\n", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:51 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003610312287880, Disabled = false, Guid = new Guid ("93db96c7-eb5b-43b3-8524-e7d90cd159d7")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:46 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003622262288710, Disabled = false, Guid = new Guid ("fc310ed6-2027-4d16-9343-a3e4b3487bd0")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:46 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003622262288910, Disabled = false, Guid = new Guid ("de47322e-63c8-474f-8d2f-fb6a591075df")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:56 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003610362271610, Disabled = false, Guid = new Guid ("f003a7ba-af48-4551-a206-1184fc83e621")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:56 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003610362271610, Disabled = false, Guid = new Guid ("5777ab80-078b-4f9a-81fb-f7872aceba99")}, 
			};
			var queue = new CacheItemPriorityQueue ();
			CacheItem item;

			queue.Enqueue (list [0]);
			Assert.AreEqual (1, queue.Count, "Enqueue-0000-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0000-2");

			queue.Enqueue (list [1]);
			Assert.AreEqual (2, queue.Count, "Enqueue-0001-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0001-2");

			item = list [1];
			Assert.IsNotNull (item, "Disable-0000-1");
			Assert.AreEqual ("78f08aef-31b7-49e6-8ba9-2d7b09f5340e", item.Guid.ToString(), "Disable-0000-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0000-3");
			item.Disabled = true;

			queue.Enqueue (list [2]);
			Assert.AreEqual (3, queue.Count, "Enqueue-0002-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0002-2");

			queue.Enqueue (list [3]);
			Assert.AreEqual (4, queue.Count, "Enqueue-0003-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0003-2");

			queue.Enqueue (list [4]);
			Assert.AreEqual (5, queue.Count, "Enqueue-0004-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0004-2");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0000-1");
			Assert.AreEqual (4, queue.Count, "Dequeue-0000-2");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", item.Guid.ToString (), "Dequeue-0000-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0000-4");

			item = list [0];
			Assert.IsNotNull (item, "Disable-0001-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", item.Guid.ToString(), "Disable-0001-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0001-3");
			item.Disabled = true;

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0001-1");
			Assert.AreEqual (3, queue.Count, "Dequeue-0001-2");
			Assert.AreEqual ("6e723bac-5e11-4cb3-933f-39923948371c", item.Guid.ToString (), "Dequeue-0001-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0001-4");

			item = list [3];
			Assert.IsNotNull (item, "Disable-0002-1");
			Assert.AreEqual ("38e7f821-d638-4f1d-89bd-41db556eb37a", item.Guid.ToString(), "Disable-0002-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0002-3");
			item.Disabled = true;

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0002-1");
			Assert.AreEqual (2, queue.Count, "Dequeue-0002-2");
			Assert.AreEqual ("38e7f821-d638-4f1d-89bd-41db556eb37a", item.Guid.ToString (), "Dequeue-0002-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0002-4");

			item = list [4];
			Assert.IsNotNull (item, "Disable-0003-1");
			Assert.AreEqual ("6e723bac-5e11-4cb3-933f-39923948371c", item.Guid.ToString(), "Disable-0003-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0003-3");
			item.Disabled = true;

			queue.Enqueue (list [5]);
			Assert.AreEqual (3, queue.Count, "Enqueue-0005-1");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", queue.Peek ().Guid.ToString(), "Enqueue-0005-2");

			item = list [2];
			Assert.IsNotNull (item, "Disable-0004-1");
			Assert.AreEqual ("ecd90b49-bb12-4524-818e-977356f8b9d2", item.Guid.ToString(), "Disable-0004-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0004-3");
			item.Disabled = true;

			queue.Enqueue (list [6]);
			Assert.AreEqual (4, queue.Count, "Enqueue-0006-1");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", queue.Peek ().Guid.ToString(), "Enqueue-0006-2");

			item = list [6];
			Assert.IsNotNull (item, "Disable-0005-1");
			Assert.AreEqual ("fc310ed6-2027-4d16-9343-a3e4b3487bd0", item.Guid.ToString(), "Disable-0005-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0005-3");
			item.Disabled = true;

			queue.Enqueue (list [7]);
			Assert.AreEqual (5, queue.Count, "Enqueue-0007-1");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", queue.Peek ().Guid.ToString(), "Enqueue-0007-2");

			queue.Enqueue (list [8]);
			Assert.AreEqual (6, queue.Count, "Enqueue-0008-1");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", queue.Peek ().Guid.ToString(), "Enqueue-0008-2");

			queue.Enqueue (list [9]);
			Assert.AreEqual (7, queue.Count, "Enqueue-0009-1");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", queue.Peek ().Guid.ToString(), "Enqueue-0009-2");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0003-1");
			Assert.AreEqual (6, queue.Count, "Dequeue-0003-2");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", item.Guid.ToString (), "Dequeue-0003-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0003-4");

			item = list [5];
			Assert.IsNotNull (item, "Disable-0006-1");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", item.Guid.ToString(), "Disable-0006-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0006-3");
			item.Disabled = true;

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0004-1");
			Assert.AreEqual (5, queue.Count, "Dequeue-0004-2");
			Assert.AreEqual ("5777ab80-078b-4f9a-81fb-f7872aceba99", item.Guid.ToString (), "Dequeue-0004-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0004-4");

			item = list [8];
			Assert.IsNotNull (item, "Disable-0007-1");
			Assert.AreEqual ("f003a7ba-af48-4551-a206-1184fc83e621", item.Guid.ToString(), "Disable-0007-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0007-3");
			item.Disabled = true;

			Assert.AreEqual (5, queue.Count, "Queue size after sequence");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0005-1");
			Assert.AreEqual (4, queue.Count, "Dequeue-0005-2");
			Assert.AreEqual ("f003a7ba-af48-4551-a206-1184fc83e621", item.Guid.ToString (), "Dequeue-0005-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0005-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0006-1");
			Assert.AreEqual (3, queue.Count, "Dequeue-0006-2");
			Assert.AreEqual ("78f08aef-31b7-49e6-8ba9-2d7b09f5340e", item.Guid.ToString (), "Dequeue-0006-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0006-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0007-1");
			Assert.AreEqual (2, queue.Count, "Dequeue-0007-2");
			Assert.AreEqual ("ecd90b49-bb12-4524-818e-977356f8b9d2", item.Guid.ToString (), "Dequeue-0007-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0007-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0008-1");
			Assert.AreEqual (1, queue.Count, "Dequeue-0008-2");
			Assert.AreEqual ("fc310ed6-2027-4d16-9343-a3e4b3487bd0", item.Guid.ToString (), "Dequeue-0008-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0008-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0009-1");
			Assert.AreEqual (0, queue.Count, "Dequeue-0009-2");
			Assert.AreEqual ("de47322e-63c8-474f-8d2f-fb6a591075df", item.Guid.ToString (), "Dequeue-0009-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0009-4");

		}

		[Test (Description="Generated from sequence file cache_pq_sequence_2010-01-29_10:24:08_001.seq")]
		public void Sequence_0001 ()
		{
			var list = new List <CacheItem> {
				new CacheItem {Key = "PartialCachingControl\nGUID: 0a543377-1bcc-4ec5-9096-616fa29ec3f5\n", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:38 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003610181191660, Disabled = false, Guid = new Guid ("b50f84e2-b96b-4183-ac6a-afeec88a258d")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:33 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003622131234770, Disabled = false, Guid = new Guid ("78f08aef-31b7-49e6-8ba9-2d7b09f5340e")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:33 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003622131252350, Disabled = false, Guid = new Guid ("ecd90b49-bb12-4524-818e-977356f8b9d2")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:41 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003610216655680, Disabled = false, Guid = new Guid ("38e7f821-d638-4f1d-89bd-41db556eb37a")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:41 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003610216655680, Disabled = false, Guid = new Guid ("6e723bac-5e11-4cb3-933f-39923948371c")}, 
				new CacheItem {Key = "PartialCachingControl\nGUID: 0a543377-1bcc-4ec5-9096-616fa29ec3f5\n", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:51 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003610312287880, Disabled = false, Guid = new Guid ("93db96c7-eb5b-43b3-8524-e7d90cd159d7")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:46 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003622262288710, Disabled = false, Guid = new Guid ("fc310ed6-2027-4d16-9343-a3e4b3487bd0")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:46 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003622262288910, Disabled = false, Guid = new Guid ("de47322e-63c8-474f-8d2f-fb6a591075df")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:56 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003610362271610, Disabled = false, Guid = new Guid ("f003a7ba-af48-4551-a206-1184fc83e621")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:56 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003610362271610, Disabled = false, Guid = new Guid ("5777ab80-078b-4f9a-81fb-f7872aceba99")}, 
			};
			var queue = new CacheItemPriorityQueue ();
			CacheItem item;

			queue.Enqueue (list [0]);
			Assert.AreEqual (1, queue.Count, "Enqueue-0000-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0000-2");

			queue.Enqueue (list [1]);
			Assert.AreEqual (2, queue.Count, "Enqueue-0001-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0001-2");

			queue.Enqueue (list [2]);
			Assert.AreEqual (3, queue.Count, "Enqueue-0002-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0002-2");

			queue.Enqueue (list [3]);
			Assert.AreEqual (4, queue.Count, "Enqueue-0003-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0003-2");

			queue.Enqueue (list [4]);
			Assert.AreEqual (5, queue.Count, "Enqueue-0004-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0004-2");

			queue.Enqueue (list [5]);
			Assert.AreEqual (6, queue.Count, "Enqueue-0005-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0005-2");

			queue.Enqueue (list [6]);
			Assert.AreEqual (7, queue.Count, "Enqueue-0006-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0006-2");

			queue.Enqueue (list [7]);
			Assert.AreEqual (8, queue.Count, "Enqueue-0007-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0007-2");

			queue.Enqueue (list [8]);
			Assert.AreEqual (9, queue.Count, "Enqueue-0008-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0008-2");

			queue.Enqueue (list [9]);
			Assert.AreEqual (10, queue.Count, "Enqueue-0009-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0009-2");

			Assert.AreEqual (10, queue.Count, "Queue size after sequence");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0000-1");
			Assert.AreEqual (9, queue.Count, "Dequeue-0000-2");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", item.Guid.ToString (), "Dequeue-0000-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0000-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0001-1");
			Assert.AreEqual (8, queue.Count, "Dequeue-0001-2");
			Assert.AreEqual ("38e7f821-d638-4f1d-89bd-41db556eb37a", item.Guid.ToString (), "Dequeue-0001-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0001-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0002-1");
			Assert.AreEqual (7, queue.Count, "Dequeue-0002-2");
			Assert.AreEqual ("6e723bac-5e11-4cb3-933f-39923948371c", item.Guid.ToString (), "Dequeue-0002-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0002-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0003-1");
			Assert.AreEqual (6, queue.Count, "Dequeue-0003-2");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", item.Guid.ToString (), "Dequeue-0003-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0003-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0004-1");
			Assert.AreEqual (5, queue.Count, "Dequeue-0004-2");
			Assert.AreEqual ("f003a7ba-af48-4551-a206-1184fc83e621", item.Guid.ToString (), "Dequeue-0004-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0004-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0005-1");
			Assert.AreEqual (4, queue.Count, "Dequeue-0005-2");
			Assert.AreEqual ("5777ab80-078b-4f9a-81fb-f7872aceba99", item.Guid.ToString (), "Dequeue-0005-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0005-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0006-1");
			Assert.AreEqual (3, queue.Count, "Dequeue-0006-2");
			Assert.AreEqual ("78f08aef-31b7-49e6-8ba9-2d7b09f5340e", item.Guid.ToString (), "Dequeue-0006-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0006-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0007-1");
			Assert.AreEqual (2, queue.Count, "Dequeue-0007-2");
			Assert.AreEqual ("ecd90b49-bb12-4524-818e-977356f8b9d2", item.Guid.ToString (), "Dequeue-0007-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0007-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0008-1");
			Assert.AreEqual (1, queue.Count, "Dequeue-0008-2");
			Assert.AreEqual ("fc310ed6-2027-4d16-9343-a3e4b3487bd0", item.Guid.ToString (), "Dequeue-0008-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0008-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0009-1");
			Assert.AreEqual (0, queue.Count, "Dequeue-0009-2");
			Assert.AreEqual ("de47322e-63c8-474f-8d2f-fb6a591075df", item.Guid.ToString (), "Dequeue-0009-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0009-4");

		}

		[Test (Description="Generated from sequence file cache_pq_sequence_2010-01-29_10:24:08_002.seq")]
		public void Sequence_0002 ()
		{
			var list = new List <CacheItem> {
				new CacheItem {Key = "PartialCachingControl\nGUID: 0a543377-1bcc-4ec5-9096-616fa29ec3f5\n", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:38 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003610181191660, Disabled = false, Guid = new Guid ("b50f84e2-b96b-4183-ac6a-afeec88a258d")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:33 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003622131234770, Disabled = false, Guid = new Guid ("78f08aef-31b7-49e6-8ba9-2d7b09f5340e")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:33 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003622131252350, Disabled = false, Guid = new Guid ("ecd90b49-bb12-4524-818e-977356f8b9d2")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:41 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003610216655680, Disabled = false, Guid = new Guid ("38e7f821-d638-4f1d-89bd-41db556eb37a")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:41 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:33 AM"), ExpiresAt = 634003610216655680, Disabled = false, Guid = new Guid ("6e723bac-5e11-4cb3-933f-39923948371c")}, 
				new CacheItem {Key = "PartialCachingControl\nGUID: 0a543377-1bcc-4ec5-9096-616fa29ec3f5\n", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:51 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003610312287880, Disabled = false, Guid = new Guid ("93db96c7-eb5b-43b3-8524-e7d90cd159d7")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:46 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003622262288710, Disabled = false, Guid = new Guid ("fc310ed6-2027-4d16-9343-a3e4b3487bd0")}, 
				new CacheItem {Key = "@@@InProc@074DE5C88B2981727366B98C", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:43:46 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003622262288910, Disabled = false, Guid = new Guid ("de47322e-63c8-474f-8d2f-fb6a591075df")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:56 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003610362271610, Disabled = false, Guid = new Guid ("f003a7ba-af48-4551-a206-1184fc83e621")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 11:23:56 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 11:23:46 AM"), ExpiresAt = 634003610362271610, Disabled = false, Guid = new Guid ("5777ab80-078b-4f9a-81fb-f7872aceba99")}, 
			};
			var queue = new CacheItemPriorityQueue ();
			CacheItem item;

			queue.Enqueue (list [0]);
			Assert.AreEqual (1, queue.Count, "Enqueue-0000-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0000-2");

			queue.Enqueue (list [1]);
			Assert.AreEqual (2, queue.Count, "Enqueue-0001-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0001-2");

			queue.Enqueue (list [2]);
			Assert.AreEqual (3, queue.Count, "Enqueue-0002-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0002-2");

			queue.Enqueue (list [3]);
			Assert.AreEqual (4, queue.Count, "Enqueue-0003-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0003-2");

			queue.Enqueue (list [4]);
			Assert.AreEqual (5, queue.Count, "Enqueue-0004-1");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", queue.Peek ().Guid.ToString(), "Enqueue-0004-2");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0000-1");
			Assert.AreEqual (4, queue.Count, "Dequeue-0000-2");
			Assert.AreEqual ("b50f84e2-b96b-4183-ac6a-afeec88a258d", item.Guid.ToString (), "Dequeue-0000-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0000-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0001-1");
			Assert.AreEqual (3, queue.Count, "Dequeue-0001-2");
			Assert.AreEqual ("6e723bac-5e11-4cb3-933f-39923948371c", item.Guid.ToString (), "Dequeue-0001-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0001-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0002-1");
			Assert.AreEqual (2, queue.Count, "Dequeue-0002-2");
			Assert.AreEqual ("38e7f821-d638-4f1d-89bd-41db556eb37a", item.Guid.ToString (), "Dequeue-0002-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0002-4");

			queue.Enqueue (list [5]);
			Assert.AreEqual (3, queue.Count, "Enqueue-0005-1");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", queue.Peek ().Guid.ToString(), "Enqueue-0005-2");

			queue.Enqueue (list [6]);
			Assert.AreEqual (4, queue.Count, "Enqueue-0006-1");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", queue.Peek ().Guid.ToString(), "Enqueue-0006-2");

			queue.Enqueue (list [7]);
			Assert.AreEqual (5, queue.Count, "Enqueue-0007-1");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", queue.Peek ().Guid.ToString(), "Enqueue-0007-2");

			queue.Enqueue (list [8]);
			Assert.AreEqual (6, queue.Count, "Enqueue-0008-1");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", queue.Peek ().Guid.ToString(), "Enqueue-0008-2");

			queue.Enqueue (list [9]);
			Assert.AreEqual (7, queue.Count, "Enqueue-0009-1");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", queue.Peek ().Guid.ToString(), "Enqueue-0009-2");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0003-1");
			Assert.AreEqual (6, queue.Count, "Dequeue-0003-2");
			Assert.AreEqual ("93db96c7-eb5b-43b3-8524-e7d90cd159d7", item.Guid.ToString (), "Dequeue-0003-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0003-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0004-1");
			Assert.AreEqual (5, queue.Count, "Dequeue-0004-2");
			Assert.AreEqual ("5777ab80-078b-4f9a-81fb-f7872aceba99", item.Guid.ToString (), "Dequeue-0004-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0004-4");

			Assert.AreEqual (5, queue.Count, "Queue size after sequence");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0005-1");
			Assert.AreEqual (4, queue.Count, "Dequeue-0005-2");
			Assert.AreEqual ("f003a7ba-af48-4551-a206-1184fc83e621", item.Guid.ToString (), "Dequeue-0005-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0005-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0006-1");
			Assert.AreEqual (3, queue.Count, "Dequeue-0006-2");
			Assert.AreEqual ("78f08aef-31b7-49e6-8ba9-2d7b09f5340e", item.Guid.ToString (), "Dequeue-0006-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0006-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0007-1");
			Assert.AreEqual (2, queue.Count, "Dequeue-0007-2");
			Assert.AreEqual ("ecd90b49-bb12-4524-818e-977356f8b9d2", item.Guid.ToString (), "Dequeue-0007-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0007-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0008-1");
			Assert.AreEqual (1, queue.Count, "Dequeue-0008-2");
			Assert.AreEqual ("fc310ed6-2027-4d16-9343-a3e4b3487bd0", item.Guid.ToString (), "Dequeue-0008-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0008-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0009-1");
			Assert.AreEqual (0, queue.Count, "Dequeue-0009-2");
			Assert.AreEqual ("de47322e-63c8-474f-8d2f-fb6a591075df", item.Guid.ToString (), "Dequeue-0009-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0009-4");

		}

		[Test (Description="Generated from sequence file cache_pq_sequence_2010-01-29_12:31:31.seq")]
		public void Sequence_0003 ()
		{
			var list = new List <CacheItem> {
				new CacheItem {Key = "PartialCachingControl\nGUID: 19e19704-457b-4894-978c-63d6d022bf22\n", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:30:31 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:26 PM"), ExpiresAt = 634003686315246510, Disabled = false, Guid = new Guid ("3378afe8-5a2a-4f30-aedd-fa146880f93e")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:50:26 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:30:26 PM"), ExpiresAt = 634003698265290760, Disabled = false, Guid = new Guid ("33191cc7-c1b4-4726-b428-64efb69a6c46")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:50:26 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:30:26 PM"), ExpiresAt = 634003698265308270, Disabled = false, Guid = new Guid ("88bee6f1-09ac-4af2-9bc3-ebd619009377")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:30:35 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:26 PM"), ExpiresAt = 634003686350855860, Disabled = false, Guid = new Guid ("e290608d-7086-41a6-a87a-3f3051c14780")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:30:35 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:26 PM"), ExpiresAt = 634003686350855860, Disabled = false, Guid = new Guid ("f374c3d0-06a5-4b0d-8fb5-f0e94a876847")}, 
				new CacheItem {Key = "PartialCachingControl\nGUID: 19e19704-457b-4894-978c-63d6d022bf22\n", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:30:37 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:32 PM"), ExpiresAt = 634003686370745960, Disabled = false, Guid = new Guid ("94cc61f5-312e-4d03-8d56-4e8b400f8ca0")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:50:32 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:30:32 PM"), ExpiresAt = 634003698320747270, Disabled = false, Guid = new Guid ("986174eb-da85-4a7b-9919-cd0668db69bf")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:50:32 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:30:32 PM"), ExpiresAt = 634003698320747680, Disabled = false, Guid = new Guid ("3c5fd8ab-a611-4bfb-afb0-5acee9b45dda")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQNgVadmin_edituserNuV78FH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:30:42 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:32 PM"), ExpiresAt = 634003686420678320, Disabled = false, Guid = new Guid ("2d354d5c-8996-4932-ba5f-cd3591fe95cb")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQNgVadmin_edituserNuV78FH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:30:42 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:32 PM"), ExpiresAt = 634003686420678320, Disabled = false, Guid = new Guid ("93a0e663-0354-4301-ac27-9e782091f661")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:50:36 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:30:36 PM"), ExpiresAt = 634003698369030440, Disabled = false, Guid = new Guid ("feebc79b-1867-42c9-a966-bbb448d78a44")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:50:36 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:30:36 PM"), ExpiresAt = 634003698369035640, Disabled = false, Guid = new Guid ("474193d1-4fd9-4b06-873a-e575744957a4")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:30:46 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:36 PM"), ExpiresAt = 634003686469024010, Disabled = false, Guid = new Guid ("817d3f42-bf7b-4a13-90bc-1895cafe2d23")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:30:46 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:36 PM"), ExpiresAt = 634003686469024010, Disabled = false, Guid = new Guid ("39402800-3c1e-478c-8bdc-571d902e32a7")}, 
				new CacheItem {Key = "PartialCachingControl\nGUID: 19e19704-457b-4894-978c-63d6d022bf22\n", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:30:50 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:45 PM"), ExpiresAt = 634003686509800050, Disabled = false, Guid = new Guid ("b45b3bd3-d55d-4c41-b9da-150c19ec0856")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:50:45 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:30:45 PM"), ExpiresAt = 634003698459800810, Disabled = false, Guid = new Guid ("66bc962f-bf18-48a4-8164-722a5f53d211")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:50:45 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:30:45 PM"), ExpiresAt = 634003698459801130, Disabled = false, Guid = new Guid ("9096d210-ed15-4d38-9af2-26e59b0b8be0")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQNgVadmin_edituserNuV78FH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:30:55 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:45 PM"), ExpiresAt = 634003686559793540, Disabled = false, Guid = new Guid ("f7e86ec2-dc06-484f-81ed-df4373fff95b")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQNgVadmin_edituserNuV78FH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:30:55 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:45 PM"), ExpiresAt = 634003686559793540, Disabled = false, Guid = new Guid ("ad6319f5-27bc-4444-9eb8-1320009ab184")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:50:50 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:30:50 PM"), ExpiresAt = 634003698501880070, Disabled = false, Guid = new Guid ("4e49dc65-2c6a-4b2f-97e2-9cf09175c57a")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:50:50 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:30:50 PM"), ExpiresAt = 634003698501880320, Disabled = false, Guid = new Guid ("417fc6e2-b9ae-40eb-906b-6e41b306a908")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:31:00 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:50 PM"), ExpiresAt = 634003686601873790, Disabled = false, Guid = new Guid ("7b0fb8c1-9642-4854-b979-7e223a092a3d")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:31:00 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:30:50 PM"), ExpiresAt = 634003686601873790, Disabled = false, Guid = new Guid ("414bdd0b-ab30-4d61-aef2-2d34fd929ed2")}, 
				new CacheItem {Key = "PartialCachingControl\nGUID: 19e19704-457b-4894-978c-63d6d022bf22\n", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:31:05 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:31:00 PM"), ExpiresAt = 634003686655460880, Disabled = false, Guid = new Guid ("c210ae2b-0c3d-4257-848d-f21ee48c02cc")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:51:00 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:31:00 PM"), ExpiresAt = 634003698605462050, Disabled = false, Guid = new Guid ("ac9cefe3-3331-4ee2-b0f1-69aaca2a955d")}, 
				new CacheItem {Key = "@@@InProc@A3D557581E229FAEA58A8D4F", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:51:00 PM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("1/29/2010 1:31:00 PM"), ExpiresAt = 634003698605462460, Disabled = false, Guid = new Guid ("ae852a56-e081-4ee7-b360-81d4ba1a2000")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:31:10 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:31:00 PM"), ExpiresAt = 634003686705453300, Disabled = false, Guid = new Guid ("e8b43015-cc9b-4cad-a881-faead4f18aa3")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("1/29/2010 1:31:10 PM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("1/29/2010 1:31:00 PM"), ExpiresAt = 634003686705453300, Disabled = false, Guid = new Guid ("3866994b-3be5-4408-9077-529fe701d3f3")}, 
			};
			var queue = new CacheItemPriorityQueue ();
			CacheItem item;

			queue.Enqueue (list [0]);
			Assert.AreEqual (1, queue.Count, "Enqueue-0000-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0000-2");

			queue.Enqueue (list [1]);
			Assert.AreEqual (2, queue.Count, "Enqueue-0001-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0001-2");

			item = list [1];
			Assert.IsNotNull (item, "Disable-0000-1");
			Assert.AreEqual ("33191cc7-c1b4-4726-b428-64efb69a6c46", item.Guid.ToString(), "Disable-0000-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0000-3");
			item.Disabled = true;

			queue.Enqueue (list [2]);
			Assert.AreEqual (3, queue.Count, "Enqueue-0002-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0002-2");

			queue.Enqueue (list [3]);
			Assert.AreEqual (4, queue.Count, "Enqueue-0003-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0003-2");

			queue.Enqueue (list [4]);
			Assert.AreEqual (5, queue.Count, "Enqueue-0004-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0004-2");

			item = list [0];
			Assert.IsNotNull (item, "Disable-0001-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", item.Guid.ToString(), "Disable-0001-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0001-3");
			item.Disabled = true;

			queue.Enqueue (list [5]);
			Assert.AreEqual (6, queue.Count, "Enqueue-0005-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0005-2");

			item = list [2];
			Assert.IsNotNull (item, "Disable-0002-1");
			Assert.AreEqual ("88bee6f1-09ac-4af2-9bc3-ebd619009377", item.Guid.ToString(), "Disable-0002-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0002-3");
			item.Disabled = true;

			queue.Enqueue (list [6]);
			Assert.AreEqual (7, queue.Count, "Enqueue-0006-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0006-2");

			item = list [6];
			Assert.IsNotNull (item, "Disable-0003-1");
			Assert.AreEqual ("986174eb-da85-4a7b-9919-cd0668db69bf", item.Guid.ToString(), "Disable-0003-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0003-3");
			item.Disabled = true;

			queue.Enqueue (list [7]);
			Assert.AreEqual (8, queue.Count, "Enqueue-0007-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0007-2");

			queue.Enqueue (list [8]);
			Assert.AreEqual (9, queue.Count, "Enqueue-0008-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0008-2");

			queue.Enqueue (list [9]);
			Assert.AreEqual (10, queue.Count, "Enqueue-0009-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0009-2");

			item = list [3];
			Assert.IsNotNull (item, "Disable-0004-1");
			Assert.AreEqual ("e290608d-7086-41a6-a87a-3f3051c14780", item.Guid.ToString(), "Disable-0004-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0004-3");
			item.Disabled = true;

			item = list [7];
			Assert.IsNotNull (item, "Disable-0005-1");
			Assert.AreEqual ("3c5fd8ab-a611-4bfb-afb0-5acee9b45dda", item.Guid.ToString(), "Disable-0005-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0005-3");
			item.Disabled = true;

			queue.Enqueue (list [10]);
			Assert.AreEqual (11, queue.Count, "Enqueue-0010-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0010-2");

			item = list [10];
			Assert.IsNotNull (item, "Disable-0006-1");
			Assert.AreEqual ("feebc79b-1867-42c9-a966-bbb448d78a44", item.Guid.ToString(), "Disable-0006-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0006-3");
			item.Disabled = true;

			queue.Enqueue (list [11]);
			Assert.AreEqual (12, queue.Count, "Enqueue-0011-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0011-2");

			queue.Enqueue (list [12]);
			Assert.AreEqual (13, queue.Count, "Enqueue-0012-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0012-2");

			queue.Enqueue (list [13]);
			Assert.AreEqual (14, queue.Count, "Enqueue-0013-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0013-2");

			item = list [8];
			Assert.IsNotNull (item, "Disable-0007-1");
			Assert.AreEqual ("2d354d5c-8996-4932-ba5f-cd3591fe95cb", item.Guid.ToString(), "Disable-0007-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0007-3");
			item.Disabled = true;

			item = list [5];
			Assert.IsNotNull (item, "Disable-0008-1");
			Assert.AreEqual ("94cc61f5-312e-4d03-8d56-4e8b400f8ca0", item.Guid.ToString(), "Disable-0008-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0008-3");
			item.Disabled = true;

			queue.Enqueue (list [14]);
			Assert.AreEqual (15, queue.Count, "Enqueue-0014-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0014-2");

			item = list [11];
			Assert.IsNotNull (item, "Disable-0009-1");
			Assert.AreEqual ("474193d1-4fd9-4b06-873a-e575744957a4", item.Guid.ToString(), "Disable-0009-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0009-3");
			item.Disabled = true;

			queue.Enqueue (list [15]);
			Assert.AreEqual (16, queue.Count, "Enqueue-0015-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0015-2");

			item = list [15];
			Assert.IsNotNull (item, "Disable-0010-1");
			Assert.AreEqual ("66bc962f-bf18-48a4-8164-722a5f53d211", item.Guid.ToString(), "Disable-0010-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0010-3");
			item.Disabled = true;

			queue.Enqueue (list [16]);
			Assert.AreEqual (17, queue.Count, "Enqueue-0016-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0016-2");

			queue.Enqueue (list [17]);
			Assert.AreEqual (18, queue.Count, "Enqueue-0017-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0017-2");

			queue.Enqueue (list [18]);
			Assert.AreEqual (19, queue.Count, "Enqueue-0018-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0018-2");

			item = list [12];
			Assert.IsNotNull (item, "Disable-0011-1");
			Assert.AreEqual ("817d3f42-bf7b-4a13-90bc-1895cafe2d23", item.Guid.ToString(), "Disable-0011-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0011-3");
			item.Disabled = true;

			item = list [16];
			Assert.IsNotNull (item, "Disable-0012-1");
			Assert.AreEqual ("9096d210-ed15-4d38-9af2-26e59b0b8be0", item.Guid.ToString(), "Disable-0012-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0012-3");
			item.Disabled = true;

			queue.Enqueue (list [19]);
			Assert.AreEqual (20, queue.Count, "Enqueue-0019-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0019-2");

			item = list [19];
			Assert.IsNotNull (item, "Disable-0013-1");
			Assert.AreEqual ("4e49dc65-2c6a-4b2f-97e2-9cf09175c57a", item.Guid.ToString(), "Disable-0013-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0013-3");
			item.Disabled = true;

			queue.Enqueue (list [20]);
			Assert.AreEqual (21, queue.Count, "Enqueue-0020-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0020-2");

			queue.Enqueue (list [21]);
			Assert.AreEqual (22, queue.Count, "Enqueue-0021-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0021-2");

			queue.Enqueue (list [22]);
			Assert.AreEqual (23, queue.Count, "Enqueue-0022-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0022-2");

			item = list [21];
			Assert.IsNotNull (item, "Disable-0014-1");
			Assert.AreEqual ("7b0fb8c1-9642-4854-b979-7e223a092a3d", item.Guid.ToString(), "Disable-0014-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0014-3");
			item.Disabled = true;

			item = list [14];
			Assert.IsNotNull (item, "Disable-0015-1");
			Assert.AreEqual ("b45b3bd3-d55d-4c41-b9da-150c19ec0856", item.Guid.ToString(), "Disable-0015-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0015-3");
			item.Disabled = true;

			queue.Enqueue (list [23]);
			Assert.AreEqual (24, queue.Count, "Enqueue-0023-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0023-2");

			item = list [20];
			Assert.IsNotNull (item, "Disable-0016-1");
			Assert.AreEqual ("417fc6e2-b9ae-40eb-906b-6e41b306a908", item.Guid.ToString(), "Disable-0016-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0016-3");
			item.Disabled = true;

			queue.Enqueue (list [24]);
			Assert.AreEqual (25, queue.Count, "Enqueue-0024-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0024-2");

			item = list [24];
			Assert.IsNotNull (item, "Disable-0017-1");
			Assert.AreEqual ("ac9cefe3-3331-4ee2-b0f1-69aaca2a955d", item.Guid.ToString(), "Disable-0017-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0017-3");
			item.Disabled = true;

			queue.Enqueue (list [25]);
			Assert.AreEqual (26, queue.Count, "Enqueue-0025-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0025-2");

			queue.Enqueue (list [26]);
			Assert.AreEqual (27, queue.Count, "Enqueue-0026-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0026-2");

			queue.Enqueue (list [27]);
			Assert.AreEqual (28, queue.Count, "Enqueue-0027-1");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", queue.Peek ().Guid.ToString(), "Enqueue-0027-2");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0000-1");
			Assert.AreEqual (27, queue.Count, "Dequeue-0000-2");
			Assert.AreEqual ("3378afe8-5a2a-4f30-aedd-fa146880f93e", item.Guid.ToString (), "Dequeue-0000-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0000-4");

			item = list [23];
			Assert.IsNotNull (item, "Disable-0018-1");
			Assert.AreEqual ("c210ae2b-0c3d-4257-848d-f21ee48c02cc", item.Guid.ToString(), "Disable-0018-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0018-3");
			item.Disabled = true;

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0001-1");
			Assert.AreEqual (26, queue.Count, "Dequeue-0001-2");
			Assert.AreEqual ("e290608d-7086-41a6-a87a-3f3051c14780", item.Guid.ToString (), "Dequeue-0001-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0001-4");

			item = list [26];
			Assert.IsNotNull (item, "Disable-0019-1");
			Assert.AreEqual ("e8b43015-cc9b-4cad-a881-faead4f18aa3", item.Guid.ToString(), "Disable-0019-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0019-3");
			item.Disabled = true;

			Assert.AreEqual (26, queue.Count, "Queue size after sequence");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0002-1");
			Assert.AreEqual (25, queue.Count, "Dequeue-0002-2");
			Assert.AreEqual ("f374c3d0-06a5-4b0d-8fb5-f0e94a876847", item.Guid.ToString (), "Dequeue-0002-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0002-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0003-1");
			Assert.AreEqual (24, queue.Count, "Dequeue-0003-2");
			Assert.AreEqual ("94cc61f5-312e-4d03-8d56-4e8b400f8ca0", item.Guid.ToString (), "Dequeue-0003-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0003-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0004-1");
			Assert.AreEqual (23, queue.Count, "Dequeue-0004-2");
			Assert.AreEqual ("2d354d5c-8996-4932-ba5f-cd3591fe95cb", item.Guid.ToString (), "Dequeue-0004-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0004-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0005-1");
			Assert.AreEqual (22, queue.Count, "Dequeue-0005-2");
			Assert.AreEqual ("93a0e663-0354-4301-ac27-9e782091f661", item.Guid.ToString (), "Dequeue-0005-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0005-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0006-1");
			Assert.AreEqual (21, queue.Count, "Dequeue-0006-2");
			Assert.AreEqual ("817d3f42-bf7b-4a13-90bc-1895cafe2d23", item.Guid.ToString (), "Dequeue-0006-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0006-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0007-1");
			Assert.AreEqual (20, queue.Count, "Dequeue-0007-2");
			Assert.AreEqual ("39402800-3c1e-478c-8bdc-571d902e32a7", item.Guid.ToString (), "Dequeue-0007-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0007-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0008-1");
			Assert.AreEqual (19, queue.Count, "Dequeue-0008-2");
			Assert.AreEqual ("b45b3bd3-d55d-4c41-b9da-150c19ec0856", item.Guid.ToString (), "Dequeue-0008-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0008-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0009-1");
			Assert.AreEqual (18, queue.Count, "Dequeue-0009-2");
			Assert.AreEqual ("f7e86ec2-dc06-484f-81ed-df4373fff95b", item.Guid.ToString (), "Dequeue-0009-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0009-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0010-1");
			Assert.AreEqual (17, queue.Count, "Dequeue-0010-2");
			Assert.AreEqual ("ad6319f5-27bc-4444-9eb8-1320009ab184", item.Guid.ToString (), "Dequeue-0010-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0010-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0011-1");
			Assert.AreEqual (16, queue.Count, "Dequeue-0011-2");
			Assert.AreEqual ("7b0fb8c1-9642-4854-b979-7e223a092a3d", item.Guid.ToString (), "Dequeue-0011-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0011-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0012-1");
			Assert.AreEqual (15, queue.Count, "Dequeue-0012-2");
			Assert.AreEqual ("414bdd0b-ab30-4d61-aef2-2d34fd929ed2", item.Guid.ToString (), "Dequeue-0012-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0012-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0013-1");
			Assert.AreEqual (14, queue.Count, "Dequeue-0013-2");
			Assert.AreEqual ("c210ae2b-0c3d-4257-848d-f21ee48c02cc", item.Guid.ToString (), "Dequeue-0013-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0013-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0014-1");
			Assert.AreEqual (13, queue.Count, "Dequeue-0014-2");
			Assert.AreEqual ("e8b43015-cc9b-4cad-a881-faead4f18aa3", item.Guid.ToString (), "Dequeue-0014-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0014-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0015-1");
			Assert.AreEqual (12, queue.Count, "Dequeue-0015-2");
			Assert.AreEqual ("3866994b-3be5-4408-9077-529fe701d3f3", item.Guid.ToString (), "Dequeue-0015-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0015-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0016-1");
			Assert.AreEqual (11, queue.Count, "Dequeue-0016-2");
			Assert.AreEqual ("33191cc7-c1b4-4726-b428-64efb69a6c46", item.Guid.ToString (), "Dequeue-0016-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0016-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0017-1");
			Assert.AreEqual (10, queue.Count, "Dequeue-0017-2");
			Assert.AreEqual ("88bee6f1-09ac-4af2-9bc3-ebd619009377", item.Guid.ToString (), "Dequeue-0017-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0017-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0018-1");
			Assert.AreEqual (9, queue.Count, "Dequeue-0018-2");
			Assert.AreEqual ("986174eb-da85-4a7b-9919-cd0668db69bf", item.Guid.ToString (), "Dequeue-0018-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0018-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0019-1");
			Assert.AreEqual (8, queue.Count, "Dequeue-0019-2");
			Assert.AreEqual ("3c5fd8ab-a611-4bfb-afb0-5acee9b45dda", item.Guid.ToString (), "Dequeue-0019-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0019-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0020-1");
			Assert.AreEqual (7, queue.Count, "Dequeue-0020-2");
			Assert.AreEqual ("feebc79b-1867-42c9-a966-bbb448d78a44", item.Guid.ToString (), "Dequeue-0020-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0020-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0021-1");
			Assert.AreEqual (6, queue.Count, "Dequeue-0021-2");
			Assert.AreEqual ("474193d1-4fd9-4b06-873a-e575744957a4", item.Guid.ToString (), "Dequeue-0021-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0021-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0022-1");
			Assert.AreEqual (5, queue.Count, "Dequeue-0022-2");
			Assert.AreEqual ("66bc962f-bf18-48a4-8164-722a5f53d211", item.Guid.ToString (), "Dequeue-0022-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0022-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0023-1");
			Assert.AreEqual (4, queue.Count, "Dequeue-0023-2");
			Assert.AreEqual ("9096d210-ed15-4d38-9af2-26e59b0b8be0", item.Guid.ToString (), "Dequeue-0023-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0023-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0024-1");
			Assert.AreEqual (3, queue.Count, "Dequeue-0024-2");
			Assert.AreEqual ("4e49dc65-2c6a-4b2f-97e2-9cf09175c57a", item.Guid.ToString (), "Dequeue-0024-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0024-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0025-1");
			Assert.AreEqual (2, queue.Count, "Dequeue-0025-2");
			Assert.AreEqual ("417fc6e2-b9ae-40eb-906b-6e41b306a908", item.Guid.ToString (), "Dequeue-0025-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0025-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0026-1");
			Assert.AreEqual (1, queue.Count, "Dequeue-0026-2");
			Assert.AreEqual ("ac9cefe3-3331-4ee2-b0f1-69aaca2a955d", item.Guid.ToString (), "Dequeue-0026-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0026-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0027-1");
			Assert.AreEqual (0, queue.Count, "Dequeue-0027-2");
			Assert.AreEqual ("ae852a56-e081-4ee7-b360-81d4ba1a2000", item.Guid.ToString (), "Dequeue-0027-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0027-4");

		}

		[Test (Description="Generated from sequence file cache_pq_sequence_2010-02-03_01:07:55.seq")]
		public void Sequence_0004 ()
		{
			var list = new List <CacheItem> {
				new CacheItem {Key = "PartialCachingControl\nGUID: f11febcc-d445-4036-bb93-aa3932ceb4ef\n", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:06:39 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("2/3/2010 2:06:34 AM"), ExpiresAt = 634007595994690560, Disabled = false, Guid = new Guid ("757dc15a-3340-4704-9292-17f3004e2ee5")}, 
				new CacheItem {Key = "@@@InProc@B748F7C2AA1F04BCF40EAB40", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:26:34 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("2/3/2010 2:06:34 AM"), ExpiresAt = 634007607944742000, Disabled = false, Guid = new Guid ("a4778103-c8e9-4304-90db-3f54b718e50a")}, 
				new CacheItem {Key = "@@@InProc@B748F7C2AA1F04BCF40EAB40", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:26:34 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("2/3/2010 2:06:34 AM"), ExpiresAt = 634007607944758990, Disabled = false, Guid = new Guid ("246d4b59-6748-4bef-8f78-5b081b0686f1")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:06:42 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("2/3/2010 2:06:34 AM"), ExpiresAt = 634007596029748620, Disabled = false, Guid = new Guid ("46616129-bd8d-402b-954f-a05944535e23")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:06:42 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("2/3/2010 2:06:34 AM"), ExpiresAt = 634007596029748620, Disabled = false, Guid = new Guid ("f85a0942-6f20-4f71-ae57-3b2669052460")}, 
				new CacheItem {Key = "PartialCachingControl\nGUID: f11febcc-d445-4036-bb93-aa3932ceb4ef\n", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:06:58 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("2/3/2010 2:06:53 AM"), ExpiresAt = 634007596187154840, Disabled = false, Guid = new Guid ("e8b1f7d4-a874-4b56-84ce-1434a72f9d35")}, 
				new CacheItem {Key = "@@@InProc@B748F7C2AA1F04BCF40EAB40", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:26:53 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("2/3/2010 2:06:53 AM"), ExpiresAt = 634007608137155850, Disabled = false, Guid = new Guid ("bc16a289-5ce4-436f-9791-1885f033bc6e")}, 
				new CacheItem {Key = "@@@InProc@B748F7C2AA1F04BCF40EAB40", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:26:53 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("2/3/2010 2:06:53 AM"), ExpiresAt = 634007608137156090, Disabled = false, Guid = new Guid ("f6651f9b-36fd-481d-bb31-8abc3d110a45")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:07:03 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("2/3/2010 2:06:53 AM"), ExpiresAt = 634007596237139120, Disabled = false, Guid = new Guid ("226ef04f-1118-4225-abe1-43d6e228db95")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:07:03 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("2/3/2010 2:06:53 AM"), ExpiresAt = 634007596237139120, Disabled = false, Guid = new Guid ("9df2ed49-168b-4769-8d9e-7f963e62123c")}, 
				new CacheItem {Key = "PartialCachingControl\nGUID: f11febcc-d445-4036-bb93-aa3932ceb4ef\n", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:07:30 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("2/3/2010 2:07:25 AM"), ExpiresAt = 634007596504393570, Disabled = false, Guid = new Guid ("30952e54-d94b-450d-b1ff-5e74c66bb4f5")}, 
				new CacheItem {Key = "@@@InProc@B748F7C2AA1F04BCF40EAB40", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:27:25 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("2/3/2010 2:07:25 AM"), ExpiresAt = 634007608454399100, Disabled = false, Guid = new Guid ("e50d5a73-7861-412b-b9ad-924c13c2e9c5")}, 
				new CacheItem {Key = "@@@InProc@B748F7C2AA1F04BCF40EAB40", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:27:25 AM"), SlidingExpiration = TimeSpan.Parse ("00:20:00"), Priority = CacheItemPriority.AboveNormal, LastChange = DateTime.Parse ("2/3/2010 2:07:25 AM"), ExpiresAt = 634007608454399320, Disabled = false, Guid = new Guid ("631452f5-a8e5-483e-a0ac-9c3f7abd37a1")}, 
				new CacheItem {Key = "@InMemoryOCP_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:07:35 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("2/3/2010 2:07:25 AM"), ExpiresAt = 634007596554387900, Disabled = false, Guid = new Guid ("01a63c0e-5963-4eac-8b0e-b1b2ea508098")}, 
				new CacheItem {Key = "@prefix@_vbk/default.aspxGETWQFH", AbsoluteExpiration = DateTime.Parse ("2/3/2010 2:07:35 AM"), SlidingExpiration = TimeSpan.Parse ("00:00:00"), Priority = CacheItemPriority.Normal, LastChange = DateTime.Parse ("2/3/2010 2:07:25 AM"), ExpiresAt = 634007596554387900, Disabled = false, Guid = new Guid ("9e38cf23-6785-49e8-9922-8e1c1d86a205")}, 
			};
			var queue = new CacheItemPriorityQueue ();
			CacheItem item;

			queue.Enqueue (list [0]);
			Assert.AreEqual (1, queue.Count, "Enqueue-0000-1");
			Assert.AreEqual ("757dc15a-3340-4704-9292-17f3004e2ee5", queue.Peek ().Guid.ToString(), "Enqueue-0000-2");

			queue.Enqueue (list [1]);
			Assert.AreEqual (2, queue.Count, "Enqueue-0001-1");
			Assert.AreEqual ("757dc15a-3340-4704-9292-17f3004e2ee5", queue.Peek ().Guid.ToString(), "Enqueue-0001-2");

			item = list [1];
			Assert.IsNotNull (item, "Disable-0000-1");
			Assert.AreEqual ("a4778103-c8e9-4304-90db-3f54b718e50a", item.Guid.ToString(), "Disable-0000-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0000-3");
			item.Disabled = true;

			queue.Enqueue (list [2]);
			Assert.AreEqual (3, queue.Count, "Enqueue-0002-1");
			Assert.AreEqual ("757dc15a-3340-4704-9292-17f3004e2ee5", queue.Peek ().Guid.ToString(), "Enqueue-0002-2");

			queue.Enqueue (list [3]);
			Assert.AreEqual (4, queue.Count, "Enqueue-0003-1");
			Assert.AreEqual ("757dc15a-3340-4704-9292-17f3004e2ee5", queue.Peek ().Guid.ToString(), "Enqueue-0003-2");

			queue.Enqueue (list [4]);
			Assert.AreEqual (5, queue.Count, "Enqueue-0004-1");
			Assert.AreEqual ("757dc15a-3340-4704-9292-17f3004e2ee5", queue.Peek ().Guid.ToString(), "Enqueue-0004-2");

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0000-1");
			Assert.AreEqual (5, queue.Count, "Peek-0000-2");
			Assert.AreEqual ("757dc15a-3340-4704-9292-17f3004e2ee5", item.Guid.ToString (), "Peek-0000-3");
			Assert.AreEqual (false, item.Disabled, "Peek-0000-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0000-1");
			Assert.AreEqual (4, queue.Count, "Dequeue-0000-2");
			Assert.AreEqual ("757dc15a-3340-4704-9292-17f3004e2ee5", item.Guid.ToString (), "Dequeue-0000-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0000-4");

			item = list [0];
			Assert.IsNotNull (item, "Disable-0001-1");
			Assert.AreEqual ("757dc15a-3340-4704-9292-17f3004e2ee5", item.Guid.ToString(), "Disable-0001-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0001-3");
			item.Disabled = true;

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0001-1");
			Assert.AreEqual (4, queue.Count, "Peek-0001-2");
			Assert.AreEqual ("f85a0942-6f20-4f71-ae57-3b2669052460", item.Guid.ToString (), "Peek-0001-3");
			Assert.AreEqual (false, item.Disabled, "Peek-0001-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0001-1");
			Assert.AreEqual (3, queue.Count, "Dequeue-0001-2");
			Assert.AreEqual ("f85a0942-6f20-4f71-ae57-3b2669052460", item.Guid.ToString (), "Dequeue-0001-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0001-4");

			item = list [4];
			Assert.IsNotNull (item, "Disable-0002-1");
			Assert.AreEqual ("f85a0942-6f20-4f71-ae57-3b2669052460", item.Guid.ToString(), "Disable-0002-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0002-3");
			item.Disabled = true;

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0002-1");
			Assert.AreEqual (3, queue.Count, "Peek-0002-2");
			Assert.AreEqual ("46616129-bd8d-402b-954f-a05944535e23", item.Guid.ToString (), "Peek-0002-3");
			Assert.AreEqual (false, item.Disabled, "Peek-0002-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0002-1");
			Assert.AreEqual (2, queue.Count, "Dequeue-0002-2");
			Assert.AreEqual ("46616129-bd8d-402b-954f-a05944535e23", item.Guid.ToString (), "Dequeue-0002-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0002-4");

			item = list [3];
			Assert.IsNotNull (item, "Disable-0003-1");
			Assert.AreEqual ("46616129-bd8d-402b-954f-a05944535e23", item.Guid.ToString(), "Disable-0003-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0003-3");
			item.Disabled = true;

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0003-1");
			Assert.AreEqual (2, queue.Count, "Peek-0003-2");
			Assert.AreEqual ("a4778103-c8e9-4304-90db-3f54b718e50a", item.Guid.ToString (), "Peek-0003-3");
			Assert.AreEqual (true, item.Disabled, "Peek-0003-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0003-1");
			Assert.AreEqual (1, queue.Count, "Dequeue-0003-2");
			Assert.AreEqual ("a4778103-c8e9-4304-90db-3f54b718e50a", item.Guid.ToString (), "Dequeue-0003-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0003-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0004-1");
			Assert.AreEqual (0, queue.Count, "Dequeue-0004-2");
			Assert.AreEqual ("246d4b59-6748-4bef-8f78-5b081b0686f1", item.Guid.ToString (), "Dequeue-0004-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0004-4");

			queue.Enqueue (list [5]);
			Assert.AreEqual (1, queue.Count, "Enqueue-0005-1");
			Assert.AreEqual ("e8b1f7d4-a874-4b56-84ce-1434a72f9d35", queue.Peek ().Guid.ToString(), "Enqueue-0005-2");

			item = list [2];
			Assert.IsNotNull (item, "Disable-0004-1");
			Assert.AreEqual ("246d4b59-6748-4bef-8f78-5b081b0686f1", item.Guid.ToString(), "Disable-0004-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0004-3");
			item.Disabled = true;

			queue.Enqueue (list [6]);
			Assert.AreEqual (2, queue.Count, "Enqueue-0006-1");
			Assert.AreEqual ("e8b1f7d4-a874-4b56-84ce-1434a72f9d35", queue.Peek ().Guid.ToString(), "Enqueue-0006-2");

			item = list [6];
			Assert.IsNotNull (item, "Disable-0005-1");
			Assert.AreEqual ("bc16a289-5ce4-436f-9791-1885f033bc6e", item.Guid.ToString(), "Disable-0005-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0005-3");
			item.Disabled = true;

			queue.Enqueue (list [7]);
			Assert.AreEqual (3, queue.Count, "Enqueue-0007-1");
			Assert.AreEqual ("e8b1f7d4-a874-4b56-84ce-1434a72f9d35", queue.Peek ().Guid.ToString(), "Enqueue-0007-2");

			queue.Enqueue (list [8]);
			Assert.AreEqual (4, queue.Count, "Enqueue-0008-1");
			Assert.AreEqual ("e8b1f7d4-a874-4b56-84ce-1434a72f9d35", queue.Peek ().Guid.ToString(), "Enqueue-0008-2");

			queue.Enqueue (list [9]);
			Assert.AreEqual (5, queue.Count, "Enqueue-0009-1");
			Assert.AreEqual ("e8b1f7d4-a874-4b56-84ce-1434a72f9d35", queue.Peek ().Guid.ToString(), "Enqueue-0009-2");

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0004-1");
			Assert.AreEqual (5, queue.Count, "Peek-0004-2");
			Assert.AreEqual ("e8b1f7d4-a874-4b56-84ce-1434a72f9d35", item.Guid.ToString (), "Peek-0004-3");
			Assert.AreEqual (false, item.Disabled, "Peek-0004-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0005-1");
			Assert.AreEqual (4, queue.Count, "Dequeue-0005-2");
			Assert.AreEqual ("e8b1f7d4-a874-4b56-84ce-1434a72f9d35", item.Guid.ToString (), "Dequeue-0005-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0005-4");

			item = list [5];
			Assert.IsNotNull (item, "Disable-0006-1");
			Assert.AreEqual ("e8b1f7d4-a874-4b56-84ce-1434a72f9d35", item.Guid.ToString(), "Disable-0006-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0006-3");
			item.Disabled = true;

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0005-1");
			Assert.AreEqual (4, queue.Count, "Peek-0005-2");
			Assert.AreEqual ("9df2ed49-168b-4769-8d9e-7f963e62123c", item.Guid.ToString (), "Peek-0005-3");
			Assert.AreEqual (false, item.Disabled, "Peek-0005-4");

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0006-1");
			Assert.AreEqual (4, queue.Count, "Peek-0006-2");
			Assert.AreEqual ("9df2ed49-168b-4769-8d9e-7f963e62123c", item.Guid.ToString (), "Peek-0006-3");
			Assert.AreEqual (false, item.Disabled, "Peek-0006-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0006-1");
			Assert.AreEqual (3, queue.Count, "Dequeue-0006-2");
			Assert.AreEqual ("9df2ed49-168b-4769-8d9e-7f963e62123c", item.Guid.ToString (), "Dequeue-0006-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0006-4");

			item = list [9];
			Assert.IsNotNull (item, "Disable-0007-1");
			Assert.AreEqual ("9df2ed49-168b-4769-8d9e-7f963e62123c", item.Guid.ToString(), "Disable-0007-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0007-3");
			item.Disabled = true;

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0007-1");
			Assert.AreEqual (3, queue.Count, "Peek-0007-2");
			Assert.AreEqual ("226ef04f-1118-4225-abe1-43d6e228db95", item.Guid.ToString (), "Peek-0007-3");
			Assert.AreEqual (false, item.Disabled, "Peek-0007-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0007-1");
			Assert.AreEqual (2, queue.Count, "Dequeue-0007-2");
			Assert.AreEqual ("226ef04f-1118-4225-abe1-43d6e228db95", item.Guid.ToString (), "Dequeue-0007-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0007-4");

			item = list [8];
			Assert.IsNotNull (item, "Disable-0008-1");
			Assert.AreEqual ("226ef04f-1118-4225-abe1-43d6e228db95", item.Guid.ToString(), "Disable-0008-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0008-3");
			item.Disabled = true;

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0008-1");
			Assert.AreEqual (2, queue.Count, "Peek-0008-2");
			Assert.AreEqual ("bc16a289-5ce4-436f-9791-1885f033bc6e", item.Guid.ToString (), "Peek-0008-3");
			Assert.AreEqual (true, item.Disabled, "Peek-0008-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0008-1");
			Assert.AreEqual (1, queue.Count, "Dequeue-0008-2");
			Assert.AreEqual ("bc16a289-5ce4-436f-9791-1885f033bc6e", item.Guid.ToString (), "Dequeue-0008-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0008-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0009-1");
			Assert.AreEqual (0, queue.Count, "Dequeue-0009-2");
			Assert.AreEqual ("f6651f9b-36fd-481d-bb31-8abc3d110a45", item.Guid.ToString (), "Dequeue-0009-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0009-4");

			queue.Enqueue (list [10]);
			Assert.AreEqual (1, queue.Count, "Enqueue-0010-1");
			Assert.AreEqual ("30952e54-d94b-450d-b1ff-5e74c66bb4f5", queue.Peek ().Guid.ToString(), "Enqueue-0010-2");

			item = list [7];
			Assert.IsNotNull (item, "Disable-0009-1");
			Assert.AreEqual ("f6651f9b-36fd-481d-bb31-8abc3d110a45", item.Guid.ToString(), "Disable-0009-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0009-3");
			item.Disabled = true;

			queue.Enqueue (list [11]);
			Assert.AreEqual (2, queue.Count, "Enqueue-0011-1");
			Assert.AreEqual ("30952e54-d94b-450d-b1ff-5e74c66bb4f5", queue.Peek ().Guid.ToString(), "Enqueue-0011-2");

			item = list [11];
			Assert.IsNotNull (item, "Disable-0010-1");
			Assert.AreEqual ("e50d5a73-7861-412b-b9ad-924c13c2e9c5", item.Guid.ToString(), "Disable-0010-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0010-3");
			item.Disabled = true;

			queue.Enqueue (list [12]);
			Assert.AreEqual (3, queue.Count, "Enqueue-0012-1");
			Assert.AreEqual ("30952e54-d94b-450d-b1ff-5e74c66bb4f5", queue.Peek ().Guid.ToString(), "Enqueue-0012-2");

			queue.Enqueue (list [13]);
			Assert.AreEqual (4, queue.Count, "Enqueue-0013-1");
			Assert.AreEqual ("30952e54-d94b-450d-b1ff-5e74c66bb4f5", queue.Peek ().Guid.ToString(), "Enqueue-0013-2");

			queue.Enqueue (list [14]);
			Assert.AreEqual (5, queue.Count, "Enqueue-0014-1");
			Assert.AreEqual ("30952e54-d94b-450d-b1ff-5e74c66bb4f5", queue.Peek ().Guid.ToString(), "Enqueue-0014-2");

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0009-1");
			Assert.AreEqual (5, queue.Count, "Peek-0009-2");
			Assert.AreEqual ("30952e54-d94b-450d-b1ff-5e74c66bb4f5", item.Guid.ToString (), "Peek-0009-3");
			Assert.AreEqual (false, item.Disabled, "Peek-0009-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0010-1");
			Assert.AreEqual (4, queue.Count, "Dequeue-0010-2");
			Assert.AreEqual ("30952e54-d94b-450d-b1ff-5e74c66bb4f5", item.Guid.ToString (), "Dequeue-0010-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0010-4");

			item = list [10];
			Assert.IsNotNull (item, "Disable-0011-1");
			Assert.AreEqual ("30952e54-d94b-450d-b1ff-5e74c66bb4f5", item.Guid.ToString(), "Disable-0011-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0011-3");
			item.Disabled = true;

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0010-1");
			Assert.AreEqual (4, queue.Count, "Peek-0010-2");
			Assert.AreEqual ("9e38cf23-6785-49e8-9922-8e1c1d86a205", item.Guid.ToString (), "Peek-0010-3");
			Assert.AreEqual (false, item.Disabled, "Peek-0010-4");

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0011-1");
			Assert.AreEqual (4, queue.Count, "Peek-0011-2");
			Assert.AreEqual ("9e38cf23-6785-49e8-9922-8e1c1d86a205", item.Guid.ToString (), "Peek-0011-3");
			Assert.AreEqual (false, item.Disabled, "Peek-0011-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0011-1");
			Assert.AreEqual (3, queue.Count, "Dequeue-0011-2");
			Assert.AreEqual ("9e38cf23-6785-49e8-9922-8e1c1d86a205", item.Guid.ToString (), "Dequeue-0011-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0011-4");

			item = list [14];
			Assert.IsNotNull (item, "Disable-0012-1");
			Assert.AreEqual ("9e38cf23-6785-49e8-9922-8e1c1d86a205", item.Guid.ToString(), "Disable-0012-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0012-3");
			item.Disabled = true;

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0012-1");
			Assert.AreEqual (3, queue.Count, "Peek-0012-2");
			Assert.AreEqual ("01a63c0e-5963-4eac-8b0e-b1b2ea508098", item.Guid.ToString (), "Peek-0012-3");
			Assert.AreEqual (false, item.Disabled, "Peek-0012-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0012-1");
			Assert.AreEqual (2, queue.Count, "Dequeue-0012-2");
			Assert.AreEqual ("01a63c0e-5963-4eac-8b0e-b1b2ea508098", item.Guid.ToString (), "Dequeue-0012-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0012-4");

			item = list [13];
			Assert.IsNotNull (item, "Disable-0013-1");
			Assert.AreEqual ("01a63c0e-5963-4eac-8b0e-b1b2ea508098", item.Guid.ToString(), "Disable-0013-3");
			Assert.AreEqual (false, item.Disabled, "Disable-0013-3");
			item.Disabled = true;

			item = queue.Peek ();
			Assert.IsNotNull (item, "Peek-0013-1");
			Assert.AreEqual (2, queue.Count, "Peek-0013-2");
			Assert.AreEqual ("e50d5a73-7861-412b-b9ad-924c13c2e9c5", item.Guid.ToString (), "Peek-0013-3");
			Assert.AreEqual (true, item.Disabled, "Peek-0013-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0013-1");
			Assert.AreEqual (1, queue.Count, "Dequeue-0013-2");
			Assert.AreEqual ("e50d5a73-7861-412b-b9ad-924c13c2e9c5", item.Guid.ToString (), "Dequeue-0013-3");
			Assert.AreEqual (true, item.Disabled, "Dequeue-0013-4");

			item = queue.Dequeue ();
			Assert.IsNotNull (item, "Dequeue-0014-1");
			Assert.AreEqual (0, queue.Count, "Dequeue-0014-2");
			Assert.AreEqual ("631452f5-a8e5-483e-a0ac-9c3f7abd37a1", item.Guid.ToString (), "Dequeue-0014-3");
			Assert.AreEqual (false, item.Disabled, "Dequeue-0014-4");

			Assert.AreEqual (0, queue.Count, "Queue size after sequence");

		}
	}
}
#endif

