/*
 * Copyright (C) 2013 Tobias Lorenz.
 * Contact: tobias.lorenz@gmx.net
 *
 * This file is part of Tobias Lorenz's Toolkit.
 *
 * Commercial License Usage
 * Licensees holding valid commercial licenses may use this file in
 * accordance with the commercial license agreement provided with the
 * Software or, alternatively, in accordance with the terms contained in
 * a written agreement between you and Tobias Lorenz.
 *
 * GNU General Public License 3.0 Usage
 * Alternatively, this file may be used under the terms of the GNU
 * General Public License version 3.0 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.  Please review the following information to
 * ensure the GNU General Public License version 3.0 requirements will be
 * met: http://www.gnu.org/copyleft/gpl.html.
 */

#pragma once

#include <Vector/BLF/platform.h>

#include <vector>

#include <Vector/BLF/AbstractFile.h>
#include <Vector/BLF/ObjectHeader2.h>
#include <Vector/BLF/VectorTypes.h>

#include <Vector/BLF/vector_blf_export.h>

namespace Vector {
namespace BLF {

/**
 * @brief MOST_PKT2
 *
 * Message on MOST25 Packet Data Channel.
 */
struct VECTOR_BLF_EXPORT MostPkt2 final : ObjectHeader2 {
    MostPkt2();

    void read(AbstractFile & is) override;
    void write(AbstractFile & os) override;
    DWORD calculateObjectSize() const override;

    /**
     * @brief application channel
     *
     * Application channel
     */
    WORD channel {};

    /**
     * Direction of message events:
     *   - 0: Rx (received)
     *   - 1: Tx (transmit receipt)
     *   - 2: Tx Request (transmit request)
     */
    BYTE dir {};

    /** reserved */
    BYTE reservedMostPkt1 {};

    /**
     * Source address
     */
    DWORD sourceAdr {};

    /**
     * Target address
     */
    DWORD destAdr {};

    /**
     * Arbitration byte
     */
    BYTE arbitration {};

    /**
     * Obsolete member; read/write 0
     */
    BYTE timeRes {};

    /**
     * Number of quadlets
     */
    BYTE quadsToFollow {};

    /** reserved */
    BYTE reservedMostPkt2 {};

    /**
     * Cyclic Redundancy Check
     */
    WORD crc {};

    /**
     * Priority
     */
    BYTE priority {};

    /**
     * @brief Tranfer Type
     *
     * Message-like events can either be recorded through the MOST transceiver chip or through a
     * separate network spy.
     *   - 1: Node
     *     MOST transceiver reported the message (either due to a successful reception or
     *     as acknowledgment for a transmit request).
     *   - 2: Spy
     *     Message was reported by the network spy. The Spy sees all messages
     *     independently of the desti-nation address.
     */
    BYTE transferType {};

    /**
     * Transmission state
     *   - 0 for Rx
     *   - 0x40 for TxOk (transmit request)
     */
    BYTE state {};

    /** reserved */
    BYTE reservedMostPkt3 {};

    /** reserved */
    WORD reservedMostPkt4 {};

    /**
     * @brief length of variable data in bytes
     *
     * Length of variable data in bytes (1014 max)
     */
    DWORD pktDataLength {};

    /** reserved */
    DWORD reservedMostPkt5 {};

    /**
     * @brief variable data
     *
     * Variable data
     */
    std::vector<uint8_t> pktData {};
};

}
}
