# 소개

**IBS**는 부동산 개발(시행) 프로젝트를 운영하면서 필요한 예산(입출금), 분양(계약), 기타 문서관리 등을 위한 프로그램입니다.

## 왜 IBS를 사용하나요?

부동산개발(시행) 프로젝트를 진행하기 위해서 공동주택, 주상복합, 오피스텔, 상가, 숙박시설 등 여러 유형의 상품들을 관리해야 합니다. 또한 세분화 된 여러 타입 및 옵션에 따른 다양한 상품의 형태와 계약
조건, 옵션 등을 모두 반영하여 관리 하는 것은 쉽지 않습니다.

이처럼 부동산개발 프로젝트는 복잡한 상품 유형을 일반분양, 조합원 모집 등 다양한 형태의 방식으로 시행되며, 이 경우 동일한 종류의 데이터라도 관리방법이나 프로세스가 다양화 되어 이를 통해 생산되는
데이터를 효과적으로 관리하는 것은 더욱 어렵습니다.

부동산개발 프로젝트를 진행 하면서 효과적인 데이터 관리는 매우 중요합니다. 하지만 그 이전에, 고도의 전문성을 요하는 상품 디자인, 사업 수행 기간을 고려한 타이밍과 시장 수요에 대한 예측, 인허가와 관련한
각종 법률적인 사항, 토지 매입과 대규모 자금 조달 등 기획 단계에서부터 고려 해야할 중요한 사안들이 매우 많습니다. 이런 일들은 사업의 성패를 좌우할 만큼 중요한 사안들입니다.

**IBS**는 부동산개발 프로젝트를 시행하는 운영자가 이 같은 상황에서 더 중요한 일에 집중할 수 있도록, 사업을 수행하면서 생산되는 데이터를 **정확하고 편리하게 관리하고, 쉽게 열람**할 수 있도록 설계
되었으며 이를 구현하기 위해서 실제 프로젝트를 수행하면서 지속적으로 그 기능을 개선해 오고 있습니다.

## 주요 기능

- 프로젝트 등록 및 종류, 특징에 따른 상세 설정 지원
    - 계약 그룹, 유닛 타입, 층별 타입, 동/호 등록 관리
    - 계약 방법(계약 금액) 및 전체 납부 회차 등록 관리
    - 그룹별, 타입별, 층별 공급 대금(분양가) 등록 관리
    - 사업 부지, 소유자 목록 및 매입 계약 체결 관리
- 계약 및 계약 고객 등록 관리, 다양한 현황 집계
- 판매 상품 유닛과 계약 고객의 1:1 매칭 등록 관리
- 일반 입출금 회계 관리 및 고객 대금 수납과 연동 관리
- 고객 납부 대금 수납 관리 및 사업 예산과 연동 관리
- 사업 예산 관리 및 PJ 진행 상황에 따른 예산 대비 집계
- 본사 및 프로젝트 문서 관리 및 소송 사건 관리

각각의 단원에서 위 기능들에 대한 자세한 정보를 찾을 수 있습니다. 프로그램의 설치 및 대략적인 기능에 대한 훑어보기는
[시작하기](/intro/getting-started) 를 참고하세요.

## 왜 IBS인가?

IBS는 _**I**ntelligent **B**uild **S**ystem :: Project Developer_ 의 약어입니다.

부동산개발 프로젝트는 사람이 살아가는 공간이자 환경을 디자인하고 빌드하는 작업이기도 합니다. 산업 기술과 문화가 고도로 발달하고 있는 지금 이 시대는 물론 먼 미래에 기술과 문화가 더욱 발달하여 세대가 바뀐다고 해도
사람이 살아가는 이상 이 작업의 중요성은 줄어들지 않을 것입니다. 오히려 더 고도화 하고 발전하며 경쟁하게 될 것입니다.

**IBS**는 부동산 개발(시행) 프로젝트를 운영하는 디벨로퍼가 프로젝트를 관리하고 수행하는 데 다양한 이점을 제공함으로서 더 좋은 상품과 공간을 개발하고 빌드하기 위한 아이디어와 역량을 발휘할 수 있도록 도움을
주는 툴이 되기 위해서 지속적으로 시스템을 구축하고 업데이트 할 것입니다.
