export interface BankCode {
  pk: number
  code: string
  name: string
}

export interface AccountSort {
  pk: number
  name: string
  accounts: number[]
}

export interface AccountD1 {
  pk: number
  sorts: number[]
  code: string
  name: string
  description: string
}

export interface AccountD2 {
  pk: number
  d1: number
  code: string
  name: string
  description: string
}

export interface AccountD3 {
  pk: number
  d2: number
  code: string
  name: string
  description: string
  is_hide: boolean
  is_special: boolean
}

export interface CompanyBank {
  pk?: number
  company?: number
  depart: number | null
  bankcode: number | null
  alias_name: string
  number: string
  holder: string
  open_date: string | null
  note: string
  is_hide: boolean
  inactive: boolean
  balance?: number
}

export interface BalanceByAccount {
  bank_acc: string
  bank_num: string
  date_inc: number
  date_out: number
  inc_sum: number | null
  out_sum: number | null
}

export interface CashBook {
  pk: number | null
  company: number | null
  sort: number | null
  sort_desc?: string
  account_d1: number | null
  account_d1_desc?: string
  account_d2: number | null
  account_d2_desc?: string
  account_d3: number | null
  account_d3_desc?: string
  project: number | null
  project_desc?: string | null
  is_return: boolean
  is_separate: boolean
  separated: number | null
  sepItems?: SepItems[]
  content: string
  trader: string
  bank_account: number | null
  bank_account_desc?: string
  income?: number | null
  outlay?: number | null
  evidence: '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | ''
  evidence_desc?: string
  note: string
  deal_date: string
}

export interface SepItems {
  pk: number | null
  account_d1: number | null
  account_d2: number | null
  account_d3: number | null
  project: number | null
  is_return: boolean
  separated?: number | null
  content: string
  trader: string
  income?: number | null
  outlay?: number | null
  evidence: '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | ''
  note: string
}

export interface ComCalculated {
  pk?: number
  company: number
  calculated: string
  user?: { pk: number; username: string }
}
