# WPF Roadmap 
WPF is a .NET Core UI framework for building Windows desktop applications. WPF is currently supported on the below versions of .NET:
- .NET Core: .NET 5 or higher (including .NET Core 3.1)
- .NET Framework: NET Framework 4 and higher

[.NET CORE Roadmap](https://github.com/dotnet/core/blob/main/roadmap.md)


The roadmap below communicates priorities for evolving and extending the scope of WPF for .NET Core through 2021 and into 2022. It will continue to evolve based on market changes and customer feedback, so please note that the plans outlined here are not exhaustive or guaranteed. We welcome your feedback on the roadmap: please feel free to contribute to existing issues or [file a new issue](https://github.com/dotnet/wpf/issues/new/choose "file a new issue").

### PROPOSED ROADMAP
| #  | Project Title  |  Target Delivery |
| :------------: | :------------: | :------------: |
|1  |Incorporating .NET Framework servicing fixes into .NET Core 3.1, .NET 5 and .NET 6 |Ongoing|
|2  |Performance Improvements |Ongoing|
|3  |Ongoing support and maintenance for .NET Framework, .NET core 3.1, .NET 5.0 and .NET 6.0 |Ongoing|
|4  |Open Sourcing of Test Infrastructure and test collateral|22H1|
|5  |New API review process for Community PRs|22H2|

### Our SLA
#### TRIAGING GITHUB ISSUES
We are committed to 72 Hours (3 working days) timeline for triaging and responding to new issues filed on GitHub according to priority and our resourcing capabilities. Additionally, older issues filed on GitHub are also being triaged. Issues filed in 2021 will be triaged first based on number of likes/reactions/comments. Issues filed before 2021 will be triaged after that based on number of reactions/comments.

#### EVALUATING PULL REQUESTS
We will begin merging contributions from the community on the WPF repo by picking 1-2 PRs from the community to manually test and integrate per month. When the Open Sourcing of Test Infrastructure and test collateral work is completed, we will enable broader community pull request merging. 
#### Code PRs considered at this time will be based on:
-	Recency
-	Extent of Reactions (Likes, comments)
-	Fixes to existing issues prioritized over new features
-	Complexity of the fix
-	Breadth of impact of the fix
-	Low potential for regression
-	Has adequate test coverage
-	Is not a new feature request

#### About non-code PRs
We are committed to a 72 hour (3 working days) turn around on triaging and responding to new non-code PRs filed on GitHub. These are PRs for documentations bugs, documentation enhancements or a general question not related to source code issues/bugs.

### COMMUNITY CALLS
We will host WPF community calls in the existing WinUI calls and will try to do them every two months . In these calls we’ll discuss the WPF roadmap, our status and your feedback.


