# Analytics

Analytics in this app are managed through the [Angulartics2](https://github.com/angulartics/angulartics2) library.

It is already pre-configured to track page views, and provides examples to track events from both TypeScript code and HTML elements.
Here is a quick usage documentation, you can read further information on the official website.

## Registering your provider

Google Analytics is already registered as the project's analytics provider.
Should you need to change the account identifier, you can do so in the call to `ga(...)` performed in the body of `index.html`.

## Tracking events

### Declarative event tracking

The simplest way to do event tracking is by adding the attributes `angulartics2On`, `angularticsCategory` and `angularticsAction` to an HTML element.
The homepage generated by the starter kit contains one such button.
For reference, here is a UI-framework-agnostic example.

```html
<button
  angulartics2On="click"
  angularticsAction="Button clicked"
  [angularticsCategory]="quote">
  Click me to send the current quote as an Analytics event
</button>
```

### Using the API

As an example, the application already comes configured to track its startup through an event.
You may use the example as reference: it can be found in the first lines of `ngOnInit()` in `app.component.ts`.

To access the API, inject your provider :

```typescript
constructor(...
            private angulartics2GoogleAnalytics: Angulartics2GoogleAnalytics,
            ...)
```

You may then use the `eventTrack` function:

```typescript
this.angulartics2GoogleAnalytics.eventTrack('Something happened', {category: 'My category'});
this.angulartics2GoogleAnalytics.eventTrack('Something else happened', {category: 'My other category', label: 'My custom label'});
```
