# I18n

The internationalization of the application is managed by [ngx-translate](https://github.com/ngx-translate/core).

## Adding translatable strings

### In HTML templates

Use the `translate` directive on an HTML element to automatically translate its content:
```html
<span translate>This text will be translated.</span>
```

You can also use the `translate` pipe if needed:
```html
<button title="{{ 'Add item' | translate }}">+</button>
```

### In TypeScript code

If you need to translate strings in JavaScript code, import the `TranslateService` dependency and use the asynchronous
`get()` method:

```typescript
let title;
translateService.get('My page title').subscribe((res: string) => { title = res; });
```

## Extracting strings to translate

Once you are ready to translate your app, just run `npm run translations:extract`.
It will create a `template.json` file in the `src/translations` folder.

You can then use any text or code editor to generate the `.json` files for each of your supported languages, and put
them in the `src/translations` folder.

Do no forget to edit the files in `src/environment` to add the supported languages of your application.

### Marking strings for extraction

If strings are not directly passed to `translateService` or put in HTML templates, they may be missing from the
extraction process.

For these cases, you have to use the dummy `marker()` function:
```typescript
import { marker } from '@biesbjerg/ngx-translate-extract-marker';

function toBeTranslatedLater() {
  return marker('A string to be translated');
}
```

Strings marked like this will then be properly extracted.
