# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2017-01-25 15:54
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import mptt.fields


class Migration(migrations.Migration):

    dependencies = [
        ('domain', '0025_refactoring'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='verbosename',
            options={'verbose_name': 'Verbose name', 'verbose_name_plural': 'Verbose names'},
        ),
        migrations.AddField(
            model_name='attributeentity',
            name='uri_prefix',
            field=models.URLField(blank=True, help_text='The prefix for the URI of this attribute/entity.', max_length=256, null=True, verbose_name='URI Prefix'),
        ),
        migrations.AlterField(
            model_name='attribute',
            name='optionsets',
            field=models.ManyToManyField(blank=True, help_text='Option sets for this attribute.', to='options.OptionSet', verbose_name='Option sets'),
        ),
        migrations.AlterField(
            model_name='attribute',
            name='unit',
            field=models.CharField(blank=True, help_text='Unit of values for this attribute.', max_length=64, null=True, verbose_name='Unit'),
        ),
        migrations.AlterField(
            model_name='attribute',
            name='value_type',
            field=models.CharField(choices=[('text', 'Text'), ('url', 'URL'), ('integer', 'Integer'), ('float', 'Float'), ('boolean', 'Boolean'), ('datetime', 'Datetime'), ('options', 'Options')], help_text='Type of values for this attribute.', max_length=8, verbose_name='Value type'),
        ),
        migrations.AlterField(
            model_name='attributeentity',
            name='comment',
            field=models.TextField(blank=True, help_text='Additional information about this attribute/entity.', null=True, verbose_name='Comment'),
        ),
        migrations.AlterField(
            model_name='attributeentity',
            name='conditions',
            field=models.ManyToManyField(blank=True, help_text='List of conditions evaluated for this attribute/entity.', to='conditions.Condition', verbose_name='Conditions'),
        ),
        migrations.AlterField(
            model_name='attributeentity',
            name='is_attribute',
            field=models.BooleanField(default=False, help_text='Designates whether this attribute/entity is an attribute (auto-generated).', verbose_name='is attribute'),
        ),
        migrations.AlterField(
            model_name='attributeentity',
            name='is_collection',
            field=models.BooleanField(default=False, help_text='Designates whether this attribute/entity is a collection.', verbose_name='is collection'),
        ),
        migrations.AlterField(
            model_name='attributeentity',
            name='key',
            field=models.SlugField(blank=True, help_text='The internal identifier of this attribute/entity. The URI will be generated from this key.', max_length=128, null=True, verbose_name='Key'),
        ),
        migrations.AlterField(
            model_name='attributeentity',
            name='label',
            field=models.CharField(db_index=True, help_text='The label to be displayed this attribute/entity (auto-generated).', max_length=512, verbose_name='Label'),
        ),
        migrations.AlterField(
            model_name='attributeentity',
            name='parent',
            field=mptt.fields.TreeForeignKey(blank=True, help_text='Parent entity in the domain model.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='domain.AttributeEntity', verbose_name='Parent entity'),
        ),
        migrations.AlterField(
            model_name='attributeentity',
            name='parent_collection',
            field=models.ForeignKey(blank=True, default=None, help_text='Next collection entity upwards in the domain model (auto-generated).', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='domain.AttributeEntity', verbose_name='Parent collection'),
        ),
        migrations.AlterField(
            model_name='attributeentity',
            name='uri',
            field=models.URLField(blank=True, help_text='The Uniform Resource Identifier of this attribute/entity set (auto-generated).', max_length=640, null=True, verbose_name='URI'),
        ),
        migrations.AlterField(
            model_name='range',
            name='attribute',
            field=models.OneToOneField(help_text='Attribute this verbose name belongs to.', on_delete=django.db.models.deletion.CASCADE, to='domain.Attribute', verbose_name='Attribute'),
        ),
        migrations.AlterField(
            model_name='range',
            name='maximum',
            field=models.FloatField(help_text='Maximum value for this attribute.', verbose_name='Maximum'),
        ),
        migrations.AlterField(
            model_name='range',
            name='minimum',
            field=models.FloatField(help_text='Minimal value for this attribute.', verbose_name='Minimum'),
        ),
        migrations.AlterField(
            model_name='range',
            name='step',
            field=models.FloatField(help_text='Step in which this attribute can be incremented/decremented.', verbose_name='Step'),
        ),
        migrations.AlterField(
            model_name='verbosename',
            name='attribute_entity',
            field=models.OneToOneField(help_text='Attribute/entity this verbose name belongs to.', on_delete=django.db.models.deletion.CASCADE, to='domain.AttributeEntity', verbose_name='Attribute entity'),
        ),
        migrations.AlterField(
            model_name='verbosename',
            name='name_de',
            field=models.CharField(help_text='German name displayed for this attribute/entity (e.g. Projekt).', max_length=256, verbose_name='Name (de)'),
        ),
        migrations.AlterField(
            model_name='verbosename',
            name='name_en',
            field=models.CharField(help_text='English name displayed for this attribute/entity (e.g. project).', max_length=256, verbose_name='Name (en)'),
        ),
        migrations.AlterField(
            model_name='verbosename',
            name='name_plural_de',
            field=models.CharField(help_text='German plural name displayed for this attribute/entity (e.g. Projekte).', max_length=256, verbose_name='Plural name (de)'),
        ),
        migrations.AlterField(
            model_name='verbosename',
            name='name_plural_en',
            field=models.CharField(help_text='English plural name displayed for this attribute/entity (e.g. projects).', max_length=256, verbose_name='Plural name (en)'),
        ),
    ]
