# Generated by Django 4.2.5 on 2023-10-01 12:55

from django.db import migrations, models


def run_data_migration(apps, schema_editor):
    Option = apps.get_model('options', 'Option')

    for option in Option.objects.all():
        option.additional_input = 'text' if option.additional_input == 'True' else ''
        option.save()


class Migration(migrations.Migration):

    dependencies = [
        ('options', '0031_add_editors'),
    ]

    operations = [
        migrations.AlterField(
            model_name='option',
            name='additional_input',
            field=models.CharField(blank=True, choices=[('', '---------'), ('text', 'Text'), ('textarea', 'Textarea')], default=False, help_text='Designates whether an additional input is possible for this option.', max_length=256, verbose_name='Additional input'),
        ),
        migrations.RunPython(run_data_migration),
    ]
