# Generated by Django 2.2.18 on 2021-02-08 17:04

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('projects', '0048_meta'),
    ]

    operations = [
        migrations.CreateModel(
            name='Invite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(blank=True, help_text='The email for this membership.', max_length=254, verbose_name='Email')),
                ('role', models.CharField(choices=[('owner', 'Owner'), ('manager', 'Manager'), ('author', 'Author'), ('guest', 'Guest')], help_text='The role for this invite.', max_length=12, verbose_name='Role')),
                ('token', models.CharField(help_text='The token for this invite.', max_length=20, verbose_name='Token')),
                ('timestamp', models.DateTimeField(help_text='The timestamp for this invite.', verbose_name='Timestamp')),
                ('project', models.ForeignKey(help_text='The project for this invite.', on_delete=django.db.models.deletion.CASCADE, related_name='invites', to='projects.Project', verbose_name='Project')),
                ('user', models.ForeignKey(help_text='The user for this membership.', null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'Invite',
                'verbose_name_plural': 'Invites',
                'ordering': ('timestamp',),
            },
        ),
    ]
