# -*- coding: utf-8 -*-
# Generated by Django 1.11.14 on 2018-08-03 15:03
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import rdmo.core.models


class Migration(migrations.Migration):

    dependencies = [
        ('domain', '0035_remove_is_collection_and_parent_collection'),
        ('options', '0013_order'),
        ('conditions', '0014_meta'),
        ('questions', '0024_data_migration'),
    ]

    operations = [
        migrations.CreateModel(
            name='QuestionItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(editable=False, verbose_name='created')),
                ('updated', models.DateTimeField(editable=False, verbose_name='updated')),
                ('uri', models.URLField(blank=True, help_text='The Uniform Resource Identifier of this question (auto-generated).', max_length=640, null=True, verbose_name='URI')),
                ('uri_prefix', models.URLField(blank=True, help_text='The prefix for the URI of this question.', max_length=256, null=True, verbose_name='URI Prefix')),
                ('key', models.SlugField(blank=True, help_text='The internal identifier of this question.', max_length=128, null=True, verbose_name='Key')),
                ('path', models.CharField(blank=True, help_text='The path part of the URI of this question (auto-generated).', max_length=512, null=True, verbose_name='Path')),
                ('comment', models.TextField(blank=True, help_text='Additional internal information about this question.', null=True, verbose_name='Comment')),
                ('is_collection', models.BooleanField(default=False, help_text='Designates whether this question is a collection.', verbose_name='is collection')),
                ('order', models.IntegerField(default=0, help_text='The position of this question in lists.', verbose_name='Order')),
                ('help_en', models.TextField(blank=True, help_text='The English help text for this question.', null=True, verbose_name='Help (en)')),
                ('help_de', models.TextField(blank=True, help_text='The German help text for this question.', null=True, verbose_name='Help (de)')),
                ('text_en', models.TextField(help_text='The English text for this question.', verbose_name='Text (en)')),
                ('text_de', models.TextField(help_text='The German text for this question.', verbose_name='Text (de)')),
                ('widget_type', models.CharField(choices=[('text', 'Text'), ('textarea', 'Textarea'), ('yesno', 'Yes/No'), ('checkbox', 'Checkboxes'), ('radio', 'Radio buttons'), ('select', 'Select drop-down'), ('range', 'Range slider'), ('date', 'Date picker')], help_text='Type of widget for this question.', max_length=12, verbose_name='Widget type')),
                ('value_type', models.CharField(choices=[(b'text', 'Text'), (b'url', 'URL'), (b'integer', 'Integer'), (b'float', 'Float'), (b'boolean', 'Boolean'), (b'datetime', 'Datetime'), (b'option', 'Option')], help_text='Type of value for this question.', max_length=8, verbose_name='Value type')),
                ('unit', models.CharField(blank=True, help_text='Unit for this question.', max_length=64, verbose_name='Unit')),
                ('attribute_entity', models.ForeignKey(blank=True, help_text='The attribute/entity this question belongs to.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='domain.AttributeEntity', verbose_name='Attribute entity')),
                ('conditions', models.ManyToManyField(blank=True, help_text='List of conditions evaluated for this question.', to='conditions.Condition', verbose_name='Conditions')),
                ('optionsets', models.ManyToManyField(blank=True, help_text='Option sets for this question.', to='options.OptionSet', verbose_name='Option sets')),
            ],
            options={
                'ordering': ('questionset', 'order'),
                'verbose_name': 'Question',
                'verbose_name_plural': 'Questions',
                'permissions': (('view_question', 'Can view Question'),),
            },
            bases=(models.Model, rdmo.core.models.TranslationMixin),
        ),
        migrations.CreateModel(
            name='QuestionSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(editable=False, verbose_name='created')),
                ('updated', models.DateTimeField(editable=False, verbose_name='updated')),
                ('uri', models.URLField(blank=True, help_text='The Uniform Resource Identifier of this questionset (auto-generated).', max_length=640, null=True, verbose_name='URI')),
                ('uri_prefix', models.URLField(blank=True, help_text='The prefix for the URI of this questionset.', max_length=256, null=True, verbose_name='URI Prefix')),
                ('key', models.SlugField(blank=True, help_text='The internal identifier of this questionset.', max_length=128, null=True, verbose_name='Key')),
                ('path', models.CharField(blank=True, help_text='The path part of the URI of this questionset (auto-generated).', max_length=512, null=True, verbose_name='Path')),
                ('comment', models.TextField(blank=True, help_text='Additional internal information about this questionset.', null=True, verbose_name='Comment')),
                ('is_collection', models.BooleanField(default=False, help_text='Designates whether this questionset is a collection.', verbose_name='is collection')),
                ('order', models.IntegerField(default=0, help_text='The position of this questionset in lists.', verbose_name='Order')),
                ('help_en', models.TextField(blank=True, help_text='The English help text for this questionset.', null=True, verbose_name='Help (en)')),
                ('help_de', models.TextField(blank=True, help_text='The German help text for this questionset.', null=True, verbose_name='Help (de)')),
                ('attribute_entity', models.ForeignKey(blank=True, help_text='The attribute/entity this questionset belongs to.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='domain.AttributeEntity', verbose_name='Attribute entity')),
                ('conditions', models.ManyToManyField(blank=True, help_text='List of conditions evaluated for this questionset.', to='conditions.Condition', verbose_name='Conditions')),
                ('subsection', models.ForeignKey(help_text='The subsection this questionset belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='questionsets', to='questions.Subsection', verbose_name='Subsection')),
            ],
            options={
                'ordering': ('subsection', 'order'),
                'verbose_name': 'Question set',
                'verbose_name_plural': 'Question set',
                'permissions': (('view_questionset', 'Can view Question set'),),
            },
            bases=(models.Model, rdmo.core.models.TranslationMixin),
        ),
        migrations.AddField(
            model_name='questionitem',
            name='questionset',
            field=models.ForeignKey(help_text='The question set this question belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='questions', to='questions.QuestionSet', verbose_name='Questionset'),
        ),
    ]
