# Generated by Django 3.2.14 on 2022-12-07 16:15

from django.db import migrations, models
import django.db.models.deletion
import rdmo.core.models


class Migration(migrations.Migration):

    dependencies = [
        ('conditions', '0022_condition_locked'),
        ('domain', '0048_meta'),
        ('questions', '0068_meta'),
    ]

    operations = [
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(editable=False, verbose_name='created')),
                ('updated', models.DateTimeField(editable=False, verbose_name='updated')),
                ('uri', models.URLField(blank=True, help_text='The Uniform Resource Identifier of this page (auto-generated).', max_length=640, verbose_name='URI')),
                ('uri_prefix', models.URLField(help_text='The prefix for the URI of this page.', max_length=256, verbose_name='URI Prefix')),
                ('key', models.SlugField(blank=True, help_text='The internal identifier of this page.', max_length=128, verbose_name='Key')),
                ('path', models.CharField(blank=True, help_text='The path part of the URI of this page (auto-generated).', max_length=512, verbose_name='Path')),
                ('comment', models.TextField(blank=True, help_text='Additional internal information about this page.', verbose_name='Comment')),
                ('locked', models.BooleanField(default=False, help_text='Designates whether this page (and its questionsets and questions) can be changed.', verbose_name='Locked')),
                ('is_collection', models.BooleanField(default=False, help_text='Designates whether this page is a collection.', verbose_name='is collection')),
                ('order', models.IntegerField(default=0, help_text='The position of this page in lists.', verbose_name='Order')),
                ('title_lang1', models.CharField(blank=True, help_text='The title for this page in the primary language.', max_length=256, verbose_name='Title (primary)')),
                ('title_lang2', models.CharField(blank=True, help_text='The title for this page in the secondary language.', max_length=256, verbose_name='Title (secondary)')),
                ('title_lang3', models.CharField(blank=True, help_text='The title for this page in the tertiary language.', max_length=256, verbose_name='Title (tertiary)')),
                ('title_lang4', models.CharField(blank=True, help_text='The title for this page in the quaternary language.', max_length=256, verbose_name='Title (quaternary)')),
                ('title_lang5', models.CharField(blank=True, help_text='The title for this page in the quinary language.', max_length=256, verbose_name='Title (quinary)')),
                ('help_lang1', models.TextField(blank=True, help_text='The help text for this page in the primary language.', verbose_name='Help (primary)')),
                ('help_lang2', models.TextField(blank=True, help_text='The help text for this page in the secondary language.', verbose_name='Help (secondary)')),
                ('help_lang3', models.TextField(blank=True, help_text='The help text for this page in the tertiary language.', verbose_name='Help (tertiary)')),
                ('help_lang4', models.TextField(blank=True, help_text='The help text for this page in the quaternary language.', verbose_name='Help (quaternary)')),
                ('help_lang5', models.TextField(blank=True, help_text='The help text for this page in the quinary language.', verbose_name='Help (quinary)')),
                ('verbose_name_lang1', models.CharField(blank=True, help_text='The name displayed for this page in the primary language.', max_length=256, verbose_name='Name (primary)')),
                ('verbose_name_lang2', models.CharField(blank=True, help_text='The name displayed for this page in the secondary language.', max_length=256, verbose_name='Name (secondary)')),
                ('verbose_name_lang3', models.CharField(blank=True, help_text='The name displayed for this page in the tertiary language.', max_length=256, verbose_name='Name (tertiary)')),
                ('verbose_name_lang4', models.CharField(blank=True, help_text='The name displayed for this page in the quaternary language.', max_length=256, verbose_name='Name (quaternary)')),
                ('verbose_name_lang5', models.CharField(blank=True, help_text='The name displayed for this page in the quinary language.', max_length=256, verbose_name='Name (quinary)')),
                ('verbose_name_plural_lang1', models.CharField(blank=True, help_text='The plural name displayed for this page in the primary language.', max_length=256, verbose_name='Plural name (primary)')),
                ('verbose_name_plural_lang2', models.CharField(blank=True, help_text='The plural name displayed for this page in the secondary language.', max_length=256, verbose_name='Plural name (secondary)')),
                ('verbose_name_plural_lang3', models.CharField(blank=True, help_text='The plural name displayed for this page in the tertiary language.', max_length=256, verbose_name='Plural name (tertiary)')),
                ('verbose_name_plural_lang4', models.CharField(blank=True, help_text='The plural name displayed for this page in the quaternary language.', max_length=256, verbose_name='Plural name (quaternary)')),
                ('verbose_name_plural_lang5', models.CharField(blank=True, help_text='The plural name displayed for this page in the quinary language.', max_length=256, verbose_name='Plural name (quinary)')),
                ('attribute', models.ForeignKey(blank=True, help_text='The attribute this page belongs to.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='pages', to='domain.attribute', verbose_name='Attribute')),
                ('conditions', models.ManyToManyField(blank=True, help_text='List of conditions evaluated for this page.', related_name='pages', to='conditions.Condition', verbose_name='Conditions')),
                ('section', models.ForeignKey(help_text='The section this page belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='pages', to='questions.section', verbose_name='Section')),
            ],
            options={
                'verbose_name': 'page',
                'verbose_name_plural': 'pages',
                'ordering': ('section', 'order'),
            },
            bases=(models.Model, rdmo.core.models.TranslationMixin),
        ),
    ]
