# Generated by Django 3.2.14 on 2023-01-10 14:05

import django.db.models.deletion
from django.db import migrations, models


def run_data_migration(apps, schema_editor):
    QuestionSet = apps.get_model('questions', 'QuestionSet')
    QuestionSetQuestionSet = apps.get_model('questions', 'QuestionSetQuestionSet')

    for questionset in QuestionSet.objects.exclude(questionset=None):
        QuestionSetQuestionSet(
            parent=questionset.questionset,
            questionset=questionset,
            order=questionset.order,
        ).save()


class Migration(migrations.Migration):

    dependencies = [
        ('questions', '0087_page_questions'),
    ]

    operations = [
        migrations.CreateModel(
            name='QuestionSetQuestionSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(default=0)),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='questionset_questionsets', to='questions.questionset')),
                ('questionset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='questionset_parents', to='questions.questionset')),
            ],
            options={
                'ordering': ('parent', 'order'),
            },
        ),
        # remove the related_name='questions' from Question.page
        migrations.AlterField(
            model_name='questionset',
            name='questionset',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='questions.QuestionSet'),
        ),
        migrations.AddField(
            model_name='questionset',
            name='questionsets',
            field=models.ManyToManyField(blank=True, help_text='The question sets of this question set.', related_name='parents', through='questions.QuestionSetQuestionSet', to='questions.QuestionSet', verbose_name='Question sets'),
        ),
        migrations.RunPython(run_data_migration),
        migrations.RemoveField(
            model_name='questionset',
            name='questionset',
        ),
        migrations.RemoveField(
            model_name='questionset',
            name='order',
        )
    ]
