# -*- coding: utf-8 -*-
# Generated by Django 1.11.14 on 2018-08-21 13:12
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import mptt.fields


class Migration(migrations.Migration):

    dependencies = [
        ('domain', '0038_rename_attributeentity_to_attribute'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='attribute',
            options={'ordering': ('uri',), 'permissions': (('view_attribute', 'Can view Attribute'),), 'verbose_name': 'Attribute', 'verbose_name_plural': 'Attributes'},
        ),
        migrations.RemoveField(
            model_name='attribute',
            name='is_attribute',
        ),
        migrations.AlterField(
            model_name='attribute',
            name='comment',
            field=models.TextField(blank=True, help_text='Additional information about this attribute.', null=True, verbose_name='Comment'),
        ),
        migrations.AlterField(
            model_name='attribute',
            name='key',
            field=models.SlugField(blank=True, help_text='The internal identifier of this attribute.', max_length=128, null=True, verbose_name='Key'),
        ),
        migrations.AlterField(
            model_name='attribute',
            name='parent',
            field=mptt.fields.TreeForeignKey(blank=True, help_text='Parent attribute in the domain model.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='domain.Attribute', verbose_name='Parent attribute'),
        ),
        migrations.AlterField(
            model_name='attribute',
            name='path',
            field=models.CharField(db_index=True, help_text='The path part of the URI of this attribute (auto-generated).', max_length=512, verbose_name='Path'),
        ),
        migrations.AlterField(
            model_name='attribute',
            name='uri',
            field=models.URLField(blank=True, help_text='The Uniform Resource Identifier of this attribute set (auto-generated).', max_length=640, null=True, verbose_name='URI'),
        ),
        migrations.AlterField(
            model_name='attribute',
            name='uri_prefix',
            field=models.URLField(blank=True, help_text='The prefix for the URI of this attribute.', max_length=256, null=True, verbose_name='URI Prefix'),
        ),
    ]
