# Generated by Django 2.2.6 on 2019-10-29 12:08

from django.conf import settings
from django.db import migrations, models


def run_data_migration(apps, schema_editor):
    for element in apps.get_model('options', 'OptionSet').objects.all():
        element.uri_prefix = element.uri_prefix or settings.DEFAULT_URI_PREFIX
        element.save()

    for element in apps.get_model('options', 'Option').objects.all():
        element.uri_prefix = element.uri_prefix or settings.DEFAULT_URI_PREFIX
        element.save()


class Migration(migrations.Migration):

    dependencies = [
        ('options', '0022_cascade_options'),
    ]

    operations = [
        migrations.RunPython(run_data_migration),
        migrations.AlterField(
            model_name='option',
            name='uri_prefix',
            field=models.URLField(help_text='The prefix for the URI of this option.', max_length=256, verbose_name='URI Prefix'),
        ),
        migrations.AlterField(
            model_name='optionset',
            name='uri_prefix',
            field=models.URLField(help_text='The prefix for the URI of this option set.', max_length=256, verbose_name='URI Prefix'),
        ),
    ]
