# Generated by Django 3.2.14 on 2023-01-10 11:08

from django.db import migrations, models


def run_data_migration(apps, schema_editor):
    Option = apps.get_model('options', 'Option')

    for option in Option.objects.all():
        option.uri_path = '%s/%s' % (option.optionset.uri_path, option.key)
        option.save()


class Migration(migrations.Migration):

    dependencies = [
        ('options', '0028_optionset_uri_path'),
    ]

    operations = [
        migrations.RenameField(
            model_name='option',
            old_name='path',
            new_name='uri_path',
        ),
        migrations.AlterField(
            model_name='option',
            name='uri',
            field=models.URLField(blank=True, help_text='The Uniform Resource Identifier of this option (auto-generated).', max_length=800, verbose_name='URI'),
        ),
        migrations.AlterField(
            model_name='option',
            name='uri_path',
            field=models.CharField(blank=True, help_text='The path for the URI of this option.', max_length=512, verbose_name='URI Path'),
        ),
        migrations.RunPython(run_data_migration),
        migrations.RemoveField(
            model_name='option',
            name='key',
        ),
    ]
