# Generated by Django 3.2.14 on 2023-01-10 14:05

import django.db.models.deletion
from django.db import migrations, models


def run_data_migration(apps, schema_editor):
    Option = apps.get_model('options', 'Option')
    OptionSetOption = apps.get_model('options', 'OptionSetOption')

    for option in Option.objects.all():
        OptionSetOption(
            optionset=option.optionset,
            option=option,
            order=option.order,
        ).save()


class Migration(migrations.Migration):

    dependencies = [
        ('options', '0029_option_uri_path'),
    ]

    operations = [
        migrations.CreateModel(
            name='OptionSetOption',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(default=0)),
                ('optionset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='optionset_options', to='options.optionset')),
                ('option', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='option_optionsets', to='options.option')),
            ],
            options={
                'ordering': ('optionset', 'order'),
            },
        ),
        # remove the related_name='options' from Option.optionset
        migrations.AlterField(
            model_name='option',
            name='optionset',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='options.OptionSet'),
        ),
        migrations.AddField(
            model_name='optionset',
            name='options',
            field=models.ManyToManyField(blank=True, help_text='The list of options for this option set.', related_name='optionsets', through='options.OptionSetOption', to='options.Option', verbose_name='Options'),
        ),
        migrations.RunPython(run_data_migration),
        migrations.RemoveField(
            model_name='option',
            name='optionset',
        ),
        migrations.RemoveField(
            model_name='option',
            name='order',
        )
    ]
