# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2017-02-21 14:11
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('projects', '0011_refactoring'),
    ]

    operations = [
        migrations.CreateModel(
            name='Membership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.CharField(choices=[('owner', 'Owner'), ('manager', 'Manager'), ('author', 'Author'), ('guest', 'Guest')], help_text='The role for this membership.', max_length=12, verbose_name='Role')),
            ],
            options={
                'ordering': ('project__title',),
                'verbose_name': 'Membership',
                'verbose_name_plural': 'Memberships',
            },
        ),
        migrations.AlterField(
            model_name='project',
            name='owner',
            field=models.ManyToManyField(help_text='The list of owners for this project.', related_name='_project_owner_+', to=settings.AUTH_USER_MODEL, verbose_name='Owner'),
        ),
        migrations.AddField(
            model_name='membership',
            name='project',
            field=models.ForeignKey(help_text='The project for this membership.', on_delete=django.db.models.deletion.CASCADE, to='projects.Project', verbose_name='Project'),
        ),
        migrations.AddField(
            model_name='membership',
            name='user',
            field=models.ForeignKey(help_text='The user for this membership.', on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
        migrations.AddField(
            model_name='project',
            name='user',
            field=models.ManyToManyField(help_text='The list of users for this project.', through='projects.Membership', to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
    ]
