# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-03-13 11:22
from __future__ import unicode_literals

from django.db import migrations


def set_null_to_blank(queryset, fields):
    for element in queryset:
        for field in fields:
            value = getattr(element, field)
            if value is None:
                setattr(element, field, '')
        element.save()


def run_data_migration(apps, schema_editor):
    Value = apps.get_model('projects', 'Value')

    set_null_to_blank(Value.objects.all(), [
        'text',
    ])


class Migration(migrations.Migration):

    dependencies = [
        ('projects', '0023_meta'),
    ]

    operations = [
        migrations.RunPython(run_data_migration),
    ]
