# Generated by Django 2.2.13 on 2020-09-10 15:27

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('projects', '0037_project_tasks'),
    ]

    operations = [
        migrations.CreateModel(
            name='Integration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('provider_key', models.TextField(help_text='The key of the provider for this integration.', verbose_name='Provider key')),
                ('project', models.ForeignKey(help_text='The project for this integration.', on_delete=django.db.models.deletion.CASCADE, related_name='integrations', to='projects.Project', verbose_name='Project')),
            ],
            options={
                'verbose_name': 'Integration',
                'verbose_name_plural': 'Integrations',
                'ordering': ('project__title',),
            },
        ),
        migrations.CreateModel(
            name='IntegrationOption',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.SlugField(help_text='The key for this integration option.', max_length=128, verbose_name='Key')),
                ('value', models.TextField(help_text='The value for this integration option.', verbose_name='Value')),
                ('integration', models.ForeignKey(help_text='The integration for this integration option.', on_delete=django.db.models.deletion.CASCADE, related_name='options', to='projects.Integration', verbose_name='Integration')),
            ],
            options={
                'verbose_name': 'Integration option',
                'verbose_name_plural': 'Integration options',
                'ordering': ('integration__project__title',),
            },
        ),
    ]
