# Generated by Django 3.2.14 on 2023-01-16 14:04

from django.db import migrations, models


def run_data_migration(apps, schema_editor):
    Page = apps.get_model('questions', 'Page')

    for page in Page.objects.all():
        page.uri_path = '%s/%s' % (page.section.uri_path, page.key)
        page.save()


class Migration(migrations.Migration):

    dependencies = [
        ('questions', '0079_section_uri_path'),
    ]

    operations = [
        migrations.RenameField(
            model_name='page',
            old_name='path',
            new_name='uri_path',
        ),
        migrations.AlterField(
            model_name='page',
            name='uri',
            field=models.URLField(blank=True, help_text='The Uniform Resource Identifier of this page (auto-generated).', max_length=800, verbose_name='URI'),
        ),
        migrations.AlterField(
            model_name='page',
            name='uri_path',
            field=models.CharField(blank=True, help_text='The path for the URI of this page.', max_length=512, verbose_name='URI Path'),
        ),
        migrations.RunPython(run_data_migration),
        migrations.RemoveField(
            model_name='page',
            name='key',
        ),
    ]
