# Generated by Django 3.2.14 on 2023-01-16 16:46

from django.db import migrations, models


def run_data_migration(apps, schema_editor):
    Question = apps.get_model('questions', 'Question')

    for question in Question.objects.all():
        if question.questionset is None:
            question.uri_path = '%s/%s' % (question.page.uri_path, question.key)
        else:
            question.uri_path = '%s/%s' % (question.questionset.uri_path, question.key)
        question.save()


class Migration(migrations.Migration):

    dependencies = [
        ('questions', '0081_questionset_uri_path'),
    ]

    operations = [
        migrations.RenameField(
            model_name='question',
            old_name='path',
            new_name='uri_path',
        ),
        migrations.AlterField(
            model_name='question',
            name='uri',
            field=models.URLField(blank=True, help_text='The Uniform Resource Identifier of this question (auto-generated).', max_length=800, null=True, verbose_name='URI'),
        ),
        migrations.AlterField(
            model_name='question',
            name='uri_path',
            field=models.CharField(blank=True, help_text='The path for the URI of this question.', max_length=512, null=True, verbose_name='URI Path'),
        ),
        migrations.RunPython(run_data_migration),
        migrations.RemoveField(
            model_name='question',
            name='key',
        ),
    ]
