# Generated by Django 3.2.14 on 2023-01-10 14:05

import django.db.models.deletion
from django.db import migrations, models


def run_data_migration(apps, schema_editor):
    Section = apps.get_model('questions', 'Section')
    CatalogSection = apps.get_model('questions', 'CatalogSection')

    for section in Section.objects.all():
        CatalogSection(
            catalog=section.catalog,
            section=section,
            order=section.order,
        ).save()


class Migration(migrations.Migration):

    dependencies = [
        ('questions', '0083_meta'),
    ]

    operations = [
        migrations.CreateModel(
            name='CatalogSection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(default=0)),
                ('catalog', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='catalog_sections', to='questions.catalog')),
                ('section', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='section_catalogs', to='questions.section')),
            ],
            options={
                'ordering': ('catalog', 'order'),
            },
        ),
        # remove the related_name='sections' from Section.catalog
        migrations.AlterField(
            model_name='section',
            name='catalog',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='questions.Catalog'),
        ),
        migrations.AddField(
            model_name='catalog',
            name='sections',
            field=models.ManyToManyField(blank=True, help_text='The sections of this catalog.', related_name='catalogs', through='questions.CatalogSection', to='questions.Section', verbose_name='Sections'),
        ),
        migrations.RunPython(run_data_migration),
        migrations.RemoveField(
            model_name='section',
            name='catalog',
        ),
        migrations.RemoveField(
            model_name='section',
            name='order',
        )
    ]
