# Generated by Django 3.2.14 on 2023-01-10 14:05

import django.db.models.deletion
from django.db import migrations, models


def run_data_migration(apps, schema_editor):
    Question = apps.get_model('questions', 'Question')
    PageQuestion = apps.get_model('questions', 'PageQuestion')

    for question in Question.objects.exclude(page=None):
        PageQuestion(
            page=question.page,
            question=question,
            order=question.order,
        ).save()


class Migration(migrations.Migration):

    dependencies = [
        ('questions', '0086_page_questionsets'),
    ]

    operations = [
        migrations.CreateModel(
            name='PageQuestion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(default=0)),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='page_questions', to='questions.page')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='question_pages', to='questions.question')),
            ],
            options={
                'ordering': ('page', 'order'),
            },
        ),
        # remove the related_name='questions' from Question.page
        migrations.AlterField(
            model_name='question',
            name='page',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='questions.Page'),
        ),
        migrations.AddField(
            model_name='page',
            name='questions',
            field=models.ManyToManyField(blank=True, help_text='The questions of this page.', related_name='pages', through='questions.PageQuestion', to='questions.Question', verbose_name='Questions'),
        ),
        migrations.RunPython(run_data_migration),
        migrations.RemoveField(
            model_name='question',
            name='page',
        )
    ]
