// GENERATED BY THE COMMAND ABOVE; DO NOT EDIT
// This file was generated by swaggo/swag

package docs

import (
	"bytes"
	"encoding/json"
	"strings"

	"github.com/alecthomas/template"
	"github.com/swaggo/swag"
)

var doc = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{.Description}}",
        "title": "{{.Title}}",
        "termsOfService": "https://github.com/nilorg",
        "contact": {
            "name": "API Support",
            "url": "https://github.com/nilorg/naas",
            "email": "862860000@qq.com"
        },
        "license": {
            "name": "GNU General Public License v3.0",
            "url": "https://github.com/nilorg/naas/blob/master/LICENSE"
        },
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/common/select": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "org:组织\nxxxx:其他",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Role（角色）"
                ],
                "summary": "查询角色",
                "parameters": [
                    {
                        "enum": [
                            "org",
                            "xxxx"
                        ],
                        "type": "string",
                        "description": "查询参数",
                        "name": "q",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "页大小",
                        "name": "pageSize",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/api.Result"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/model.ResultSelect"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/oauth2/clients": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "查询客户端翻页",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "OAuth2"
                ],
                "summary": "client",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "当前页",
                        "name": "current",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "页大小",
                        "name": "pageSize",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/api.Result"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "allOf": [
                                                {
                                                    "$ref": "#/definitions/model.TableListData"
                                                },
                                                {
                                                    "type": "object",
                                                    "properties": {
                                                        "list": {
                                                            "$ref": "#/definitions/service.ResultClientInfo"
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "创建客户端",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "OAuth2"
                ],
                "summary": "client",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/service.OAuth2ClientEditModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/oauth2/clients/{client_id}": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "OAuth2"
                ],
                "summary": "获取一个客户端",
                "parameters": [
                    {
                        "type": "string",
                        "description": "client id",
                        "name": "client_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/api.Result"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/service.OAuth2ClientDetailInfo"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "根据客户端ID,修改客户端信息",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "OAuth2"
                ],
                "summary": "client",
                "parameters": [
                    {
                        "type": "string",
                        "description": "client id",
                        "name": "client_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "客户端信息",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/service.OAuth2ClientEditModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/oauth2/clients/{client_id}/scopes": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "查询客户端scope",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "OAuth2"
                ],
                "summary": "scope",
                "parameters": [
                    {
                        "type": "string",
                        "description": "客户端ID",
                        "name": "client_id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/api.Result"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/model.OAuth2ClientScope"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/oauth2/scopes": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "paged:查询翻页列表\nall:查询所有",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "OAuth2"
                ],
                "summary": "查询scope",
                "parameters": [
                    {
                        "enum": [
                            "paged",
                            "all"
                        ],
                        "type": "string",
                        "description": "查询参数",
                        "name": "q",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "当前页",
                        "name": "current",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "页大小",
                        "name": "pageSize",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/api.Result"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/model.OAuth2Scope"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/oauth2/scopes/{scop_code}": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "OAuth2"
                ],
                "summary": "获取一个scope",
                "parameters": [
                    {
                        "type": "string",
                        "description": "scop code",
                        "name": "scop_code",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "OAuth2"
                ],
                "summary": "编辑scope",
                "parameters": [
                    {
                        "type": "string",
                        "description": "scop code",
                        "name": "scop_code",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/service.OAuth2EditScopeModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/open/users/wx": {
            "post": {
                "description": "从微信创建用户",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Open（开放接口）"
                ],
                "summary": "从微信创建用户",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/open.createUserFromWeixinModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/organizations": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "查询组织翻页数据",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization（组织）"
                ],
                "summary": "查询组织",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "当前页",
                        "name": "current",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "页大小",
                        "name": "pageSize",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/api.Result"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/model.TableListData"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "创建组织",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization（组织）"
                ],
                "summary": "创建组织",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/service.OrganizationEditModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/organizations/{org_id}": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "根据组织ID,获取一个组织",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization（组织）"
                ],
                "summary": "获取一个组织",
                "parameters": [
                    {
                        "type": "string",
                        "description": "org id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "根据组织ID,修改一个组织",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization（组织）"
                ],
                "summary": "修改一个组织",
                "parameters": [
                    {
                        "type": "string",
                        "description": "organization id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "组织需要修改的信息",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/service.OrganizationEditModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "根据组织ID,删除一个组织",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization（组织）"
                ],
                "summary": "删除一个组织",
                "parameters": [
                    {
                        "type": "string",
                        "description": "organization id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/resource/servers": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "查询资源翻页数据",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Resource（资源）"
                ],
                "summary": "查询资源",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "当前页",
                        "name": "current",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "页大小",
                        "name": "pageSize",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/api.Result"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/model.TableListData"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "创建资源",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Resource（资源）"
                ],
                "summary": "创建资源",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/service.ResourceEditModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/resource/servers/{resource_server_id}": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "根据资源ID,获取一个资源",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Resource（资源）"
                ],
                "summary": "获取一个资源",
                "parameters": [
                    {
                        "type": "string",
                        "description": "resource id",
                        "name": "resource_server_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "根据资源ID,修改一个资源",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Resource（资源）"
                ],
                "summary": "修改一个资源",
                "parameters": [
                    {
                        "type": "string",
                        "description": "resource id",
                        "name": "resource_server_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "资源需要修改的信息",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/service.ResourceEditModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/resource/web_routes": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "查询资源服务器WebRule翻页数据",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "ResourceWebRoute（资源服务器Web路由）"
                ],
                "summary": "查询资源服务器WebRule",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "当前页",
                        "name": "current",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "页大小",
                        "name": "pageSize",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/api.Result"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/model.TableListData"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "ResourceWebRoute（资源服务器Web路由）"
                ],
                "summary": "添加web路由",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/service.ResourceWebRouteEdit"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/resource/web_routes/:resource_web_route_id": {
            "put": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "根据资源web路由ID,修改一个资源web路由",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "ResourceWebRoute（资源服务器Web路由）"
                ],
                "summary": "修改一个资源web路由",
                "parameters": [
                    {
                        "type": "string",
                        "description": "resource web route id",
                        "name": "resource_web_route_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Web路由需要修改的信息",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/service.ResourceWebRouteEdit"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/resource/web_routes/{resource_web_route_id}": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "根据路由ID,获取一个Web路由",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "ResourceWebRoute（资源服务器Web路由）"
                ],
                "summary": "获取一个Web路由",
                "parameters": [
                    {
                        "type": "string",
                        "description": "resource web route id",
                        "name": "resource_web_route_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/roles": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "recursive:递归获取所有角色\nlist:查询列表",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Role（角色）"
                ],
                "summary": "查询角色",
                "parameters": [
                    {
                        "enum": [
                            "recursive",
                            "list"
                        ],
                        "type": "string",
                        "description": "查询参数",
                        "name": "q",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/api.Result"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/model.Role"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/roles/{role_code}/resource_web_route/{resource_web_route_id}": {
            "post": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Role（角色）"
                ],
                "summary": "添加资源web路由",
                "parameters": [
                    {
                        "type": "string",
                        "description": "角色Code",
                        "name": "role_code",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "资源web路由ID",
                        "name": "resource_web_route_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/users": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "查询用户翻页数据",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User（用户）"
                ],
                "summary": "查询用户",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "当前页",
                        "name": "current",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "页大小",
                        "name": "pageSize",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/api.Result"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/model.TableListData"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "创建用户",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User（用户）"
                ],
                "summary": "创建用户",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/api.userCreateModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        },
        "/users/{user_id}": {
            "get": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "根据用户ID,获取一个用户",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User（用户）"
                ],
                "summary": "获取一个用户",
                "parameters": [
                    {
                        "type": "string",
                        "description": "user id",
                        "name": "user_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "根据用户ID,修改一个用户",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User（用户）"
                ],
                "summary": "修改一个用户",
                "parameters": [
                    {
                        "type": "string",
                        "description": "user id",
                        "name": "user_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "用户需要修改的信息",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/service.UserUpdateModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "OAuth2AccessCode": []
                    }
                ],
                "description": "根据用户ID,删除一个用户",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User（用户）"
                ],
                "summary": "删除一个用户",
                "parameters": [
                    {
                        "type": "string",
                        "description": "user id",
                        "name": "user_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api.Result"
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "api.Result": {
            "type": "object",
            "properties": {
                "data": {
                    "type": "object"
                },
                "error": {
                    "type": "object",
                    "$ref": "#/definitions/api.ResultError"
                },
                "status": {
                    "type": "string"
                }
            }
        },
        "api.ResultError": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "integer"
                },
                "message": {
                    "type": "string"
                }
            }
        },
        "api.userCreateModel": {
            "type": "object",
            "properties": {
                "password": {
                    "type": "string",
                    "example": "123456"
                },
                "username": {
                    "type": "string",
                    "example": "test"
                }
            }
        },
        "model.OAuth2ClientScope": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string"
                },
                "deleted_at": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "oauth2_client_id": {
                    "type": "integer"
                },
                "scope_code": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "model.OAuth2Scope": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string"
                },
                "deleted_at": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "type": {
                    "description": "basic,",
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "model.Pagination": {
            "type": "object",
            "properties": {
                "current": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "total": {
                    "type": "integer"
                }
            }
        },
        "model.ResultSelect": {
            "type": "object",
            "properties": {
                "label": {
                    "type": "string"
                },
                "value": {
                    "type": "object"
                }
            }
        },
        "model.Role": {
            "type": "object",
            "properties": {
                "child_roles": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/model.Role"
                    }
                },
                "code": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string"
                },
                "deleted_at": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "parent_code": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "model.TableListData": {
            "type": "object",
            "properties": {
                "list": {
                    "type": "object"
                },
                "pagination": {
                    "type": "object",
                    "$ref": "#/definitions/model.Pagination"
                }
            }
        },
        "open.createUserFromWeixinModel": {
            "type": "object",
            "properties": {
                "wx_union_id": {
                    "description": "微信unionid",
                    "type": "string"
                }
            }
        },
        "service.OAuth2ClientDetailInfo": {
            "type": "object",
            "properties": {
                "client_id": {
                    "type": "integer"
                },
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "profile": {
                    "type": "string"
                },
                "redirect_uri": {
                    "type": "string"
                },
                "website": {
                    "type": "string"
                }
            }
        },
        "service.OAuth2ClientEditModel": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "profile": {
                    "type": "string"
                },
                "redirect_uri": {
                    "type": "string"
                },
                "website": {
                    "type": "string"
                }
            }
        },
        "service.OAuth2EditScopeModel": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "service.OrganizationEditModel": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "parent_id": {
                    "type": "integer"
                }
            }
        },
        "service.ResourceEditModel": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "integer"
                },
                "secret": {
                    "type": "string"
                }
            }
        },
        "service.ResourceWebRouteEdit": {
            "type": "object",
            "properties": {
                "method": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "resource_server_id": {
                    "type": "integer"
                }
            }
        },
        "service.ResultClientInfo": {
            "type": "object",
            "properties": {
                "client_id": {
                    "type": "integer"
                },
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "profile": {
                    "type": "string"
                },
                "redirect_uri": {
                    "type": "string"
                },
                "website": {
                    "type": "string"
                }
            }
        },
        "service.UserUpdateModel": {
            "type": "object",
            "properties": {
                "password": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        }
    },
    "securityDefinitions": {
        "OAuth2AccessCode": {
            "type": "oauth2",
            "flow": "accessCode",
            "authorizationUrl": "http://localhost:8080/oauth2/authorize",
            "tokenUrl": "http://localhost:8080/oauth2/token",
            "scopes": {
                "email": " 用户emial",
                "openid": " 用户openid",
                "phone": " 用户手机号",
                "profile": " 用户资料"
            }
        }
    }
}`

type swaggerInfo struct {
	Version     string
	Host        string
	BasePath    string
	Schemes     []string
	Title       string
	Description string
}

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = swaggerInfo{
	Version:     "1.0",
	Host:        "localhost:8080",
	BasePath:    "/api/v1",
	Schemes:     []string{},
	Title:       "NilOrg认证授权服务",
	Description: "NilOrg认证授权服务Api详情.",
}

type s struct{}

func (s *s) ReadDoc() string {
	sInfo := SwaggerInfo
	sInfo.Description = strings.Replace(sInfo.Description, "\n", "\\n", -1)

	t, err := template.New("swagger_info").Funcs(template.FuncMap{
		"marshal": func(v interface{}) string {
			a, _ := json.Marshal(v)
			return string(a)
		},
	}).Parse(doc)
	if err != nil {
		return doc
	}

	var tpl bytes.Buffer
	if err := t.Execute(&tpl, sInfo); err != nil {
		return doc
	}

	return tpl.String()
}

func init() {
	swag.Register(swag.Name, &s{})
}
