// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package ecr provides a client for Amazon EC2 Container Registry.
package ecr

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opBatchCheckLayerAvailability = "BatchCheckLayerAvailability"

// BatchCheckLayerAvailabilityRequest generates a "aws/request.Request" representing the
// client's request for the BatchCheckLayerAvailability operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchCheckLayerAvailability method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchCheckLayerAvailabilityRequest method.
//    req, resp := client.BatchCheckLayerAvailabilityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) BatchCheckLayerAvailabilityRequest(input *BatchCheckLayerAvailabilityInput) (req *request.Request, output *BatchCheckLayerAvailabilityOutput) {
	op := &request.Operation{
		Name:       opBatchCheckLayerAvailability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchCheckLayerAvailabilityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchCheckLayerAvailabilityOutput{}
	req.Data = output
	return
}

// Check the availability of multiple image layers in a specified registry and
// repository.
//
//  This operation is used by the Amazon ECR proxy, and it is not intended
// for general use by customers. Use the docker CLI to pull, tag, and push images.
func (c *ECR) BatchCheckLayerAvailability(input *BatchCheckLayerAvailabilityInput) (*BatchCheckLayerAvailabilityOutput, error) {
	req, out := c.BatchCheckLayerAvailabilityRequest(input)
	err := req.Send()
	return out, err
}

const opBatchDeleteImage = "BatchDeleteImage"

// BatchDeleteImageRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteImage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchDeleteImage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchDeleteImageRequest method.
//    req, resp := client.BatchDeleteImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) BatchDeleteImageRequest(input *BatchDeleteImageInput) (req *request.Request, output *BatchDeleteImageOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteImageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchDeleteImageOutput{}
	req.Data = output
	return
}

// Deletes a list of specified images within a specified repository. Images
// are specified with either imageTag or imageDigest.
func (c *ECR) BatchDeleteImage(input *BatchDeleteImageInput) (*BatchDeleteImageOutput, error) {
	req, out := c.BatchDeleteImageRequest(input)
	err := req.Send()
	return out, err
}

const opBatchGetImage = "BatchGetImage"

// BatchGetImageRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetImage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchGetImage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchGetImageRequest method.
//    req, resp := client.BatchGetImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) BatchGetImageRequest(input *BatchGetImageInput) (req *request.Request, output *BatchGetImageOutput) {
	op := &request.Operation{
		Name:       opBatchGetImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetImageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchGetImageOutput{}
	req.Data = output
	return
}

// Gets detailed information for specified images within a specified repository.
// Images are specified with either imageTag or imageDigest.
func (c *ECR) BatchGetImage(input *BatchGetImageInput) (*BatchGetImageOutput, error) {
	req, out := c.BatchGetImageRequest(input)
	err := req.Send()
	return out, err
}

const opCompleteLayerUpload = "CompleteLayerUpload"

// CompleteLayerUploadRequest generates a "aws/request.Request" representing the
// client's request for the CompleteLayerUpload operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CompleteLayerUpload method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CompleteLayerUploadRequest method.
//    req, resp := client.CompleteLayerUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) CompleteLayerUploadRequest(input *CompleteLayerUploadInput) (req *request.Request, output *CompleteLayerUploadOutput) {
	op := &request.Operation{
		Name:       opCompleteLayerUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CompleteLayerUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CompleteLayerUploadOutput{}
	req.Data = output
	return
}

// Inform Amazon ECR that the image layer upload for a specified registry, repository
// name, and upload ID, has completed. You can optionally provide a sha256 digest
// of the image layer for data validation purposes.
//
//  This operation is used by the Amazon ECR proxy, and it is not intended
// for general use by customers. Use the docker CLI to pull, tag, and push images.
func (c *ECR) CompleteLayerUpload(input *CompleteLayerUploadInput) (*CompleteLayerUploadOutput, error) {
	req, out := c.CompleteLayerUploadRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRepository = "CreateRepository"

// CreateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateRepository operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateRepository method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateRepositoryRequest method.
//    req, resp := client.CreateRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) CreateRepositoryRequest(input *CreateRepositoryInput) (req *request.Request, output *CreateRepositoryOutput) {
	op := &request.Operation{
		Name:       opCreateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRepositoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateRepositoryOutput{}
	req.Data = output
	return
}

// Creates an image repository.
func (c *ECR) CreateRepository(input *CreateRepositoryInput) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRepository = "DeleteRepository"

// DeleteRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepository operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRepository method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRepositoryRequest method.
//    req, resp := client.DeleteRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) DeleteRepositoryRequest(input *DeleteRepositoryInput) (req *request.Request, output *DeleteRepositoryOutput) {
	op := &request.Operation{
		Name:       opDeleteRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteRepositoryOutput{}
	req.Data = output
	return
}

// Deletes an existing image repository. If a repository contains images, you
// must use the force option to delete it.
func (c *ECR) DeleteRepository(input *DeleteRepositoryInput) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRepositoryPolicy = "DeleteRepositoryPolicy"

// DeleteRepositoryPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepositoryPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRepositoryPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRepositoryPolicyRequest method.
//    req, resp := client.DeleteRepositoryPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) DeleteRepositoryPolicyRequest(input *DeleteRepositoryPolicyInput) (req *request.Request, output *DeleteRepositoryPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteRepositoryPolicyOutput{}
	req.Data = output
	return
}

// Deletes the repository policy from a specified repository.
func (c *ECR) DeleteRepositoryPolicy(input *DeleteRepositoryPolicyInput) (*DeleteRepositoryPolicyOutput, error) {
	req, out := c.DeleteRepositoryPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeRepositories = "DescribeRepositories"

// DescribeRepositoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRepositories operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeRepositories method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeRepositoriesRequest method.
//    req, resp := client.DescribeRepositoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) DescribeRepositoriesRequest(input *DescribeRepositoriesInput) (req *request.Request, output *DescribeRepositoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRepositoriesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeRepositoriesOutput{}
	req.Data = output
	return
}

// Describes image repositories in a registry.
func (c *ECR) DescribeRepositories(input *DescribeRepositoriesInput) (*DescribeRepositoriesOutput, error) {
	req, out := c.DescribeRepositoriesRequest(input)
	err := req.Send()
	return out, err
}

const opGetAuthorizationToken = "GetAuthorizationToken"

// GetAuthorizationTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetAuthorizationToken operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetAuthorizationToken method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetAuthorizationTokenRequest method.
//    req, resp := client.GetAuthorizationTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) GetAuthorizationTokenRequest(input *GetAuthorizationTokenInput) (req *request.Request, output *GetAuthorizationTokenOutput) {
	op := &request.Operation{
		Name:       opGetAuthorizationToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAuthorizationTokenInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetAuthorizationTokenOutput{}
	req.Data = output
	return
}

// Retrieves a token that is valid for a specified registry for 12 hours. This
// command allows you to use the docker CLI to push and pull images with Amazon
// ECR. If you do not specify a registry, the default registry is assumed.
//
// The authorizationToken returned for each registry specified is a base64
// encoded string that can be decoded and used in a docker login command to
// authenticate to a registry. The AWS CLI offers an aws ecr get-login command
// that simplifies the login process.
func (c *ECR) GetAuthorizationToken(input *GetAuthorizationTokenInput) (*GetAuthorizationTokenOutput, error) {
	req, out := c.GetAuthorizationTokenRequest(input)
	err := req.Send()
	return out, err
}

const opGetDownloadUrlForLayer = "GetDownloadUrlForLayer"

// GetDownloadUrlForLayerRequest generates a "aws/request.Request" representing the
// client's request for the GetDownloadUrlForLayer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDownloadUrlForLayer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDownloadUrlForLayerRequest method.
//    req, resp := client.GetDownloadUrlForLayerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) GetDownloadUrlForLayerRequest(input *GetDownloadUrlForLayerInput) (req *request.Request, output *GetDownloadUrlForLayerOutput) {
	op := &request.Operation{
		Name:       opGetDownloadUrlForLayer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDownloadUrlForLayerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDownloadUrlForLayerOutput{}
	req.Data = output
	return
}

// Retrieves the pre-signed Amazon S3 download URL corresponding to an image
// layer. You can only get URLs for image layers that are referenced in an image.
//
//  This operation is used by the Amazon ECR proxy, and it is not intended
// for general use by customers. Use the docker CLI to pull, tag, and push images.
func (c *ECR) GetDownloadUrlForLayer(input *GetDownloadUrlForLayerInput) (*GetDownloadUrlForLayerOutput, error) {
	req, out := c.GetDownloadUrlForLayerRequest(input)
	err := req.Send()
	return out, err
}

const opGetRepositoryPolicy = "GetRepositoryPolicy"

// GetRepositoryPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetRepositoryPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetRepositoryPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetRepositoryPolicyRequest method.
//    req, resp := client.GetRepositoryPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) GetRepositoryPolicyRequest(input *GetRepositoryPolicyInput) (req *request.Request, output *GetRepositoryPolicyOutput) {
	op := &request.Operation{
		Name:       opGetRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetRepositoryPolicyOutput{}
	req.Data = output
	return
}

// Retrieves the repository policy for a specified repository.
func (c *ECR) GetRepositoryPolicy(input *GetRepositoryPolicyInput) (*GetRepositoryPolicyOutput, error) {
	req, out := c.GetRepositoryPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opInitiateLayerUpload = "InitiateLayerUpload"

// InitiateLayerUploadRequest generates a "aws/request.Request" representing the
// client's request for the InitiateLayerUpload operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the InitiateLayerUpload method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the InitiateLayerUploadRequest method.
//    req, resp := client.InitiateLayerUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) InitiateLayerUploadRequest(input *InitiateLayerUploadInput) (req *request.Request, output *InitiateLayerUploadOutput) {
	op := &request.Operation{
		Name:       opInitiateLayerUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InitiateLayerUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &InitiateLayerUploadOutput{}
	req.Data = output
	return
}

// Notify Amazon ECR that you intend to upload an image layer.
//
//  This operation is used by the Amazon ECR proxy, and it is not intended
// for general use by customers. Use the docker CLI to pull, tag, and push images.
func (c *ECR) InitiateLayerUpload(input *InitiateLayerUploadInput) (*InitiateLayerUploadOutput, error) {
	req, out := c.InitiateLayerUploadRequest(input)
	err := req.Send()
	return out, err
}

const opListImages = "ListImages"

// ListImagesRequest generates a "aws/request.Request" representing the
// client's request for the ListImages operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListImages method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListImagesRequest method.
//    req, resp := client.ListImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) ListImagesRequest(input *ListImagesInput) (req *request.Request, output *ListImagesOutput) {
	op := &request.Operation{
		Name:       opListImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListImagesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListImagesOutput{}
	req.Data = output
	return
}

// Lists all the image IDs for a given repository.
func (c *ECR) ListImages(input *ListImagesInput) (*ListImagesOutput, error) {
	req, out := c.ListImagesRequest(input)
	err := req.Send()
	return out, err
}

const opPutImage = "PutImage"

// PutImageRequest generates a "aws/request.Request" representing the
// client's request for the PutImage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutImage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutImageRequest method.
//    req, resp := client.PutImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) PutImageRequest(input *PutImageInput) (req *request.Request, output *PutImageOutput) {
	op := &request.Operation{
		Name:       opPutImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutImageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutImageOutput{}
	req.Data = output
	return
}

// Creates or updates the image manifest associated with an image.
//
//  This operation is used by the Amazon ECR proxy, and it is not intended
// for general use by customers. Use the docker CLI to pull, tag, and push images.
func (c *ECR) PutImage(input *PutImageInput) (*PutImageOutput, error) {
	req, out := c.PutImageRequest(input)
	err := req.Send()
	return out, err
}

const opSetRepositoryPolicy = "SetRepositoryPolicy"

// SetRepositoryPolicyRequest generates a "aws/request.Request" representing the
// client's request for the SetRepositoryPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetRepositoryPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetRepositoryPolicyRequest method.
//    req, resp := client.SetRepositoryPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) SetRepositoryPolicyRequest(input *SetRepositoryPolicyInput) (req *request.Request, output *SetRepositoryPolicyOutput) {
	op := &request.Operation{
		Name:       opSetRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetRepositoryPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetRepositoryPolicyOutput{}
	req.Data = output
	return
}

// Applies a repository policy on a specified repository to control access permissions.
func (c *ECR) SetRepositoryPolicy(input *SetRepositoryPolicyInput) (*SetRepositoryPolicyOutput, error) {
	req, out := c.SetRepositoryPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opUploadLayerPart = "UploadLayerPart"

// UploadLayerPartRequest generates a "aws/request.Request" representing the
// client's request for the UploadLayerPart operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UploadLayerPart method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UploadLayerPartRequest method.
//    req, resp := client.UploadLayerPartRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ECR) UploadLayerPartRequest(input *UploadLayerPartInput) (req *request.Request, output *UploadLayerPartOutput) {
	op := &request.Operation{
		Name:       opUploadLayerPart,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadLayerPartInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UploadLayerPartOutput{}
	req.Data = output
	return
}

// Uploads an image layer part to Amazon ECR.
//
//  This operation is used by the Amazon ECR proxy, and it is not intended
// for general use by customers. Use the docker CLI to pull, tag, and push images.
func (c *ECR) UploadLayerPart(input *UploadLayerPartInput) (*UploadLayerPartOutput, error) {
	req, out := c.UploadLayerPartRequest(input)
	err := req.Send()
	return out, err
}

// An object representing authorization data for an Amazon ECR registry.
type AuthorizationData struct {
	_ struct{} `type:"structure"`

	// A base64-encoded string that contains authorization data for the specified
	// Amazon ECR registry. When the string is decoded, it is presented in the format
	// user:password for private registry authentication using docker login.
	AuthorizationToken *string `locationName:"authorizationToken" type:"string"`

	// The Unix time in seconds and milliseconds when the authorization token expires.
	// Authorization tokens are valid for 12 hours.
	ExpiresAt *time.Time `locationName:"expiresAt" type:"timestamp" timestampFormat:"unix"`

	// The registry URL to use for this authorization token in a docker login command.
	// The Amazon ECR registry URL format is https://aws_account_id.dkr.ecr.region.amazonaws.com.
	// For example, https://012345678910.dkr.ecr.us-east-1.amazonaws.com..
	ProxyEndpoint *string `locationName:"proxyEndpoint" type:"string"`
}

// String returns the string representation
func (s AuthorizationData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizationData) GoString() string {
	return s.String()
}

type BatchCheckLayerAvailabilityInput struct {
	_ struct{} `type:"structure"`

	// The digests of the image layers to check.
	LayerDigests []*string `locationName:"layerDigests" min:"1" type:"list" required:"true"`

	// The AWS account ID associated with the registry that contains the image layers
	// to check. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that is associated with the image layers to check.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchCheckLayerAvailabilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCheckLayerAvailabilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCheckLayerAvailabilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCheckLayerAvailabilityInput"}
	if s.LayerDigests == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerDigests"))
	}
	if s.LayerDigests != nil && len(s.LayerDigests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerDigests", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchCheckLayerAvailabilityOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*LayerFailure `locationName:"failures" type:"list"`

	// A list of image layer objects corresponding to the image layer references
	// in the request.
	Layers []*Layer `locationName:"layers" type:"list"`
}

// String returns the string representation
func (s BatchCheckLayerAvailabilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCheckLayerAvailabilityOutput) GoString() string {
	return s.String()
}

// Deletes specified images within a specified repository. Images are specified
// with either the imageTag or imageDigest.
type BatchDeleteImageInput struct {
	_ struct{} `type:"structure"`

	// A list of image ID references that correspond to images to delete. The format
	// of the imageIds reference is imageTag=tag or imageDigest=digest.
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list" required:"true"`

	// The AWS account ID associated with the registry that contains the image to
	// delete. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository that contains the image to delete.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchDeleteImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteImageInput"}
	if s.ImageIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageIds"))
	}
	if s.ImageIds != nil && len(s.ImageIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIds", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchDeleteImageOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*ImageFailure `locationName:"failures" type:"list"`

	// The image IDs of the deleted images.
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchDeleteImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteImageOutput) GoString() string {
	return s.String()
}

type BatchGetImageInput struct {
	_ struct{} `type:"structure"`

	// A list of image ID references that correspond to images to describe. The
	// format of the imageIds reference is imageTag=tag or imageDigest=digest.
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list" required:"true"`

	// The AWS account ID associated with the registry that contains the images
	// to describe. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository that contains the images to describe.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchGetImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetImageInput"}
	if s.ImageIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageIds"))
	}
	if s.ImageIds != nil && len(s.ImageIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIds", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchGetImageOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*ImageFailure `locationName:"failures" type:"list"`

	// A list of image objects corresponding to the image references in the request.
	Images []*Image `locationName:"images" type:"list"`
}

// String returns the string representation
func (s BatchGetImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetImageOutput) GoString() string {
	return s.String()
}

type CompleteLayerUploadInput struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image layer.
	LayerDigests []*string `locationName:"layerDigests" min:"1" type:"list" required:"true"`

	// The AWS account ID associated with the registry to which to upload layers.
	// If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to associate with the image layer.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`

	// The upload ID from a previous InitiateLayerUpload operation to associate
	// with the image layer.
	UploadId *string `locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteLayerUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteLayerUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteLayerUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteLayerUploadInput"}
	if s.LayerDigests == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerDigests"))
	}
	if s.LayerDigests != nil && len(s.LayerDigests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerDigests", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CompleteLayerUploadOutput struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image layer.
	LayerDigest *string `locationName:"layerDigest" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The upload ID associated with the layer.
	UploadId *string `locationName:"uploadId" type:"string"`
}

// String returns the string representation
func (s CompleteLayerUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteLayerUploadOutput) GoString() string {
	return s.String()
}

type CreateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name to use for the repository. The repository name may be specified
	// on its own (such as nginx-web-app) or it can be prepended with a namespace
	// to group the repository into a category (such as project-a/nginx-web-app).
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// An object representing a repository.
	Repository *Repository `locationName:"repository" type:"structure"`
}

// String returns the string representation
func (s CreateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryOutput) GoString() string {
	return s.String()
}

type DeleteRepositoryInput struct {
	_ struct{} `type:"structure"`

	// Force the deletion of the repository if it contains images.
	Force *bool `locationName:"force" type:"boolean"`

	// The AWS account ID associated with the registry that contains the repository
	// to delete. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to delete.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// An object representing a repository.
	Repository *Repository `locationName:"repository" type:"structure"`
}

// String returns the string representation
func (s DeleteRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryOutput) GoString() string {
	return s.String()
}

type DeleteRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the registry that contains the repository
	// policy to delete. If you do not specify a registry, the default registry
	// is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that is associated with the repository policy
	// to delete.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryPolicyInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy that was deleted from the repository.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s DeleteRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryPolicyOutput) GoString() string {
	return s.String()
}

type DescribeRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of repository results returned by DescribeRepositories
	// in paginated output. When this parameter is used, DescribeRepositories only
	// returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another DescribeRepositories request with the returned nextToken value. This
	// value can be between 1 and 100. If this parameter is not used, then DescribeRepositories
	// returns up to 100 results and a nextToken value, if applicable.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeRepositories
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	//
	//  This token should be treated as an opaque identifier that is only used
	// to retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The AWS account ID associated with the registry that contains the repositories
	// to be described. If you do not specify a registry, the default registry is
	// assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// A list of repositories to describe. If this parameter is omitted, then all
	// repositories in a registry are described.
	RepositoryNames []*string `locationName:"repositoryNames" min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRepositoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRepositoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRepositoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RepositoryNames != nil && len(s.RepositoryNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future DescribeRepositories request.
	// When the results of a DescribeRepositories request exceed maxResults, this
	// value can be used to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of repository objects corresponding to valid repositories.
	Repositories []*Repository `locationName:"repositories" type:"list"`
}

// String returns the string representation
func (s DescribeRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRepositoriesOutput) GoString() string {
	return s.String()
}

type GetAuthorizationTokenInput struct {
	_ struct{} `type:"structure"`

	// A list of AWS account IDs that are associated with the registries for which
	// to get authorization tokens. If you do not specify a registry, the default
	// registry is assumed.
	RegistryIds []*string `locationName:"registryIds" min:"1" type:"list"`
}

// String returns the string representation
func (s GetAuthorizationTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAuthorizationTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAuthorizationTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAuthorizationTokenInput"}
	if s.RegistryIds != nil && len(s.RegistryIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetAuthorizationTokenOutput struct {
	_ struct{} `type:"structure"`

	// A list of authorization token data objects that correspond to the registryIds
	// values in the request.
	AuthorizationData []*AuthorizationData `locationName:"authorizationData" type:"list"`
}

// String returns the string representation
func (s GetAuthorizationTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAuthorizationTokenOutput) GoString() string {
	return s.String()
}

type GetDownloadUrlForLayerInput struct {
	_ struct{} `type:"structure"`

	// The digest of the image layer to download.
	LayerDigest *string `locationName:"layerDigest" type:"string" required:"true"`

	// The AWS account ID associated with the registry that contains the image layer
	// to download. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that is associated with the image layer to download.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDownloadUrlForLayerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDownloadUrlForLayerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDownloadUrlForLayerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDownloadUrlForLayerInput"}
	if s.LayerDigest == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerDigest"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetDownloadUrlForLayerOutput struct {
	_ struct{} `type:"structure"`

	// The pre-signed Amazon S3 download URL for the requested layer.
	DownloadUrl *string `locationName:"downloadUrl" type:"string"`

	// The digest of the image layer to download.
	LayerDigest *string `locationName:"layerDigest" type:"string"`
}

// String returns the string representation
func (s GetDownloadUrlForLayerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDownloadUrlForLayerOutput) GoString() string {
	return s.String()
}

type GetRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the registry that contains the repository.
	// If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository whose policy you want to retrieve.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryPolicyInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy text associated with the repository.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s GetRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryPolicyOutput) GoString() string {
	return s.String()
}

// An object representing an Amazon ECR image.
type Image struct {
	_ struct{} `type:"structure"`

	// An object containing the image tag and image digest associated with an image.
	ImageId *ImageIdentifier `locationName:"imageId" type:"structure"`

	// The image manifest associated with the image.
	ImageManifest *string `locationName:"imageManifest" type:"string"`

	// The AWS account ID associated with the registry containing the image.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository associated with the image.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Image) GoString() string {
	return s.String()
}

// An object representing an Amazon ECR image failure.
type ImageFailure struct {
	_ struct{} `type:"structure"`

	// The code associated with the failure.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"ImageFailureCode"`

	// The reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The image ID associated with the failure.
	ImageId *ImageIdentifier `locationName:"imageId" type:"structure"`
}

// String returns the string representation
func (s ImageFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageFailure) GoString() string {
	return s.String()
}

// An object with identifying information for an Amazon ECR image.
type ImageIdentifier struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image manifest.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The tag used for the image.
	ImageTag *string `locationName:"imageTag" type:"string"`
}

// String returns the string representation
func (s ImageIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageIdentifier) GoString() string {
	return s.String()
}

type InitiateLayerUploadInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the registry that you intend to upload
	// layers to. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that you intend to upload layers to.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s InitiateLayerUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateLayerUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateLayerUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitiateLayerUploadInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type InitiateLayerUploadOutput struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, that Amazon ECR expects future layer part uploads to
	// be.
	PartSize *int64 `locationName:"partSize" type:"long"`

	// The upload ID for the layer upload. This parameter is passed to further UploadLayerPart
	// and CompleteLayerUpload operations.
	UploadId *string `locationName:"uploadId" type:"string"`
}

// String returns the string representation
func (s InitiateLayerUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateLayerUploadOutput) GoString() string {
	return s.String()
}

// An object representing an Amazon ECR image layer.
type Layer struct {
	_ struct{} `type:"structure"`

	// The availability status of the image layer. Valid values are AVAILABLE and
	// UNAVAILABLE.
	LayerAvailability *string `locationName:"layerAvailability" type:"string" enum:"LayerAvailability"`

	// The sha256 digest of the image layer.
	LayerDigest *string `locationName:"layerDigest" type:"string"`

	// The size, in bytes, of the image layer.
	LayerSize *int64 `locationName:"layerSize" type:"long"`
}

// String returns the string representation
func (s Layer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Layer) GoString() string {
	return s.String()
}

// An object representing an Amazon ECR image layer failure.
type LayerFailure struct {
	_ struct{} `type:"structure"`

	// The failure code associated with the failure.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"LayerFailureCode"`

	// The reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The layer digest associated with the failure.
	LayerDigest *string `locationName:"layerDigest" type:"string"`
}

// String returns the string representation
func (s LayerFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LayerFailure) GoString() string {
	return s.String()
}

type ListImagesFilter struct {
	_ struct{} `type:"structure"`

	TagStatus *string `locationName:"tagStatus" type:"string" enum:"TagStatus"`
}

// String returns the string representation
func (s ListImagesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImagesFilter) GoString() string {
	return s.String()
}

type ListImagesInput struct {
	_ struct{} `type:"structure"`

	Filter *ListImagesFilter `locationName:"filter" type:"structure"`

	// The maximum number of image results returned by ListImages in paginated output.
	// When this parameter is used, ListImages only returns maxResults results in
	// a single page along with a nextToken response element. The remaining results
	// of the initial request can be seen by sending another ListImages request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// this parameter is not used, then ListImages returns up to 100 results and
	// a nextToken value, if applicable.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListImages request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value. This value is null when there are no more results to return.
	//
	//  This token should be treated as an opaque identifier that is only used
	// to retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The AWS account ID associated with the registry that contains the repository
	// to list images in. If you do not specify a registry, the default registry
	// is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository whose image IDs are to be listed.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s ListImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImagesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListImagesOutput struct {
	_ struct{} `type:"structure"`

	// The list of image IDs for the requested repository.
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list"`

	// The nextToken value to include in a future ListImages request. When the results
	// of a ListImages request exceed maxResults, this value can be used to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImagesOutput) GoString() string {
	return s.String()
}

type PutImageInput struct {
	_ struct{} `type:"structure"`

	// The image manifest corresponding to the image to be uploaded.
	ImageManifest *string `locationName:"imageManifest" type:"string" required:"true"`

	// The AWS account ID associated with the registry that contains the repository
	// in which to put the image. If you do not specify a registry, the default
	// registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository in which to put the image.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s PutImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutImageInput"}
	if s.ImageManifest == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageManifest"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutImageOutput struct {
	_ struct{} `type:"structure"`

	// Details of the image uploaded.
	Image *Image `locationName:"image" type:"structure"`
}

// String returns the string representation
func (s PutImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutImageOutput) GoString() string {
	return s.String()
}

// An object representing a repository.
type Repository struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the registry that contains the repository.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the repository. The ARN contains
	// the arn:aws:ecr namespace, followed by the region of the repository, the
	// AWS account ID of the repository owner, the repository namespace, and then
	// the repository name. For example, arn:aws:ecr:region:012345678910:repository/test.
	RepositoryArn *string `locationName:"repositoryArn" type:"string"`

	// The name of the repository.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The URI for the repository. You can use this URI for Docker push and pull
	// operations.
	RepositoryUri *string `locationName:"repositoryUri" type:"string"`
}

// String returns the string representation
func (s Repository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Repository) GoString() string {
	return s.String()
}

type SetRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// If the policy you are attempting to set on a repository policy would prevent
	// you from setting another policy in the future, you must force the SetRepositoryPolicy
	// operation. This is intended to prevent accidental repository lock outs.
	Force *bool `locationName:"force" type:"boolean"`

	// The JSON repository policy text to apply to the repository.
	PolicyText *string `locationName:"policyText" type:"string" required:"true"`

	// The AWS account ID associated with the registry that contains the repository.
	// If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to receive the policy.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s SetRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetRepositoryPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetRepositoryPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetRepositoryPolicyInput"}
	if s.PolicyText == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyText"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy text applied to the repository.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s SetRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetRepositoryPolicyOutput) GoString() string {
	return s.String()
}

type UploadLayerPartInput struct {
	_ struct{} `type:"structure"`

	// The base64-encoded layer part payload.
	//
	// LayerPartBlob is automatically base64 encoded/decoded by the SDK.
	LayerPartBlob []byte `locationName:"layerPartBlob" type:"blob" required:"true"`

	// The integer value of the first byte of the layer part.
	PartFirstByte *int64 `locationName:"partFirstByte" type:"long" required:"true"`

	// The integer value of the last byte of the layer part.
	PartLastByte *int64 `locationName:"partLastByte" type:"long" required:"true"`

	// The AWS account ID associated with the registry that you are uploading layer
	// parts to. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that you are uploading layer parts to.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`

	// The upload ID from a previous InitiateLayerUpload operation to associate
	// with the layer part upload.
	UploadId *string `locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadLayerPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadLayerPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadLayerPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadLayerPartInput"}
	if s.LayerPartBlob == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerPartBlob"))
	}
	if s.PartFirstByte == nil {
		invalidParams.Add(request.NewErrParamRequired("PartFirstByte"))
	}
	if s.PartLastByte == nil {
		invalidParams.Add(request.NewErrParamRequired("PartLastByte"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UploadLayerPartOutput struct {
	_ struct{} `type:"structure"`

	// The integer value of the last byte received in the request.
	LastByteReceived *int64 `locationName:"lastByteReceived" type:"long"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The upload ID associated with the request.
	UploadId *string `locationName:"uploadId" type:"string"`
}

// String returns the string representation
func (s UploadLayerPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadLayerPartOutput) GoString() string {
	return s.String()
}

const (
	// @enum ImageFailureCode
	ImageFailureCodeInvalidImageDigest = "InvalidImageDigest"
	// @enum ImageFailureCode
	ImageFailureCodeInvalidImageTag = "InvalidImageTag"
	// @enum ImageFailureCode
	ImageFailureCodeImageTagDoesNotMatchDigest = "ImageTagDoesNotMatchDigest"
	// @enum ImageFailureCode
	ImageFailureCodeImageNotFound = "ImageNotFound"
	// @enum ImageFailureCode
	ImageFailureCodeMissingDigestAndTag = "MissingDigestAndTag"
)

const (
	// @enum LayerAvailability
	LayerAvailabilityAvailable = "AVAILABLE"
	// @enum LayerAvailability
	LayerAvailabilityUnavailable = "UNAVAILABLE"
)

const (
	// @enum LayerFailureCode
	LayerFailureCodeInvalidLayerDigest = "InvalidLayerDigest"
	// @enum LayerFailureCode
	LayerFailureCodeMissingLayerDigest = "MissingLayerDigest"
)

const (
	// @enum TagStatus
	TagStatusTagged = "TAGGED"
	// @enum TagStatus
	TagStatusUntagged = "UNTAGGED"
)
