/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.Tool;
import antlr.collections.impl.IndexedVector;
import antlr.preprocessor.Grammar;
import antlr.preprocessor.Hierarchy;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class GrammarFile {
    protected String fileName;
    protected String headerAction = "";
    protected IndexedVector options;
    protected IndexedVector grammars;
    protected boolean expanded = false;
    protected Tool tool;

    public GrammarFile(Tool tool, String string2) {
        this.fileName = string2;
        this.grammars = new IndexedVector();
        this.tool = tool;
    }

    public void addGrammar(Grammar grammar) {
        this.grammars.appendElement(grammar.getName(), grammar);
    }

    public void generateExpandedFile() throws IOException {
        if (!this.expanded) {
            return;
        }
        String string2 = this.nameForExpandedGrammarFile(this.getName());
        PrintWriter printWriter = this.tool.openOutputFile(string2);
        printWriter.println(this.toString());
        printWriter.close();
    }

    public IndexedVector getGrammars() {
        return this.grammars;
    }

    public String getName() {
        return this.fileName;
    }

    public String nameForExpandedGrammarFile(String string2) {
        if (this.expanded) {
            return "expanded" + this.tool.fileMinusPath(string2);
        }
        return string2;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public void addHeaderAction(String string2) {
        this.headerAction = this.headerAction + string2 + System.getProperty("line.separator");
    }

    public void setOptions(IndexedVector indexedVector) {
        this.options = indexedVector;
    }

    public String toString() {
        String string2 = this.headerAction == null ? "" : this.headerAction;
        String string3 = this.options == null ? "" : Hierarchy.optionsToString(this.options);
        StringBuffer stringBuffer = new StringBuffer(10000);
        stringBuffer.append(string2);
        stringBuffer.append(string3);
        Enumeration enumeration = this.grammars.elements();
        while (enumeration.hasMoreElements()) {
            Grammar grammar = (Grammar)enumeration.nextElement();
            stringBuffer.append(grammar.toString());
        }
        return stringBuffer.toString();
    }
}

