/*
 * Decompiled with CFR 0.152.
 */
package com.xruby;

import com.xruby.compiler.codegen.NameFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

class CommandLineOptions {
    private boolean compileOnly_ = false;
    private boolean help_ = false;
    private boolean eval_one_line_ = false;
    private boolean verbose_ = false;
    private boolean switch_ = false;
    private boolean strip_ = false;
    private boolean is_pe_ = false;
    private boolean enableDebug = false;
    private String eval_script_ = "";
    private String file_ = null;
    String backupExtension_ = null;
    private List<String> vars_ = new ArrayList<String>();
    private List<String> args_ = new ArrayList<String>();

    public boolean isCompileOnly() {
        return this.compileOnly_;
    }

    public boolean isHelp() {
        return this.help_;
    }

    public boolean isEvalOneLine() {
        return this.eval_one_line_;
    }

    public boolean isVerbose() {
        return this.verbose_;
    }

    public boolean isStrip() {
        return this.strip_;
    }

    public boolean isPe() {
        return this.is_pe_;
    }

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public void enableDebug() {
        this.enableDebug = true;
    }

    public String getEvalScript() {
        if (this.is_pe_) {
            return "while gets();" + this.eval_script_ + ";end";
        }
        return this.eval_script_;
    }

    public String getFilename() {
        return this.file_;
    }

    public String getBackupExtension() {
        return this.backupExtension_;
    }

    public String[] getVars() {
        return this.vars_.toArray(new String[0]);
    }

    public String[] getArgs() {
        return this.args_.toArray(new String[0]);
    }

    private String getRidOfQuote(String s) {
        if (s.charAt(0) == '\"' || s.charAt(0) == '\'') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private String[] preProcessSingleQuote(String[] args) {
        ArrayList<String> a = new ArrayList<String>();
        boolean find_single_quote = false;
        String temp = null;
        for (String s : args) {
            if (find_single_quote) {
                if (s.charAt(s.length() - 1) == '\'') {
                    a.add(this.getRidOfQuote(temp + " " + s));
                    find_single_quote = false;
                    continue;
                }
                temp = temp + " " + s;
                continue;
            }
            if (s.charAt(0) == '\'') {
                if (s.charAt(s.length() - 1) == '\'') {
                    a.add(this.getRidOfQuote(s));
                    continue;
                }
                temp = s;
                find_single_quote = true;
                continue;
            }
            a.add(s);
        }
        return a.toArray(new String[0]);
    }

    public void parseOptionsFromFile(String filename) {
        String s = this.readOptionsFromFile(filename);
        if (null == s) {
            return;
        }
        if (s.equals("-s")) {
            this.moveArgsToVars();
        }
    }

    private void moveArgsToVars() {
        int i = 0;
        while (i < this.args_.size()) {
            String s = this.args_.get(i);
            if (s.charAt(0) == '-') {
                this.vars_.add(s.substring(1));
                this.args_.remove(i);
                continue;
            }
            ++i;
        }
    }

    private String readOptionsFromFile(String filename) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            do {
                int i;
                String s;
                if ((s = reader.readLine()) == null || s.length() <= "#! ruby".length() || s.charAt(0) != '#' || s.charAt(1) != '!' || (i = s.indexOf("ruby")) <= 0) continue;
                return s.substring(i + 4).trim();
            } while (this.strip_);
            reader.close();
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private String[] preProcess_pe_i(String[] args) {
        ArrayList<String> a = new ArrayList<String>();
        for (String s : args) {
            if (s.equals("-pe")) {
                this.is_pe_ = true;
                a.add("-e");
                continue;
            }
            if (s.startsWith("-i")) {
                if (s.equals("-i")) continue;
                this.backupExtension_ = s.substring(2);
                continue;
            }
            a.add(s);
        }
        return a.toArray(new String[0]);
    }

    public CommandLineOptions(String[] args) {
        CommandLine line;
        if (args.length == 0) {
            return;
        }
        args = this.preProcessSingleQuote(args);
        args = this.preProcess_pe_i(args);
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("h", false, "display help");
        options.addOption("c", false, "compiler only");
        options.addOption("e", true, "eval one line");
        options.addOption("v", false, "print version number, then turn on verbose mode");
        options.addOption("s", false, "enable some switch parsing for switches after script name");
        options.addOption("x", false, "strip off text before #!ruby line");
        options.addOption("g", false, "enable debug");
        options.addOption("n", true, "provide class prefix name");
        try {
            line = parser.parse(options, args, true);
        }
        catch (ParseException e) {
            throw new Error(e.toString());
        }
        if (line.hasOption("c")) {
            this.compileOnly_ = true;
            if (line.hasOption("g")) {
                this.enableDebug = true;
            }
            if (line.hasOption("v")) {
                this.verbose_ = true;
            }
            if (line.hasOption("n")) {
                String str;
                NameFactory.name_classprefix_ = str = line.getOptionValue("n");
            }
        } else if (line.hasOption("h")) {
            this.help_ = true;
        } else if (line.hasOption("v")) {
            this.verbose_ = true;
        } else if (line.hasOption("e")) {
            this.eval_one_line_ = true;
            this.eval_script_ = line.getOptionValue("e");
        } else if (line.hasOption("s")) {
            this.switch_ = true;
        } else if (line.hasOption("x")) {
            this.strip_ = true;
        }
        if (line.getArgList().size() > 0) {
            this.file_ = (String)line.getArgList().remove(0);
            this.args_.addAll(line.getArgList());
            if (this.switch_) {
                this.moveArgsToVars();
            }
        }
    }
}

