/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.xruby.compiler.codegen.CompilationResults;
import com.xruby.compiler.codegen.RubyCompilerImpl;
import com.xruby.compiler.parser.RubyParser;
import com.xruby.runtime.lang.RubyBinding;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

public class RubyCompiler {
    public static final String VERSION = "0.3.3";
    private RubyBinding binding_;
    private boolean strip_;
    private boolean enableDebug = true;
    private boolean verbose_ = true;

    public RubyCompiler() {
        this.binding_ = null;
        this.strip_ = false;
    }

    public RubyCompiler(boolean strip2) {
        this.binding_ = null;
        this.strip_ = strip2;
    }

    public RubyCompiler(RubyBinding binding2, boolean strip2) {
        this.binding_ = binding2;
        this.strip_ = strip2;
    }

    public CompilationResults compileString(String text) throws RecognitionException, TokenStreamException {
        return this.compile(null, null, new StringReader(text));
    }

    public CompilationResults compileString(String filename, String text) throws RecognitionException, TokenStreamException {
        return this.compile(null, filename, new StringReader(text));
    }

    public CompilationResults compileStdin() throws FileNotFoundException, RecognitionException, TokenStreamException {
        InputStreamReader reader = new InputStreamReader(System.in);
        return this.compile(null, null, new BufferedReader(reader));
    }

    public CompilationResults compileFile(String filename) throws FileNotFoundException, RecognitionException, TokenStreamException {
        File f = new File(filename);
        if (f.isDirectory()) {
            return this.compileDir(filename, f);
        }
        return this.compileSingleFile(null, f);
    }

    private CompilationResults compileDir(String extra, File dir) throws FileNotFoundException, RecognitionException, TokenStreamException {
        CompilationResults dirResults = new CompilationResults();
        for (String filename : dir.list()) {
            CompilationResults results;
            if (filename.charAt(0) == '.') continue;
            File file = new File(dir, filename);
            if (file.isDirectory()) {
                results = this.compileDir(extra, file);
                dirResults.add(results);
                continue;
            }
            if (!filename.endsWith(".rb")) continue;
            results = this.compileSingleFile(extra, file);
            dirResults.add(results);
        }
        return dirResults;
    }

    private CompilationResults compileSingleFile(String extra, File file) throws FileNotFoundException, RecognitionException, TokenStreamException {
        if (this.verbose_) {
            System.out.println("Compiling " + file.getPath() + "...");
        }
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            return this.compile(extra, file.getPath(), new BufferedReader(reader));
        }
        catch (UnsupportedEncodingException exc) {
            throw new RecognitionException();
        }
    }

    private CompilationResults compile(String extra, String filename, Reader reader) throws RecognitionException, TokenStreamException {
        RubyParser parser = this.createParser(reader);
        RubyCompilerImpl compiler = new RubyCompilerImpl(extra, filename);
        if (this.enableDebug) {
            compiler.enableDebug();
        }
        return compiler.compile(parser.parse(filename), this.binding_);
    }

    private RubyParser createParser(Reader reader) {
        if (null == this.binding_) {
            return new RubyParser(reader, this.strip_);
        }
        return new RubyParser(reader, this.binding_.getVariableNames(), this.strip_);
    }

    public void enableDebug() {
        this.enableDebug = true;
    }

    public void setVerbose() {
        this.verbose_ = true;
    }
}

