/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import antlr.RecognitionException;
import com.xruby.compiler.codedom.AssignmentOperatorExpression;
import com.xruby.compiler.codedom.BinaryOperatorExpression;
import com.xruby.compiler.codedom.Block;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.CompoundStatement;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.ExpressionStatement;
import com.xruby.compiler.codedom.LocalVariableExpression;
import com.xruby.compiler.codedom.NilExpression;
import java.util.ArrayList;

public class AndOrBinaryOperatorExpression
extends BinaryOperatorExpression {
    public AndOrBinaryOperatorExpression(String operator, Expression left, Expression right) {
        super(operator, left, right);
    }

    private void ensureVariablesAreInitialized(CodeVisitor visitor) {
        ArrayList<String> vars = new ArrayList<String>();
        this.right_.getNewlyAssignedVariables(visitor, vars);
        if (vars.isEmpty()) {
            return;
        }
        CompoundStatement comp = new CompoundStatement();
        for (String var : vars) {
            try {
                comp.addStatement(new ExpressionStatement(new AssignmentOperatorExpression(new LocalVariableExpression(var, false), new NilExpression())));
            }
            catch (RecognitionException e) {
                throw new Error(e);
            }
        }
        comp.accept(visitor);
        visitor.visitTerminal();
    }

    @Override
    public void accept(CodeVisitor visitor) {
        if (this.operator_.equals("&&")) {
            this.left_.accept(visitor);
            Object label = visitor.visitAndBinaryOperatorLeft();
            this.right_.accept(visitor);
            visitor.visitAndBinaryOperatorRight(label);
        } else {
            this.ensureVariablesAreInitialized(visitor);
            ArrayList<Block> pulled_blocks = new ArrayList<Block>();
            this.right_.pullBlock(pulled_blocks);
            for (Block block : pulled_blocks) {
                block.acceptAsPulled(visitor);
            }
            this.left_.accept(visitor);
            Object label = visitor.visitOrBinaryOperatorLeft();
            this.right_.accept(visitor);
            visitor.visitOrBinaryOperatorRight(label);
        }
    }
}

