/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import antlr.RecognitionException;
import com.xruby.compiler.codedom.AndOrBinaryOperatorExpression;
import com.xruby.compiler.codedom.BinaryOperatorExpression;
import com.xruby.compiler.codedom.Block;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.LocalVariableExpression;
import com.xruby.compiler.codedom.MethodCallExpression;
import com.xruby.compiler.codedom.VariableExpression;
import com.xruby.compiler.codedom.YieldExpression;
import java.util.ArrayList;

public class AssignmentOperatorExpression
extends Expression {
    private VariableExpression lhs_;
    private Expression rhs_;

    public AssignmentOperatorExpression(Expression left, Expression right) throws RecognitionException {
        if (!(left instanceof VariableExpression)) {
            throw new RecognitionException("Only variable can be assigned");
        }
        this.lhs_ = (VariableExpression)left;
        this.rhs_ = right;
    }

    VariableExpression getLhs() {
        return this.lhs_;
    }

    Expression getRhs() {
        return this.rhs_;
    }

    public static Expression create(Expression left, Expression right) throws RecognitionException {
        if (left instanceof MethodCallExpression) {
            MethodCallExpression call2 = (MethodCallExpression)left;
            if (call2.isElementSet()) {
                return call2.convertElementAccessToElementSet(right);
            }
            throw new RecognitionException("Method call can not be assigned");
        }
        if (left instanceof BinaryOperatorExpression) {
            BinaryOperatorExpression e = (BinaryOperatorExpression)left;
            return new AndOrBinaryOperatorExpression(e.operator_, e.left_, new AssignmentOperatorExpression(e.right_, right));
        }
        return new AssignmentOperatorExpression(left, right);
    }

    @Override
    public void accept(CodeVisitor visitor) {
        this.rhs_.accept(visitor);
        this.addLineno(visitor);
        this.lhs_.acceptAsAssignment(visitor, this.rhs_ instanceof MethodCallExpression || this.rhs_ instanceof YieldExpression, false);
    }

    @Override
    void pullBlock(ArrayList<Block> result) {
        this.rhs_.pullBlock(result);
    }

    @Override
    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
        String name;
        if (this.lhs_ instanceof LocalVariableExpression && !symboltable.isDefinedInCurrentScope(name = ((LocalVariableExpression)this.lhs_).getValue())) {
            result.add(name);
        }
    }

    @Override
    public void getFrequentlyUsedIntegers(ArrayList<Integer> result) {
        this.rhs_.getFrequentlyUsedIntegers(result);
    }
}

