/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import com.xruby.compiler.codedom.Block;
import com.xruby.compiler.codegen.NameFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlockFarm {
    private static Map<String, Map<String, int[]>> farm = new HashMap<String, Map<String, int[]>>();

    public static String getMapByName(String scriptName) {
        Set<String> files = farm.keySet();
        if (!files.contains(scriptName)) {
            return null;
        }
        StringBuffer description = new StringBuffer();
        Map<String, int[]> map = farm.get(scriptName);
        description.append(map.size()).append("\n");
        Set<String> blocks = map.keySet();
        for (String blockName : blocks) {
            int[] range = map.get(blockName);
            String line = String.format("%s %d %d\n", blockName, range[0], range[1]);
            description.append(line);
        }
        return description.toString();
    }

    static void markBlock(Block block) {
        String blockName = block.getName();
        String name = BlockFarm.extractBlockName(blockName);
        String scriptName = BlockFarm.extractScriptName(blockName);
        Map<String, int[]> map = farm.get(scriptName);
        if (map == null) {
            map = new HashMap<String, int[]>();
            farm.put(scriptName, map);
        }
        int start2 = block.getStartPosition();
        int end = block.getEndPosition();
        int[] range = new int[]{start2, end};
        map.put(name, range);
    }

    static void markMethod(String scriptName, String methodName, int[] range) {
        Map<String, int[]> map = farm.get(scriptName);
        if (map == null) {
            map = new HashMap<String, int[]>();
            farm.put(scriptName, map);
        }
        methodName = BlockFarm.extractBlockName(methodName);
        map.put(methodName, range);
    }

    private static String extractBlockName(String name) {
        Pattern pattern = Pattern.compile("/");
        Matcher matcher = pattern.matcher(name);
        String blockName = matcher.replaceAll(".");
        return blockName;
    }

    private static String extractScriptName(String blockName) {
        StringTokenizer st;
        if (blockName.startsWith(NameFactory.name_classprefix_ + "/")) {
            blockName = blockName.substring(6);
        }
        if ((st = new StringTokenizer(blockName, "/")).hasMoreTokens()) {
            return st.nextToken() + ".rb";
        }
        return null;
    }

    public static Map<String, Map<String, int[]>> getBlockMap() {
        return farm;
    }
}

